/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types.collections;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.Printer;
import com.github.jlangch.venice.impl.javainterop.JavaInteropUtil;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.IVncJavaObject;
import com.github.jlangch.venice.impl.types.TypeRank;
import com.github.jlangch.venice.impl.types.VncBoolean;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncHashMap;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncMap;
import com.github.jlangch.venice.impl.types.collections.VncMapEntry;
import com.github.jlangch.venice.impl.types.collections.VncMutable;
import com.github.jlangch.venice.impl.types.collections.VncSequence;
import com.github.jlangch.venice.impl.types.collections.VncVector;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.impl.util.MetaUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class VncJavaMap
extends VncMap
implements IVncJavaObject,
VncMutable {
    private static final long serialVersionUID = -1848883965231344442L;
    private final Map<Object, Object> value;

    public VncJavaMap() {
        this((Map<Object, Object>)null, (VncVal)null);
    }

    public VncJavaMap(VncVal meta) {
        this((Map<Object, Object>)null, meta);
    }

    public VncJavaMap(Map<Object, Object> val) {
        this(val, null);
    }

    public VncJavaMap(Map<Object, Object> val, VncVal meta) {
        super(meta == null ? Constants.Nil : meta);
        this.value = val == null ? new HashMap() : val;
    }

    @Override
    public Object getDelegate() {
        return this.value;
    }

    @Override
    public VncJavaMap emptyWithMeta() {
        return new VncJavaMap(this.getMeta());
    }

    @Override
    public VncHashMap withValues(Map<VncVal, VncVal> replaceVals) {
        return new VncHashMap(replaceVals, this.getMeta());
    }

    @Override
    public VncHashMap withValues(Map<VncVal, VncVal> replaceVals, VncVal meta) {
        return new VncHashMap(replaceVals, meta);
    }

    @Override
    public VncJavaMap withMeta(VncVal meta) {
        return new VncJavaMap(this.value, meta);
    }

    @Override
    public VncKeyword getType() {
        Class<?> type = this.value.getClass();
        ArrayList<VncKeyword> superclasses = new ArrayList<VncKeyword>();
        for (Class<?> superClass = type.getSuperclass(); superClass != null; superClass = superClass.getSuperclass()) {
            superclasses.add(new VncKeyword(superClass.getName(), MetaUtil.typeMeta(new VncKeyword[0])));
        }
        return new VncKeyword(type.getName(), MetaUtil.typeMeta(superclasses.toArray(new VncKeyword[0])));
    }

    @Override
    public Map<VncVal, VncVal> getJavaMap() {
        return this.value.entrySet().stream().collect(Collectors.toMap(e -> JavaInteropUtil.convertToVncVal(e.getKey()), e -> JavaInteropUtil.convertToVncVal(e.getValue())));
    }

    @Override
    public void clear() {
        this.value.clear();
    }

    @Override
    public VncVal get(VncVal key) {
        return JavaInteropUtil.convertToVncVal(this.value.get(key.convertToJavaObject()));
    }

    @Override
    public VncVal containsKey(VncVal key) {
        return VncBoolean.of(this.value.containsKey(key.convertToJavaObject()));
    }

    @Override
    public VncList keys() {
        return VncList.ofList(this.value.keySet().stream().map(k -> JavaInteropUtil.convertToVncVal(k)).collect(Collectors.toList()));
    }

    @Override
    public List<VncMapEntry> entries() {
        return Collections.unmodifiableList(this.getJavaMap().entrySet().stream().map(e -> new VncMapEntry((VncVal)e.getKey(), (VncVal)e.getValue())).collect(Collectors.toList()));
    }

    @Override
    public VncJavaMap putAll(VncMap map) {
        this.getJavaMap().entrySet().forEach(e -> this.value.put(((VncVal)e.getKey()).convertToJavaObject(), ((VncVal)e.getValue()).convertToJavaObject()));
        return this;
    }

    @Override
    public VncJavaMap assoc(VncVal ... mvs) {
        if (mvs.length % 2 != 0) {
            throw new VncException(String.format("java-map: assoc requires an even number of items.", new Object[0]));
        }
        for (int i = 0; i < mvs.length - 1; i += 2) {
            this.value.put(mvs[i].convertToJavaObject(), mvs[i + 1].convertToJavaObject());
        }
        return this;
    }

    @Override
    public VncJavaMap assoc(VncSequence mvs) {
        if (mvs.size() % 2 != 0) {
            throw new VncException(String.format("java-map: assoc requires an even number of items.", new Object[0]));
        }
        VncSequence kv = mvs;
        while (!kv.isEmpty()) {
            this.value.put(kv.first().convertToJavaObject(), kv.second().convertToJavaObject());
            kv = kv.drop(2);
        }
        return this;
    }

    @Override
    public VncJavaMap dissoc(VncVal ... keys) {
        for (VncVal key : keys) {
            this.value.remove(key.convertToJavaObject());
        }
        return this;
    }

    @Override
    public VncJavaMap dissoc(VncSequence keys) {
        for (VncVal key : keys) {
            this.value.remove(key.convertToJavaObject());
        }
        return this;
    }

    @Override
    public VncList toVncList() {
        return VncList.ofAll(this.value.entrySet().stream().map(e -> VncVector.of(JavaInteropUtil.convertToVncVal(e.getKey()), JavaInteropUtil.convertToVncVal(e.getValue()))), this.getMeta());
    }

    @Override
    public VncVector toVncVector() {
        return VncVector.ofAll(this.value.entrySet().stream().map(e -> VncVector.of(JavaInteropUtil.convertToVncVal(e.getKey()), JavaInteropUtil.convertToVncVal(e.getValue()))), this.getMeta());
    }

    @Override
    public int size() {
        return this.value.size();
    }

    @Override
    public boolean isEmpty() {
        return this.value.isEmpty();
    }

    @Override
    public TypeRank typeRank() {
        return TypeRank.JAVAMAP;
    }

    @Override
    public Object convertToJavaObject() {
        return this.value;
    }

    @Override
    public int compareTo(VncVal o) {
        if (o == Constants.Nil) {
            return 1;
        }
        if (Types.isVncJavaMap(o)) {
            int c = Integer.compare(this.size(), ((VncJavaMap)o).size());
            if (c != 0) {
                return c;
            }
            return this.equals(o) ? 0 : -1;
        }
        return super.compareTo(o);
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VncJavaMap other = (VncJavaMap)obj;
        return this.value.equals(other.value);
    }

    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean print_machine_readably) {
        ArrayList list = new ArrayList();
        this.value.entrySet().forEach(e -> {
            list.add(JavaInteropUtil.convertToVncVal(e.getKey()));
            list.add(JavaInteropUtil.convertToVncVal(e.getValue()));
        });
        return "{" + Printer.join(list.stream(), " ", print_machine_readably) + "}";
    }
}

