/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl;

import com.github.jlangch.venice.impl.debug.agent.DebugAgent;
import com.github.jlangch.venice.impl.env.Env;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncList;
import java.util.List;

public class RecursionPoint {
    private final List<VncSymbol> loopBindingNames;
    private final int loopBindingNamesCount;
    private final VncList loopExpressions;
    private final Env loopEnv;
    private final VncVal meta;
    private final DebugAgent debugAgent;

    public RecursionPoint(List<VncSymbol> loopBindingNames, VncList loopExpressions, Env loopEnv, VncVal meta, DebugAgent debugAgent) {
        this.loopBindingNames = loopBindingNames;
        this.loopBindingNamesCount = loopBindingNames.size();
        this.loopExpressions = loopExpressions;
        this.loopEnv = loopEnv;
        this.meta = meta;
        this.debugAgent = debugAgent;
    }

    public int getLoopBindingNamesCount() {
        return this.loopBindingNamesCount;
    }

    public VncSymbol getLoopBindingName(int idx) {
        return this.loopBindingNames.get(idx);
    }

    public List<VncSymbol> getLoopBindingNames() {
        return this.loopBindingNames;
    }

    public VncList getLoopExpressions() {
        return this.loopExpressions;
    }

    public Env getLoopEnv() {
        return this.loopEnv;
    }

    public VncVal getMeta() {
        return this.meta;
    }

    public DebugAgent getDebugAgent() {
        return this.debugAgent;
    }

    public boolean isDebuggingActive() {
        return this.debugAgent != null;
    }
}

