/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.docgen.cheatsheet;

import com.github.jlangch.venice.impl.reader.HighlightClass;
import java.util.HashMap;
import java.util.Map;

public class DocColorTheme {
    private static String PURPLE = "#9932CC";
    private static String GREY = "#404040";
    private static String GREY_LIGHT = "#808080";
    private static String BLUE = "#4169E1";
    private static String GREEN = "#2E8B57";
    private static String ORANGE = "#E9967A";
    private static String RED = "#C71585";
    private final String name;
    private final Map<HighlightClass, String> colors = new HashMap<HighlightClass, String>();

    public DocColorTheme(String name, Map<HighlightClass, String> colors) {
        this.name = name;
        this.colors.putAll(colors);
    }

    public String getName() {
        return this.name;
    }

    public String getColor(HighlightClass clazz) {
        return this.colors.get((Object)clazz);
    }

    public static DocColorTheme getLightTheme() {
        HashMap<HighlightClass, String> colors = new HashMap<HighlightClass, String>();
        colors.put(HighlightClass.COMMENT, GREY_LIGHT);
        colors.put(HighlightClass.WHITESPACES, null);
        colors.put(HighlightClass.STRING, GREEN);
        colors.put(HighlightClass.NUMBER, ORANGE);
        colors.put(HighlightClass.CONSTANT, ORANGE);
        colors.put(HighlightClass.KEYWORD, ORANGE);
        colors.put(HighlightClass.SYMBOL, GREY);
        colors.put(HighlightClass.SYMBOL_SPECIAL_FORM, PURPLE);
        colors.put(HighlightClass.SYMBOL_FUNCTION_NAME, BLUE);
        colors.put(HighlightClass.SYMBOL_MACRO_NAME, BLUE);
        colors.put(HighlightClass.SYMBOL_EAR_MUFFS, BLUE);
        colors.put(HighlightClass.QUOTE, GREY);
        colors.put(HighlightClass.QUASI_QUOTE, GREY);
        colors.put(HighlightClass.UNQUOTE, GREY);
        colors.put(HighlightClass.UNQUOTE_SPLICING, GREY);
        colors.put(HighlightClass.META, GREY_LIGHT);
        colors.put(HighlightClass.AT, GREY);
        colors.put(HighlightClass.HASH, GREY);
        colors.put(HighlightClass.BRACE_BEGIN, GREY);
        colors.put(HighlightClass.BRACE_END, GREY);
        colors.put(HighlightClass.BRACKET_BEGIN, GREY);
        colors.put(HighlightClass.BRACKET_END, GREY);
        colors.put(HighlightClass.PARENTHESIS_BEGIN, GREY);
        colors.put(HighlightClass.PARENTHESIS_END, GREY);
        colors.put(HighlightClass.UNKNOWN, GREY);
        colors.put(HighlightClass.UNPROCESSED, RED);
        return new DocColorTheme("light", colors);
    }
}

