/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.functions;

import com.github.jlangch.venice.SecurityException;
import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.Printer;
import com.github.jlangch.venice.impl.thread.ThreadContext;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.VncBoolean;
import com.github.jlangch.venice.impl.types.VncChar;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncJavaObject;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncHashMap;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.util.Coerce;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.impl.util.ArityExceptions;
import com.github.jlangch.venice.impl.util.SymbolMapBuilder;
import com.github.jlangch.venice.impl.util.io.CharsetUtil;
import com.github.jlangch.venice.impl.util.io.IOStreamUtil;
import com.github.jlangch.venice.javainterop.IInterceptor;
import com.github.jlangch.venice.javainterop.ILoadPaths;
import com.github.jlangch.venice.util.CapturingPrintStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Map;

public class IOFunctionsStreams {
    public static VncFunction io_flush = new VncFunction("io/flush", (VncVal)VncFunction.meta().arglists("(io/flush s)").doc("Flushes a `:java.io.OutputStream` or a `:java.io.Writer`.").seeAlso("io/close").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            this.sandboxFunctionCallValidation();
            VncVal arg = args.first();
            if (Types.isVncJavaObject(arg, OutputStream.class)) {
                OutputStream os = Coerce.toVncJavaObject(args.first(), OutputStream.class);
                try {
                    os.flush();
                }
                catch (Exception ex) {
                    throw new VncException("Failed to close: " + os.getClass().getName());
                }
            } else if (Types.isVncJavaObject(arg, Writer.class)) {
                Writer wr = Coerce.toVncJavaObject(args.first(), Writer.class);
                try {
                    wr.flush();
                }
                catch (Exception ex) {
                    throw new VncException("Failed to close: " + wr.getClass().getName());
                }
            } else {
                throw new VncException(String.format("Function 'io/flush' does not allow %s as argument", Types.getType(args.first())));
            }
            return Constants.Nil;
        }
    };
    public static VncFunction io_close = new VncFunction("io/close", (VncVal)VncFunction.meta().arglists("(io/close s)").doc("Closes a `:java.io.InputStream`, `:java.io.OutputStream`, `:java.io.Reader`, or a `:java.io.Writer`.\n\nOften it is more elegant to use try-with to let Venice implicitly close the stream when its leaves the scope:  \n\n```                                        \n(let [file (io/file \"foo.txt\")]          \n  (try-with [is (io/file-in-stream file)]  \n     (io/slurp-stream is :binary false)))  \n```").seeAlso("io/flush").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            this.sandboxFunctionCallValidation();
            VncVal arg = args.first();
            if (Types.isVncJavaObject(arg, InputStream.class)) {
                InputStream is = Coerce.toVncJavaObject(args.first(), InputStream.class);
                try {
                    is.close();
                }
                catch (Exception ex) {
                    throw new VncException("Failed to close: " + is.getClass().getName());
                }
            } else if (Types.isVncJavaObject(arg, OutputStream.class)) {
                OutputStream os = Coerce.toVncJavaObject(args.first(), OutputStream.class);
                try {
                    os.close();
                }
                catch (Exception ex) {
                    throw new VncException("Failed to close: " + os.getClass().getName());
                }
            } else if (Types.isVncJavaObject(arg, Reader.class)) {
                Reader rd = Coerce.toVncJavaObject(args.first(), Reader.class);
                try {
                    rd.close();
                }
                catch (Exception ex) {
                    throw new VncException("Failed to close: " + rd.getClass().getName());
                }
            } else if (Types.isVncJavaObject(arg, Writer.class)) {
                Writer wr = Coerce.toVncJavaObject(args.first(), Writer.class);
                try {
                    wr.close();
                }
                catch (Exception ex) {
                    throw new VncException("Failed to close: " + wr.getClass().getName());
                }
            } else {
                throw new VncException(String.format("Function 'io/close' does not allow %s as argument", Types.getType(args.first())));
            }
            return Constants.Nil;
        }
    };
    public static VncFunction io_copy_stream = new VncFunction("io/copy-stream", (VncVal)VncFunction.meta().arglists("(io/copy-stream in-stream out-stream)").doc("Copies the input stream to the output stream. Returns `nil` on sucess or throws a VncException on failure. Input and output must be a `java.io.InputStream` and `java.io.OutputStream`.").seeAlso("io/copy-file").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2);
            this.sandboxFunctionCallValidation();
            InputStream is = Coerce.toVncJavaObject(args.first(), InputStream.class);
            OutputStream os = Coerce.toVncJavaObject(args.second(), OutputStream.class);
            try {
                IOStreamUtil.copy(is, os);
            }
            catch (Exception ex) {
                throw new VncException("Failed to copy data from a :java.io.InputStream to a :java.io.OutputStream");
            }
            return Constants.Nil;
        }
    };
    public static VncFunction io_file_in_stream = new VncFunction("io/file-in-stream", (VncVal)VncFunction.meta().arglists("(io/file-in-stream f)").doc("Returns a `java.io.InputStream` for the file f.           \n\nf may be a:                                               \n\n * string file path, e.g: \"/temp/foo.json\"              \n * `java.io.File`, e.g: `(io/file \"/temp/foo.json\")`    \n\n`io/file-in-stream` supports load paths. See the `loadpath/paths` doc for a description of the *load path* feature.\n\nNote: The caller is responsible for closing the stream!").seeAlso("io/slurp", "io/slurp-stream", "io/string-in-stream", "io/bytebuf-in-stream", "loadpath/paths").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertMinArity(this, args, 1);
            File file = IOFunctionsStreams.convertToFile(args.first());
            if (file != null) {
                IInterceptor interceptor = this.sandboxFunctionCallValidation();
                try {
                    InputStream is = interceptor.getLoadPaths().getInputStream(file);
                    if (is == null) {
                        if (file.exists()) {
                            throw new VncException("Failed to slurp data from the file " + file.getPath() + ". The file does not exists!");
                        }
                        throw new SecurityException("Failed to slurp data from the file " + file.getPath() + ". The load paths configuration prevented this action!");
                    }
                    return new VncJavaObject(is);
                }
                catch (Exception ex) {
                    throw new VncException("Failed to create a a `java.io.InputStream` from the file " + file.getPath(), ex);
                }
            }
            throw new VncException(String.format("Function 'io/file-in-stream' does not allow %s as f", Types.getType(args.first())));
        }
    };
    public static VncFunction io_file_out_stream = new VncFunction("io/file-out-stream", (VncVal)VncFunction.meta().arglists("(io/file-out-stream f options)").doc("Returns a `java.io.OutputStream` for the file f. \n\nf may be a:  \n\n * string file path, e.g: \"/temp/foo.json\" \n * `java.io.File`, e.g: `(io/file \"/temp/foo.json\")` \n\nOptions: \n\n| :append true/false | e.g.: `:append true`, defaults to false |\n| :encoding enc      | e.g.: `:encoding :utf-8`, defaults to :utf-8 |\n\n`io/file-out-stream` supports load paths. See the `loadpath/paths` doc for a description of the *load path* feature.\n\nNote: The caller is responsible for closing the stream!").seeAlso("io/slurp", "io/slurp-stream", "io/string-in-stream", "io/bytebuf-in-stream", "loadpath/paths").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertMinArity(this, args, 1);
            VncHashMap options = VncHashMap.ofAll(args.slice(2));
            VncVal append = options.get(new VncKeyword("append"));
            File file = IOFunctionsStreams.convertToFile(args.first());
            if (file != null) {
                IInterceptor interceptor = this.sandboxFunctionCallValidation();
                try {
                    OutputStream outStream = interceptor.getLoadPaths().getOutputStream(file, StandardOpenOption.CREATE, StandardOpenOption.WRITE, VncBoolean.isTrue(append) ? StandardOpenOption.APPEND : StandardOpenOption.TRUNCATE_EXISTING);
                    if (outStream != null) {
                        return new VncJavaObject(outStream);
                    }
                    throw new SecurityException(String.format("Failed to spit data to the file %s. The load paths configuration prevented this action!", file.getPath()));
                }
                catch (Exception ex) {
                    throw new VncException(String.format("Failed to create a `java.io.OutputStream` for the file '%s'", file.getPath()), ex);
                }
            }
            throw new VncException(String.format("Function 'io/file-out-stream' does not allow %s as f", Types.getType(args.first())));
        }
    };
    public static VncFunction io_string_in_stream = new VncFunction("io/string-in-stream", (VncVal)VncFunction.meta().arglists("(io/string-in-stream s & options)").doc("Returns a `java.io.InputStream` for the string s.                     \n\nOptions:                                                              \n\n| :encoding enc      | e.g.: `:encoding :utf-8`, defaults to :utf-8 | \n\nNote: The caller is responsible for closing the stream!").examples("(let [text \"The quick brown fox jumped over the lazy dog\"]  \n  (try-with [is (io/string-in-stream text)]                   \n    ; do something with is                                    \n  ))").seeAlso("io/slurp-stream", "io/file-in-stream", "io/bytebuf-in-stream").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertMinArity(this, args, 1);
            this.sandboxFunctionCallValidation();
            VncString s = Coerce.toVncString(args.first());
            VncHashMap options = VncHashMap.ofAll(args.rest());
            VncVal encVal = options.get(new VncKeyword("encoding"));
            Charset charset = CharsetUtil.charset(encVal);
            try {
                return new VncJavaObject(new ByteArrayInputStream(s.getValue().getBytes(charset)));
            }
            catch (Exception ex) {
                throw new VncException("Failed to create a :java.io.InputStream from a string", ex);
            }
        }
    };
    public static VncFunction io_bytebuf_in_stream = new VncFunction("io/bytebuf-in-stream", (VncVal)VncFunction.meta().arglists("(io/bytebuf-in-stream buf)").doc("Returns a `java.io.InputStream` from a bytebuf.\n\nNote: The caller is responsible for closing the stream!").examples("(try-with [is (io/bytebuf-in-stream (bytebuf [97 98 99]))] \n    ; do something with is                                 \n  )").seeAlso("io/slurp-stream", "io/file-in-stream", "io/string-in-stream").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            ByteBuffer buf = Coerce.toVncByteBuffer(args.first()).getValue();
            try {
                return new VncJavaObject(new ByteArrayInputStream(buf.array()));
            }
            catch (Exception ex) {
                throw new VncException(String.format("Failed to create a :java.io.InputStream from a bytebuf", new Object[0]));
            }
        }
    };
    public static VncFunction io_bytebuf_out_stream = new VncFunction("io/bytebuf-out-stream", (VncVal)VncFunction.meta().arglists("(io/bytebuf-out-stream)").doc("Returns a new `java.io.ByteArrayOutputStream`.\n\nDereferencing a :ByteArrayOutputStream returns the captured bytebuf.\n\nNote: The caller is responsible for closing the stream!").examples("(try-with [os (io/bytebuf-out-stream)]                  \n   (io/spit-stream os (bytebuf [97 98 99]) :flush true) \n   (str/format-bytebuf @os \", \" :prefix0x))           ").seeAlso("io/slurp-stream", "io/file-in-stream", "io/string-in-stream").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 0);
            try {
                return new VncJavaObject(new ByteArrayOutputStream());
            }
            catch (Exception ex) {
                throw new VncException(String.format("Failed to create a :java.io.InputStream from a bytebuf", new Object[0]));
            }
        }
    };
    public static VncFunction io_uri_stream = new VncFunction("io/uri-stream", (VncVal)VncFunction.meta().arglists("(io/uri-stream uri)").doc("Returns a `java.io.InputStream` from the uri.\n\nNote: The caller is responsible for closing the stream!").examples("(let [url \"https://www.w3schools.com/xml/books.xm\"]     \n  (try-with [is (io/uri-stream url)]                      \n    (io/slurp-stream is :binary false :encoding :utf-8))) ").seeAlso("io/slurp-stream").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            String protocol;
            URL url;
            ILoadPaths loadpaths;
            block9: {
                ArityExceptions.assertMinArity(this, args, 1);
                this.sandboxFunctionCallValidation();
                VncVal arg = args.first();
                loadpaths = ThreadContext.getInterceptor().getLoadPaths();
                url = null;
                try {
                    if (Types.isVncString(arg)) {
                        url = new URL(Coerce.toVncString(arg).getValue());
                        break block9;
                    }
                    if (Types.isVncJavaObject(arg, URL.class)) {
                        url = Coerce.toVncJavaObject(arg, URL.class);
                        break block9;
                    }
                    if (Types.isVncJavaObject(arg, URI.class)) {
                        url = Coerce.toVncJavaObject(arg, URI.class).toURL();
                        break block9;
                    }
                    throw new VncException(String.format("Function 'io/uri-stream' does not allow %s as argument", Types.getType(arg)));
                }
                catch (VncException ex) {
                    throw ex;
                }
                catch (MalformedURLException ex) {
                    throw new VncException("Function 'io/uri-stream' got a malformed uri as argument", ex);
                }
            }
            if (!(loadpaths.isUnlimitedAccess() || "http".equals(protocol = url.getProtocol()) || "https".equals(protocol))) {
                throw new VncException(String.format("io/uri-stream supports only the protocols 'http' and 'https' if load paths 'limited access' is configured! Rejected protocol '%s'.", protocol));
            }
            try {
                return new VncJavaObject(url.openStream());
            }
            catch (Exception ex) {
                throw new VncException("Failed to create a :java.io.InputStream from an URI", ex);
            }
        }
    };
    public static VncFunction io_wrap_os_with_buffered_writer = new VncFunction("io/wrap-os-with-buffered-writer", (VncVal)VncFunction.meta().arglists("(io/wrap-os-with-buffered-writer os encoding?)").doc("Wraps a `java.io.OutputStream` os with a `java.io.BufferedWriter` using an optional encoding (defaults to :utf-8).\n\nNote: The caller is responsible for closing the writer!").examples("(let [os (io/bytebuf-out-stream)]                             \n  (try-with [wr (io/wrap-os-with-buffered-writer os :utf-8)]  \n    (println wr \"line 1\")                                   \n    (println wr \"line 2\")                                   \n    (flush wr)                                                \n    @os))                                                     ").seeAlso("io/wrap-os-with-print-writer").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1, 2);
            try {
                OutputStream os = (OutputStream)Coerce.toVncJavaObject(args.first()).getDelegate();
                Charset charset = CharsetUtil.charset(args.second());
                return new VncJavaObject(new BufferedWriter(new OutputStreamWriter(os, charset)));
            }
            catch (Exception ex) {
                throw new VncException("Failed to wrap a :java.io.OutputStream with a :java.io.BufferedWriter", ex);
            }
        }
    };
    public static VncFunction io_wrap_os_with_print_writer = new VncFunction("io/wrap-os-with-print-writer", (VncVal)VncFunction.meta().arglists("(io/wrap-os-with-print-writer os encoding?)").doc("Wraps an `java.io.OutputStream` os with a `java.io.PrintWriter` using an optional encoding (defaults to :utf-8).\n\nNote: The caller is responsible for closing the writer!").examples("(let [os (io/bytebuf-out-stream)]                            \n  (try-with [pr (io/wrap-os-with-print-writer os :utf-8)]    \n    (println pr \"line 1\")                                  \n    (println pr \"line 2\")                                  \n    (flush pr)                                               \n    @os))                                                    ").seeAlso("io/wrap-os-with-buffered-writer").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1, 2);
            try {
                OutputStream os = (OutputStream)Coerce.toVncJavaObject(args.first()).getDelegate();
                Charset charset = CharsetUtil.charset(args.second());
                return new VncJavaObject(new PrintWriter(new OutputStreamWriter(os, charset)));
            }
            catch (Exception ex) {
                throw new VncException("Failed to wrap a :java.io.OutputStream with a :java.io.PrintWriter", ex);
            }
        }
    };
    public static VncFunction io_wrap_is_with_buffered_reader = new VncFunction("io/wrap-is-with-buffered-reader", (VncVal)VncFunction.meta().arglists("(io/wrap-is-with-buffered-reader is encoding?)").doc("Wraps an `java.io.InputStream` is with a `java.io.BufferedReader` using an optional encoding (defaults to :utf-8).\n\nNote: The caller is responsible for closing the reader!").examples("(let [data (bytebuf [108 105 110 101 32 49 10 108 105 110 101 32 50])     \n       is   (io/bytebuf-in-stream data)]                                  \n  (try-with [rd (io/wrap-is-with-buffered-reader is :utf-8)]              \n    (println (read-line rd))                                              \n    (println (read-line rd))))                                            ").seeAlso("io/buffered-reader").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            Object delegate;
            ArityExceptions.assertArity(this, args, 1, 2);
            if (Types.isVncJavaObject(args.first()) && (delegate = ((VncJavaObject)args.first()).getDelegate()) instanceof InputStream) {
                try {
                    InputStream is = (InputStream)delegate;
                    Charset charset = CharsetUtil.charset(args.second());
                    return new VncJavaObject(new BufferedReader(new InputStreamReader(is, charset)));
                }
                catch (Exception ex) {
                    throw new VncException("Failed to wrap a :java.io.InputStream with a :java.io.BufferReader", ex);
                }
            }
            throw new VncException(String.format("Function 'io/wrap-is-with-buffered-reader' requires an InputStream or a Reader. %s as is not allowed!", Types.getType(args.first())));
        }
    };
    public static VncFunction io_buffered_reader = new VncFunction("io/buffered-reader", (VncVal)VncFunction.meta().arglists("(io/buffered-reader is encoding?)", "(io/buffered-reader rdr)").doc("Creates a `java.io.BufferedReader` from a `java.io.InputStream` is with optional encoding (defaults to :utf-8), from a `java.io.Reader` or from a string.\n\nNote: The caller is responsible for closing the reader!").examples("(let [data (bytebuf [108 105 110 101 32 49 10 108 105 110 101 32 50])      \n      is   (io/bytebuf-in-stream data)]                                    \n  (try-with [rd (io/buffered-reader is :utf-8)]                            \n    (println (read-line rd))                                               \n    (println (read-line rd))))                                             ", "(try-with [rd (io/buffered-reader \"1\\n2\\n3\\n4\")]                      \n  (println (read-line rd))                                                 \n  (println (read-line rd)))                                                ").seeAlso("io/buffered-writer").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1, 2);
            if (Types.isVncString(args.first())) {
                return new VncJavaObject(new BufferedReader(new StringReader(((VncString)args.first()).getValue())));
            }
            if (Types.isVncJavaObject(args.first())) {
                Object delegate = ((VncJavaObject)args.first()).getDelegate();
                if (delegate instanceof InputStream) {
                    try {
                        InputStream is = (InputStream)delegate;
                        Charset charset = CharsetUtil.charset(args.second());
                        return new VncJavaObject(new BufferedReader(new InputStreamReader(is, charset)));
                    }
                    catch (Exception ex) {
                        throw new VncException(ex.getMessage(), ex);
                    }
                }
                if (delegate instanceof BufferedReader) {
                    return args.first();
                }
                if (delegate instanceof Reader) {
                    return new VncJavaObject(new BufferedReader((Reader)delegate));
                }
            }
            throw new VncException(String.format("Function 'io/buffered-reader' requires a :java.io.InputStream, a :java.io.Reader, or a string. %s as is not allowed!", Types.getType(args.first())));
        }
    };
    public static VncFunction io_buffered_writer = new VncFunction("io/buffered-writer", (VncVal)VncFunction.meta().arglists("(io/buffered-writer os encoding?)", "(io/buffered-writer wr)").doc("Creates a `java.io.BufferedWriter` from a `java.io.OutputStream` os with optional encoding (defaults to :utf-8) or from a `java.io.Writer`.\n\nNote: The caller is responsible for closing the writer!").examples(new String[0]).seeAlso("io/buffered-reader").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1, 2);
            if (Types.isVncJavaObject(args.first())) {
                Object delegate = ((VncJavaObject)args.first()).getDelegate();
                if (delegate instanceof OutputStream) {
                    try {
                        OutputStream os = (OutputStream)delegate;
                        Charset charset = CharsetUtil.charset(args.second());
                        return new VncJavaObject(new BufferedWriter(new OutputStreamWriter(os, charset)));
                    }
                    catch (Exception ex) {
                        throw new VncException(ex.getMessage(), ex);
                    }
                }
                if (delegate instanceof BufferedWriter) {
                    return args.first();
                }
                if (delegate instanceof Writer) {
                    return new VncJavaObject(new BufferedWriter((Writer)delegate));
                }
            }
            throw new VncException(String.format("Function 'io/buffered-writer' requires a :java.io.OutputStream or a :java.io.Writer. %s as is not allowed!", Types.getType(args.first())));
        }
    };
    public static VncFunction io_string_writer = new VncFunction("io/string-writer", (VncVal)VncFunction.meta().arglists("(io/string-writer)").doc("Creates a `java.io.StringWriter`.\n\nDereferencing a string writer returns the captured string.\n\nNote: The caller is responsible for closing the writer!").examples("(try-with [sw (io/string-writer)]     \n  (print sw 100)                      \n  (print sw \"-\")                    \n  (print sw 200)                      \n  (flush sw)                          \n  (println @sw))                      ").seeAlso("str", "io/string-reader").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 0);
            return new VncJavaObject(new StringWriter());
        }
    };
    public static VncFunction io_string_reader = new VncFunction("io/string-reader", (VncVal)VncFunction.meta().arglists("(io/string-reader s)").doc("Creates a `java.io.StringReader` from a string.\n\nNote: The caller is responsible for closing the reader!").examples("(try-with [rd (io/string-reader \"1234\")]       \n  (println (read-char rd))                       \n  (println (read-char rd))                       \n  (println (read-char rd)))                      ", "(let [rd (io/string-reader \"1\\n2\\n3\\n4\")]   \n  (try-with [br (io/buffered-reader rd)]         \n    (println (read-line br))                     \n    (println (read-line br))                     \n    (println (read-line br))))                   ").seeAlso("io/string-writer", "io/buffered-reader").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            return new VncJavaObject(new StringReader(Coerce.toVncString(args.first()).getValue()));
        }
    };
    public static VncFunction io_capturing_print_stream = new VncFunction("io/capturing-print-stream", (VncVal)VncFunction.meta().arglists("(io/capturing-print-stream)").doc("Creates a new capturing print stream.\n\nDereferencing a capturing print stream returns the captured string.\n\nNote: The caller is responsible for closing the stream!").examples("(try-with [ps (io/capturing-print-stream)]    \n  (binding [*out* ps]                         \n    (println 100)                             \n    (println 200)                             \n    (flush)                                   \n    @ps))                                     ", "(try-with [ps (io/capturing-print-stream)]    \n  (println ps 100)                            \n  (println ps 200)                            \n  (flush ps)                                  \n  @ps)                                        ").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 0);
            return new VncJavaObject(new CapturingPrintStream());
        }
    };
    public static VncFunction io_print = new VncFunction("io/print", (VncVal)VncFunction.meta().arglists("(io/print os s)").doc("Prints a string s to an output stream. The output stream may be a `:java.io.Writer` or a `:java.io.PrintStream`!").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2);
            VncVal v = args.first();
            if (Types.isVncJavaObject(v, PrintStream.class)) {
                PrintStream ps = Coerce.toVncJavaObject(v, PrintStream.class);
                ps.print(Printer.pr_str(args.second(), false));
            } else if (Types.isVncJavaObject(v, Writer.class)) {
                Writer wr = Coerce.toVncJavaObject(v, Writer.class);
                try {
                    wr.write(Printer.pr_str(args.second(), false));
                }
                catch (IOException ex) {
                    throw new VncException("Failed print string to a :java.io.Writer", ex);
                }
            } else {
                throw new VncException(String.format("io/print does not allow type %s as output stream arg. Expected a :java.io.PrintStream or a :java.io.Writer.", Types.getType(args.first())));
            }
            return Constants.Nil;
        }
    };
    public static VncFunction io_read_line = new VncFunction("io/read-line", (VncVal)VncFunction.meta().arglists("(io/read-line is)").doc("Reads the next line from the passed stream that must be a subclass of `:java.io.BufferedReader`.\n\nReturns `nil` if the end of the stream is reached.").seeAlso("io/read-char").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            VncVal v = args.first();
            if (Types.isVncJavaObject(v, BufferedReader.class)) {
                BufferedReader br = Coerce.toVncJavaObject(v, BufferedReader.class);
                try {
                    return new VncString(br.readLine());
                }
                catch (IOException ex) {
                    throw new VncException("Failed read the next line from a :java.io.BufferedReader.", ex);
                }
            }
            throw new VncException(String.format("io/read-line does not allow type %s as input stream arg. Expected a :java.io.BufferedReader.", Types.getType(args.first())));
        }
    };
    public static VncFunction io_read_char = new VncFunction("io/read-char", (VncVal)VncFunction.meta().arglists("(io/read-char is)").doc("With arg reads the next char from the passed stream that must be a subclass of `:java.io.Reader`.\n\nReturns `nil` if the end of the stream is reached.").seeAlso("io/read-line").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            VncVal v = args.first();
            if (Types.isVncJavaObject(v, Reader.class)) {
                Reader rd = Coerce.toVncJavaObject(v, Reader.class);
                try {
                    int ch = rd.read();
                    return ch == -1 ? Constants.Nil : new VncChar((char)ch);
                }
                catch (IOException ex) {
                    throw new VncException("Failed read the next a char from a :java.io.Reader", ex);
                }
            }
            throw new VncException(String.format("io/read-char does not allow type %s as input stream arg. Expected a :java.io.Reader.", Types.getType(args.first())));
        }
    };
    public static Map<VncVal, VncVal> ns = new SymbolMapBuilder().add(io_copy_stream).add(io_uri_stream).add(io_file_in_stream).add(io_file_out_stream).add(io_string_in_stream).add(io_bytebuf_in_stream).add(io_bytebuf_out_stream).add(io_wrap_os_with_buffered_writer).add(io_wrap_os_with_print_writer).add(io_wrap_is_with_buffered_reader).add(io_buffered_reader).add(io_buffered_writer).add(io_string_writer).add(io_string_reader).add(io_capturing_print_stream).add(io_print).add(io_read_line).add(io_read_char).add(io_flush).add(io_close).toMap();

    public static File convertToFile(VncVal f, String errFormat) {
        File file = IOFunctionsStreams.convertToFile(f);
        if (file == null) {
            throw new VncException(String.format(errFormat, Types.getType(f)));
        }
        return file;
    }

    private static File convertToFile(VncVal f) {
        if (Types.isVncString(f)) {
            return new File(((VncString)f).getValue());
        }
        if (Types.isVncJavaObject(f, File.class)) {
            return Coerce.toVncJavaObject(f, File.class);
        }
        if (Types.isVncJavaObject(f, Path.class)) {
            return Coerce.toVncJavaObject(f, Path.class).toFile();
        }
        return null;
    }

    public static void validateReadableFile(File file) {
        if (!file.isFile()) {
            throw new VncException(String.format("'%s' is not a file", file.getPath()));
        }
        if (!file.canRead()) {
            throw new VncException(String.format("The file '%s' has no read permission", file.getPath()));
        }
    }
}

