/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types;

import com.github.jlangch.venice.impl.FunctionMetaBuilder;
import com.github.jlangch.venice.impl.thread.ThreadContext;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.INamespaceAware;
import com.github.jlangch.venice.impl.types.IVncFunction;
import com.github.jlangch.venice.impl.types.TypeRank;
import com.github.jlangch.venice.impl.types.VncConstant;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncVector;
import com.github.jlangch.venice.impl.types.util.QualifiedName;
import com.github.jlangch.venice.impl.util.CallFrame;
import com.github.jlangch.venice.impl.util.MetaUtil;
import com.github.jlangch.venice.impl.util.MeterRegistry;
import com.github.jlangch.venice.impl.util.StringUtil;
import com.github.jlangch.venice.javainterop.IInterceptor;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;

public abstract class VncFunction
extends VncVal
implements IVncFunction,
INamespaceAware {
    public static final String TYPE_FUNCTION = ":core/function";
    public static final String TYPE_MACRO = ":core/macro";
    private static final long serialVersionUID = -1848883965231344442L;
    private final String namespace;
    private final String simpleName;
    private final String qualifiedName;
    private final VncVector params;
    private final int fixedArgsCount;
    private final boolean variadicArgs;
    private final VncVector preConditions;
    private final boolean anonymous;
    private final boolean macro;
    private final AtomicReference<VncVal> fnMeta = new AtomicReference<VncConstant>(Constants.Nil);
    private volatile boolean fnPrivate;

    public VncFunction(String name) {
        this(name, null, false, null, Constants.Nil);
    }

    public VncFunction(String name, VncVal meta) {
        this(name, null, false, null, meta);
    }

    public VncFunction(String name, VncVector params, VncVal meta) {
        this(name, params, false, null, meta);
    }

    public VncFunction(String name, VncVector params) {
        this(name, params, false, null, Constants.Nil);
    }

    public VncFunction(String name, VncVector params, boolean macro, VncVector preConditions, VncVal meta) {
        super(Constants.Nil);
        QualifiedName qn = QualifiedName.parse(name);
        this.namespace = qn.getNamespace();
        this.simpleName = qn.getSimpleName();
        this.qualifiedName = qn.getQualifiedName();
        this.params = params == null ? VncVector.empty() : params;
        int fixedArgs = 0;
        boolean variadic = false;
        if (params != null) {
            for (VncVal p : params) {
                if (VncFunction.isElisionSymbol(p)) {
                    variadic = true;
                    break;
                }
                ++fixedArgs;
            }
        }
        this.fixedArgsCount = fixedArgs;
        this.variadicArgs = variadic;
        this.anonymous = VncFunction.isAnonymousFuncName(this.simpleName);
        this.macro = macro;
        this.preConditions = preConditions;
        this.fnMeta.set(MetaUtil.setNamespace(meta, this.namespace));
        this.fnPrivate = MetaUtil.isPrivate(meta);
    }

    public static VncFunction of(final IVncFunction fn) {
        return new VncFunction(VncFunction.createAnonymousFuncName()){
            private static final long serialVersionUID = 1L;

            @Override
            public VncVal apply(VncList args) {
                return fn.apply(args);
            }
        };
    }

    public static VncFunction of(final Supplier<VncVal> fn) {
        return new VncFunction(VncFunction.createAnonymousFuncName()){
            private static final long serialVersionUID = 1L;

            @Override
            public VncVal apply(VncList args) {
                return (VncVal)fn.get();
            }
        };
    }

    public static VncFunction of(final Function<VncList, VncVal> fn) {
        return new VncFunction(VncFunction.createAnonymousFuncName()){
            private static final long serialVersionUID = 1L;

            @Override
            public VncVal apply(VncList args) {
                return (VncVal)fn.apply(args);
            }
        };
    }

    @Override
    public VncFunction withMeta(VncVal meta) {
        this.fnMeta.set(meta);
        this.fnPrivate = MetaUtil.isPrivate(meta);
        return this;
    }

    @Override
    public VncKeyword getType() {
        return new VncKeyword(this.isMacro() ? TYPE_MACRO : TYPE_FUNCTION, MetaUtil.typeMeta(new VncKeyword(":core/val")));
    }

    @Override
    public abstract VncVal apply(VncList var1);

    @Override
    public VncVal applyOf(VncVal ... mvs) {
        return this.apply(VncList.of(mvs));
    }

    public VncFunction getFunctionForArgs(VncList args) {
        return this.getFunctionForArity(args.size());
    }

    public VncFunction getFunctionForArity(int arity) {
        return this;
    }

    @Override
    public boolean isNative() {
        return true;
    }

    public boolean isRedefinable() {
        return true;
    }

    public VncVector getParams() {
        return this.params;
    }

    @Override
    public boolean isMacro() {
        return this.macro;
    }

    @Override
    public boolean isAnonymous() {
        return this.anonymous;
    }

    @Override
    public String getSimpleName() {
        return this.simpleName;
    }

    @Override
    public String getQualifiedName() {
        return this.qualifiedName;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public boolean hasNamespace() {
        return this.namespace != null;
    }

    @Override
    public VncList getArgLists() {
        return (VncList)this.getMetaVal(MetaUtil.ARGLIST, VncList.empty());
    }

    public VncVal getDoc() {
        return this.getMetaVal(MetaUtil.DOC);
    }

    public VncList getExamples() {
        return (VncList)this.getMetaVal(MetaUtil.EXAMPLES, VncList.empty());
    }

    public VncList getSeeAlso() {
        return (VncList)this.getMetaVal(MetaUtil.SEE_ALSO, VncList.empty());
    }

    public int getFixedArgsCount() {
        return this.fixedArgsCount;
    }

    public boolean hasVariadicArgs() {
        return this.variadicArgs;
    }

    public VncVal getBody() {
        return Constants.Nil;
    }

    public VncVector getPreConditions() {
        return this.preConditions;
    }

    public boolean hasPreConditions() {
        return this.preConditions != null && !this.preConditions.isEmpty();
    }

    @Override
    public VncVal getMeta() {
        return this.fnMeta.get();
    }

    @Override
    public boolean isPrivate() {
        return this.fnPrivate;
    }

    @Override
    public TypeRank typeRank() {
        return TypeRank.FUNCTION;
    }

    @Override
    public Object convertToJavaObject() {
        return this;
    }

    public String toString() {
        return String.format("%s %s %s%s", this.isMacro() ? "macro" : "function", this.getQualifiedName(), new StringBuilder().append("{").append("visibility ").append(this.isPrivate() ? ":private" : ":public").append(", ns ").append(StringUtil.quote(this.namespace == null ? "" : this.namespace, '\"')).append(", native " + this.isNative()).append("}"), this.isNative() ? "" : " defined at " + new CallFrame(this).getSourcePosInfo());
    }

    protected IInterceptor sandboxFunctionCallValidation() {
        return ThreadContext.getInterceptor().validateVeniceFunction(this.qualifiedName);
    }

    public static String createAnonymousFuncName() {
        return VncFunction.createAnonymousFuncName(null);
    }

    public static String createAnonymousFuncName(String name) {
        return StringUtil.isEmpty(name) ? "anonymous-" + UUID.randomUUID().toString() : "anonymous-" + name + "-" + UUID.randomUUID().toString();
    }

    public static boolean isAnonymousFuncName(String name) {
        return name == null || name.startsWith("anonymous-");
    }

    private static boolean isElisionSymbol(VncVal val) {
        return val instanceof VncSymbol && ((VncSymbol)val).getName().equals("&");
    }

    public static FunctionMetaBuilder meta() {
        return new FunctionMetaBuilder();
    }

    public static VncVal applyWithMeter(IVncFunction fn, VncList args, MeterRegistry meterRegistry) {
        if (meterRegistry.enabled && fn.isNative()) {
            long nanos = System.nanoTime();
            VncVal result = fn.apply(args);
            meterRegistry.record(((VncFunction)fn).getQualifiedName(), System.nanoTime() - nanos);
            return result;
        }
        return fn.apply(args);
    }
}

