/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types.util;

import com.github.jlangch.venice.impl.javainterop.JavaInteropUtil;
import com.github.jlangch.venice.impl.namespaces.Namespaces;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.IDeref;
import com.github.jlangch.venice.impl.types.IVncFunction;
import com.github.jlangch.venice.impl.types.IVncJavaObject;
import com.github.jlangch.venice.impl.types.VncAtom;
import com.github.jlangch.venice.impl.types.VncBigDecimal;
import com.github.jlangch.venice.impl.types.VncBigInteger;
import com.github.jlangch.venice.impl.types.VncBoolean;
import com.github.jlangch.venice.impl.types.VncByteBuffer;
import com.github.jlangch.venice.impl.types.VncChar;
import com.github.jlangch.venice.impl.types.VncConstant;
import com.github.jlangch.venice.impl.types.VncDouble;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncInteger;
import com.github.jlangch.venice.impl.types.VncJavaObject;
import com.github.jlangch.venice.impl.types.VncJust;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncLong;
import com.github.jlangch.venice.impl.types.VncMultiArityFunction;
import com.github.jlangch.venice.impl.types.VncMultiFunction;
import com.github.jlangch.venice.impl.types.VncNumber;
import com.github.jlangch.venice.impl.types.VncSpecialForm;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.types.VncThreadLocal;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.VncVolatile;
import com.github.jlangch.venice.impl.types.collections.VncCollection;
import com.github.jlangch.venice.impl.types.collections.VncDAG;
import com.github.jlangch.venice.impl.types.collections.VncDelayQueue;
import com.github.jlangch.venice.impl.types.collections.VncHashMap;
import com.github.jlangch.venice.impl.types.collections.VncHashSet;
import com.github.jlangch.venice.impl.types.collections.VncJavaList;
import com.github.jlangch.venice.impl.types.collections.VncJavaMap;
import com.github.jlangch.venice.impl.types.collections.VncJavaSet;
import com.github.jlangch.venice.impl.types.collections.VncLazySeq;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncMap;
import com.github.jlangch.venice.impl.types.collections.VncMapEntry;
import com.github.jlangch.venice.impl.types.collections.VncMutableList;
import com.github.jlangch.venice.impl.types.collections.VncMutableMap;
import com.github.jlangch.venice.impl.types.collections.VncMutableSet;
import com.github.jlangch.venice.impl.types.collections.VncMutableVector;
import com.github.jlangch.venice.impl.types.collections.VncOrderedMap;
import com.github.jlangch.venice.impl.types.collections.VncQueue;
import com.github.jlangch.venice.impl.types.collections.VncSequence;
import com.github.jlangch.venice.impl.types.collections.VncSet;
import com.github.jlangch.venice.impl.types.collections.VncSortedMap;
import com.github.jlangch.venice.impl.types.collections.VncSortedSet;
import com.github.jlangch.venice.impl.types.collections.VncStack;
import com.github.jlangch.venice.impl.types.collections.VncVector;
import com.github.jlangch.venice.impl.types.custom.VncCustomType;
import com.github.jlangch.venice.impl.types.custom.VncProtocol;
import com.github.jlangch.venice.impl.util.MetaUtil;
import java.util.Map;

public class Types {
    public static final VncKeyword ANY = new VncKeyword("core/any");

    public static boolean isIDeref(Object val) {
        return val != null && val instanceof IDeref;
    }

    public static boolean isVncVal(Object val) {
        return val != null && val instanceof VncVal;
    }

    public static boolean isVncConstant(VncVal val) {
        return val != null && val instanceof VncConstant;
    }

    public static boolean isVncBoolean(VncVal val) {
        return val != null && val instanceof VncBoolean;
    }

    public static boolean isVncAtom(VncVal val) {
        return val != null && val instanceof VncAtom;
    }

    public static boolean isVncVolatile(VncVal val) {
        return val != null && val instanceof VncVolatile;
    }

    public static boolean isVncThreadLocal(VncVal val) {
        return val != null && val instanceof VncThreadLocal;
    }

    public static boolean isVncString(VncVal val) {
        return val != null && val instanceof VncString;
    }

    public static boolean isVncChar(VncVal val) {
        return val != null && val instanceof VncChar;
    }

    public static boolean isVncKeyword(VncVal val) {
        return val != null && val instanceof VncKeyword;
    }

    public static boolean isVncSymbol(VncVal val) {
        return val != null && val instanceof VncSymbol;
    }

    public static boolean isVncInteger(VncVal val) {
        return val != null && val instanceof VncInteger;
    }

    public static boolean isVncLong(VncVal val) {
        return val != null && val instanceof VncLong;
    }

    public static boolean isVncDouble(VncVal val) {
        return val != null && val instanceof VncDouble;
    }

    public static boolean isVncBigDecimal(VncVal val) {
        return val != null && val instanceof VncBigDecimal;
    }

    public static boolean isVncBigInteger(VncVal val) {
        return val != null && val instanceof VncBigInteger;
    }

    public static boolean isVncNumber(VncVal val) {
        return val != null && val instanceof VncNumber;
    }

    public static boolean isVncJust(VncVal val) {
        return val != null && val instanceof VncJust;
    }

    public static boolean isVncCustomType(VncVal val) {
        return val != null && val instanceof VncCustomType;
    }

    public static boolean isVncByteBuffer(VncVal val) {
        return val != null && val instanceof VncByteBuffer;
    }

    public static boolean isVncCollection(VncVal val) {
        return val != null && val instanceof VncCollection;
    }

    public static boolean isVncSet(VncVal val) {
        return val != null && val instanceof VncSet;
    }

    public static boolean isVncHashSet(VncVal val) {
        return val != null && val instanceof VncHashSet;
    }

    public static boolean isVncSortedSet(VncVal val) {
        return val != null && val instanceof VncSortedSet;
    }

    public static boolean isVncMutableSet(VncVal val) {
        return val != null && val instanceof VncMutableSet;
    }

    public static boolean isVncSequence(VncVal val) {
        return val != null && val instanceof VncSequence;
    }

    public static boolean isVncList(VncVal val) {
        return val != null && val instanceof VncList;
    }

    public static boolean isVncLazySeq(VncVal val) {
        return val != null && val instanceof VncLazySeq;
    }

    public static boolean isVncMutableList(VncVal val) {
        return val != null && val instanceof VncMutableList;
    }

    public static boolean isVncVector(VncVal val) {
        return val != null && val instanceof VncVector;
    }

    public static boolean isVncMutableVector(VncVal val) {
        return val != null && val instanceof VncMutableVector;
    }

    public static boolean isVncMap(VncVal val) {
        return val != null && val instanceof VncMap;
    }

    public static boolean isVncHashMap(VncVal val) {
        return val != null && val instanceof VncHashMap;
    }

    public static boolean isVncOrderedMap(VncVal val) {
        return val != null && val instanceof VncOrderedMap;
    }

    public static boolean isVncSortedMap(VncVal val) {
        return val != null && val instanceof VncSortedMap;
    }

    public static boolean isVncMutableMap(VncVal val) {
        return val != null && val instanceof VncMutableMap;
    }

    public static boolean isVncMapEntry(VncVal val) {
        return val != null && val instanceof VncMapEntry;
    }

    public static boolean isVncStack(VncVal val) {
        return val != null && val instanceof VncStack;
    }

    public static boolean isVncQueue(VncVal val) {
        return val != null && val instanceof VncQueue;
    }

    public static boolean isVncDelayQueue(VncVal val) {
        return val != null && val instanceof VncDelayQueue;
    }

    public static boolean isVncDAG(VncVal val) {
        return val != null && val instanceof VncDAG;
    }

    public static boolean isIVncFunction(VncVal val) {
        return val != null && val instanceof IVncFunction;
    }

    public static boolean isVncFunction(VncVal val) {
        return val != null && val instanceof VncFunction;
    }

    public static boolean isVncMultiArityFunction(VncVal val) {
        return val != null && val instanceof VncMultiArityFunction;
    }

    public static boolean isVncMultiFunction(VncVal val) {
        return val != null && val instanceof VncMultiFunction;
    }

    public static boolean isVncMacro(VncVal val) {
        return val != null && Types.isVncFunction(val) && ((VncFunction)val).isMacro();
    }

    public static boolean isVncSpecialForm(VncVal val) {
        return val != null && val instanceof VncSpecialForm;
    }

    public static boolean isVncJavaObject(VncVal val) {
        return val != null && val instanceof VncJavaObject;
    }

    public static boolean isVncJavaObject(VncVal val, Class<?> type) {
        return val != null && val instanceof VncJavaObject && type.isAssignableFrom(((VncJavaObject)val).getDelegate().getClass());
    }

    public static boolean isVncJavaList(VncVal val) {
        return val != null && val instanceof VncJavaList;
    }

    public static boolean isVncJavaSet(VncVal val) {
        return val != null && val instanceof VncJavaSet;
    }

    public static boolean isVncJavaMap(VncVal val) {
        return val != null && val instanceof VncJavaMap;
    }

    public static boolean isVncProtocol(VncVal val) {
        return val != null && val instanceof VncProtocol;
    }

    public static VncKeyword getType(VncVal val) {
        return val.getType();
    }

    public static VncVal getSupertype(VncVal val) {
        return MetaUtil.getSupertypes(val.getType().getMeta()).first();
    }

    public static VncList getSupertypes(VncVal val) {
        return MetaUtil.getSupertypes(val.getType().getMeta());
    }

    public static boolean isInstanceOf(VncKeyword type, VncVal val) {
        String sType;
        switch (sType = ":" + type.getQualifiedName()) {
            case ":core/nil": {
                return val == Constants.Nil;
            }
            case ":core/char": {
                return Types.isVncChar(val);
            }
            case ":core/string": {
                return Types.isVncString(val);
            }
            case ":core/boolean": {
                return Types.isVncBoolean(val);
            }
            case ":core/number": {
                return Types.isVncNumber(val);
            }
            case ":core/integer": {
                return Types.isVncInteger(val);
            }
            case ":core/long": {
                return Types.isVncLong(val);
            }
            case ":core/double": {
                return Types.isVncDouble(val);
            }
            case ":core/decimal": {
                return Types.isVncBigDecimal(val);
            }
            case ":core/bigint": {
                return Types.isVncBigInteger(val);
            }
            case ":core/bytebuf": {
                return Types.isVncByteBuffer(val);
            }
            case ":core/symbol": {
                return Types.isVncSymbol(val);
            }
            case ":core/keyword": {
                return Types.isVncKeyword(val);
            }
            case ":core/atom": {
                return Types.isVncAtom(val);
            }
            case ":core/volatile": {
                return Types.isVncVolatile(val);
            }
            case ":core/thread-local": {
                return Types.isVncThreadLocal(val);
            }
            case ":core/java-object": {
                return Types.isVncJavaObject(val);
            }
            case ":core/just": {
                return Types.isVncJust(val);
            }
            case ":core/function": {
                return Types.isVncFunction(val);
            }
            case ":core/macro": {
                return Types.isVncMacro(val);
            }
            case ":core/collection": {
                return Types.isVncCollection(val);
            }
            case ":core/sequence": {
                return Types.isVncSequence(val);
            }
            case ":core/vector": {
                return Types.isVncVector(val);
            }
            case ":core/list": {
                return Types.isVncList(val);
            }
            case ":core/mutable-list": {
                return Types.isVncMutableList(val);
            }
            case ":core/mutable-vector": {
                return Types.isVncMutableVector(val);
            }
            case ":core/set": {
                return Types.isVncSet(val);
            }
            case ":core/hash-set": {
                return Types.isVncHashSet(val);
            }
            case ":core/sorted-set": {
                return Types.isVncSortedSet(val);
            }
            case ":core/mutable-set": {
                return Types.isVncMutableSet(val);
            }
            case ":core/map": {
                return Types.isVncMap(val);
            }
            case ":core/hash-map": {
                return Types.isVncHashMap(val);
            }
            case ":core/ordered-map": {
                return Types.isVncOrderedMap(val);
            }
            case ":core/sorted-map": {
                return Types.isVncSortedMap(val);
            }
            case ":core/mutable-map": {
                return Types.isVncMutableMap(val);
            }
            case ":core/map-entry": {
                return Types.isVncMapEntry(val);
            }
            case ":core/stack": {
                return Types.isVncStack(val);
            }
            case ":core/queue": {
                return Types.isVncQueue(val);
            }
            case ":core/delay-queue": {
                return Types.isVncDelayQueue(val);
            }
            case ":core/custom-type": {
                return Types.isVncCustomType(val);
            }
            case ":dag/dag": {
                return Types.isVncDAG(val);
            }
        }
        try {
            if (Types.isVncCustomType(val)) {
                if (((VncCustomType)val).getType().equals(type)) {
                    return true;
                }
                if (Types.getSupertypes(val).getJavaList().contains(type)) {
                    return true;
                }
                if (val.isWrapped()) {
                    VncKeyword wrappingType = val.getWrappingTypeDef().getType();
                    return type.equals(wrappingType);
                }
                return false;
            }
            if (val.isWrapped()) {
                VncKeyword wrappingType = val.getWrappingTypeDef().getType();
                return type.equals(wrappingType);
            }
            Class<?> javaClazz = JavaInteropUtil.toClass(type, Namespaces.getCurrentNamespace().getJavaImports());
            if (Types.isVncJavaObject(val)) {
                return Class.forName(javaClazz.getName()).isAssignableFrom(((IVncJavaObject)((Object)val)).getDelegate().getClass());
            }
            if (Types.isVncJavaSet(val)) {
                return Class.forName(javaClazz.getName()).isAssignableFrom(((IVncJavaObject)((Object)val)).getDelegate().getClass());
            }
            if (Types.isVncJavaList(val)) {
                return Class.forName(javaClazz.getName()).isAssignableFrom(((IVncJavaObject)((Object)val)).getDelegate().getClass());
            }
            if (Types.isVncJavaMap(val)) {
                return Class.forName(javaClazz.getName()).isAssignableFrom(((IVncJavaObject)((Object)val)).getDelegate().getClass());
            }
            return false;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static boolean isCorePrimitiveType(VncVal val) {
        String type;
        switch (type = Types.isVncKeyword(val) ? ((VncKeyword)val).getValue() : val.getType().getValue()) {
            case "core/nil": {
                return true;
            }
            case "core/boolean": {
                return true;
            }
            case "core/long": {
                return true;
            }
            case "core/integer": {
                return true;
            }
            case "core/double": {
                return true;
            }
            case "core/bigint": {
                return true;
            }
            case "core/decimal": {
                return true;
            }
            case "core/string": {
                return true;
            }
            case "core/char": {
                return true;
            }
            case "core/symbol": {
                return true;
            }
            case "core/keyword": {
                return true;
            }
            case "core/function": {
                return true;
            }
        }
        return false;
    }

    public static boolean _equal_Q(VncVal a, VncVal b) {
        if (Types.isVncNumber(a) && Types.isVncNumber(b)) {
            return VncBoolean.isTrue(((VncNumber)a).equ(b));
        }
        if (Types.isVncString(a) && Types.isVncChar(b)) {
            return ((VncString)a).getValue().equals(((VncChar)b).getValue().toString());
        }
        if (Types.isVncChar(a) && Types.isVncString(b)) {
            return ((VncChar)a).getValue().toString().equals(((VncString)b).getValue());
        }
        return Types._equal_strict_Q(a, b);
    }

    public static boolean _equal_strict_Q(VncVal a, VncVal b) {
        Class<?> otb;
        Class<?> ota = a.getClass();
        if (!(ota == (otb = b.getClass()) || a instanceof VncString && b instanceof VncString || a instanceof VncList && b instanceof VncList)) {
            return false;
        }
        if (a instanceof VncConstant) {
            return (VncConstant)a == (VncConstant)b;
        }
        if (a instanceof VncBoolean) {
            return ((VncBoolean)a).getValue() == ((VncBoolean)b).getValue();
        }
        if (a instanceof VncLong) {
            return ((VncLong)a).toJavaLong() == ((VncLong)b).toJavaLong();
        }
        if (a instanceof VncInteger) {
            return ((VncInteger)a).toJavaInteger() == ((VncInteger)b).toJavaInteger();
        }
        if (a instanceof VncDouble) {
            return ((VncDouble)a).toJavaDouble() == ((VncDouble)b).toJavaDouble();
        }
        if (a instanceof VncBigDecimal) {
            return ((VncBigDecimal)a).getValue().equals(((VncBigDecimal)b).getValue());
        }
        if (a instanceof VncBigInteger) {
            return ((VncBigInteger)a).getValue().equals(((VncBigInteger)b).getValue());
        }
        if (a instanceof VncSymbol) {
            return ((VncSymbol)a).getName().equals(((VncSymbol)b).getName());
        }
        if (a instanceof VncString) {
            return ((VncString)a).getValue().equals(((VncString)b).getValue());
        }
        if (a instanceof VncSequence) {
            if (a instanceof VncJavaList) {
                return a.equals(b);
            }
            if (((VncSequence)a).size() != ((VncSequence)b).size()) {
                return false;
            }
            for (int i = 0; i < ((VncSequence)a).size(); ++i) {
                if (Types._equal_Q(((VncSequence)a).nth(i), ((VncSequence)b).nth(i))) continue;
                return false;
            }
            return true;
        }
        if (a instanceof VncSet) {
            if (a instanceof VncJavaSet) {
                return a.equals(b);
            }
            if (((VncSet)a).size() != ((VncSet)b).size()) {
                return false;
            }
            return ((VncSet)a).stream().allMatch(v -> ((VncSet)b).contains((VncVal)v));
        }
        if (a instanceof VncMap) {
            if (a instanceof VncJavaMap) {
                return a.equals(b);
            }
            if (((VncMap)a).getJavaMap().size() != ((VncMap)b).getJavaMap().size()) {
                return false;
            }
            VncMap mhm = (VncMap)a;
            Map<VncVal, VncVal> hm = mhm.getJavaMap();
            for (VncVal k : hm.keySet()) {
                VncVal valA = ((VncMap)a).getJavaMap().get(k);
                VncVal valB = ((VncMap)b).getJavaMap().get(k);
                if (valA == null && valB == null) {
                    return true;
                }
                if (valA != null && valB != null) {
                    if (Types._equal_Q(valA, valB)) continue;
                    return false;
                }
                return false;
            }
            return true;
        }
        return a.equals(b);
    }

    public static boolean isJavaTypeReference(VncKeyword keyword) {
        String name = keyword.getValue();
        if (name.indexOf(47) < 0) {
            return name.charAt(name.length() - 1) == '.' ? false : name.indexOf(46) >= 0;
        }
        return false;
    }
}

