/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.javainterop;

import com.github.jlangch.venice.SecurityException;
import com.github.jlangch.venice.impl.sandbox.RestrictedBlacklistedFunctions;
import com.github.jlangch.venice.javainterop.IInterceptor;
import com.github.jlangch.venice.javainterop.IInvoker;
import com.github.jlangch.venice.javainterop.Interceptor;
import com.github.jlangch.venice.javainterop.LoadPathsFactory;
import com.github.jlangch.venice.javainterop.ReturnValue;
import com.github.jlangch.venice.javainterop.SandboxRules;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class RejectAllInterceptor
extends Interceptor {
    private static final String PREFIX = "Venice Sandbox (RejectAllInterceptor)";
    private static final Integer MAX_EXECUTION_TIME_SECONDS = null;
    private static final Integer MAX_FUTURE_THREAD_POOL_SIZE = 5;
    private final long executionTimeDeadline = RejectAllInterceptor.calcExecutionTimeDeadline(MAX_EXECUTION_TIME_SECONDS);

    public RejectAllInterceptor() {
        super(LoadPathsFactory.rejectAll());
    }

    @Override
    public ReturnValue onInvokeInstanceMethod(IInvoker invoker, Object receiver, Class<?> receiverFormalType, String method, Object ... args) throws SecurityException {
        if (receiver == null) {
            throw new SecurityException(String.format("%s: Access to any java object denied", PREFIX));
        }
        throw new SecurityException(String.format("%s: Access denied to target %s", PREFIX, receiver.getClass().getName()));
    }

    @Override
    public ReturnValue onInvokeStaticMethod(IInvoker invoker, Class<?> receiver, String method, Object ... args) throws SecurityException {
        throw new SecurityException(String.format("%s: Access denied to target %s", PREFIX, receiver.getName()));
    }

    @Override
    public ReturnValue onInvokeConstructor(IInvoker invoker, Class<?> receiver, Object ... args) throws SecurityException {
        throw new SecurityException(String.format("%s: Access denied to target %s", PREFIX, receiver.getName()));
    }

    @Override
    public ReturnValue onGetBeanProperty(IInvoker invoker, Object receiver, String property) throws SecurityException {
        if (receiver == null) {
            throw new SecurityException(String.format("%s: Access to any java object denied", PREFIX));
        }
        throw new SecurityException(String.format("%s: Access denied to target %s", PREFIX, receiver.getClass().getName()));
    }

    @Override
    public void onSetBeanProperty(IInvoker invoker, Object receiver, String property, Object value) throws SecurityException {
        if (receiver == null) {
            throw new SecurityException(String.format("%s: Access to any java object denied", PREFIX));
        }
        throw new SecurityException(String.format("%s: Access denied to target %s", PREFIX, receiver.getClass().getName()));
    }

    @Override
    public ReturnValue onGetStaticField(IInvoker invoker, Class<?> receiver, String fieldName) throws SecurityException {
        throw new SecurityException(String.format("%s: Access denied to target %s", PREFIX, receiver.getName()));
    }

    @Override
    public ReturnValue onGetInstanceField(IInvoker invoker, Object receiver, Class<?> receiverFormalType, String fieldName) throws SecurityException {
        if (receiver == null) {
            throw new SecurityException(String.format("%s: Access to any java object denied", PREFIX));
        }
        throw new SecurityException(String.format("%s: Access denied to target %s", PREFIX, receiver.getClass().getName()));
    }

    @Override
    public byte[] onLoadClassPathResource(String resourceName) throws SecurityException {
        throw new SecurityException(String.format("%s: Access denied to classpath resource '%s'", PREFIX, resourceName));
    }

    @Override
    public String onReadSystemProperty(String propertyName) throws SecurityException {
        throw new SecurityException(String.format("%s: Access denied to system property '%s'", PREFIX, propertyName));
    }

    @Override
    public String onReadSystemEnv(String name) throws SecurityException {
        throw new SecurityException(String.format("%s: Access denied to system environment variable '%s'", PREFIX, name));
    }

    @Override
    public IInterceptor validateVeniceFunction(String funcName) throws SecurityException {
        if (RestrictedBlacklistedFunctions.getAllFunctions().contains(funcName)) {
            throw new SecurityException(String.format("%s: Access denied to Venice function '%s'!", PREFIX, funcName));
        }
        return this;
    }

    @Override
    public IInterceptor validateLoadModule(String moduleName) throws SecurityException {
        if (!SandboxRules.DEFAULT_WHITELISTED_MODULES.contains(moduleName)) {
            throw new SecurityException(String.format("%s: Access denied to Venice module :%s!", PREFIX, moduleName));
        }
        return this;
    }

    @Override
    public IInterceptor validateMaxExecutionTime() throws SecurityException {
        if (this.executionTimeDeadline > 0L && System.currentTimeMillis() > this.executionTimeDeadline) {
            throw new SecurityException("Venice Sandbox: The sandbox exceeded the max execution time");
        }
        return this;
    }

    @Override
    public Integer getMaxExecutionTimeSeconds() {
        return MAX_EXECUTION_TIME_SECONDS;
    }

    @Override
    public Integer getMaxFutureThreadPoolSize() {
        return MAX_FUTURE_THREAD_POOL_SIZE;
    }

    public List<String> getBlacklistedVeniceFunctions() {
        ArrayList<String> list = new ArrayList<String>(RestrictedBlacklistedFunctions.getAllFunctions());
        Collections.sort(list);
        return list;
    }

    public List<String> getWhitelistedVeniceModules() {
        ArrayList<String> list = new ArrayList<String>(SandboxRules.DEFAULT_WHITELISTED_MODULES);
        Collections.sort(list);
        return list;
    }

    private static long calcExecutionTimeDeadline(Integer maxExecutionTimeSeconds) {
        return maxExecutionTimeSeconds == null ? -1L : System.currentTimeMillis() + (long)maxExecutionTimeSeconds.intValue() * 1000L;
    }
}

