/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.examples;

import com.github.jlangch.venice.SecurityException;
import com.github.jlangch.venice.Venice;
import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.javainterop.SandboxInterceptor;
import com.github.jlangch.venice.javainterop.SandboxRules;

public class Embed_10_CustomSandbox {
    public static void main(String[] args) {
        try {
            Embed_10_CustomSandbox.run();
            System.exit(0);
        }
        catch (VncException ex) {
            ex.printVeniceStackTrace();
            System.exit(1);
        }
        catch (RuntimeException ex) {
            ex.printStackTrace();
            System.exit(1);
        }
    }

    public static void run() {
        Venice venice = new Venice(Embed_10_CustomSandbox.createSandbox());
        venice.eval("(. :java.lang.Math :PI)");
        System.out.println("OK      : (. :java.lang.Math :PI)");
        venice.eval("(. :java.lang.Math :min 20 30)");
        System.out.println("OK      : (. :java.lang.Math :min 20 30)");
        venice.eval("(. (. :java.time.ZonedDateTime :now) :plusDays 5))");
        System.out.println("OK      : (. (. :java.time.ZonedDateTime :now) :plusDays 5))");
        venice.eval("(doto (. :java.util.ArrayList :new)        (. :add 1)                           (. :add 2))                    ");
        System.out.println("OK      : java.util.ArrayList::new()");
        venice.eval("(-<> (. :java.awt.color.ColorSpace :CS_LINEAR_RGB)           (. :java.awt.color.ICC_ColorSpace :getInstance <>)      (. <> :getMaxValue 0))                             ");
        System.out.println("OK      : use of java.awt.** classes");
        try {
            venice.eval("(. :java.lang.System :exit 0)");
        }
        catch (SecurityException ex) {
            System.out.println("REJECTED: (. :java.lang.System :exit 0)");
        }
        try {
            venice.eval("(io/slurp \"/tmp/file\")");
        }
        catch (SecurityException ex) {
            System.out.println("REJECTED: (io/slurp ...)");
        }
        venice.eval("(println 100)");
        System.out.println("OK:  (println 100)");
        try {
            venice.eval("(sleep 10_000)");
        }
        catch (SecurityException ex) {
            System.out.println("EXCEEDED: max exec time on (sleep ...)");
        }
        try {
            venice.eval("(system-prop \"db.password\")");
        }
        catch (SecurityException ex) {
            System.out.println("REJECTED: (system-prop ...)");
        }
        try {
            venice.eval("(system-env \"USER\")");
        }
        catch (SecurityException ex) {
            System.out.println("REJECTED: (system-env ...)");
        }
        try {
            venice.eval("(io/load-classpath-resource \"resources/images/img.tiff\")");
        }
        catch (SecurityException ex) {
            System.out.println("REJECTED: (io/load-classpath-resource ...)");
        }
    }

    private static SandboxInterceptor createSandbox() {
        return new SandboxRules().rejectAllUnsafeFunctions().rejectVeniceFunctions("time/date", "time/zone-ids").whitelistVeniceFunctions("*print*").whitelistVeniceFunctions(".").withStandardSystemProperties().withSystemProperties("db.name", "db.port").withSystemEnvs("SHELL", "HOME").withClasspathResources("resources/images/*.png").withClasses("java.lang.Math:PI", "java.lang.Math:min", "java.time.ZonedDateTime:*", "java.awt.**:*", "java.util.ArrayList:new", "java.util.ArrayList:add").withVeniceModules("crypt", "kira", "math").withMaxFutureThreadPoolSize(20).withMaxExecTimeSeconds(3).sandbox();
    }
}

