/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl;

import com.github.jlangch.venice.SecurityException;
import com.github.jlangch.venice.Venice;
import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.Modules;
import com.github.jlangch.venice.impl.thread.ThreadContext;
import com.github.jlangch.venice.impl.util.io.ClassPathResource;
import com.github.jlangch.venice.javainterop.IInterceptor;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ModuleLoader {
    private static final Map<String, String> modules = new ConcurrentHashMap<String, String>();
    private static final Map<String, String> classpathFiles = new ConcurrentHashMap<String, String>();
    private static final Map<String, String> externalFiles = new ConcurrentHashMap<String, String>();

    public static String loadModule(String module) {
        if (!Modules.isValidModule(module)) {
            throw new VncException(String.format("The Venice module '%s' does not exist", module));
        }
        String name = module + ".venice";
        try {
            return modules.computeIfAbsent(name, k -> new ClassPathResource(Venice.class.getPackage(), (String)k).getResourceAsString("UTF-8"));
        }
        catch (Exception ex) {
            throw new VncException(String.format("Failed to load Venice module '%s'", name), ex);
        }
    }

    public static String loadClasspathVeniceFile(String file) {
        if (!file.endsWith(".venice")) {
            throw new VncException(String.format("Must not load other than Venice (*.venice) resources from classpath. Resource: '%s'", file));
        }
        try {
            IInterceptor interceptor = ThreadContext.getInterceptor();
            return classpathFiles.computeIfAbsent(file, k -> ModuleLoader.loadClasspathVeniceFile(file, interceptor));
        }
        catch (SecurityException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new VncException(String.format("Failed to load Venice classpath file '%s'", file), ex);
        }
    }

    public static String loadExternalVeniceFile(String file) {
        if (!file.endsWith(".venice")) {
            throw new VncException(String.format("Must not load other than Venice (*.venice) files. File: '%s'", file));
        }
        File f = new File(file);
        IInterceptor interceptor = ThreadContext.getInterceptor();
        String data = interceptor.getLoadPaths().loadVeniceFile(f);
        if (data == null) {
            throw new VncException("The file '" + f + "' does not exist!");
        }
        externalFiles.put(f.getName(), data);
        return data;
    }

    public static boolean isLoadedModule(String module) {
        return modules.containsKey(module);
    }

    public static boolean isLoadedClasspathFile(String file) {
        return classpathFiles.containsKey(file);
    }

    public static boolean isLoadedExternalFile(String file) {
        return externalFiles.containsKey(file);
    }

    public static String getCachedLoadedModule(String module) {
        return modules.get(module);
    }

    public static String getCachedClasspathFile(String file) {
        return classpathFiles.get(file);
    }

    public static String getCachedExternalFile(String file) {
        return externalFiles.get(file);
    }

    public static void clear() {
        modules.clear();
        classpathFiles.clear();
        externalFiles.clear();
    }

    private static String loadClasspathVeniceFile(String file, IInterceptor interceptor) {
        try {
            return new String(interceptor.onLoadClassPathResource(file), "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException("UnsupportedEncoding", ex);
        }
    }
}

