/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.ansi;

import com.github.jlangch.venice.impl.reader.HighlightClass;
import com.github.jlangch.venice.impl.types.VncKeyword;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class AnsiColorTheme {
    public static String ANSI_RESET = "\u001b[0m";
    private final String name;
    private final Map<VncKeyword, String> colors = new HashMap<VncKeyword, String>();
    private final Map<HighlightClass, VncKeyword> mapper;

    public AnsiColorTheme(String name, Map<VncKeyword, String> colors) {
        this.name = name;
        this.colors.putAll(colors);
        this.mapper = Arrays.stream(HighlightClass.values()).collect(Collectors.toMap(p -> p, p -> new VncKeyword(p.name().toLowerCase().replace('_', '-'))));
    }

    public String getName() {
        return this.name;
    }

    public String getColor(HighlightClass clazz) {
        return this.getColor(this.mapper.get((Object)clazz));
    }

    public String getColor(VncKeyword clazz) {
        return this.colors.get(clazz);
    }

    public String style(String text, HighlightClass clazz) {
        String style = clazz == null ? null : this.getColor(clazz);
        return style == null ? text : style + text + ANSI_RESET;
    }
}

