/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.docgen.cheatsheet;

import com.github.jlangch.venice.Parameters;
import com.github.jlangch.venice.Venice;
import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.util.io.ClassPathResource;
import com.github.jlangch.venice.util.pdf.PdfRenderer;
import java.nio.ByteBuffer;
import java.util.Map;

public class CheatsheetRenderer {
    public static String parseTemplate() {
        try {
            String template = CheatsheetRenderer.loadCheatSheetTemplate();
            String script = "(do                                              \n   (load-module :kira)                           \n   (kira/parse-string template [\"${\" \"}$\"]))   ";
            return (String)new Venice().eval("(do                                              \n   (load-module :kira)                           \n   (kira/parse-string template [\"${\" \"}$\"]))   ", Parameters.of("template", template));
        }
        catch (VncException ex) {
            throw new RuntimeException("Failed to parse cheatsheet template. \nVenice Callstack: \n" + ex.getCallStackAsString("   "), ex);
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed toparse cheatsheet template", ex);
        }
    }

    public static String renderXHTML(Map<String, Object> data) {
        try {
            String template = CheatsheetRenderer.loadCheatSheetTemplate();
            String script = "(do                                           \n   (load-module :kira)                        \n   (kira/eval template [\"${\" \"}$\"] data))   ";
            return (String)new Venice().eval("(do                                           \n   (load-module :kira)                        \n   (kira/eval template [\"${\" \"}$\"] data))   ", Parameters.of("template", template, "data", data));
        }
        catch (VncException ex) {
            throw new RuntimeException("Failed to render cheatsheet XHTML. \nVenice Callstack: \n" + ex.getCallStackAsString("   "), ex);
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to render cheatsheet XHTML", ex);
        }
    }

    public static ByteBuffer renderPDF(String xhtml) {
        return PdfRenderer.render(xhtml, "classpath:/com/github/jlangch/venice/fonts/");
    }

    private static String loadCheatSheetTemplate() {
        return new ClassPathResource(Venice.class.getPackage(), "docgen/cheatsheet2.html").getResourceAsString("UTF-8");
    }
}

