/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.specialforms;

import com.github.jlangch.venice.ValueException;
import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.debug.agent.DebugAgent;
import com.github.jlangch.venice.impl.debug.breakpoint.BreakpointFnRef;
import com.github.jlangch.venice.impl.debug.breakpoint.FunctionScope;
import com.github.jlangch.venice.impl.env.Env;
import com.github.jlangch.venice.impl.env.Var;
import com.github.jlangch.venice.impl.specialforms.util.CatchBlock;
import com.github.jlangch.venice.impl.specialforms.util.FinallyBlock;
import com.github.jlangch.venice.impl.specialforms.util.SpecialFormsContext;
import com.github.jlangch.venice.impl.specialforms.util.SpecialFormsUtil;
import com.github.jlangch.venice.impl.thread.ThreadContext;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.VncBoolean;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncJavaObject;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncSpecialForm;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncMap;
import com.github.jlangch.venice.impl.types.collections.VncSequence;
import com.github.jlangch.venice.impl.types.collections.VncVector;
import com.github.jlangch.venice.impl.types.util.Coerce;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.impl.util.CallStack;
import com.github.jlangch.venice.impl.util.SymbolMapBuilder;
import com.github.jlangch.venice.impl.util.reflect.ReflectionAccessor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SpecialForms_TryCatchFunctions {
    public static VncSpecialForm try_ = new VncSpecialForm("try", (VncVal)VncSpecialForm.meta().arglists("(try expr*)", "(try expr* (catch selector ex-sym expr*)*)", "(try expr* (catch selector ex-sym expr*)* (finally expr*))").doc("Exception handling: try - catch - finally \n\n`(try)` without any expression returns `nil`.\n\nThe exception types \n\n  * :java.lang.Exception \n  * :java.lang.RuntimeException \n  * :com.github.jlangch.venice.VncException \n  * :com.github.jlangch.venice.ValueException \n\nare imported implicitly so its alias :Exception, :RuntimeException, :VncException, and :ValueException can be used as selector without an import of the class.\n\n**Selectors**\n\n  * a class: (e.g., :RuntimeException, :java.text.ParseException),     matches any instance of that class\n  * a key-values vector: (e.g., [key val & kvs]), matches any instance     of :ValueException where the exception's value meets the expression     `(and (= (get ex-value key) val) ...)`\n  * a predicate: (a function of one argument like map?, set?), matches     any instance of :ValueException where the predicate applied to the     exception's value returns true\n\n**Notes:**\n\nThe finally block is just for side effects, like closing resources. It never returns a value!\n\nAll exceptions in Venice are *unchecked*. If *checked* exceptions are thrown in Venice they are immediately wrapped in a :RuntimeException before being thrown! If Venice catches a *checked* exception from a Java interop call it wraps it in a :RuntimeException before handling it by the catch block selectors.").examples("(try                                      \n   (throw \"test\")                       \n   (catch :ValueException e               \n          \"caught ~(ex-value e)\"))        ", "(try                                       \n   (throw 100)                             \n   (catch :Exception e -100))                ", "(try                                       \n   (throw 100)                             \n   (catch :ValueException e (ex-value e))  \n   (finally (println \"...finally\")))       ", "(try                                              \n   (throw (ex :RuntimeException \"message\"))     \n   (catch :RuntimeException e (ex-message e)))     ", ";; exception type selector:                       \n(try                                              \n   (throw [1 2 3])                                \n   (catch :ValueException e (ex-value e))         \n   (catch :RuntimeException e \"runtime ex\")     \n   (finally (println \"...finally\")))             ", ";; key-value selector:                                      \n(try                                                        \n   (throw {:a 100, :b 200})                                 \n   (catch [:a 100] e                                        \n      (println \"ValueException, value: ~(ex-value e)\"))   \n   (catch [:a 100, :b 200] e                                \n      (println \"ValueException, value: ~(ex-value e)\")))   ", ";; key-value selector (exception cause):                           \n(try                                                               \n   (throw (ex :java.io.IOException \"failure\"))                   \n   (catch [:cause-type :java.io.IOException] e                     \n      (println \"IOException, msg: ~(ex-message (ex-cause e))\"))  \n   (catch :RuntimeException e                                      \n      (println \"RuntimeException, msg: ~(ex-message e)\")))         ", ";; predicate selector:                                      \n(try                                                        \n   (throw {:a 100, :b 200})                                 \n   (catch long? e                                           \n      (println \"ValueException, value: ~(ex-value e)\"))   \n   (catch map? e                                            \n      (println \"ValueException, value: ~(ex-value e)\"))   \n   (catch #(and (map? %) (= 100 (:a %))) e                  \n      (println \"ValueException, value: ~(ex-value e)\"))))   ", ";; predicate selector with custom types:                       \n(do                                                            \n   (deftype :my-exception1 [message :string, position :long])  \n   (deftype :my-exception2 [message :string])                  \n                                                               \n   (try                                                        \n      (throw (my-exception1. \"error\" 100))                   \n      (catch my-exception1? e                                  \n         (println (:value e)))                                 \n      (catch my-exception2? e                                  \n         (println (:value e)))))                                 ").seeAlso("try-with", "throw", "ex").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncVal specialFormMeta, VncList args, Env env, SpecialFormsContext ctx) {
            return SpecialForms_TryCatchFunctions.handleTryCatchFinally("try", args, ctx, env, specialFormMeta, new ArrayList());
        }
    };
    public static VncSpecialForm try_with = new VncSpecialForm("try-with", (VncVal)VncSpecialForm.meta().arglists("(try-with [bindings*] expr*)", "(try-with [bindings*] expr* (catch selector ex-sym expr*)*)", "(try-with [bindings*] expr* (catch selector ex-sym expr*)* (finally expr))").doc("*try-with-resources* allows the declaration of resources to be used in a try block with the assurance that the resources will be closed after execution of that block. The resources declared must implement the Closeable or AutoCloseable interface.").examples("(do                                               \n  (let [file (io/temp-file \"test-\", \".txt\")]  \n    (io/spit file \"123456789\" :append true)     \n    (try-with [is (io/file-in-stream file)]       \n      (io/slurp-stream is :binary false))))        ").seeAlso("try", "throw", "ex").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public VncVal apply(VncVal specialFormMeta, VncList args, Env env, SpecialFormsContext ctx) {
            Env localEnv = new Env(env);
            VncSequence bindings = Coerce.toVncSequence(args.first());
            ArrayList<Var> boundResources = new ArrayList<Var>();
            for (int i = 0; i < bindings.size(); i += 2) {
                VncVal sym = bindings.nth(i);
                VncVal val = ctx.getEvaluator().evaluate(bindings.nth(i + 1), localEnv, false);
                if (!Types.isVncSymbol(sym)) {
                    throw new VncException(String.format("Invalid 'try-with' destructuring symbol value type %s. Expected symbol.", Types.getType(sym)));
                }
                Var binding = new Var((VncSymbol)sym, val);
                localEnv.setLocal(binding);
                boundResources.add(binding);
            }
            try {
                VncVal vncVal = SpecialForms_TryCatchFunctions.handleTryCatchFinally("try-with", args.rest(), ctx, localEnv, specialFormMeta, boundResources);
                return vncVal;
            }
            finally {
                Collections.reverse(boundResources);
                boundResources.stream().forEach(b -> {
                    Object r;
                    VncVal resource = b.getVal();
                    if (Types.isVncJavaObject(resource) && (r = ((VncJavaObject)resource).getDelegate()) instanceof AutoCloseable) {
                        try {
                            ((AutoCloseable)r).close();
                        }
                        catch (Exception ex) {
                            throw new VncException(String.format("'try-with' failed to close resource %s.", b.getName()));
                        }
                    }
                });
            }
        }
    };
    private static final VncKeyword CAUSE_TYPE_SELECTOR_KEY = new VncKeyword(":cause-type");
    public static Map<VncVal, VncVal> ns = new SymbolMapBuilder().add(try_).add(try_with).toMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static VncVal handleTryCatchFinally(String specialForm, VncList args, SpecialFormsContext ctx, Env env, VncVal meta, List<Var> bindings) {
        ThreadContext threadCtx = ThreadContext.get();
        DebugAgent debugAgent = threadCtx.getDebugAgent_();
        if (debugAgent != null && debugAgent.hasBreakpointFor(new BreakpointFnRef(specialForm))) {
            CallStack callStack = threadCtx.getCallStack_();
            debugAgent.onBreakSpecialForm(specialForm, FunctionScope.FunctionEntry, bindings, meta, env, callStack);
        }
        try {
            Env bodyEnv = new Env(env);
            VncVal vncVal = SpecialFormsUtil.evaluateBody(SpecialForms_TryCatchFunctions.getTryBody(args), ctx, bodyEnv, true);
            return vncVal;
        }
        catch (Exception ex) {
            RuntimeException wrappedEx = ex instanceof RuntimeException ? (RuntimeException)ex : new RuntimeException(ex);
            CatchBlock catchBlock = SpecialForms_TryCatchFunctions.findCatchBlockMatchingThrowable(ctx, env, args, ex);
            if (catchBlock == null) {
                throw wrappedEx;
            }
            Env catchEnv = new Env(env);
            catchEnv.setLocal(new Var(catchBlock.getExSym(), new VncJavaObject(wrappedEx)));
            SpecialForms_TryCatchFunctions.catchBlockDebug(threadCtx, debugAgent, catchBlock.getMeta(), catchEnv, catchBlock.getExSym(), wrappedEx);
            VncVal vncVal = SpecialFormsUtil.evaluateBody(catchBlock.getBody(), ctx, catchEnv, false);
            return vncVal;
        }
        finally {
            FinallyBlock finallyBlock = SpecialForms_TryCatchFunctions.findFirstFinallyBlock(args);
            if (finallyBlock != null) {
                Env finallyEnv = new Env(env);
                SpecialForms_TryCatchFunctions.finallyBlockDebug(threadCtx, debugAgent, finallyBlock.getMeta(), finallyEnv);
                SpecialFormsUtil.evaluateBody(finallyBlock.getBody(), ctx, finallyEnv, false);
            }
        }
    }

    private static VncList getTryBody(VncList args) {
        String symName;
        VncVal first;
        VncVal e;
        ArrayList<VncVal> body = new ArrayList<VncVal>();
        Iterator<VncVal> iterator = args.iterator();
        while (!(!iterator.hasNext() || Types.isVncList(e = iterator.next()) && Types.isVncSymbol(first = ((VncList)e).first()) && ((symName = ((VncSymbol)first).getName()).equals("catch") || symName.equals("finally")))) {
            body.add(e);
        }
        return VncList.ofList(body);
    }

    private static CatchBlock findCatchBlockMatchingThrowable(SpecialFormsContext ctx, Env env, VncList blocks, Throwable th) {
        for (VncVal b : blocks) {
            VncList block;
            VncVal catchSym;
            if (!Types.isVncList(b) || !Types.isVncSymbol(catchSym = (block = (VncList)b).first()) || !((VncSymbol)catchSym).getName().equals("catch") || !SpecialForms_TryCatchFunctions.isCatchBlockMatchingThrowable(ctx, env, block, th)) continue;
            return new CatchBlock(Coerce.toVncSymbol(block.third()), block.slice(3), catchSym.getMeta());
        }
        return null;
    }

    private static boolean isCatchBlockMatchingThrowable(SpecialFormsContext ctx, Env env, VncList block, Throwable th) {
        VncVal selector = ctx.getEvaluator().evaluate(block.second(), env, false);
        if (Types.isVncString(selector)) {
            String className = SpecialFormsUtil.resolveClassName(((VncString)selector).getValue());
            Class<?> targetClass = ReflectionAccessor.classForName(className);
            return targetClass.isAssignableFrom(th.getClass());
        }
        if (Types.isVncFunction(selector)) {
            VncFunction predicate = (VncFunction)selector;
            predicate.sandboxFunctionCallValidation();
            if (th instanceof ValueException) {
                VncVal exVal = SpecialForms_TryCatchFunctions.getValueExceptionValue((ValueException)th);
                VncVal result = predicate.apply(VncList.of(exVal));
                return VncBoolean.isTrue(result);
            }
            VncVal result = predicate.apply(VncList.of(Constants.Nil));
            return VncBoolean.isTrue(result);
        }
        if (Types.isVncSequence(selector)) {
            VncVal exVal;
            VncSequence seq = (VncSequence)selector;
            if (seq.first().equals(CAUSE_TYPE_SELECTOR_KEY) && Types.isVncKeyword(seq.second())) {
                Throwable cause = th.getCause();
                if (cause != null) {
                    VncKeyword classRef = (VncKeyword)seq.second();
                    String className = SpecialFormsUtil.resolveClassName(classRef.getSimpleName());
                    Class<?> targetClass = ReflectionAccessor.classForName(className);
                    if (!targetClass.isAssignableFrom(cause.getClass())) {
                        return false;
                    }
                    if (seq.size() == 2) {
                        return true;
                    }
                }
                seq = seq.drop(2);
            }
            if (th instanceof ValueException && Types.isVncMap(exVal = SpecialForms_TryCatchFunctions.getValueExceptionValue((ValueException)th))) {
                VncMap exValMap = (VncMap)exVal;
                while (!seq.isEmpty()) {
                    VncVal key = seq.first();
                    VncVal val = seq.second();
                    if (!Types._equal_strict_Q(val, exValMap.get(key))) {
                        return false;
                    }
                    seq = seq.drop(2);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private static FinallyBlock findFirstFinallyBlock(VncList blocks) {
        for (VncVal b : blocks) {
            VncList block;
            VncVal first;
            if (!Types.isVncList(b) || !Types.isVncSymbol(first = (block = (VncList)b).first()) || !((VncSymbol)first).getName().equals("finally")) continue;
            return new FinallyBlock(block.rest(), first.getMeta());
        }
        return null;
    }

    private static void catchBlockDebug(ThreadContext threadCtx, DebugAgent debugAgent, VncVal meta, Env env, VncSymbol exSymbol, RuntimeException ex) {
        if (debugAgent != null && debugAgent.hasBreakpointFor(new BreakpointFnRef("catch"))) {
            debugAgent.onBreakSpecialForm("catch", FunctionScope.FunctionEntry, VncVector.of(exSymbol), VncList.of(new VncJavaObject(ex)), meta, env, threadCtx.getCallStack_());
        }
    }

    private static void finallyBlockDebug(ThreadContext threadCtx, DebugAgent debugAgent, VncVal meta, Env env) {
        if (debugAgent != null && debugAgent.hasBreakpointFor(new BreakpointFnRef("finally"))) {
            debugAgent.onBreakSpecialForm("finally", FunctionScope.FunctionEntry, new ArrayList<Var>(), meta, env, threadCtx.getCallStack_());
        }
    }

    private static VncVal getValueExceptionValue(ValueException ex) {
        Object val = ex.getValue();
        return val == null ? Constants.Nil : (val instanceof VncVal ? (VncVal)val : new VncJavaObject(val));
    }
}

