/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.specialforms;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.Destructuring;
import com.github.jlangch.venice.impl.env.Env;
import com.github.jlangch.venice.impl.env.GenSym;
import com.github.jlangch.venice.impl.env.Var;
import com.github.jlangch.venice.impl.namespaces.Namespace;
import com.github.jlangch.venice.impl.namespaces.Namespaces;
import com.github.jlangch.venice.impl.specialforms.util.DefTypeForm;
import com.github.jlangch.venice.impl.specialforms.util.SpecialFormsContext;
import com.github.jlangch.venice.impl.specialforms.util.SpecialFormsUtil;
import com.github.jlangch.venice.impl.thread.ThreadContext;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.VncBoolean;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncMultiArityFunction;
import com.github.jlangch.venice.impl.types.VncProtocolFunction;
import com.github.jlangch.venice.impl.types.VncSpecialForm;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncHashMap;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncMap;
import com.github.jlangch.venice.impl.types.collections.VncSequence;
import com.github.jlangch.venice.impl.types.collections.VncVector;
import com.github.jlangch.venice.impl.types.custom.VncCustomBaseTypeDef;
import com.github.jlangch.venice.impl.types.custom.VncProtocol;
import com.github.jlangch.venice.impl.types.util.Coerce;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.impl.util.ArityExceptions;
import com.github.jlangch.venice.impl.util.CallFrame;
import com.github.jlangch.venice.impl.util.MetaUtil;
import com.github.jlangch.venice.impl.util.SymbolMapBuilder;
import com.github.jlangch.venice.impl.util.WithCallStack;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class SpecialForms_TypeFunctions {
    public static VncSpecialForm defprotocol = new VncSpecialForm("defprotocol", (VncVal)VncSpecialForm.meta().arglists("(defprotocol protocol fn-spec*)").doc("Defines a new protocol with the supplied function specs.  \n\nFormats:                                                  \n\n * `(defprotocol P (foo [x]))`                            \n * `(defprotocol P (foo [x] [x y]))`                      \n * `(defprotocol P (foo [x] [x y] nil))`                  \n * `(defprotocol P (foo [x] [x y] 100))`                  \n * `(defprotocol P (foo [x]) (bar [x] [x y]))`              ").examples("(do                                                       \n   (ns foo)                                               \n   (deftype :complex [re :long, im :long])                \n   (defprotocol XMath (+ [x y])                           \n                      (- [x y]))                          \n   (extend :foo/complex XMath                             \n           (+ [x y] (complex. (core/+ (:re x) (:re y))    \n                              (core/+ (:im x) (:im y))))  \n           (- [x y] (complex. (core/- (:re x) (:re y))    \n                              (core/- (:im x) (:im y))))) \n   (extend :core/long XMath                               \n           (+ [x y] (core/+ x y))                         \n           (- [x y] (core/- x y)))                        \n   (foo/+ (complex. 1 1)  (complex. 4 5)))                  ", "(do                                                                  \n   (ns foo)                                                          \n   (defprotocol Lifecycle (start [c]) (stop [c]))                    \n   (deftype :component [name :string]                                \n            Lifecycle (start [c] (println \"'~(:name c)' started\")) \n                      (stop [c] (println \"'~(:name c)' stopped\"))) \n   (let [c          (component. \"test\")                            \n         lifecycle? (extends? (type c) Lifecycle)]                   \n     (println \"'~(:name c)' extends Lifecycle protocol: ~{lifecycle?}\") \n     (start c)                                                       \n     (stop c)))                                                        ").seeAlso("extend", "extends?", "defmulti").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncVal specialFormMeta, VncList args, Env env, SpecialFormsContext ctx) {
            CallFrame callframe = new CallFrame("defprotocol", args, specialFormMeta);
            try (WithCallStack cs = new WithCallStack(callframe);){
                ArityExceptions.assertMinArity("defprotocol", ArityExceptions.FnType.SpecialForm, args, 2);
            }
            VncSymbol protocolName = Namespaces.qualifySymbolWithCurrNS(SpecialFormsUtil.evaluateSymbolMetaData(args.first(), env, ctx));
            SpecialForms_TypeFunctions.validateDefProtocol(args);
            VncMap protocolFns = VncHashMap.empty();
            for (VncVal s : args.rest()) {
                VncMultiArityFunction fn = SpecialForms_TypeFunctions.parseProtocolFnSpec(s, env, ctx);
                VncSymbol fnName = new VncSymbol(protocolName.getNamespace(), fn.getSimpleName(), specialFormMeta);
                VncProtocolFunction fnProtocol = new VncProtocolFunction(fnName.getQualifiedName(), protocolName, fn, fn.getMeta());
                VncVal p = env.getGlobalOrNull(fnName);
                if (p instanceof VncProtocolFunction && !((VncProtocolFunction)p).getProtocolName().equals(protocolName)) {
                    throw new VncException(String.format("The protocol function '%s' of protocol '%s' collides with the same function in protocol '%s' in the same namespace!", fn.getSimpleName(), ((VncProtocolFunction)p).getProtocolName(), protocolName));
                }
                env.setGlobal(new Var(fnName, fnProtocol));
                protocolFns = protocolFns.assoc(new VncString(fn.getSimpleName()), fn);
            }
            VncProtocol protocol = new VncProtocol(protocolName, protocolFns, protocolName.getMeta());
            env.setGlobal(new Var(protocolName, protocol));
            return protocol;
        }

        @Override
        public boolean addCallFrame() {
            return false;
        }
    };
    public static VncSpecialForm extend_ = new VncSpecialForm("extend", (VncVal)VncSpecialForm.meta().arglists("(extend type protocol fns*)").doc("Extends protocol for type with the supplied functions.    \n\nFormats:                                                  \n\n * `(extend :core/long P (foo [x] x))`                    \n * `(extend :core/long P (foo [x] x) (foo [x y] x))`      \n * `(extend :core/long P (foo [x] x) (bar [x] x))`          ").examples("(do                                                       \n   (ns foo)                                               \n   (deftype :complex [re :long, im :long])                \n   (defprotocol XMath (+ [x y])                           \n                      (- [x y]))                          \n   (extend :foo/complex XMath                             \n           (+ [x y] (complex. (core/+ (:re x) (:re y))    \n                              (core/+ (:im x) (:im y))))  \n           (- [x y] (complex. (core/- (:re x) (:re y))    \n                              (core/- (:im x) (:im y))))) \n   (extend :core/long XMath                               \n           (+ [x y] (core/+ x y))                         \n           (- [x y] (core/- x y)))                        \n   (foo/+ (complex. 1 1)  (complex. 4 5)))                  ").seeAlso("defprotocol", "extends?").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncVal specialFormMeta, VncList args, Env env, SpecialFormsContext ctx) {
            VncVal typeRef = args.first();
            VncVal protocolRef = args.second();
            VncSymbol protocolSym = Namespaces.qualifySymbolWithCurrNS(SpecialFormsUtil.evaluateSymbolMetaData(protocolRef, env, ctx));
            return SpecialForms_TypeFunctions.extendType(typeRef, protocolSym, args.drop(2), env, ctx);
        }
    };
    public static VncSpecialForm extendsQ_ = new VncSpecialForm("extends?", (VncVal)VncSpecialForm.meta().arglists("(extends? type protocol)").doc("Returns true if the type extends the protocol.").examples("(do                                                       \n   (ns foo)                                               \n   (deftype :complex [re :long, im :long])                \n   (defprotocol XMath (+ [x y])                           \n                      (- [x y]))                          \n   (extend :foo/complex XMath                             \n           (+ [x y] (complex. (core/+ (:re x) (:re y))    \n                              (core/+ (:im x) (:im y))))  \n           (- [x y] (complex. (core/- (:re x) (:re y))    \n                              (core/- (:im x) (:im y))))) \n   (extend :core/long XMath                               \n           (+ [x y] (core/+ x y))                         \n           (- [x y] (core/- x y)))                        \n   (extends? :foo/complex XMath))                           ").seeAlso("defprotocol", "extend").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncVal specialFormMeta, VncList args, Env env, SpecialFormsContext ctx) {
            VncVal typeRef = args.first();
            VncSymbol protocolSym = Namespaces.qualifySymbolWithCurrNS(SpecialFormsUtil.evaluateSymbolMetaData(args.second(), env, ctx));
            VncVal typeRefEval = ctx.getEvaluator().evaluate(typeRef, env, false);
            if (!(typeRefEval instanceof VncKeyword)) {
                throw new VncException(String.format("The type '%s' must be a keyword like :core/long!", typeRefEval.getType()));
            }
            VncVal p = env.getGlobalOrNull(protocolSym);
            if (!(p instanceof VncProtocol)) {
                throw new VncException(String.format("The protocol '%s' is not defined!", protocolSym.getQualifiedName()));
            }
            VncKeyword type = (VncKeyword)typeRefEval;
            if (!type.hasNamespace()) {
                throw new VncException(String.format("The type '%s' must be qualified!", type.getQualifiedName()));
            }
            VncProtocol protocol = (VncProtocol)p;
            return VncBoolean.of(protocol.isRegistered(type));
        }
    };
    public static VncSpecialForm deftype = new VncSpecialForm("deftype", (VncVal)VncSpecialForm.meta().arglists("(deftype name fields)", "(deftype name fields validator)").doc("Defines a new custom *record* type for the name with the fields. \n\nVenice implicitly creates a builder and a type check function suffixed with a dot and a question mark:\n\n```venice                                        \n(deftype :point [x :long, y :long])              \n                                                 \n(point. 200 300)           ; builder             \n(point? (point. 200 300))  ; type check          \n```                                              \n\nThe builder accepts values of any subtype of the \nfield's type.").examples("(do                                                      \n  (ns foo)                                               \n  (deftype :point [x :long, y :long])                    \n  ; explicitly creating a custom type value              \n  (def x (.: :point 100 200))                            \n  ; Venice implicitly creates a builder function         \n  ; suffixed with a '.'                                  \n  (def y (point. 200 300))                               \n  ; ... and a type check function                        \n  (point? y)                                             \n  y)                                                       ", "(do                                                      \n  (ns foo)                                               \n  (deftype :point [x :long, y :long])                    \n  (def x (point. 100 200))                               \n  (type x))                                                ", "(do                                                      \n  (ns foo)                                               \n  (deftype :point [x :long, y :long]                     \n     (fn [p]                                             \n       (assert (pos? (:x p)) \"x must be positive\")     \n       (assert (pos? (:y p)) \"y must be positive\")))   \n  (def p (point. 100 200))                               \n  [(:x p) (:y p)])                                        ", "(do                                                 \n  (ns foo)                                          \n  (deftype :named [name :string, value :any])       \n  (def x (named. \"count\" 200))                    \n  (def y (named. \"seq\" [1 2]))                    \n  [x y])                                              ", ";; modifying a custom type field                    \n(do                                                 \n  (deftype :point [x :long, y :long])               \n  (def p (point. 0 0))                              \n  (def q (assoc p :x 1 :y 2)) ; q is a 'point'      \n  (pr-str q))                                         ", ";; removing a custom type field                     \n(do                                                 \n  (deftype :point [x :long, y :long])               \n  (def p (point. 100 200))                          \n  (def q (dissoc p :x)) ; q is just a map now       \n  (pr-str q))                                         ").seeAlso("deftype?", "deftype-of", "deftype-or", ".:", "deftype-describe", "Object", "assoc", "dissoc").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncVal specialFormMeta, VncList args, Env env, SpecialFormsContext ctx) {
            VncFunction validationFn;
            ArityExceptions.assertMinArity("deftype", ArityExceptions.FnType.SpecialForm, args, 2);
            VncSequence deftypeArgs = args.takeWhile(e -> !Types.isVncSymbol(e));
            VncList extendArgs = args.drop(((VncList)deftypeArgs).size());
            VncKeyword type = Coerce.toVncKeyword(ctx.getEvaluator().evaluate(((VncList)deftypeArgs).first(), env, false));
            VncVector fields = Coerce.toVncVector(deftypeArgs.second());
            VncFunction vncFunction = validationFn = ((VncList)deftypeArgs).size() == 3 ? Coerce.toVncFunction(ctx.getEvaluator().evaluate(args.third(), env, false)) : null;
            if (validationFn != null) {
                validationFn.sandboxFunctionCallValidation();
            }
            VncVal customType = DefTypeForm.defineCustomType(type, fields, validationFn, ctx.getInterpreter(), env);
            while (!extendArgs.isEmpty()) {
                VncVal protocolSym = extendArgs.first();
                VncSequence extDefs = extendArgs.drop(1).takeWhile(e -> Types.isVncList(e));
                if (Types.isVncSymbol(protocolSym)) {
                    extendArgs = extendArgs.drop(((VncList)extDefs).size() + 1);
                    SpecialForms_TypeFunctions.extendType(customType, (VncSymbol)protocolSym, (VncList)extDefs, env, ctx);
                    continue;
                }
                throw new VncException(String.format("Invalid extend protocol definitions for custom type '%s'", type.toString()));
            }
            return customType;
        }
    };
    public static VncSpecialForm deftypeQ = new VncSpecialForm("deftype?", (VncVal)VncSpecialForm.meta().arglists("(deftype? type)").doc("Returns true if `type` is a custom type else false.").examples("(do                                                 \n  (ns foo)                                          \n  (deftype :complex [real :long, imaginary :long])  \n  (deftype? :complex))                                ", "(do                                                 \n  (ns foo)                                          \n  (deftype-of :email-address :string)               \n  (deftype? :email-address))                          ", "(do                                                 \n  (ns foo)                                          \n  (deftype :complex [real :long, imaginary :long])  \n  (def x (complex. 100 200))                        \n  (deftype? (type x)))                                ").seeAlso("deftype", "deftype-of", "deftype-or", ".:", "deftype-describe").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncVal specialFormMeta, VncList args, Env env, SpecialFormsContext ctx) {
            ArityExceptions.assertArity("deftype?", ArityExceptions.FnType.SpecialForm, args, 1);
            VncVal type = ctx.getEvaluator().evaluate(args.first(), env, false);
            return VncBoolean.of(DefTypeForm.isCustomType(type, env));
        }
    };
    public static VncSpecialForm deftype_describe = new VncSpecialForm("deftype-describe", (VncVal)VncSpecialForm.meta().arglists("(deftype-describe type)").doc("Describes a custom type.").examples("(do                                                           \n  (ns foo)                                                    \n  (deftype :complex [real :long, imaginary :long])            \n  (deftype-describe :complex))                                \n", "(do                                                           \n  (ns foo)                                                    \n  (deftype-of :port :long)                                    \n  (deftype-describe :port))                                   \n", "(do                                                           \n  (ns foo)                                                    \n  (deftype-or :digit 0 1 2 3 4 5 6 7 8 9)                     \n  (deftype-describe :digit))                                    ").seeAlso("deftype", "deftype?", "deftype-or", "deftype-of", ".:").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncVal specialFormMeta, VncList args, Env env, SpecialFormsContext ctx) {
            ArityExceptions.assertArity("deftype-describe", ArityExceptions.FnType.SpecialForm, args, 1);
            VncVal evaluatedArg = ctx.getEvaluator().evaluate(args.first(), env, false);
            return DefTypeForm.describeType(evaluatedArg, env);
        }
    };
    public static VncSpecialForm deftype_new = new VncSpecialForm(".:", (VncVal)VncSpecialForm.meta().arglists("(.: type-name args*)").doc("Instantiates a custom type.                           \n\nNote: Venice implicitly creates a builder function    \nsuffixed with a dot:                                  \n\n```venice                                             \n(deftype :complex [real :long, imaginary :long])      \n(complex. 200 300)                                    \n```                                                   \n\nFor readability prefer `(complex. 200 300)` over      \n`(.: :complex 100 200)`.                                ").examples("(do                                                      \n  (ns foo)                                               \n  (deftype :complex [real :long, imaginary :long])       \n  (def x (.: :complex 100 200))                          \n  [(:real x) (:imaginary x)])                              ").seeAlso("deftype", "deftype?", "deftype-of", "deftype-or", "deftype-describe").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncVal specialFormMeta, VncList args, Env env, SpecialFormsContext ctx) {
            ArityExceptions.assertMinArity(".:", ArityExceptions.FnType.SpecialForm, args, 1);
            ArrayList<VncVal> evaluatedArgs = new ArrayList<VncVal>();
            for (VncVal v : args) {
                evaluatedArgs.add(ctx.getEvaluator().evaluate(v, env, false));
            }
            return DefTypeForm.createType(evaluatedArgs, env);
        }
    };
    public static VncSpecialForm deftype_of = new VncSpecialForm("deftype-of", (VncVal)VncSpecialForm.meta().arglists("(deftype-of name base-type)", "(deftype-of name base-type validator)").doc("Defines a new custom *wrapper* type based on a base type. \n\nVenice implicitly creates a builder and a type check function suffixed with a dot and a question mark:\n\n```venice                           \n(deftype-of :port :long)            \n                                    \n(port. 8080)          ; builder     \n(port? (port. 8080))  ; type check  \n```").examples("(do                                                           \n  (ns foo)                                                    \n  (deftype-of :email-address :string)                         \n  ; explicitly creating a wrapper type value                  \n  (def x (.: :email-address \"foo@foo.org\"))                 \n  ; Venice implicitly creates a builder function              \n  ; suffixed with a '.'                                       \n  (def y (email-address. \"foo@foo.org\"))                    \n  ; ... and a type check function                             \n  (email-address? y)                                          \n  y)                                                            ", "(do                                                           \n  (ns foo)                                                    \n  (deftype-of :email-address :string)                         \n  (str \"Email: \" (email-address. \"foo@foo.org\")))           ", "(do                                                           \n  (ns foo)                                                    \n  (deftype-of :email-address :string)                         \n  (def x (email-address. \"foo@foo.org\"))                    \n  [(type x) (supertype x)])                                     ", "(do                                                           \n  (ns foo)                                                    \n  (deftype-of :email-address                                  \n              :string                                         \n              str/valid-email-addr?)                          \n  (email-address. \"foo@foo.org\"))                             ", "(do                                                           \n  (ns foo)                                                    \n  (deftype-of :contract-id :long)                             \n  (contract-id. 100000))                                        ", "(do                                                           \n  (ns foo)                                                    \n  (deftype-of :my-long :long)                                 \n  (+ 10 (my-long. 100000)))                                     ").seeAlso("deftype", "deftype?", "deftype-or", ".:", "deftype-describe").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncVal specialFormMeta, VncList args, Env env, SpecialFormsContext ctx) {
            VncFunction validationFn;
            ArityExceptions.assertMinArity("deftype-of", ArityExceptions.FnType.SpecialForm, args, 2);
            VncKeyword type = Coerce.toVncKeyword(ctx.getEvaluator().evaluate(args.first(), env, false));
            VncKeyword baseType = Coerce.toVncKeyword(ctx.getEvaluator().evaluate(args.second(), env, false));
            VncFunction vncFunction = validationFn = args.size() == 3 ? Coerce.toVncFunction(ctx.getEvaluator().evaluate(args.third(), env, false)) : null;
            if (validationFn != null) {
                validationFn.sandboxFunctionCallValidation();
            }
            return DefTypeForm.defineCustomWrapperType(type, baseType, validationFn, ctx.getInterpreter(), env, ctx.getWrappableTypes());
        }
    };
    public static VncSpecialForm deftype_or = new VncSpecialForm("deftype-or", (VncVal)VncSpecialForm.meta().arglists("(deftype-or name val*)").doc("Defines a new custom *choice* type. \n\nVenice implicitly creates a builder and a type check function suffixed with a dot and a question mark:\n\n```venice                                 \n(deftype-or :color :red :green :blue)     \n                                          \n(color. :blue)           ; builder        \n(color? (color. :blue))  ; type check     \n```").examples("(do                                                           \n  (ns foo)                                                    \n  (deftype-or :color :red :green :blue)                       \n  ; explicitly creating a wrapper type value                  \n  (def x (.: :color :red))                                    \n  ; Venice implicitly creates a builder function              \n  ; suffixed with a '.'                                       \n  (def y (color. :blue))                                       \n  ; ... and a type check function                             \n  (color? y)                                                  \n  y)                                                            ", "(do                                                           \n  (ns foo)                                                    \n  (deftype-or :digit 0 1 2 3 4 5 6 7 8 9)                     \n  (digit. 1))                                                   ", "(do                                                           \n  (ns foo)                                                    \n  (deftype-or :long-or-double :long :double)                  \n  (long-or-double. 1000))                                       ").seeAlso("deftype", "deftype?", "deftype-of", ".:", "deftype-describe").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncVal specialFormMeta, VncList args, Env env, SpecialFormsContext ctx) {
            ArityExceptions.assertMinArity("deftype-or", ArityExceptions.FnType.SpecialForm, args, 2);
            VncKeyword type = Coerce.toVncKeyword(ctx.getEvaluator().evaluate(args.first(), env, false));
            VncList choiceVals = args.rest();
            return DefTypeForm.defineCustomChoiceType(type, choiceVals, ctx.getInterpreter(), env);
        }
    };
    public static Map<VncVal, VncVal> ns = new SymbolMapBuilder().add(defprotocol).add(deftype).add(deftype_describe).add(deftype_new).add(deftype_of).add(deftype_or).add(deftypeQ).add(extend_).add(extendsQ_).toMap();

    private static void validateDefProtocol(VncList args) {
        if (!Types.isVncSymbol(args.first())) {
            throw new VncException("A protocol definition must have a symbol as its name!\nE.g.: as 'P' in (defprotocol P (foo [x]))");
        }
        for (VncVal spec : args.rest()) {
            if (!Types.isVncList(spec)) {
                throw new VncException("A protocol definition must have a list with function specifications!\nE.g.: as '(foo [x])' (defprotocol P (foo [x]) (bar [x]))");
            }
            VncList specList = (VncList)spec;
            VncSymbol fnName = (VncSymbol)specList.first();
            VncList specs = specList.rest();
            VncSequence paramSpecs = specs.takeWhile(s -> Types.isVncVector(s));
            if (!Types.isVncSymbol(fnName)) {
                throw new VncException("A protocol function specification must have a symbol as its name!\nE.g.: as 'foo' in (defprotocol P (foo [x]))");
            }
            if (((VncList)paramSpecs).isEmpty()) {
                throw new VncException(String.format("The protocol function specification '%s' must have at least one parameter specification!\nE.g.: as '[x]' in (defprotocol P (foo [x]))", fnName));
            }
            HashSet<Integer> aritySet = new HashSet<Integer>();
            for (VncVal ps : paramSpecs) {
                if (!Types.isVncVector(ps)) {
                    throw new VncException(String.format("The protocol function specification '%s' must have one or multiple vectors of param symbols followed by an optional return value of any type but vector!\nE.g.: (defprotocol P (foo [x] [x y] nil))", fnName));
                }
                int arity = ((VncVector)ps).size();
                if (aritySet.contains(arity)) {
                    throw new VncException(String.format("The protocol function specification '%s' has multiple parameter definitions for the arity %d!\nE.g.: as '[x y]' in (defprotocol P (foo [x] [x y] [x y]))", fnName, arity));
                }
                aritySet.add(arity);
                for (VncVal p : (VncVector)ps) {
                    if (Types.isVncSymbol(p)) continue;
                    throw new VncException(String.format("The protocol function specification '%s' must have vector of param symbols!\nE.g.: as '[x y]' in (defprotocol P (foo [x y]))", fnName));
                }
            }
        }
    }

    private static VncMultiArityFunction parseProtocolFnSpec(VncVal spec, final Env env, SpecialFormsContext ctx) {
        VncList specList = (VncList)spec;
        VncSymbol fnName = (VncSymbol)specList.first();
        VncList specs = specList.rest();
        VncSequence paramSpecs = specs.takeWhile(s -> Types.isVncVector(s));
        VncList body = specs.slice(((VncList)paramSpecs).size());
        Namespace ns = Namespaces.getCurrentNamespace();
        List argList = ((VncList)paramSpecs).stream().map(spc -> String.format("(%s %s)", fnName.getName(), spc.toString())).map(s -> new VncString((String)s)).collect(Collectors.toList());
        List<VncFunction> functions = ((VncList)paramSpecs).getJavaList().stream().map(p -> new VncFunction(fnName.getQualifiedName(), (VncVector)p, fnName.getMeta(), (VncVal)p, ns, ctx, body){
            private static final long serialVersionUID = -1L;
            final /* synthetic */ VncVal val$p;
            final /* synthetic */ Namespace val$ns;
            final /* synthetic */ SpecialFormsContext val$ctx;
            final /* synthetic */ VncList val$body;
            {
                this.val$p = vncVal;
                this.val$ns = namespace;
                this.val$ctx = specialFormsContext;
                this.val$body = vncList;
                super(name, params, meta);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public VncVal apply(VncList args) {
                ThreadContext threadCtx = ThreadContext.get();
                Env localEnv = new Env(env);
                localEnv.addLocalVars(Destructuring.destructure(this.val$p, args));
                Namespace curr_ns = threadCtx.getCurrNS_();
                try {
                    threadCtx.setCurrNS_(this.val$ns);
                    this.val$ctx.getValuesEvaluator().evaluate_values(this.val$body.butlast(), localEnv);
                    VncVal vncVal = this.val$ctx.getEvaluator().evaluate(this.val$body.last(), localEnv, false);
                    return vncVal;
                }
                finally {
                    threadCtx.setCurrNS_(curr_ns);
                }
            }
        }).collect(Collectors.toList());
        return new VncMultiArityFunction(fnName.getQualifiedName(), functions, false, MetaUtil.mergeMeta(VncHashMap.of(MetaUtil.ARGLIST, VncList.ofColl(argList)), fnName.getMeta()));
    }

    private static VncVal extendType(VncVal typeRef, VncSymbol protocolSym, VncList fnSpecList, Env env, SpecialFormsContext ctx) {
        if (!(typeRef instanceof VncKeyword)) {
            throw new VncException(String.format("The type '%s' must be a keyword like :core/long!", typeRef.getType()));
        }
        VncVal p = env.getGlobalOrNull(protocolSym);
        if (!(p instanceof VncProtocol)) {
            throw new VncException(String.format("The protocol '%s' is not defined!", protocolSym.getQualifiedName()));
        }
        VncKeyword type = (VncKeyword)typeRef;
        if (!type.hasNamespace()) {
            throw new VncException(String.format("The type '%s' must be qualified!", type.getQualifiedName()));
        }
        VncProtocol protocol = (VncProtocol)p;
        boolean isObjectProtocol = protocol.getName().equals(new VncSymbol("Object"));
        for (VncVal fnSpec : fnSpecList.getJavaList()) {
            VncCustomBaseTypeDef customBaseTypeDef;
            VncVal typeDef;
            VncKeyword qualifiedType;
            VncVal fnName;
            if (!Types.isVncList(fnSpec)) {
                throw new VncException(String.format("Invalid extend for protocol '%s' with type '%s' . Expected a function spec like '(foo [x] nil)'!", protocolSym.getQualifiedName(), typeRef.getType()));
            }
            VncFunction fn = SpecialForms_TypeFunctions.extendFnSpec(type, (VncList)fnSpec, protocol, env, ctx);
            if (!isObjectProtocol || !((fnName = ((VncList)fnSpec).first()) instanceof VncSymbol)) continue;
            if (((VncSymbol)fnName).getSimpleName().equals("toString")) {
                qualifiedType = type.hasNamespace() ? type : type.withNamespace(Namespaces.getCurrentNS());
                typeDef = env.getGlobalOrNull(qualifiedType.toSymbol());
                if (!(typeDef instanceof VncCustomBaseTypeDef)) continue;
                customBaseTypeDef = (VncCustomBaseTypeDef)typeDef;
                customBaseTypeDef.setCustomToStringFn(fn);
                continue;
            }
            if (!((VncSymbol)fnName).getSimpleName().equals("compareTo") || !((typeDef = env.getGlobalOrNull((qualifiedType = type.hasNamespace() ? type : type.withNamespace(Namespaces.getCurrentNS())).toSymbol())) instanceof VncCustomBaseTypeDef)) continue;
            customBaseTypeDef = (VncCustomBaseTypeDef)typeDef;
            customBaseTypeDef.setCustomCompareToFn(fn);
        }
        protocol.register(type);
        return Constants.Nil;
    }

    private static VncFunction extendFnSpec(VncKeyword type, VncList fnSpec, VncProtocol protocol, Env env, SpecialFormsContext ctx) {
        String name = ((VncSymbol)fnSpec.first()).getName();
        VncSymbol fnProtoSym = new VncSymbol(protocol.getName().getNamespace(), name, fnSpec.first().getMeta());
        VncSymbol fnSym = new VncSymbol(GenSym.generateAutoSym(name).getName(), fnSpec.first().getMeta());
        VncVal protocolFn = env.getGlobalOrNull(fnProtoSym);
        if (!(protocolFn instanceof VncProtocolFunction)) {
            throw new VncException(String.format("The protocol function '%s' does not exist!", fnProtoSym.getQualifiedName()));
        }
        VncList fnDef = VncList.of(new VncSymbol("defn"), fnSym).addAllAtEnd(fnSpec.rest());
        ctx.getEvaluator().evaluate(fnDef, env, false);
        VncFunction fn = (VncFunction)env.getGlobalOrNull(fnSym);
        env.removeGlobalSymbol(fnSym);
        ((VncProtocolFunction)protocolFn).register(type, fn);
        return fn;
    }
}

