/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.docgen.cheatsheet;

import com.github.jlangch.venice.Venice;
import com.github.jlangch.venice.impl.RunMode;
import com.github.jlangch.venice.impl.VeniceInterpreter;
import com.github.jlangch.venice.impl.docgen.cheatsheet.CheatsheetRenderer;
import com.github.jlangch.venice.impl.docgen.cheatsheet.CodeSnippetReader;
import com.github.jlangch.venice.impl.docgen.cheatsheet.DocItem;
import com.github.jlangch.venice.impl.docgen.cheatsheet.DocItemBuilder;
import com.github.jlangch.venice.impl.docgen.cheatsheet.DocSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.modules.ModuleAnsiSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.modules.ModuleAppSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.modules.ModuleBenchmarkSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.modules.ModuleComponentSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.modules.ModuleConfigSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.modules.ModuleCryptographySection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.modules.ModuleExcelSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.modules.ModuleGeoipSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.modules.ModuleGradleSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.modules.ModuleGrepSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.modules.ModuleHexdumpSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.modules.ModuleJavaSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.modules.ModuleKiraSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.modules.ModuleMavenSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.modules.ModuleParsifalSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.modules.ModuleSemverSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.modules.ModuleShellSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.modules.ModuleTestSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.modules.ModuleTracingSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.modules.ModuleXmlSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.section.ArraySection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.section.ByteBufSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.section.CidrSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.section.CollectionsSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.section.ConcurrencySection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.section.CsvSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.section.ExceptionsSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.section.FunctionsSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.section.InetSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.section.IoFileSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.section.IoSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.section.IoZipSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.section.JavaInteropSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.section.JsonSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.section.LazySequencesSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.section.LoadPathSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.section.MacrosSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.section.MathSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.section.NamespaceSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.section.PdfSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.section.PrimitivesSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.section.ProtocolsSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.section.RegexSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.section.ReplSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.section.SandboxSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.section.SpecialFormsSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.section.SystemSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.section.SystemVarSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.section.TimeSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.section.TransducersSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.section.TypesSection;
import com.github.jlangch.venice.impl.docgen.util.CodeHighlighter;
import com.github.jlangch.venice.impl.docgen.util.ColorTheme;
import com.github.jlangch.venice.impl.docgen.util.MarkdownDoc;
import com.github.jlangch.venice.impl.env.Env;
import com.github.jlangch.venice.impl.repl.ReplDirs;
import com.github.jlangch.venice.impl.repl.ReplFunctions;
import com.github.jlangch.venice.impl.util.StringUtil;
import com.github.jlangch.venice.impl.util.io.ClassPathResource;
import com.github.jlangch.venice.impl.util.io.IOStreamUtil;
import com.github.jlangch.venice.impl.util.markdown.Markdown;
import com.github.jlangch.venice.impl.util.markdown.renderer.html.HtmlRenderer;
import com.github.jlangch.venice.javainterop.AcceptAllInterceptor;
import com.lowagie.text.pdf.PdfReader;
import java.io.File;
import java.io.FileOutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class DocGenerator {
    private final DocItemBuilder diBuilder;

    public DocGenerator(boolean runExamples) {
        ArrayList<String> preloadedModules = new ArrayList<String>();
        preloadedModules.addAll(Arrays.asList("app", "xml", "crypt", "gradle", "trace", "ansi", "maven", "kira", "java", "semver", "excel", "hexdump", "shell", "geoip", "benchmark", "component", "config", "parsifal", "grep", "test"));
        VeniceInterpreter venice = new VeniceInterpreter(new AcceptAllInterceptor());
        Env docEnv = venice.createEnv(preloadedModules, false, false, RunMode.DOCGEN, IOStreamUtil.nullPrintStream(), IOStreamUtil.nullPrintStream(), null);
        Env env = ReplFunctions.register(docEnv, null, null, false, ReplDirs.notavail());
        this.diBuilder = new DocItemBuilder(env, new CodeHighlighter(ColorTheme.getLightTheme()), preloadedModules, runExamples);
    }

    public static List<DocSection> docInfo() {
        return new DocGenerator(false).buildDocInfo();
    }

    public void run(String version) {
        try {
            System.out.println("Creating cheatsheet V" + version);
            List<DocSection> left = this.getLeftSections();
            List<DocSection> right = this.getRightSections();
            List<DocSection> leftModules = this.getModulesLeftSections();
            List<DocSection> rightModules = this.getModulesRightSections();
            List<MarkdownDoc> topics = this.getMarkdownTopics();
            this.validateUniqueSectionsId(left, right);
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("meta-author", "Venice");
            data.put("version", version);
            data.put("toc", this.getTOC());
            data.put("left", left);
            data.put("right", right);
            data.put("left-modules", leftModules);
            data.put("right-modules", rightModules);
            data.put("details", this.getDocItems(this.concat(left, right, leftModules, rightModules)));
            data.put("snippets", new CodeSnippetReader().readSnippets());
            data.put("topics", topics);
            data.put("pdfmode", false);
            String html = CheatsheetRenderer.renderXHTML(data);
            this.save(new File(this.getUserDir(), "cheatsheet.html"), html);
            data.put("pdfmode", true);
            String xhtml = CheatsheetRenderer.renderXHTML(data);
            ByteBuffer pdf = CheatsheetRenderer.renderPDF(xhtml);
            byte[] pdfArr = pdf.array();
            this.save(new File(this.getUserDir(), "cheatsheet.pdf"), pdfArr);
            PdfReader reader = new PdfReader(pdf.array());
            int pages = reader.getNumberOfPages();
            reader.close();
            System.out.println(String.format("Generated Cheat Sheet at: %s. XHTML: %dKB, PDF: %dKB / %d pages", this.getUserDir(), xhtml.length() / 1024, pdfArr.length / 1024, pages));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private List<DocSection> buildDocInfo() {
        ArrayList<DocSection> sections = new ArrayList<DocSection>();
        sections.addAll(this.getLeftSections());
        sections.addAll(this.getRightSections());
        return sections;
    }

    private List<DocSection> getTOC() {
        ArrayList<DocSection> content = new ArrayList<DocSection>();
        DocSection primitives = new DocSection("Primitives", "primitives");
        primitives.addSection(new DocSection("Literals", "primitives.literals"));
        primitives.addSection(new DocSection("Numbers", "primitives.numbers"));
        primitives.addSection(new DocSection("Strings", "primitives.strings"));
        primitives.addSection(new DocSection("Chars", "primitives.chars"));
        primitives.addSection(new DocSection("Other", "primitives.other"));
        content.add(primitives);
        DocSection collections = new DocSection("Collections", "collections");
        collections.addSection(new DocSection("List", "collections.lists"));
        collections.addSection(new DocSection("Vector", "collections.vectors"));
        collections.addSection(new DocSection("Set", "collections.sets"));
        collections.addSection(new DocSection("Map", "collections.maps"));
        collections.addSection(new DocSection("LazySeq", "lazyseq"));
        collections.addSection(new DocSection("Stack", "collections.stack"));
        collections.addSection(new DocSection("Queue", "collections.queue"));
        collections.addSection(new DocSection("DelayQueue", "collections.delayqueue"));
        collections.addSection(new DocSection("DAG", "collections.dag"));
        collections.addSection(new DocSection("Array", "arrays"));
        collections.addSection(new DocSection("ByteBuf", "bytebuf"));
        content.add(collections);
        DocSection datatypes = new DocSection("Custom\u00a0Types", "datatypes");
        datatypes.addSection(new DocSection("Types", "types"));
        datatypes.addSection(new DocSection("Protocols", "protocols"));
        content.add(datatypes);
        DocSection functions = new DocSection("Core\u00a0Functions", "functions");
        functions.addSection(new DocSection("Functions", "functions"));
        functions.addSection(new DocSection("Macros", "macros"));
        functions.addSection(new DocSection("Special\u00a0Forms", "specialforms"));
        functions.addSection(new DocSection("Transducers", "transducers"));
        functions.addSection(new DocSection("Namespaces", "namespace"));
        functions.addSection(new DocSection("Exceptions", "exceptions"));
        content.add(functions);
        DocSection concurrency = new DocSection("Concurrency", "concurrency");
        concurrency.addSection(new DocSection("Atoms", "concurrency.atoms"));
        concurrency.addSection(new DocSection("Futures", "concurrency.futures"));
        concurrency.addSection(new DocSection("Promises", "concurrency.promises"));
        concurrency.addSection(new DocSection("Delay", "concurrency.delay"));
        concurrency.addSection(new DocSection("Agents", "concurrency.agents"));
        concurrency.addSection(new DocSection("Scheduler", "concurrency.scheduler"));
        concurrency.addSection(new DocSection("Locking", "concurrency.locking"));
        concurrency.addSection(new DocSection("Volatiles", "concurrency.volatiles"));
        concurrency.addSection(new DocSection("Parallel", "concurrency.parallel"));
        content.add(concurrency);
        DocSection threads = new DocSection("Threads", "concurrency.threads");
        threads.addSection(new DocSection("ThreadLocal", "concurrency.threadlocal"));
        threads.addSection(new DocSection("Threads", "concurrency.threads"));
        content.add(threads);
        DocSection system = new DocSection("System\u00a0&\u00a0Java", "system");
        system.addSection(new DocSection("System", "system"));
        system.addSection(new DocSection("System\u00a0Vars", "sysvars"));
        system.addSection(new DocSection("Java\u00a0Interop", "javainterop"));
        system.addSection(new DocSection("REPL", "repl"));
        system.addSection(new DocSection("Sandbox", "sandbox"));
        system.addSection(new DocSection("Load\u00a0Paths", "loadpaths"));
        content.add(system);
        DocSection util = new DocSection("Util", "util");
        util.addSection(new DocSection("Math", "math"));
        util.addSection(new DocSection("Time", "time"));
        util.addSection(new DocSection("Regex", "regex"));
        util.addSection(new DocSection("INET", "inet"));
        util.addSection(new DocSection("CIDR", "cidr"));
        content.add(util);
        DocSection io = new DocSection("I/O", "io");
        io.addSection(new DocSection("I/O", "io.util"));
        io.addSection(new DocSection("File", "io.file"));
        io.addSection(new DocSection("Zip/GZip", "io.zip"));
        content.add(io);
        DocSection documents = new DocSection("Documents", "miscellaneous");
        documents.addSection(new DocSection("JSON", "json"));
        documents.addSection(new DocSection("PDF", "pdf"));
        documents.addSection(new DocSection("PDF Tools", "pdf.pdftools"));
        documents.addSection(new DocSection("CSV", "csv"));
        documents.addSection(new DocSection("XML", "modules.xml"));
        documents.addSection(new DocSection("Excel", "modules.excel"));
        content.add(documents);
        DocSection extmod = new DocSection("Modules", "modules");
        extmod.addSection(new DocSection("Kira\u00a0Templates", "modules.kira"));
        extmod.addSection(new DocSection("Parsifal", "modules.parsifal"));
        extmod.addSection(new DocSection("Configuration", "modules.config"));
        extmod.addSection(new DocSection("Component", "modules.component"));
        extmod.addSection(new DocSection("XML", "modules.xml"));
        extmod.addSection(new DocSection("Grep", "modules.grep"));
        extmod.addSection(new DocSection("Cryptography", "modules.cryptography"));
        extmod.addSection(new DocSection("Java", "modules.java"));
        extmod.addSection(new DocSection("Semver", "modules.semver"));
        extmod.addSection(new DocSection("Hexdump", "modules.hexdump"));
        extmod.addSection(new DocSection("Shell", "modules.shell"));
        extmod.addSection(new DocSection("Geo IP", "modules.geoip"));
        extmod.addSection(new DocSection("Ansi", "modules.ansi"));
        extmod.addSection(new DocSection("Gradle", "modules.gradle"));
        extmod.addSection(new DocSection("Maven", "modules.maven"));
        extmod.addSection(new DocSection("Test", "modules.test"));
        extmod.addSection(new DocSection("Tracing", "modules.tracing"));
        extmod.addSection(new DocSection("Benchmark", "modules.benchmark"));
        extmod.addSection(new DocSection("App", "modules.app"));
        content.add(extmod);
        DocSection others = new DocSection("Others", "others");
        others.addSection(new DocSection("Embedding in Java", "embedding"));
        others.addSection(new DocSection("Venice Doc", "venicedoc"));
        others.addSection(new DocSection("Markdown", "markdown"));
        content.add(others);
        return content;
    }

    private List<MarkdownDoc> getMarkdownTopics() {
        ArrayList<MarkdownDoc> topics = new ArrayList<MarkdownDoc>();
        topics.add(new MarkdownDoc("VeniceDoc", new HtmlRenderer().render(this.loadVeniceDocMarkdown()), "venicedoc"));
        topics.add(new MarkdownDoc("Markdown", new HtmlRenderer().render(this.loadMarkdownDoc()), "markdown"));
        return topics;
    }

    private List<DocSection> getLeftSections() {
        return Arrays.asList(new PrimitivesSection(this.diBuilder).section(), new ByteBufSection(this.diBuilder).section(), new RegexSection(this.diBuilder).section(), new MathSection(this.diBuilder).section(), new TransducersSection(this.diBuilder).section(), new FunctionsSection(this.diBuilder).section(), new MacrosSection(this.diBuilder).section(), new SpecialFormsSection(this.diBuilder).section(), new ExceptionsSection(this.diBuilder).section(), new TypesSection(this.diBuilder).section(), new ProtocolsSection(this.diBuilder).section(), new NamespaceSection(this.diBuilder).section(), new JavaInteropSection(this.diBuilder).section(), new ReplSection(this.diBuilder).section(), new SandboxSection(this.diBuilder).section(), new LoadPathSection(this.diBuilder).section(), new PdfSection(this.diBuilder).section(), new IoZipSection(this.diBuilder).section());
    }

    private List<DocSection> getRightSections() {
        return Arrays.asList(new CollectionsSection(this.diBuilder).section(), new LazySequencesSection(this.diBuilder).section(), new ArraySection(this.diBuilder).section(), new ConcurrencySection(this.diBuilder).section(), new SystemSection(this.diBuilder).section(), new SystemVarSection(this.diBuilder).section(), new TimeSection(this.diBuilder).section(), new IoSection(this.diBuilder).section(), new IoFileSection(this.diBuilder).section(), new JsonSection(this.diBuilder).section(), new InetSection(this.diBuilder).section(), new CidrSection(this.diBuilder).section(), new CsvSection(this.diBuilder).section());
    }

    private List<DocSection> getModulesLeftSections() {
        return Arrays.asList(new ModuleKiraSection(this.diBuilder).section(), new ModuleCryptographySection(this.diBuilder).section(), new ModuleXmlSection(this.diBuilder).section(), new ModuleJavaSection(this.diBuilder).section(), new ModuleParsifalSection(this.diBuilder).section(), new ModuleGradleSection(this.diBuilder).section(), new ModuleMavenSection(this.diBuilder).section(), new ModuleTracingSection(this.diBuilder).section(), new ModuleShellSection(this.diBuilder).section(), new ModuleAnsiSection(this.diBuilder).section(), new ModuleGrepSection(this.diBuilder).section());
    }

    private List<DocSection> getModulesRightSections() {
        return Arrays.asList(new ModuleHexdumpSection(this.diBuilder).section(), new ModuleSemverSection(this.diBuilder).section(), new ModuleGeoipSection(this.diBuilder).section(), new ModuleExcelSection(this.diBuilder).section(), new ModuleTestSection(this.diBuilder).section(), new ModuleConfigSection(this.diBuilder).section(), new ModuleComponentSection(this.diBuilder).section(), new ModuleAppSection(this.diBuilder).section(), new ModuleBenchmarkSection(this.diBuilder).section());
    }

    private List<DocItem> getDocItems(List<DocSection> sections) {
        return sections.stream().map(s -> s.getSections()).flatMap(Collection::stream).map(s -> s.getSections()).flatMap(Collection::stream).map(s -> s.getItems()).flatMap(Collection::stream).filter(i -> !StringUtil.isBlank(i.getName())).distinct().sorted(Comparator.comparing(DocItem::getName)).collect(Collectors.toList());
    }

    private List<DocSection> concat(List<DocSection> s1, List<DocSection> s2, List<DocSection> s3, List<DocSection> s4) {
        ArrayList<DocSection> list = new ArrayList<DocSection>();
        list.addAll(s1);
        list.addAll(s2);
        list.addAll(s3);
        list.addAll(s4);
        return list;
    }

    private void save(File file, String text) throws Exception {
        this.save(file, text.getBytes("UTF-8"));
    }

    private void save(File file, byte[] data) throws Exception {
        try (FileOutputStream fos = new FileOutputStream(file);){
            fos.write(data, 0, data.length);
            fos.flush();
        }
    }

    private File getUserDir() {
        return new File(System.getProperty("user.dir"));
    }

    private Markdown loadVeniceDocMarkdown() {
        try {
            return Markdown.parse(new ClassPathResource(Venice.class.getPackage(), "docgen/venice-doc.md").getResourceAsString("UTF-8"));
        }
        catch (RuntimeException ex) {
            throw new RuntimeException("Failed to read 'venice-doc.md'!", ex);
        }
    }

    private Markdown loadMarkdownDoc() {
        try {
            return Markdown.parse(new ClassPathResource(Venice.class.getPackage(), "docgen/markdown-doc.md").getResourceAsString("UTF-8"));
        }
        catch (RuntimeException ex) {
            throw new RuntimeException("Failed to read 'markdown-doc.md'!", ex);
        }
    }

    private final void validateUniqueSectionsId(List<DocSection> left, List<DocSection> right) {
        HashSet ids = new HashSet();
        left.forEach(s -> this.validateUniqueSectionId((DocSection)s, ids));
        right.forEach(s -> this.validateUniqueSectionId((DocSection)s, ids));
    }

    private final void validateUniqueSectionId(DocSection section, Set<String> ids) {
        String id = section.getId();
        if (id != null) {
            if (ids.contains(section.getId())) {
                throw new RuntimeException(String.format("Non unique section id %s on section %s", id, section.getTitle()));
            }
            ids.add(id);
        }
        section.getSections().forEach(s -> this.validateUniqueSectionId((DocSection)s, ids));
    }
}

