/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.docgen.cheatsheet;

import com.github.jlangch.venice.Parameters;
import com.github.jlangch.venice.Venice;
import com.github.jlangch.venice.impl.docgen.cheatsheet.CrossRef;
import com.github.jlangch.venice.impl.docgen.cheatsheet.DocItem;
import com.github.jlangch.venice.impl.docgen.cheatsheet.ExampleOutput;
import com.github.jlangch.venice.impl.docgen.cheatsheet.IdGen;
import com.github.jlangch.venice.impl.docgen.util.CodeHighlighter;
import com.github.jlangch.venice.impl.env.Env;
import com.github.jlangch.venice.impl.specialforms.SpecialFormsDoc;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncSpecialForm;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.custom.VncProtocol;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.impl.util.StringUtil;
import com.github.jlangch.venice.impl.util.markdown.Markdown;
import com.github.jlangch.venice.util.CapturingPrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class DocItemBuilder {
    private static final boolean MARKDOWN_FN_DESCR = true;
    private static final List<ExampleOutput> EMPTY_EXAMPLES = Collections.unmodifiableList(new ArrayList());
    private static final int CROSSREF_MAX_LEN = 145;
    private final Env env;
    private final boolean runExamples;
    private final List<String> preloadedModules = new ArrayList<String>();
    private final Map<String, DocItem> docItems = new HashMap<String, DocItem>();
    private final CodeHighlighter codeHighlighter;
    private final IdGen idgen = new IdGen();

    public DocItemBuilder(Env env, CodeHighlighter codeHighlighter, List<String> preloadedModules, boolean runExamples) {
        this.env = env;
        this.codeHighlighter = codeHighlighter;
        this.runExamples = runExamples;
        this.preloadedModules.addAll(preloadedModules);
    }

    public DocItem getDocItem(String name) {
        return this.getDocItem(name, true, false);
    }

    public DocItem getDocItem(String name, boolean runExamples) {
        return this.getDocItem(name, runExamples, false);
    }

    public DocItem getDocItem(String name, boolean runExamples, boolean catchEx) {
        DocItem item = this.docItems.get(name);
        if (item != null) {
            return item;
        }
        DocItem item_ = this.getDocItem_(name, runExamples, catchEx);
        if (item_ != null) {
            this.docItems.put(name, item_);
        }
        return item_;
    }

    public String id() {
        return this.idgen.id();
    }

    public String id(String name) {
        return this.idgen.id(name);
    }

    private DocItem getDocItem_(String name, boolean runExamples, boolean catchEx) {
        VncProtocol crossRefProtocol = this.findProtocol(name);
        if (crossRefProtocol != null) {
            String fnDescr = crossRefProtocol.getDoc() == Constants.Nil ? "" : ((VncString)crossRefProtocol.getDoc()).getValue();
            String descr = null;
            String descrXmlStyled = Markdown.parse(fnDescr).renderToHtml();
            return new DocItem(name, new ArrayList<String>(), descr, descrXmlStyled, this.runExamples(name, this.toStringList(crossRefProtocol.getExamples(), name, ":examples"), runExamples, catchEx), this.createCrossRefs(name, crossRefProtocol.getSeeAlso()), this.id(name));
        }
        VncFunction fn = this.findFunction(name);
        if (fn != null) {
            String fnDescr = fn.getDoc() == Constants.Nil ? "" : ((VncString)fn.getDoc()).getValue();
            String descr = null;
            String descrXmlStyled = Markdown.parse(fnDescr).renderToHtml();
            return new DocItem(name, this.toStringList(fn.getArgLists(), name, ":arglists"), descr, descrXmlStyled, this.runExamples(name, this.toStringList(fn.getExamples(), name, ":examples"), runExamples, catchEx), this.createCrossRefs(name, fn.getSeeAlso()), this.id(name));
        }
        VncSpecialForm sf = this.findSpecialForm(name);
        if (sf != null) {
            String fnDescr = sf.getDoc() == Constants.Nil ? "" : ((VncString)sf.getDoc()).getValue();
            String descr = null;
            String descrXmlStyled = Markdown.parse(fnDescr).renderToHtml();
            return new DocItem(name, this.toStringList(sf.getArgLists(), name, ":arglists"), descr, descrXmlStyled, this.runExamples(name, this.toStringList(sf.getExamples(), name, ":examples"), runExamples, catchEx), this.createCrossRefs(name, sf.getSeeAlso()), this.id(name));
        }
        throw new RuntimeException(String.format("Unknown doc function %s", name));
    }

    private List<ExampleOutput> runExamples(String name, List<String> examples, boolean run, boolean catchEx) {
        if (this.runExamples) {
            Venice runner = new Venice();
            AtomicLong exampleNr = new AtomicLong(0L);
            try {
                return examples.stream().filter(e -> !StringUtil.isEmpty(e)).map(e -> this.runExample(runner, exampleNr.incrementAndGet(), name, (String)e, run, catchEx)).collect(Collectors.toList());
            }
            catch (RuntimeException ex) {
                throw new RuntimeException(String.format("Failed to run examples #%d (of %d) for %s", exampleNr.get(), examples.size(), name), ex);
            }
        }
        return EMPTY_EXAMPLES;
    }

    private ExampleOutput runExample(Venice runner, long exampleNr, String name, String example, boolean run, boolean catchEx) {
        String exampleHighlighted = this.codeHighlighter.highlight(example);
        if (run) {
            CapturingPrintStream ps_out = new CapturingPrintStream();
            CapturingPrintStream ps_err = new CapturingPrintStream();
            try {
                String modules = this.preloadedModules.stream().map(m -> "  (load-module :" + m + ")").collect(Collectors.joining("\n"));
                String script = "(do \n" + modules + "\n\n  (pr-str " + example + "\n))";
                String result = (String)runner.eval("example", script, Parameters.of("*out*", ps_out, "*err*", ps_err));
                return new ExampleOutput(name, example, exampleHighlighted, ps_out.getOutput(), ps_err.getOutput(), result);
            }
            catch (RuntimeException ex) {
                if (catchEx) {
                    return new ExampleOutput(name, example, exampleHighlighted, ps_out.getOutput(), ps_err.getOutput(), ex);
                }
                throw new RuntimeException(String.format("Failed to run example #%d for '%s'", exampleNr, name), ex);
            }
        }
        return new ExampleOutput(name, example, exampleHighlighted);
    }

    private VncFunction findFunction(String name) {
        VncFunction fn = (VncFunction)SpecialFormsDoc.ns.get(new VncSymbol(name));
        if (fn != null) {
            return fn;
        }
        VncVal val = this.env.getOrNil(new VncSymbol(name));
        return Types.isVncFunction(val) ? (VncFunction)val : null;
    }

    private VncSpecialForm findSpecialForm(String name) {
        VncVal val = this.env.getOrNil(new VncSymbol(name));
        return Types.isVncSpecialForm(val) ? (VncSpecialForm)val : null;
    }

    private VncProtocol findProtocol(String name) {
        VncVal val = this.env.getOrNil(new VncSymbol(name));
        return val instanceof VncProtocol ? (VncProtocol)val : null;
    }

    private List<CrossRef> createCrossRefs(String parentName, VncList seeAlso) {
        ArrayList<CrossRef> crossRefs = new ArrayList<CrossRef>();
        seeAlso.forEach((Consumer<? super VncVal>)((Consumer<VncVal>)v -> {
            String crossRefName = ((VncString)v).getValue();
            VncProtocol crossRefProtocol = this.findProtocol(crossRefName);
            if (crossRefProtocol != null) {
                String doc;
                String string = doc = crossRefProtocol.getDoc() == Constants.Nil ? null : ((VncString)crossRefProtocol.getDoc()).getValue();
                if (doc != null) {
                    crossRefs.add(this.createCrossRef(crossRefName, this.getCrossRefDescr(doc)));
                }
            } else {
                VncFunction crossRefFn = this.findFunction(crossRefName);
                if (crossRefFn != null) {
                    String doc;
                    String string = doc = crossRefFn.getDoc() == Constants.Nil ? null : ((VncString)crossRefFn.getDoc()).getValue();
                    if (doc != null) {
                        crossRefs.add(this.createCrossRef(crossRefName, this.getCrossRefDescr(doc)));
                    }
                } else {
                    VncSpecialForm crossRefSf = this.findSpecialForm(crossRefName);
                    if (crossRefSf != null) {
                        String doc;
                        String string = doc = crossRefSf.getDoc() == Constants.Nil ? null : ((VncString)crossRefSf.getDoc()).getValue();
                        if (doc != null) {
                            crossRefs.add(this.createCrossRef(crossRefName, this.getCrossRefDescr(doc)));
                        }
                    } else {
                        throw new RuntimeException(String.format("Missing cross reference function %s -> %s", parentName, crossRefName));
                    }
                }
            }
        }));
        return crossRefs;
    }

    private String getCrossRefDescr(String descr) {
        String s;
        String crossRefDescr = Markdown.parse(descr).renderToText(290);
        int posLF = crossRefDescr.indexOf(10);
        String string = s = posLF == -1 ? crossRefDescr.trim() : crossRefDescr.substring(0, posLF).trim();
        if (s.length() > 145) {
            int spacePos = s.indexOf(32, 130);
            String string2 = s = spacePos != -1 ? s.substring(0, spacePos) : s.substring(0, 140).trim();
            if (!s.endsWith(".")) {
                s = s + " ...";
            }
        }
        return s;
    }

    private CrossRef createCrossRef(String name, String descr) {
        return new CrossRef(name, this.id(name), descr);
    }

    private List<String> toStringList(VncList list, String name, String helpType) {
        try {
            return list.stream().map(s -> ((VncString)s).getValue()).collect(Collectors.toList());
        }
        catch (Exception ex) {
            throw new RuntimeException(String.format("Failed on item '%s' processing %s", name, helpType), ex);
        }
    }
}

