/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.functions;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.thread.ThreadBridge;
import com.github.jlangch.venice.impl.threadpool.ManagedScheduledThreadPoolExecutor;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncJavaObject;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncLong;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.util.Coerce;
import com.github.jlangch.venice.impl.util.ArityExceptions;
import com.github.jlangch.venice.impl.util.SymbolMapBuilder;
import com.github.jlangch.venice.impl.util.callstack.CallFrame;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class ScheduleFunctions {
    public static VncFunction schedule_delay = new VncFunction("schedule-delay", (VncVal)VncFunction.meta().arglists("(schedule-delay fn delay time-unit)").doc("Creates and executes a one-shot action that becomes enabled after the given delay.\u00b6Returns a future. `(deref f)`, `(future? f)`, `(cancel f)`, and `(done? f)` will work on the returned future.\u00b6Time unit is one of :milliseconds, :seconds, :minutes, :hours, or :days. ").examples("(schedule-delay (fn[] (println \"test\")) 1 :seconds)", "(deref (schedule-delay (fn [] 100) 2 :seconds))").seeAlso("schedule-at-fixed-rate").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 3);
            this.sandboxFunctionCallValidation();
            VncFunction fn = Coerce.toVncFunction(args.first());
            VncLong delay = Coerce.toVncLong(args.second());
            VncKeyword unit = Coerce.toVncKeyword(args.third());
            fn.sandboxFunctionCallValidation();
            ThreadBridge threadBridge = ThreadBridge.create("schedule-delay", new CallFrame[]{new CallFrame(this, args), new CallFrame(fn)}, new ThreadBridge.Options[0]);
            Callable<VncVal> taskWrapper = threadBridge.bridgeCallable(() -> fn.applyOf(new VncVal[0]));
            ScheduledFuture<VncVal> future = ScheduleFunctions.getScheduledExecutorService().schedule(taskWrapper, (long)delay.getValue(), ScheduleFunctions.toTimeUnit(unit));
            return new VncJavaObject(future);
        }
    };
    public static VncFunction schedule_at_fixed_rate = new VncFunction("schedule-at-fixed-rate", (VncVal)VncFunction.meta().arglists("(schedule-at-fixed-rate fn initial-delay period time-unit)").doc("Creates and executes a periodic action that becomes enabled first after the given initial delay, and subsequently with the given period.\u00b6Returns a future. `(future? f)`, `(cancel f)`, and `(done? f)` will work on the returned future.\u00b6Time unit is one of :milliseconds, :seconds, :minutes, :hours, or :days. ").examples("(schedule-at-fixed-rate #(println \"test\") 1 2 :seconds)", "(let [s (schedule-at-fixed-rate #(println \"test\") 1 2 :seconds)] \n   (sleep 16 :seconds) \n   (cancel s))").seeAlso("schedule-delay").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 4);
            this.sandboxFunctionCallValidation();
            VncFunction fn = Coerce.toVncFunction(args.first());
            VncLong delay = Coerce.toVncLong(args.second());
            VncLong period = Coerce.toVncLong(args.third());
            VncKeyword unit = Coerce.toVncKeyword(args.fourth());
            fn.sandboxFunctionCallValidation();
            ThreadBridge threadBridge = ThreadBridge.create("schedule-at-fixed-rate", new CallFrame[]{new CallFrame(this, args), new CallFrame(fn)}, new ThreadBridge.Options[0]);
            Runnable taskWrapper = threadBridge.bridgeRunnable(() -> fn.applyOf(new VncVal[0]));
            ScheduledFuture<?> future = ScheduleFunctions.getScheduledExecutorService().scheduleAtFixedRate(taskWrapper, delay.getValue(), period.getValue(), ScheduleFunctions.toTimeUnit(unit));
            return new VncJavaObject(future);
        }
    };
    public static final Map<VncVal, VncVal> ns = new SymbolMapBuilder().add(schedule_delay).add(schedule_at_fixed_rate).toMap();
    private static ManagedScheduledThreadPoolExecutor mngdExecutor = new ManagedScheduledThreadPoolExecutor("venice-scheduler-pool", 4);

    public static TimeUnit toTimeUnit(VncKeyword unit) {
        switch (unit.getValue()) {
            case "millis": {
                return TimeUnit.MILLISECONDS;
            }
            case "milliseconds": {
                return TimeUnit.MILLISECONDS;
            }
            case "seconds": {
                return TimeUnit.SECONDS;
            }
            case "minutes": {
                return TimeUnit.MINUTES;
            }
            case "hours": {
                return TimeUnit.HOURS;
            }
            case "days": {
                return TimeUnit.DAYS;
            }
        }
        throw new VncException("Invalid scheduler time-unit " + unit.getValue());
    }

    public static void shutdown() {
        mngdExecutor.shutdown();
    }

    public static ScheduledExecutorService getScheduledExecutorService() {
        return mngdExecutor.getExecutor();
    }
}

