/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.reader;

import java.io.BufferedReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class LineReader {
    private static final String EOF = null;
    private final List<String> lines;
    private String lnNext;
    private int lineNr;

    public LineReader(String s) {
        this.lines = s == null ? new ArrayList() : this.lines(s);
        this.lineNr = 1;
        this.lnNext = this.lines.isEmpty() ? EOF : this.lines.get(0);
    }

    public String peek() {
        return this.lnNext;
    }

    public void consume() {
        if (this.lnNext != EOF) {
            this.lnNext = this.lineNr >= this.lines.size() ? EOF : this.lines.get(this.lineNr++);
        }
    }

    public int getLineNr() {
        return this.lineNr;
    }

    public int size() {
        return this.lines.size();
    }

    public boolean eof() {
        return this.lnNext == EOF;
    }

    private List<String> lines(String s) {
        if (s.isEmpty()) {
            ArrayList<String> lines = new ArrayList<String>();
            lines.add("");
            return lines;
        }
        List<String> lines = new BufferedReader(new StringReader(s)).lines().collect(Collectors.toList());
        if (s.endsWith("\n")) {
            lines.add("");
        }
        return lines;
    }
}

