/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.repl;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.env.Env;
import com.github.jlangch.venice.impl.env.Var;
import com.github.jlangch.venice.impl.repl.ReplConfig;
import com.github.jlangch.venice.impl.repl.ReplDirs;
import com.github.jlangch.venice.impl.repl.ReplRestart;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncJavaObject;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncLong;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncOrderedMap;
import com.github.jlangch.venice.impl.util.ArityExceptions;
import java.util.ArrayList;
import java.util.List;
import org.repackage.org.jline.terminal.Terminal;
import org.repackage.org.jline.utils.InfoCmp;

public class ReplFunctions {
    public static Env register(Env env, Terminal terminal, ReplConfig config, boolean macroExpandOnLoad, ReplDirs replDirs) {
        Env e = env;
        for (VncFunction fn : ReplFunctions.createFunctions(terminal, config, macroExpandOnLoad, replDirs)) {
            e = ReplFunctions.registerFn(e, fn);
        }
        return e;
    }

    private static Env registerFn(Env env, VncFunction fn) {
        return env.setGlobal(new Var(new VncSymbol(fn.getQualifiedName()), fn, false));
    }

    private static List<VncFunction> createFunctions(Terminal terminal, ReplConfig config, boolean macroExpandOnLoad, ReplDirs replDirs) {
        ArrayList<VncFunction> fns = new ArrayList<VncFunction>();
        fns.add(ReplFunctions.createReplInfoFn(terminal, config));
        fns.add(ReplFunctions.createReplRestartFn(terminal, config, macroExpandOnLoad));
        fns.add(ReplFunctions.createTermRowsFn(terminal));
        fns.add(ReplFunctions.createTermColsFn(terminal));
        fns.add(ReplFunctions.createReplHomeDirFn(replDirs));
        fns.add(ReplFunctions.createReplLibsDirFn(replDirs));
        fns.add(ReplFunctions.createReplFontsDirFn(replDirs));
        return fns;
    }

    private static VncFunction createReplInfoFn(final Terminal terminal, final ReplConfig config) {
        return new VncFunction("repl/info", VncFunction.meta().arglists("(repl/info)").doc("Returns information on the REPL.\n\nNote: This function is only available when called from within a REPL!\n\nE.g.: \n\n```\n{ :term-name \"JLine terminal\" \n  :term-type \"xterm-256color\" \n  :term-cols 80 \n  :term-rows 24 \n  :term-colors 256 \n  :term-class :org.repackage.org.jline.terminal.impl.PosixSysTerminal \n  :color-mode :light }").seeAlso("repl?", "repl/term-rows", "repl/term-cols").build()){
            private static final long serialVersionUID = -1L;

            @Override
            public VncVal apply(VncList args) {
                ArityExceptions.assertArity(this, args, 0);
                try {
                    return VncOrderedMap.of(new VncKeyword("term-name"), new VncString(terminal.getName()), new VncKeyword("term-type"), new VncString(terminal.getType()), new VncKeyword("term-cols"), new VncLong(terminal.getSize().getColumns()), new VncKeyword("term-rows"), new VncLong(terminal.getSize().getRows()), new VncKeyword("term-colors"), new VncLong(terminal.getNumericCapability(InfoCmp.Capability.max_colors).intValue()), new VncKeyword("term-class"), new VncKeyword(terminal.getClass().getName()), new VncKeyword("color-mode"), new VncKeyword(config.getColorMode().toString().toLowerCase()));
                }
                catch (Exception ex) {
                    throw new VncException("Failed to get the REPL terminal info", ex);
                }
            }
        };
    }

    private static VncFunction createReplRestartFn(Terminal terminal, final ReplConfig config, final boolean macroExpandOnLoad) {
        return new VncFunction("repl/restart", VncFunction.meta().arglists("(repl/restart)").doc("Restarts the REPL.\n\nNote: This function is only available when called from within a REPL!").seeAlso("repl?").build()){
            private static final long serialVersionUID = -1L;

            @Override
            public VncVal apply(VncList args) {
                ArityExceptions.assertArity(this, args, 0);
                ReplRestart.restart(macroExpandOnLoad, config.getColorMode());
                return Constants.Nil;
            }
        };
    }

    private static VncFunction createTermRowsFn(final Terminal terminal) {
        return new VncFunction("repl/term-rows", VncFunction.meta().arglists("(repl/term-rows)").doc("Returns number of rows in the REPL terminal.\n\nNote: This function is only available when called from within a REPL!").seeAlso("repl?", "repl/term-cols", "repl/info").build()){
            private static final long serialVersionUID = -1L;

            @Override
            public VncVal apply(VncList args) {
                ArityExceptions.assertArity(this, args, 0);
                return new VncLong(terminal.getSize().getRows());
            }
        };
    }

    private static VncFunction createTermColsFn(final Terminal terminal) {
        return new VncFunction("repl/term-cols", VncFunction.meta().arglists("(repl/term-cols)").doc("Returns number of columns in the REPL terminal.\n\nNote: This function is only available when called from within a REPL!").seeAlso("repl?", "repl/term-rows", "repl/info").build()){
            private static final long serialVersionUID = -1L;

            @Override
            public VncVal apply(VncList args) {
                ArityExceptions.assertArity(this, args, 0);
                return new VncLong(terminal.getSize().getColumns());
            }
        };
    }

    private static VncFunction createReplHomeDirFn(final ReplDirs replDirs) {
        return new VncFunction("repl/home-dir", VncFunction.meta().arglists("(repl/home-dir)").doc("Returns the REPL home directory!").seeAlso("repl?", "repl/libs-dir", "repl/fonts-dir").build()){
            private static final long serialVersionUID = -1L;

            @Override
            public VncVal apply(VncList args) {
                ArityExceptions.assertArity(this, args, 0);
                return replDirs.getHomeDir() == null ? Constants.Nil : new VncJavaObject(replDirs.getHomeDir());
            }
        };
    }

    private static VncFunction createReplLibsDirFn(final ReplDirs replDirs) {
        return new VncFunction("repl/libs-dir", VncFunction.meta().arglists("(repl/libs-dir)").doc("Returns the REPL libs directory!").seeAlso("repl?", "repl/home-dir", "repl/fonts-dir").build()){
            private static final long serialVersionUID = -1L;

            @Override
            public VncVal apply(VncList args) {
                ArityExceptions.assertArity(this, args, 0);
                return replDirs.getLibsDir() == null ? Constants.Nil : new VncJavaObject(replDirs.getLibsDir());
            }
        };
    }

    private static VncFunction createReplFontsDirFn(final ReplDirs replDirs) {
        return new VncFunction("repl/fonts-dir", VncFunction.meta().arglists("(repl/fonts-dir)").doc("Returns the REPL fonts directory!").seeAlso("repl?", "repl/home-dir", "repl/libs-dir").build()){
            private static final long serialVersionUID = -1L;

            @Override
            public VncVal apply(VncList args) {
                ArityExceptions.assertArity(this, args, 0);
                return replDirs.getFontsDir() == null ? Constants.Nil : new VncJavaObject(replDirs.getFontsDir());
            }
        };
    }
}

