/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.util.loadpath;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.util.loadpath.Access;
import com.github.jlangch.venice.impl.util.loadpath.LoadPath;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;

public class DirectoryLoadPath
extends LoadPath {
    private final File dir;

    public DirectoryLoadPath(File dir) {
        this.dir = this.canonical(dir);
    }

    @Override
    public File path() {
        return this.dir;
    }

    @Override
    public boolean isOnPath(File file, Access mode) {
        try {
            File f = this.realFile(file);
            return this.isFileWithinDirectory(f);
        }
        catch (Exception ex) {
            throw new VncException(String.format("Failed to check if the file '%s' is on the load path", file.getPath()), ex);
        }
    }

    @Override
    public boolean isRegularFileOnLoadPath(File file, Access mode) {
        return file.isFile() && this.isOnPath(file, mode);
    }

    @Override
    public boolean isDirectoryOnLoadPath(File file, Access mode) {
        return file.isDirectory() && this.isOnPath(file, mode);
    }

    @Override
    public File normalize(File file) {
        try {
            File f = this.realFile(file);
            return this.isFileWithinDirectory(f) ? f : null;
        }
        catch (Exception ex) {
            throw new VncException(String.format("Failed to normalize the file '%s'!", file.getPath()), ex);
        }
    }

    @Override
    public ByteBuffer load(File file) throws IOException {
        File f = this.realFile(file);
        return f.isFile() && this.isFileWithinDirectory(f) ? ByteBuffer.wrap(Files.readAllBytes(f.toPath())) : null;
    }

    @Override
    public InputStream getInputStream(File file) throws IOException {
        File f = this.realFile(file);
        return f.isFile() && this.isFileWithinDirectory(f) ? Files.newInputStream(f.toPath(), new OpenOption[0]) : null;
    }

    @Override
    public BufferedReader getBufferedReader(File file, Charset charset) throws IOException {
        File f = this.realFile(file);
        return f.isFile() && this.isFileWithinDirectory(f) ? Files.newBufferedReader(f.toPath(), charset) : null;
    }

    @Override
    public OutputStream getOutputStream(File file, OpenOption ... options) throws IOException {
        File f = this.realFile(file);
        return this.isFileWithinDirectory(f) ? Files.newOutputStream(f.toPath(), options) : null;
    }

    public String toString() {
        return this.dir.getPath();
    }

    private File realFile(File file) {
        return file.isAbsolute() ? file : new File(this.dir, file.getPath());
    }

    private boolean isFileWithinDirectory(File file) {
        return this.canonical(file).toPath().startsWith(this.dir.toPath());
    }
}

