/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.util.markdown.renderer.text;

import com.github.jlangch.venice.impl.reader.LineReader;
import com.github.jlangch.venice.impl.util.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;

public class LineWrap {
    public static List<String> softWrap(String text, int maxWidth) {
        if (maxWidth < 1) {
            throw new IllegalArgumentException("A maxWidth must be a positive number!");
        }
        return LineWrap.wrap(text, maxWidth, LineWrap::softWrapLine);
    }

    public static List<String> hardWrap(String text, int maxWidth) {
        if (maxWidth < 1) {
            throw new IllegalArgumentException("A maxWidth must be a positive number!");
        }
        return LineWrap.wrap(text, maxWidth, LineWrap::hardWrapLine);
    }

    private static List<String> wrap(String text, int maxWidth, BiFunction<String, Integer, List<String>> wrapper) {
        if (StringUtil.isBlank(text)) {
            return new ArrayList<String>();
        }
        LineReader reader = new LineReader(text);
        ArrayList<String> lines = new ArrayList<String>();
        while (!reader.eof()) {
            String line = StringUtil.trimRight(reader.peek());
            lines.addAll((Collection<String>)wrapper.apply(line, maxWidth));
            reader.consume();
        }
        return lines;
    }

    private static List<String> softWrapLine(String line, int maxWidth) {
        ArrayList<String> lines = new ArrayList<String>();
        if (line.length() <= maxWidth) {
            lines.add(line);
        } else {
            int minWidth = maxWidth / 2;
            String rest = line;
            while (rest.length() > maxWidth) {
                String part;
                int pos;
                for (pos = maxWidth; !(pos < minWidth || LineWrap.isWhitespaceChar(rest.charAt(pos)) || pos > 1 && LineWrap.isPunctuationChar(rest.charAt(pos - 1))); --pos) {
                }
                if (pos >= minWidth) {
                    part = rest.substring(0, pos).trim();
                    rest = rest.substring(pos).trim();
                    lines.add(part);
                    continue;
                }
                part = rest.substring(0, maxWidth).trim();
                rest = rest.substring(maxWidth).trim();
                lines.add(part);
            }
            if (!rest.isEmpty()) {
                lines.add(rest);
            }
        }
        return lines;
    }

    private static List<String> hardWrapLine(String line, int maxWidth) {
        ArrayList<String> lines = new ArrayList<String>();
        if (line.length() <= maxWidth) {
            lines.add(line);
        } else {
            String rest = line;
            while (rest.length() > maxWidth) {
                String part = rest.substring(0, maxWidth).trim();
                rest = rest.substring(maxWidth).trim();
                lines.add(part);
            }
            if (!rest.isEmpty()) {
                lines.add(rest);
            }
        }
        return lines;
    }

    private static boolean isWhitespaceChar(int ch) {
        switch (ch) {
            case 9: 
            case 32: {
                return true;
            }
        }
        return false;
    }

    private static boolean isPunctuationChar(int ch) {
        switch (ch) {
            case 33: 
            case 44: 
            case 46: 
            case 59: 
            case 63: {
                return true;
            }
        }
        return false;
    }
}

