/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.util.excel;

import com.github.jlangch.venice.impl.util.excel.Excel;
import com.github.jlangch.venice.util.excel.ExcelSheetReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class ExcelReader {
    private final Excel excel;

    ExcelReader(Excel excel) {
        this.excel = excel;
    }

    public static ExcelReader open(byte[] document) {
        return new ExcelReader(Excel.open(new ByteArrayInputStream(document)));
    }

    public static ExcelReader open(ByteBuffer document) {
        return new ExcelReader(Excel.open(new ByteArrayInputStream(document.array())));
    }

    public static ExcelReader open(File file) {
        return new ExcelReader(Excel.open(file));
    }

    public static ExcelReader open(InputStream is) {
        return new ExcelReader(Excel.open(is));
    }

    public int getNumberOfSheets() {
        return this.excel.getNumberOfSheets();
    }

    public void evaluateAllFormulas() {
        this.excel.evaluateAllFormulas();
    }

    public ExcelSheetReader getSheet(String name) {
        return new ExcelSheetReader(this.excel.getSheet(name));
    }

    public ExcelSheetReader getSheetAt(int sheetIdx) {
        return new ExcelSheetReader(this.excel.getSheetAt(sheetIdx - 1));
    }
}

