/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.functions;

import com.github.jlangch.venice.ContinueException;
import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.Printer;
import com.github.jlangch.venice.impl.env.GenSym;
import com.github.jlangch.venice.impl.functions.FunctionsUtil;
import com.github.jlangch.venice.impl.functions.TransducerFunctions;
import com.github.jlangch.venice.impl.namespaces.Namespaces;
import com.github.jlangch.venice.impl.reader.HighlightClass;
import com.github.jlangch.venice.impl.reader.HighlightItem;
import com.github.jlangch.venice.impl.reader.HighlightParser;
import com.github.jlangch.venice.impl.reader.Reader;
import com.github.jlangch.venice.impl.thread.ThreadContext;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.IVncFunction;
import com.github.jlangch.venice.impl.types.VncBigDecimal;
import com.github.jlangch.venice.impl.types.VncBigInteger;
import com.github.jlangch.venice.impl.types.VncBoolean;
import com.github.jlangch.venice.impl.types.VncByteBuffer;
import com.github.jlangch.venice.impl.types.VncChar;
import com.github.jlangch.venice.impl.types.VncConstant;
import com.github.jlangch.venice.impl.types.VncDouble;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncInteger;
import com.github.jlangch.venice.impl.types.VncJavaObject;
import com.github.jlangch.venice.impl.types.VncJust;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncLong;
import com.github.jlangch.venice.impl.types.VncMultiArityFunction;
import com.github.jlangch.venice.impl.types.VncMultiFunction;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.types.VncThreadLocal;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncCollection;
import com.github.jlangch.venice.impl.types.collections.VncDelayQueue;
import com.github.jlangch.venice.impl.types.collections.VncHashMap;
import com.github.jlangch.venice.impl.types.collections.VncHashSet;
import com.github.jlangch.venice.impl.types.collections.VncJavaList;
import com.github.jlangch.venice.impl.types.collections.VncJavaSet;
import com.github.jlangch.venice.impl.types.collections.VncLazySeq;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncMap;
import com.github.jlangch.venice.impl.types.collections.VncMapEntry;
import com.github.jlangch.venice.impl.types.collections.VncMutable;
import com.github.jlangch.venice.impl.types.collections.VncMutableList;
import com.github.jlangch.venice.impl.types.collections.VncMutableMap;
import com.github.jlangch.venice.impl.types.collections.VncMutableSet;
import com.github.jlangch.venice.impl.types.collections.VncMutableVector;
import com.github.jlangch.venice.impl.types.collections.VncOrderedMap;
import com.github.jlangch.venice.impl.types.collections.VncQueue;
import com.github.jlangch.venice.impl.types.collections.VncSequence;
import com.github.jlangch.venice.impl.types.collections.VncSet;
import com.github.jlangch.venice.impl.types.collections.VncSortedMap;
import com.github.jlangch.venice.impl.types.collections.VncSortedSet;
import com.github.jlangch.venice.impl.types.collections.VncStack;
import com.github.jlangch.venice.impl.types.collections.VncVector;
import com.github.jlangch.venice.impl.types.custom.VncCustomType;
import com.github.jlangch.venice.impl.types.util.Coerce;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.impl.util.ArityExceptions;
import com.github.jlangch.venice.impl.util.MeterRegistry;
import com.github.jlangch.venice.impl.util.StringUtil;
import com.github.jlangch.venice.impl.util.SymbolMapBuilder;
import com.github.jlangch.venice.impl.util.callstack.CallFrame;
import com.github.jlangch.venice.impl.util.callstack.CallStack;
import com.github.jlangch.venice.impl.util.transducer.Reducer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class CoreFunctions {
    public static VncFunction nil_Q = new VncFunction("nil?", (VncVal)VncFunction.meta().arglists("(nil? x)").doc("Returns true if x is nil, false otherwise").examples("(nil? nil)", "(nil? 0)", "(nil? false)").seeAlso("some?").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            return VncBoolean.of(args.first() == Constants.Nil);
        }
    };
    public static VncFunction some_Q = new VncFunction("some?", (VncVal)VncFunction.meta().arglists("(some? x)").doc("Returns true if x is not nil, false otherwise").examples("(some? nil)", "(some? 0)", "(some? 4.0)", "(some? false)", "(some? [])", "(some? {})").seeAlso("nil?").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            return VncBoolean.of(args.first() != Constants.Nil);
        }
    };
    public static VncFunction true_Q = new VncFunction("true?", (VncVal)VncFunction.meta().arglists("(true? x)").doc("Returns true if x is true, false otherwise").examples("(true? true)", "(true? false)", "(true? nil)", "(true? 0)", "(true? (== 1 1))").seeAlso("false?", "not").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            return VncBoolean.of(VncBoolean.isTrue(args.first()));
        }
    };
    public static VncFunction false_Q = new VncFunction("false?", (VncVal)VncFunction.meta().arglists("(false? x)").doc("Returns true if x is false, false otherwise").examples("(false? true)", "(false? false)", "(false? nil)", "(false? 0)", "(false? (== 1 2))").seeAlso("true?", "not").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            return VncBoolean.of(VncBoolean.isFalse(args.first()));
        }
    };
    public static VncFunction boolean_Q = new VncFunction("boolean?", (VncVal)VncFunction.meta().arglists("(boolean? n)").doc("Returns true if n is a boolean").examples("(boolean? true)", "(boolean? false)", "(boolean? nil)", "(boolean? 0)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            return VncBoolean.of(Types.isVncBoolean(args.first()));
        }
    };
    public static VncFunction int_Q = new VncFunction("int?", (VncVal)VncFunction.meta().arglists("(int? n)").doc("Returns true if n is an int").examples("(int? 4I)", "(int? 4)", "(int? 3.1)", "(int? true)", "(int? nil)", "(int? {})").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            return VncBoolean.of(Types.isVncInteger(args.first()));
        }
    };
    public static VncFunction long_Q = new VncFunction("long?", (VncVal)VncFunction.meta().arglists("(long? n)").doc("Returns true if n is a long").examples("(long? 4)", "(long? 4I)", "(long? 3.1)", "(long? true)", "(long? nil)", "(long? {})").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            return VncBoolean.of(Types.isVncLong(args.first()));
        }
    };
    public static VncFunction double_Q = new VncFunction("double?", (VncVal)VncFunction.meta().arglists("(double? n)").doc("Returns true if n is a double").examples("(double? 4.0)", "(double? 3)", "(double? 3I)", "(double? 3.0M)", "(double? true)", "(double? nil)", "(double? {})").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            return VncBoolean.of(Types.isVncDouble(args.first()));
        }
    };
    public static VncFunction decimal_Q = new VncFunction("decimal?", (VncVal)VncFunction.meta().arglists("(decimal? n)").doc("Returns true if n is a decimal").examples("(decimal? 4.0M)", "(decimal? 4.0)", "(decimal? 3)", "(decimal? 3I)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            return VncBoolean.of(Types.isVncBigDecimal(args.first()));
        }
    };
    public static VncFunction bigint_Q = new VncFunction("bigint?", (VncVal)VncFunction.meta().arglists("(bigint? n)").doc("Returns true if n is a big integer").examples("(bigint? 4.0N)", "(bigint? 4.0)", "(bigint? 3)", "(bigint? 3I)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            return VncBoolean.of(Types.isVncBigInteger(args.first()));
        }
    };
    public static VncFunction number_Q = new VncFunction("number?", (VncVal)VncFunction.meta().arglists("(number? n)").doc("Returns true if n is a number (int, long, double, or decimal)").examples("(number? 4I))", "(number? 4)", "(number? 4.0M)", "(number? 4.0)", "(number? true)", "(number? \"a\")").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            return VncBoolean.of(Types.isVncLong(args.first()) || Types.isVncInteger(args.first()) || Types.isVncDouble(args.first()) || Types.isVncBigDecimal(args.first()));
        }
    };
    public static VncFunction string_Q = new VncFunction("string?", (VncVal)VncFunction.meta().arglists("(string? x)").doc("Returns true if x is a string").examples("(string? \"abc\")", "(string? 1)", "(string? nil)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            if (args.first() instanceof VncKeyword) {
                return VncBoolean.False;
            }
            if (args.first() instanceof VncString) {
                return VncBoolean.True;
            }
            return VncBoolean.False;
        }
    };
    public static VncFunction char_cast = new VncFunction("char", (VncVal)VncFunction.meta().arglists("(char c)").doc("Converts a number or s single char string to a char.").examples("(char 65)", "(char \"A\")", "(long (char \"A\"))", "(str/join (map char [65 66 67 68]))", "(map #(- (long %) (long (char \"0\"))) (str/chars \"123456\"))").seeAlso("char?").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            VncVal c = args.first();
            if (c == Constants.Nil) {
                return Constants.Nil;
            }
            if (Types.isVncChar(c)) {
                return c;
            }
            if (Types.isVncString(c)) {
                String s = ((VncString)c).getValue();
                if (s.length() == 1) {
                    return new VncChar(s.charAt(0));
                }
                throw new VncException("Function 'char' expects a string type argument of length 1.");
            }
            if (Types.isVncInteger(c)) {
                return new VncChar((char)((VncInteger)c).getValue().intValue());
            }
            if (Types.isVncLong(c)) {
                return new VncChar((char)((VncLong)c).getValue().intValue());
            }
            throw new VncException(String.format("Function 'char' does not allow %s argument.", Types.getType(c)));
        }
    };
    public static VncFunction char_Q = new VncFunction("char?", (VncVal)VncFunction.meta().arglists("(char? s)").doc("Returns true if s is a char.").examples("(char? #\\a)").seeAlso("char").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            return VncBoolean.of(Types.isVncChar(args.first()));
        }
    };
    public static VncFunction char_literals = new VncFunction("char-literals", (VncVal)VncFunction.meta().arglists("(char-literals)").doc("Returns all defined char literals. \n\n" + CoreFunctions.renderCharLiteralsMarkdownTable()).examples("(char-literals)").seeAlso("char", "char?").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 0);
            return VncList.ofList(VncChar.symbols().entrySet().stream().map(e -> VncList.of(new VncString((String)e.getKey()), new VncString(((VncChar)e.getValue()).toUnicode()), new VncString("'" + ((VncChar)e.getValue()).getValue() + "'"))).collect(Collectors.toList()));
        }
    };
    public static VncFunction symbol = new VncFunction("symbol", (VncVal)VncFunction.meta().arglists("(symbol name)", "(symbol ns name)").doc("Returns a symbol from the given name").examples("(symbol \"a\")", "(symbol \"foo\" \"a\")", "(symbol *ns* \"a\")", "(symbol 'a)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1, 2);
            if (args.size() == 1) {
                if (Types.isVncSymbol(args.first())) {
                    return args.first();
                }
                if (Types.isVncString(args.first())) {
                    return new VncSymbol(((VncString)args.first()).getValue());
                }
                throw new VncException(String.format("Function 'symbol' does not allow %s name.", Types.getType(args.first())));
            }
            if (Types.isVncSymbol(args.first())) {
                return new VncSymbol(Coerce.toVncSymbol(args.first()).getName(), Coerce.toVncString(args.second()).getValue(), Constants.Nil);
            }
            return new VncSymbol(Coerce.toVncString(args.first()).getValue(), Coerce.toVncString(args.second()).getValue(), Constants.Nil);
        }
    };
    public static VncFunction symbol_Q = new VncFunction("symbol?", (VncVal)VncFunction.meta().arglists("(symbol? x)").doc("Returns true if x is a symbol").examples("(symbol? 'a)", "(symbol? (symbol \"a\"))", "(symbol? nil)", "(symbol? :a)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            return VncBoolean.of(Types.isVncSymbol(args.first()));
        }
    };
    public static VncFunction qualified_symbol_Q = new VncFunction("qualified-symbol?", (VncVal)VncFunction.meta().arglists("(qualified-symbol? x)").doc("Returns true if x is a qualified symbol").examples("(qualified-symbol? 'foo/a)", "(qualified-symbol? (symbol \"foo/a\"))", "(qualified-symbol? 'a)", "(qualified-symbol? nil)", "(qualified-symbol? :a)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            VncVal s = args.first();
            if (Types.isVncSymbol(s)) {
                return VncBoolean.of(((VncSymbol)s).hasNamespace());
            }
            return VncBoolean.False;
        }
    };
    public static VncFunction keyword = new VncFunction("keyword", (VncVal)VncFunction.meta().arglists("(keyword name)").doc("Returns a keyword from the given name").examples("(keyword \"a\")", "(keyword :a)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            if (Types.isVncKeyword(args.first())) {
                return args.first();
            }
            if (Types.isVncString(args.first())) {
                return new VncKeyword(((VncString)args.first()).getValue());
            }
            throw new VncException(String.format("Function 'keyword' does not allow %s name", Types.getType(args.first())));
        }
    };
    public static VncFunction keyword_Q = new VncFunction("keyword?", (VncVal)VncFunction.meta().arglists("(keyword? x)").doc("Returns true if x is a keyword").examples("(keyword? (keyword \"a\"))", "(keyword? :a)", "(keyword? nil)", "(keyword? 'a)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            return VncBoolean.of(Types.isVncKeyword(args.first()));
        }
    };
    public static VncFunction fn_Q = new VncFunction("fn?", (VncVal)VncFunction.meta().arglists("(fn? x)").doc("Returns true if x is a function").examples("(do \n   (def sum (fn [x] (+ 1 x)))\n   (fn? sum))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            if (!Types.isVncFunction(args.first())) {
                return VncBoolean.False;
            }
            return VncBoolean.of(!((VncFunction)args.first()).isMacro());
        }
    };
    public static VncFunction macro_Q = new VncFunction("macro?", (VncVal)VncFunction.meta().arglists("(macro? x)").doc("Returns true if x is a macro").examples("(macro? and)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            return VncBoolean.of(Types.isVncMacro(args.first()));
        }
    };
    public static VncFunction fn_name = new VncFunction("fn-name", (VncVal)VncFunction.meta().arglists("(fn-name f)").doc("Returns the qualified name of a function or macro").examples("(fn-name (fn sum [x y] (+ x y)))", "(let [f str/digit?]  \n  (fn-name f))       ").seeAlso("name", "namespace", "fn-about", "fn-body", "fn-pre-conditions").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            VncVal arg = args.first();
            if (arg == Constants.Nil) {
                return Constants.Nil;
            }
            if (Types.isVncFunction(arg) || Types.isVncMacro(arg)) {
                VncFunction fn = (VncFunction)arg;
                fn.sandboxFunctionCallValidation();
                return new VncString(fn.getQualifiedName());
            }
            throw new VncException(String.format("Function 'fn-name' does not allow %s as parameter", Types.getType(arg)));
        }
    };
    public static VncFunction fn_about = new VncFunction("fn-about", (VncVal)VncFunction.meta().arglists("(fn-about f)").doc("Returns the meta information about a function").examples("(fn-about and)", "(fn-about println)", "(fn-about +)").seeAlso("fn-name", "fn-body", "fn-pre-conditions").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            VncVal arg = args.first();
            if (arg == Constants.Nil) {
                return Constants.Nil;
            }
            if (Types.isVncFunction(arg) || Types.isVncMacro(arg)) {
                VncFunction fn = (VncFunction)arg;
                fn.sandboxFunctionCallValidation();
                return fn.about();
            }
            throw new VncException(String.format("Function 'fn-about' does not allow %s as parameter", Types.getType(arg)));
        }
    };
    public static VncFunction fn_body = new VncFunction("fn-body", (VncVal)VncFunction.meta().arglists("(fn-body fn)", "(fn-body fn arity)").doc("Returns the body (a list of forms) of a function.\n\nReturns `nil` if fn is not a function or if fn is a native function.").examples("(do                         \n  (defn calc [& x]          \n    (->> x                  \n         (filter even?)     \n         (map #(* % 10))))  \n  (fn-body (var-get calc))) ").seeAlso("fn-name", "fn-about", "fn-pre-conditions").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1, 2);
            if (!Types.isVncFunction(args.first())) {
                return Constants.Nil;
            }
            VncFunction fn = (VncFunction)args.first();
            fn.sandboxFunctionCallValidation();
            if (fn instanceof VncMultiArityFunction) {
                VncMultiArityFunction mafn = (VncMultiArityFunction)fn;
                if (args.size() == 1) {
                    throw new VncException("The passed function is a multi-arity function. Please pass the arity as second argument!");
                }
                if (args.size() == 2) {
                    int arity = Coerce.toVncLong(args.second()).getIntValue();
                    return mafn.getFunctionForArity(arity).getBody();
                }
                return Constants.Nil;
            }
            if (fn instanceof VncMultiFunction) {
                return Constants.Nil;
            }
            return fn.getBody();
        }
    };
    public static VncFunction fn_pre_conditions = new VncFunction("fn-pre-conditions", (VncVal)VncFunction.meta().arglists("(fn-pre-conditions fn)", "(fn-pre-conditions fn arity)").doc("Returns the pre-conditions (a vector of forms) of a function.\n\nReturns `nil` if fn is not a function.").examples("(do                                   \n  (defn sum [x y]                     \n     { :pre [(> x 0) (> y 0)] }       \n     (+ x y))                         \n  (fn-pre-conditions (var-get sum)))  ").seeAlso("fn-name", "fn-about", "fn-body").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1, 2);
            if (!Types.isVncFunction(args.first())) {
                return Constants.Nil;
            }
            VncFunction fn = (VncFunction)args.first();
            fn.sandboxFunctionCallValidation();
            if (fn instanceof VncMultiArityFunction) {
                VncMultiArityFunction mafn = (VncMultiArityFunction)fn;
                if (args.size() == 1) {
                    return ((VncFunction)mafn.getFunctions().first()).getPreConditions();
                }
                if (args.size() == 2) {
                    int arity = Coerce.toVncLong(args.second()).getIntValue();
                    return mafn.getFunctionForArity(arity).getPreConditions();
                }
                return Constants.Nil;
            }
            if (fn instanceof VncMultiFunction) {
                return Constants.Nil;
            }
            return fn.getPreConditions();
        }
    };
    public static VncFunction pr_str = new VncFunction("pr-str", (VncVal)VncFunction.meta().arglists("(pr-str & xs)").doc("With no args, returns the empty string. With one arg x, returns x.toString(). With more than one arg, returns the concatenation of the str values of the args with delimiter ' '.").examples("(pr-str)", "(pr-str 1 2 3)").seeAlso("str").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            return args.isEmpty() ? VncString.empty() : new VncString(args.stream().map(v -> Printer.pr_str(v, true)).collect(Collectors.joining(" ")));
        }
    };
    public static VncFunction str = new VncFunction("str", (VncVal)VncFunction.meta().arglists("(str & xs)").doc("With no args, returns the empty string. With one arg x, returns x.toString(). (str nil) returns the empty string. With more than one arg, returns the concatenation of the str values of the args.").examples("(str)", "(str 1 2 3)", "(str +)", "(str [1 2 3])", "(str \"total \" 100)", "(str #\\h #\\i)").seeAlso("pr-str").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            StringBuilder sb = new StringBuilder();
            for (VncVal v : args) {
                if (v == Constants.Nil) continue;
                sb.append(Printer.pr_str(v, false));
            }
            return new VncString(sb.toString());
        }
    };
    public static VncFunction to_str = new VncFunction("to-str", (VncVal)VncFunction.meta().arglists("(to-str x)", "(to-str print-machine-readably x)").doc("Returns the string representation of x.").examples("(to-str [1 2 3])", "(to-str false [1 2 3])", "(to-str true [1 2 3])").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1, 2);
            if (args.size() == 1) {
                return new VncString(args.first().toString());
            }
            boolean print_machine_readably = Coerce.toVncBoolean(args.first()).getValue();
            VncVal v = args.second();
            return new VncString(v.toString(print_machine_readably));
        }
    };
    public static VncFunction read_string = new VncFunction("read-string", (VncVal)VncFunction.meta().arglists("(read-string s)", "(read-string s origin)").doc("Reads Venice source from a string and transforms its content into a Venice data structure, following the rules of the Venice syntax.").examples("(do                                             \n  (eval (read-string \"(def x 100)\" \"test\")) \n  x)                                              ").seeAlso("eval").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            try {
                ArityExceptions.assertArity(this, args, 1, 2);
                String origin = null;
                if (args.size() == 2) {
                    origin = Coerce.toVncString(args.second()).getValue();
                    origin = origin.substring(origin.lastIndexOf(47) + 1);
                }
                origin = StringUtil.isBlank(origin) ? "unknown" : origin;
                return Reader.read_str(Coerce.toVncString(args.first()).getValue(), origin);
            }
            catch (ContinueException c) {
                return Constants.Nil;
            }
        }
    };
    public static VncFunction just = new VncFunction("just", (VncVal)VncFunction.meta().arglists("(just x)").doc("Creates a wrapped x, that is dereferenceable").examples("(just 10)", "(just \"10\")", "(deref (just 10))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            return new VncJust(args.first());
        }
    };
    public static VncFunction just_Q = new VncFunction("just?", (VncVal)VncFunction.meta().arglists("(just? x)").doc("Returns true if x is of type just").examples("(just? (just 1))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            return VncBoolean.of(Types.isVncJust(args.first()));
        }
    };
    public static VncFunction equal_strict_Q = new VncFunction("=", (VncVal)VncFunction.meta().arglists("(= x y)").doc("Returns true if both operands have equivalent type and value").examples("(= \"abc\" \"abc\")", "(= 0 0)", "(= 0 1)", "(= 0 0.0)", "(= 0 0.0M)", "(= \"0\" 0)").seeAlso("==").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertMinArity(this, args, 1);
            if (args.size() == 2) {
                return VncBoolean.of(Types._equal_strict_Q(args.first(), args.second()));
            }
            if (args.size() == 1) {
                return VncBoolean.True;
            }
            VncVal first = args.first();
            for (VncVal v : args.rest()) {
                if (Types._equal_strict_Q(first, v)) continue;
                return VncBoolean.False;
            }
            return VncBoolean.True;
        }
    };
    public static VncFunction equal_Q = new VncFunction("==", (VncVal)VncFunction.meta().arglists("(== x y)").doc("Returns true if both operands have equivalent value. \n\nNumbers of different types can be checked for value equality.").examples("(== \"abc\" \"abc\")", "(== 0 0)", "(== 0 1)", "(== 0 0.0)", "(== 0 0.0M)", "(== \"0\" 0)").seeAlso("=").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertMinArity(this, args, 1);
            if (args.size() == 2) {
                return VncBoolean.of(Types._equal_Q(args.first(), args.second()));
            }
            if (args.size() == 1) {
                return VncBoolean.True;
            }
            VncVal first = args.first();
            for (VncVal v : args.rest()) {
                if (Types._equal_Q(first, v)) continue;
                return VncBoolean.False;
            }
            return VncBoolean.True;
        }
    };
    public static VncFunction match_Q = new VncFunction("match?", (VncVal)VncFunction.meta().arglists("(match? s regex)").doc("Returns true if the string s matches the regular expression regex.\n\nThe argument 'regex' may be a string representing a regular expression or a :java.util.regex.Pattern. \n\nSee the functions in the 'regex' namespace if more than a simple regex match is required! E.g. `regex/matches?` performs much better on matching many strings against the same pattern: \n\n```                                                          \n(let [m (regex/matcher #\"[0-9]+\" \"\")]                    \n  (filter #(regex/matches? m %) [\"100\" \"1a1\" \"200\"]))  \n```").examples("(match? \"1234\" \"[0-9]+\")", "(match? \"1234ss\" \"[0-9]+\")", "(match? \"1234\" #\"[0-9]+\")").seeAlso("not-match?", "regex/matches?", "regex/matches-not?", "regex/pattern", "regex/matcher", "regex/matches", "regex/find", "regex/find-all").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2);
            if (!Types.isVncString(args.first())) {
                throw new VncException(String.format("Invalid first argument type %s while calling function 'match?'", Types.getType(args.first())));
            }
            String s = ((VncString)args.first()).getValue();
            if (Types.isVncString(args.second())) {
                String regex = ((VncString)args.second()).getValue();
                return VncBoolean.of(s.matches(regex));
            }
            if (Types.isVncJavaObject(args.second(), Pattern.class)) {
                Pattern p = Coerce.toVncJavaObject(args.second(), Pattern.class);
                return VncBoolean.of(p.matcher(s).matches());
            }
            if (Types.isVncJavaObject(args.second(), Matcher.class)) {
                Matcher m = Coerce.toVncJavaObject(args.second(), Matcher.class);
                return VncBoolean.of(m.reset(s).matches());
            }
            throw new VncException(String.format("Invalid second argument type %s while calling function 'match?'", Types.getType(args.second())));
        }
    };
    public static VncFunction not_match_Q = new VncFunction("not-match?", (VncVal)VncFunction.meta().arglists("(not-match? s regex)").doc("Returns true if the string s does not match the regular expression regex.\n\nThe argument 'regex' may be a string representing a regular expression or a :java.util.regex.Pattern.\n\nSee the functions in the 'regex' namespace if more than a simple regex match is required! E.g. `regex/matches-not?` performs much better on matching many strings against the same pattern: \n\n```                                                              \n(let [m (regex/matcher #\"[0-9]+\" \"\")]                        \n  (filter #(regex/matches-not? m %) [\"100\" \"1a1\" \"200\"]))  \n```").examples("(not-match? \"S1000\" \"[0-9]+\")", "(not-match? \"S1000\" #\"[0-9]+\")", "(not-match? \"1000\" \"[0-9]+\")").seeAlso("match?", "regex/matches-not?", "regex/matches?", "regex/pattern", "regex/matcher", "regex/matches", "regex/find", "regex/find-all").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2);
            if (!Types.isVncString(args.first())) {
                throw new VncException(String.format("Invalid first argument type %s while calling function 'not-match?'", Types.getType(args.first())));
            }
            String s = ((VncString)args.first()).getValue();
            if (Types.isVncString(args.second())) {
                String regex = ((VncString)args.second()).getValue();
                return VncBoolean.of(!s.matches(regex));
            }
            if (Types.isVncJavaObject(args.second(), Pattern.class)) {
                Pattern p = Coerce.toVncJavaObject(args.second(), Pattern.class);
                return VncBoolean.of(!p.matcher(s).matches());
            }
            if (Types.isVncJavaObject(args.second(), Matcher.class)) {
                Matcher m = Coerce.toVncJavaObject(args.second(), Matcher.class);
                return VncBoolean.of(!m.reset(s).matches());
            }
            throw new VncException(String.format("Invalid second argument type %s while calling function 'match?'", Types.getType(args.second())));
        }
    };
    public static VncFunction lt = new VncFunction("<", (VncVal)VncFunction.meta().arglists("(< x y)", "(< x y & more)").doc("Returns true if the numbers are in monotonically increasing order, otherwise false.").examples("(< 2 3)", "(< 2 3.0)", "(< 2 3.0M)", "(< 2 3 4 5 6 7)", "(let [x 10] \n  (< 0 x 100)) ").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertMinArity(this, args, 2);
            VncVal op1 = args.first();
            if (!Types.isVncNumber(op1)) {
                throw new VncException("Function '<' supports numbers only.");
            }
            if (args.size() == 2) {
                VncVal op2 = args.second();
                if (!Types.isVncNumber(op2)) {
                    throw new VncException("Function '<' supports numbers only.");
                }
                return VncBoolean.of(op1.compareTo(op2) < 0);
            }
            VncList vals = args.rest();
            while (!vals.isEmpty()) {
                VncVal op2 = vals.first();
                if (!Types.isVncNumber(op2)) {
                    throw new VncException("Function '<' supports numbers only.");
                }
                if (op1.compareTo(op2) < 0) {
                    op1 = op2;
                    vals = vals.rest();
                    continue;
                }
                return VncBoolean.False;
            }
            return VncBoolean.True;
        }
    };
    public static VncFunction lte = new VncFunction("<=", (VncVal)VncFunction.meta().arglists("(<= x y)", "(<= x y & more)").doc("Returns true if the numbers are in monotonically non-decreasing order, otherwise false.").examples("(<= 2 3)", "(<= 3 3)", "(<= 2 3.0)", "(<= 2 3.0M)", "(<= 2 3 4 5 6 7)", "(let [x 10] \n  (<= 0 x 100)) ").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertMinArity(this, args, 2);
            VncVal op1 = args.first();
            if (!Types.isVncNumber(op1)) {
                throw new VncException("Function '<=' supports numbers only.");
            }
            if (args.size() == 2) {
                VncVal op2 = args.second();
                if (!Types.isVncNumber(op2)) {
                    throw new VncException("Function '<=' supports numbers only.");
                }
                return VncBoolean.of(op1.compareTo(op2) <= 0);
            }
            VncList vals = args.rest();
            while (!vals.isEmpty()) {
                VncVal op2 = vals.first();
                if (!Types.isVncNumber(op2)) {
                    throw new VncException("Function '<=' supports numbers only.");
                }
                if (op1.compareTo(op2) <= 0) {
                    op1 = op2;
                    vals = vals.rest();
                    continue;
                }
                return VncBoolean.False;
            }
            return VncBoolean.True;
        }
    };
    public static VncFunction gt = new VncFunction(">", (VncVal)VncFunction.meta().arglists("(> x y)", "(> x y & more)").doc("Returns true if the numbers are in monotonically decreasing order, otherwise false.").examples("(> 3 2)", "(> 3 3)", "(> 3.0 2)", "(> 3.0M 2)", "(> 7 6 5 4 3 2)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertMinArity(this, args, 2);
            VncVal op1 = args.first();
            if (!Types.isVncNumber(op1)) {
                throw new VncException("Function '>' supports numbers only.");
            }
            if (args.size() == 2) {
                VncVal op2 = args.second();
                if (!Types.isVncNumber(op2)) {
                    throw new VncException("Function '>' supports numbers only.");
                }
                return VncBoolean.of(op1.compareTo(op2) > 0);
            }
            VncList vals = args.rest();
            while (!vals.isEmpty()) {
                VncVal op2 = vals.first();
                if (!Types.isVncNumber(op2)) {
                    throw new VncException("Function '>' supports numbers only.");
                }
                if (op1.compareTo(op2) > 0) {
                    op1 = op2;
                    vals = vals.rest();
                    continue;
                }
                return VncBoolean.False;
            }
            return VncBoolean.True;
        }
    };
    public static VncFunction gte = new VncFunction(">=", (VncVal)VncFunction.meta().arglists("(>= x y)", "(>= x y & more)").doc("Returns true if the numbers are in monotonically non-increasing order, otherwise false.").examples("(>= 3 2)", "(>= 3 3)", "(>= 3.0 2)", "(>= 3.0M 2)", "(>= 7 6 5 4 3 2)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertMinArity(this, args, 2);
            VncVal op1 = args.first();
            if (!Types.isVncNumber(op1)) {
                throw new VncException("Function '>=' supports numbers only.");
            }
            if (args.size() == 2) {
                VncVal op2 = args.second();
                if (!Types.isVncNumber(op2)) {
                    throw new VncException("Function '>=' supports numbers only.");
                }
                return VncBoolean.of(op1.compareTo(op2) >= 0);
            }
            VncList vals = args.rest();
            while (!vals.isEmpty()) {
                VncVal op2 = vals.first();
                if (!Types.isVncNumber(op2)) {
                    throw new VncException("Function '>=' supports numbers only.");
                }
                if (op1.compareTo(op2) >= 0) {
                    op1 = op2;
                    vals = vals.rest();
                    continue;
                }
                return VncBoolean.False;
            }
            return VncBoolean.True;
        }
    };
    public static VncFunction boolean_cast = new VncFunction("boolean", (VncVal)VncFunction.meta().arglists("(boolean x)").doc("Converts to boolean. Everything except 'false' and 'nil' is true in boolean context.").examples("(boolean false)", "(boolean true)", "(boolean nil)", "(boolean 100)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            VncVal arg = args.first();
            if (arg == Constants.Nil) {
                return VncBoolean.False;
            }
            if (VncBoolean.isFalse(arg)) {
                return VncBoolean.False;
            }
            return VncBoolean.True;
        }
    };
    public static VncFunction long_cast = new VncFunction("long", (VncVal)VncFunction.meta().arglists("(long x)").doc("Converts to long").examples("(long 1)", "(long nil)", "(long false)", "(long true)", "(long 1.2)", "(long 1.2M)", "(long \"1\")", "(long (char \"A\"))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            VncVal arg = args.first();
            if (arg == Constants.Nil) {
                return new VncLong(0L);
            }
            if (VncBoolean.isFalse(arg)) {
                return new VncLong(0L);
            }
            if (VncBoolean.isTrue(arg)) {
                return new VncLong(1L);
            }
            if (Types.isVncLong(arg)) {
                return arg;
            }
            if (Types.isVncInteger(arg)) {
                return new VncLong(((VncInteger)arg).toJavaLong());
            }
            if (Types.isVncDouble(arg)) {
                return new VncLong(((VncDouble)arg).toJavaLong());
            }
            if (Types.isVncBigDecimal(arg)) {
                return new VncLong(((VncBigDecimal)arg).toJavaLong());
            }
            if (Types.isVncBigInteger(arg)) {
                return new VncLong(((VncBigInteger)arg).toJavaLong());
            }
            if (Types.isVncChar(arg)) {
                return new VncLong(((VncChar)arg).getValue().charValue());
            }
            if (Types.isVncString(arg)) {
                String s = ((VncString)arg).getValue();
                try {
                    return new VncLong(Long.parseLong(s));
                }
                catch (Exception ex) {
                    throw new VncException(String.format("Function 'long': the string %s can not be converted to a long", s));
                }
            }
            if (Types.isVncJavaObject(arg, Long.class)) {
                return new VncLong((Long)((VncJavaObject)arg).getDelegate());
            }
            throw new VncException(String.format("Function 'long' does not allow %s as operand 1", Types.getType(arg)));
        }
    };
    public static VncFunction int_cast = new VncFunction("int", (VncVal)VncFunction.meta().arglists("(int x)").doc("Converts to int").examples("(int 1)", "(int nil)", "(int false)", "(int true)", "(int 1.2)", "(int 1.2M)", "(int \"1\")", "(int (char \"A\"))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            VncVal arg = args.first();
            if (arg == Constants.Nil) {
                return new VncInteger(0);
            }
            if (VncBoolean.isFalse(arg)) {
                return new VncInteger(0);
            }
            if (VncBoolean.isTrue(arg)) {
                return new VncInteger(1);
            }
            if (Types.isVncInteger(arg)) {
                return arg;
            }
            if (Types.isVncLong(arg)) {
                return new VncInteger(((VncLong)arg).toJavaInteger());
            }
            if (Types.isVncDouble(arg)) {
                return new VncInteger(((VncDouble)arg).toJavaInteger());
            }
            if (Types.isVncBigDecimal(arg)) {
                return new VncInteger(((VncBigDecimal)arg).toJavaInteger());
            }
            if (Types.isVncBigInteger(arg)) {
                return new VncInteger(((VncBigInteger)arg).toJavaInteger());
            }
            if (Types.isVncChar(arg)) {
                return new VncInteger(((VncChar)arg).getValue().charValue());
            }
            if (Types.isVncString(arg)) {
                String s = ((VncString)arg).getValue();
                try {
                    return new VncInteger(Integer.parseInt(s));
                }
                catch (Exception ex) {
                    throw new VncException(String.format("Function 'int': the string %s can not be converted to an int", s));
                }
            }
            if (Types.isVncJavaObject(arg, Integer.class)) {
                return new VncInteger((Integer)((VncJavaObject)arg).getDelegate());
            }
            throw new VncException(String.format("Function 'int' does not allow %s as operand 1", Types.getType(arg)));
        }
    };
    public static VncFunction double_cast = new VncFunction("double", (VncVal)VncFunction.meta().arglists("(double x)").doc("Converts to double").examples("(double 1)", "(double nil)", "(double false)", "(double true)", "(double 1.2)", "(double 1.2M)", "(double \"1.2\")").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            VncVal arg = args.first();
            if (arg == Constants.Nil) {
                return new VncDouble(0.0);
            }
            if (VncBoolean.isFalse(arg)) {
                return new VncDouble(0.0);
            }
            if (VncBoolean.isTrue(arg)) {
                return new VncDouble(1.0);
            }
            if (Types.isVncInteger(arg)) {
                return new VncDouble(((VncInteger)arg).toJavaDouble());
            }
            if (Types.isVncLong(arg)) {
                return new VncDouble(((VncLong)arg).toJavaDouble());
            }
            if (Types.isVncDouble(arg)) {
                return arg;
            }
            if (Types.isVncBigDecimal(arg)) {
                return new VncDouble(((VncBigDecimal)arg).toJavaDouble());
            }
            if (Types.isVncBigInteger(arg)) {
                return new VncDouble(((VncBigInteger)arg).toJavaDouble());
            }
            if (Types.isVncString(arg)) {
                String s = ((VncString)arg).getValue();
                try {
                    return new VncDouble(Double.parseDouble(s));
                }
                catch (Exception ex) {
                    throw new VncException(String.format("Function 'double': the string %s can not be converted to a double", s));
                }
            }
            if (Types.isVncJavaObject(arg, Double.class)) {
                return new VncDouble((Double)((VncJavaObject)arg).getDelegate());
            }
            if (Types.isVncJavaObject(arg, Float.class)) {
                return new VncDouble((Float)((VncJavaObject)arg).getDelegate());
            }
            throw new VncException(String.format("Function 'double' does not allow %s as operand 1", Types.getType(arg)));
        }
    };
    public static VncFunction decimal_cast = new VncFunction("decimal", (VncVal)VncFunction.meta().arglists("(decimal x) (decimal x scale rounding-mode)").doc("Converts to decimal. rounding-mode is one of (:CEILING, :DOWN, :FLOOR, :HALF_DOWN, :HALF_EVEN, :HALF_UP, :UNNECESSARY, :UP)").examples("(decimal 2)", "(decimal 2 3 :HALF_UP)", "(decimal 2.5787 3 :HALF_UP)", "(decimal 2.5787M 3 :HALF_UP)", "(decimal \"2.5787\" 3 :HALF_UP)", "(decimal nil)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            RoundingMode roundingMode;
            ArityExceptions.assertArity(this, args, 1, 3);
            if (args.isEmpty()) {
                return new VncBigDecimal(BigDecimal.ZERO);
            }
            VncVal arg = args.first();
            boolean scaling = args.size() == 3;
            int scale = scaling ? Coerce.toVncLong(args.second()).getIntValue() : 0;
            RoundingMode roundingMode2 = roundingMode = args.size() < 3 ? null : VncBigDecimal.toRoundingMode((VncString)args.nth(2));
            if (arg == Constants.Nil) {
                BigDecimal dec = BigDecimal.ZERO;
                return new VncBigDecimal(!scaling ? dec : dec.setScale(scale, roundingMode));
            }
            if (VncBoolean.isFalse(arg)) {
                BigDecimal dec = BigDecimal.ZERO;
                return new VncBigDecimal(!scaling ? dec : dec.setScale(scale, roundingMode));
            }
            if (VncBoolean.isTrue(arg)) {
                BigDecimal dec = BigDecimal.ONE;
                return new VncBigDecimal(!scaling ? dec : dec.setScale(scale, roundingMode));
            }
            if (Types.isVncString(arg)) {
                BigDecimal dec = new BigDecimal(((VncString)arg).getValue());
                return new VncBigDecimal(!scaling ? dec : dec.setScale(scale, roundingMode));
            }
            if (Types.isVncNumber(arg)) {
                BigDecimal dec = VncBigDecimal.of(arg).getValue();
                return new VncBigDecimal(!scaling ? dec : dec.setScale(scale, roundingMode));
            }
            if (Types.isVncJavaObject(arg, BigDecimal.class)) {
                return new VncBigDecimal((BigDecimal)((VncJavaObject)arg).getDelegate());
            }
            throw new VncException(String.format("Function 'decimal' does not allow %s as operand 1", Types.getType(arg)));
        }
    };
    public static VncFunction bigint_cast = new VncFunction("bigint", (VncVal)VncFunction.meta().arglists("(bigint x)").doc("Converts to big integer.").examples("(bigint 2000)", "(bigint 34897.65)", "(bigint \"5676000000000\")", "(bigint nil)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            if (args.isEmpty()) {
                return new VncBigDecimal(BigDecimal.ZERO);
            }
            VncVal arg = args.first();
            if (arg == Constants.Nil) {
                return new VncBigInteger(BigInteger.ZERO);
            }
            if (VncBoolean.isFalse(arg)) {
                return new VncBigInteger(BigInteger.ZERO);
            }
            if (VncBoolean.isTrue(arg)) {
                return new VncBigInteger(BigInteger.ONE);
            }
            if (Types.isVncString(arg)) {
                return new VncBigInteger(new BigInteger(((VncString)arg).getValue()));
            }
            if (Types.isVncNumber(arg)) {
                return VncBigInteger.of(arg);
            }
            if (Types.isVncJavaObject(arg, BigInteger.class)) {
                return new VncBigInteger((BigInteger)((VncJavaObject)arg).getDelegate());
            }
            throw new VncException(String.format("Function 'decimal' does not allow %s as operand 1", Types.getType(arg)));
        }
    };
    public static VncFunction new_list = new VncFunction("list", (VncVal)VncFunction.meta().arglists("(list & items)").doc("Creates a new list containing the items.").examples("(list)", "(list 1 2 3)", "(list 1 2 3 [:a :b])").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            return args;
        }
    };
    public static VncFunction new_list_ASTERISK = new VncFunction("list*", (VncVal)VncFunction.meta().arglists("(list* args)", "(list* a args)", "(list* a b args)", "(list* a b c args)", "(list* a b c d & more)").doc("Creates a new list containing the items prepended to the rest, the last of which will be treated as a collection.").examples("(list* 1 '(2 3))", "(list* 1 2 3 [4])", "(list* 1 2 3 '(4 5))", "(list* '(1 2) 3 [4])", "(list* nil)", "(list* nil [2 3])", "(list* 1 2 nil)").seeAlso("cons", "conj", "vector*").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertMinArity(this, args, 1);
            if (args.size() == 1 && args.first() == Constants.Nil) {
                return Constants.Nil;
            }
            if (args.last() == Constants.Nil) {
                return args.butlast();
            }
            if (!Types.isVncSequence(args.last())) {
                throw new VncException(String.format("Function 'list*' does not allow %s as last argument", Types.getType(args.last())));
            }
            return VncList.empty().addAllAtEnd(args.butlast()).addAllAtEnd((VncSequence)args.last());
        }
    };
    public static VncFunction list_Q = new VncFunction("list?", (VncVal)VncFunction.meta().arglists("(list? obj)").doc("Returns true if obj is a list").examples("(list? (list 1 2))", "(list? '(1 2))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            return VncBoolean.of(Types.isVncList(args.first()));
        }
    };
    public static VncFunction new_mutable_list = new VncFunction("mutable-list", (VncVal)VncFunction.meta().arglists("(mutable-list & items)").doc("Creates a new mutable list containing the items.\n\nThe list is backed by `java.util.ArrayList` and is not thread-safe.").examples("(mutable-list)", "(mutable-list 1 2 3)", "(mutable-list 1 2 3 [:a :b])").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            return VncMutableList.ofAll(args, Constants.Nil);
        }
    };
    public static VncFunction mutable_list_Q = new VncFunction("mutable-list?", (VncVal)VncFunction.meta().arglists("(mutable-list? obj)").doc("Returns true if obj is a mutable list").examples("(mutable-list? (mutable-list 1 2))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            return VncBoolean.of(Types.isVncMutableList(args.first()));
        }
    };
    public static VncFunction new_vector = new VncFunction("vector", (VncVal)VncFunction.meta().arglists("(vector & items)").doc("Creates a new vector containing the items.").examples("(vector)", "(vector 1 2 3)", "(vector 1 2 3 [:a :b])", "(vector \"abc\")").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            return args.toVncVector();
        }
    };
    public static VncFunction new_vector_ASTERISK = new VncFunction("vector*", (VncVal)VncFunction.meta().arglists("(vector* args)", "(vector* a args)", "(vector* a b args)", "(vector* a b c args)", "(vector* a b c d & more)").doc("Creates a new vector containing the items prepended to the rest, the last of which will be treated as a collection.").examples("(vector* 1 [2 3])", "(vector* 1 2 3 [4])", "(vector* 1 2 3 '(4 5))", "(vector* '[1 2] 3 [4])", "(vector* nil)", "(vector* nil [2 3])", "(vector* 1 2 nil)").seeAlso("cons", "conj", "list*").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertMinArity(this, args, 1);
            if (args.size() == 1 && args.first() == Constants.Nil) {
                return Constants.Nil;
            }
            if (args.last() == Constants.Nil) {
                return args.butlast();
            }
            if (!Types.isVncSequence(args.last())) {
                throw new VncException(String.format("Function 'vector*' does not allow %s as last argument", Types.getType(args.last())));
            }
            return VncVector.empty().addAllAtEnd(args.butlast()).addAllAtEnd((VncSequence)args.last());
        }
    };
    public static VncFunction vector_Q = new VncFunction("vector?", (VncVal)VncFunction.meta().arglists("(vector? obj)").doc("Returns true if obj is a vector").examples("(vector? (vector 1 2))", "(vector? [1 2])").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            return VncBoolean.of(CoreFunctions.vector_Q(args.first()));
        }
    };
    public static VncFunction subvec = new VncFunction("subvec", (VncVal)VncFunction.meta().arglists("(subvec v start) (subvec v start end)").doc("Returns a vector of the items in vector from start (inclusive) to end (exclusive). If end is not supplied, defaults to (count vector)").examples("(subvec [1 2 3 4 5 6] 2)", "(subvec [1 2 3 4 5 6] 2 3)").seeAlso("sublist").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            Integer to;
            ArityExceptions.assertArity(this, args, 2, 3);
            VncSequence seq = Coerce.toVncSequence(args.first());
            if (seq instanceof VncLazySeq) {
                throw new VncException("Function 'subvec' requires a vector but got a lazy-seq!");
            }
            VncVector vec = Coerce.toVncVector(seq);
            int from = Coerce.toVncLong(args.second()).getIntValue();
            Integer n = to = args.size() > 2 ? Coerce.toVncLong(args.nth(2)).getIntValue() : null;
            if (from >= vec.size()) {
                return VncVector.empty();
            }
            return to == null ? vec.slice(from) : vec.slice(from, to);
        }
    };
    public static VncFunction sublist = new VncFunction("sublist", (VncVal)VncFunction.meta().arglists("(sublist l start) (sublist l start end)").doc("Returns a list of the items in list from start (inclusive) to end (exclusive). If end is not supplied, defaults to (count list).\n\n`sublist` accepts a lazy-seq if both start and end is given.").examples("(sublist '(1 2 3 4 5 6) 2)", "(sublist '(1 2 3 4 5 6) 2 3)", "(doall (sublist (lazy-seq 1 inc) 3 7))").seeAlso("subvec").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            Integer to;
            ArityExceptions.assertArity(this, args, 2, 3);
            VncSequence seq = Coerce.toVncSequence(args.first());
            int from = Coerce.toVncLong(args.second()).getIntValue();
            Integer n = to = args.size() > 2 ? Coerce.toVncLong(args.nth(2)).getIntValue() : null;
            if (seq instanceof VncLazySeq) {
                VncLazySeq lazySeq = (VncLazySeq)seq;
                if (to == null) {
                    throw new VncException("Function 'sublist' requires start and end if a lazy-seq is passed!");
                }
                return lazySeq.slice(from, to);
            }
            VncList list = Coerce.toVncList(seq);
            if (from >= list.size()) {
                return VncList.empty();
            }
            return to == null ? list.slice(from) : list.slice(from, to);
        }
    };
    public static VncFunction replace = new VncFunction("replace", (VncVal)VncFunction.meta().arglists("(replace smap coll)").doc("Given a map of replacement pairs and a collection, returns a collection with any elements that are a key in smap replaced with the corresponding value in smap.").examples("(replace {2 :two, 4 :four} [4 2 3 4 5 6 2])", "(replace {2 :two, 4 :four} #{1 2 3 4 5})", "(replace {[:a 10] [:c 30]} {:a 10 :b 20})").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2);
            VncMap map = Coerce.toVncMap(args.first());
            VncVal coll = args.second();
            if (Types.isVncSequence(coll)) {
                VncSequence seq = (VncSequence)coll;
                ArrayList<VncVal> vals = new ArrayList<VncVal>();
                for (VncVal v : seq) {
                    VncVal r = map.get(v);
                    vals.add(r == Constants.Nil ? v : r);
                }
                return seq.withValues(vals, coll.getMeta());
            }
            if (Types.isVncSet(coll)) {
                VncSet set = (VncSet)coll;
                ArrayList<VncVal> vals = new ArrayList<VncVal>();
                for (VncVal v : set) {
                    VncVal r = map.get(v);
                    vals.add(r == Constants.Nil ? v : r);
                }
                return set.withValues(vals, coll.getMeta());
            }
            if (Types.isVncMap(coll)) {
                VncMap mapc = (VncMap)coll;
                for (VncMapEntry e : map.entries()) {
                    VncVal k = Coerce.toVncVector(e.getKey()).first();
                    VncVal v = Coerce.toVncVector(e.getKey()).second();
                    if (!v.equals(mapc.get(k))) continue;
                    mapc = mapc.dissoc(k);
                    mapc = mapc.assoc(Coerce.toVncVector(e.getValue()).first(), Coerce.toVncVector(e.getValue()).second());
                }
                return mapc;
            }
            throw new VncException("Function 'repeat' requires a list, vector, set, or map as coll argument");
        }
    };
    public static VncFunction shuffle = new VncFunction("shuffle", (VncVal)VncFunction.meta().arglists("(shuffle coll)").doc("Returns a collection of the items in coll in random order.").examples("(shuffle '(1 2 3 4 5 6))", "(shuffle [1 2 3 4 5 6])", "(shuffle \"abcdef\")").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            VncVal coll = args.first();
            if (coll == Constants.Nil) {
                return Constants.Nil;
            }
            if (Types.isVncSequence(coll)) {
                return ((VncSequence)coll).shuffle();
            }
            if (Types.isVncString(coll)) {
                return ((VncString)coll).toVncList().shuffle();
            }
            throw new VncException("Function 'shuffle' requires a list, vector, or string as coll argument.");
        }
    };
    public static VncFunction new_mutable_vector = new VncFunction("mutable-vector", (VncVal)VncFunction.meta().arglists("(mutable-vector & items)").doc("Creates a new mutable threadsafe vector containing the items.").examples("(mutable-vector)", "(mutable-vector 1 2 3)", "(mutable-vector 1 2 3 [:a :b])").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            return VncMutableVector.ofAll(args);
        }
    };
    public static VncFunction mutable_vector_Q = new VncFunction("mutable-vector?", (VncVal)VncFunction.meta().arglists("(mutable-vector? obj)").doc("Returns true if obj is a mutable vector").examples("(mutable-vector? (mutable-vector 1 2))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            return VncBoolean.of(Types.isVncMutableVector(args.first()));
        }
    };
    public static VncFunction mutable_Q = new VncFunction("mutable?", (VncVal)VncFunction.meta().arglists("(mutable? val)").doc("Returns true if val is mutable").examples("(mutable? (queue))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            return VncBoolean.of(args.first() instanceof VncMutable);
        }
    };
    public static VncFunction new_lazy_seq = new VncFunction("lazy-seq", (VncVal)VncFunction.meta().arglists("(lazy-seq)", "(lazy-seq f)", "(lazy-seq seed f)", "(lazy-seq head tail-lazy-seq)").doc("Creates a new lazy sequence.\n\n`(lazy-seq)`\u00b6empty lazy sequence\n\n`(lazy-seq f)`\u00b6(theoretically) infinitely lazy sequence using a repeatedly invoked supplier function for each next value. The supplier function f is a no arg function. The sequence ends if the supplier function returns nil. \n\n`(lazy-seq seed f)`\u00b6\n(theoretically) infinitely lazy sequence with a seed value and a supplier function to calculate the next value based on the previous. f is a single arg function. The sequence ends if the supplier function returns nil.\n\n`(lazy-seq head tail-lazy-seq)`\u00b6Constructs a lazy sequence of a head element and a lazy sequence tail supplier.").examples("; empty lazy sequence  \n(->> (lazy-seq)        \n     (doall))", "; lazy sequence with a supplier function producing random longs \n(->> (lazy-seq rand-long)                                       \n     (take 4)                                                   \n     (doall))", "; lazy sequence with a constant value                           \n(->> (lazy-seq (constantly 5))                                  \n     (take 4)                                                   \n     (doall))", "; lazy sequence with a seed value and a supplier function \n; producing of all positive numbers (1, 2, 3, 4, ...)     \n(->> (lazy-seq 1 inc)                                     \n     (take 10)                                            \n     (doall))", "; producing of all positive even numbers (2, 4, 6, ...)   \n(->> (lazy-seq 2 #(+ % 2))                                \n     (take 10)                                            \n     (doall))", "; lazy sequence as value producing function               \n(interleave [:a :b :c] (lazy-seq 1 inc))", "; lazy sequence with a mapping                         \n(->> (lazy-seq 1 (fn [x] (do (println \"realized\" x)  \n                             (inc x))))                \n     (take 10)                                         \n     (map #(* 10 %))                                   \n     (take 2)                                          \n     (doall))", "; finite lazy sequence from a vector  \n(->> (lazy-seq [1 2 3 4])             \n     (doall))", "; finite lazy sequence with a supplier function that   \n; returns nil to terminate the sequence                \n(do                                                    \n   (def counter (atom 5))                              \n   (defn generate []                                   \n      (swap! counter dec)                              \n      (if (pos? @counter) @counter nil))               \n   (doall (lazy-seq generate)))", "; lazy sequence from a head element and a tail lazy    \n; sequence                                             \n(->> (cons -1 (lazy-seq 0 #(+ % 1)))                   \n     (take 5)                                          \n     (doall))", "; lazy sequence from a head element and a tail lazy    \n; sequence                                             \n(->> (lazy-seq -1 (lazy-seq 0 #(+ % 1)))               \n     (take 5)                                          \n     (doall))").seeAlso("doall", "lazy-seq?").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 0, 1, 2);
            if (args.size() == 0) {
                return new VncLazySeq(Constants.Nil);
            }
            if (args.size() == 1) {
                if (Types.isVncFunction(args.first())) {
                    VncFunction fn = (VncFunction)args.first();
                    fn.sandboxFunctionCallValidation();
                    return VncLazySeq.iterate(fn, Constants.Nil);
                }
                if (Types.isVncList(args.first())) {
                    return VncLazySeq.ofAll(Coerce.toVncList(args.first()), Constants.Nil);
                }
                if (Types.isVncVector(args.first())) {
                    return VncLazySeq.ofAll(Coerce.toVncVector(args.first()), Constants.Nil);
                }
                throw new VncException("Function 'lazy-seq' requires for the first arg either nil, a function, or a sequence.");
            }
            if (args.second() == Constants.Nil) {
                VncFunction fn = Coerce.toVncFunction(args.first());
                fn.sandboxFunctionCallValidation();
                return VncLazySeq.iterate(fn, Constants.Nil);
            }
            if (Types.isVncFunction(args.second())) {
                VncFunction fn = (VncFunction)args.second();
                fn.sandboxFunctionCallValidation();
                return VncLazySeq.iterate(args.first(), fn, Constants.Nil);
            }
            if (Types.isVncLazySeq(args.second())) {
                return VncLazySeq.cons(args.first(), (VncLazySeq)args.second(), (VncVal)Constants.Nil);
            }
            throw new VncException("Function 'lazy-seq' requires for the second arg either nil, a function, or a lazy sequence.");
        }
    };
    public static VncFunction lazyseq_Q = new VncFunction("lazy-seq?", (VncVal)VncFunction.meta().arglists("(lazy-seq? obj)").doc("Returns true if obj is a lazyseq").examples("(lazy-seq? (lazy-seq rand-long))").seeAlso("lazy-seq").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            return VncBoolean.of(Types.isVncLazySeq(args.first()));
        }
    };
    public static VncFunction new_set = new VncFunction("set", (VncVal)VncFunction.meta().arglists("(set & items)").doc("Creates a new set containing the items.").examples("(set)", "(set nil)", "(set 1)", "(set 1 2 3)", "(set [1 2] 3)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            return VncHashSet.ofAll(args);
        }
    };
    public static VncFunction new_sorted_set = new VncFunction("sorted-set", (VncVal)VncFunction.meta().arglists("(sorted-set & items)").doc("Creates a new sorted-set containing the items.").examples("(sorted-set)", "(sorted-set nil)", "(sorted-set 1)", "(sorted-set 6 2 4)", "(str (sorted-set [2 3] [1 2]))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            return VncSortedSet.ofAll(args);
        }
    };
    public static VncFunction new_mutable_set = new VncFunction("mutable-set", (VncVal)VncFunction.meta().arglists("(mutable-set & items)").doc("Creates a new mutable set containing the items.").examples("(mutable-set)", "(mutable-set nil)", "(mutable-set 1)", "(mutable-set 1 2 3)", "(mutable-set [1 2] 3)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            return VncMutableSet.ofAll(args, Constants.Nil);
        }
    };
    public static VncFunction set_Q = new VncFunction("set?", (VncVal)VncFunction.meta().arglists("(set? obj)").doc("Returns true if obj is a set").examples("(set? (set 1))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            return VncBoolean.of(Types.isVncHashSet(args.first()));
        }
    };
    public static VncFunction sorted_set_Q = new VncFunction("sorted-set?", (VncVal)VncFunction.meta().arglists("(sorted-set? obj)").doc("Returns true if obj is a sorted-set").examples("(sorted-set? (sorted-set 1))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            return VncBoolean.of(Types.isVncSortedSet(args.first()));
        }
    };
    public static VncFunction mutable_set_Q = new VncFunction("mutable-set?", (VncVal)VncFunction.meta().arglists("(mutable-set? obj)").doc("Returns true if obj is a mutable-set").examples("(mutable-set? (mutable-set 1))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            return VncBoolean.of(Types.isVncMutableSet(args.first()));
        }
    };
    public static VncFunction distinct_Q = new VncFunction("distinct?", (VncVal)VncFunction.meta().arglists("(distinct? x) (distinct? x y) (distinct? x y & more)").doc("Returns true if no two of the arguments are equal").examples("(distinct? 1 2 3)", "(distinct? 1 2 3 3)", "(distinct? 1 2 3 1)").seeAlso("distinct").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertMinArity(this, args, 1);
            VncList vals = args;
            HashSet<VncVal> visited = new HashSet<VncVal>();
            while (!vals.isEmpty()) {
                VncVal v = vals.first();
                vals = vals.rest();
                if (visited.contains(v)) {
                    return VncBoolean.False;
                }
                visited.add(v);
            }
            return VncBoolean.True;
        }
    };
    public static VncFunction difference = new VncFunction("difference", (VncVal)VncFunction.meta().arglists("(difference s1)", "(difference s1 s2)", "(difference s1 s2 & sets)").doc("Return a set that is the first set without elements of the remaining sets").examples("(difference (set 1 2 3))", "(difference (set 1 2) (set 2 3))", "(difference (set 1 2) (set 1) (set 1 4) (set 3))").seeAlso("union", "intersection", "cons", "conj", "disj").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertMinArity(this, args, 1);
            HashSet<VncVal> set = new HashSet<VncVal>(Coerce.toVncSet(args.first()).getJavaSet());
            for (int ii = 1; ii < args.size(); ++ii) {
                set.removeAll(Coerce.toVncSet(args.nth(ii)).getJavaSet());
            }
            return VncHashSet.ofAll(set);
        }
    };
    public static VncFunction union = new VncFunction("union", (VncVal)VncFunction.meta().arglists("(union s1)", "(union s1 s2)", "(union s1 s2 & sets)").doc("Return a set that is the union of the input sets").examples("(union (set 1 2 3))", "(union (set 1 2) (set 2 3))", "(union (set 1 2 3) (set 1 2) (set 1 4) (set 3))").seeAlso("difference", "intersection", "cons", "conj", "disj").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertMinArity(this, args, 1);
            HashSet<VncVal> set = new HashSet<VncVal>(Coerce.toVncSet(args.first()).getJavaSet());
            for (int ii = 1; ii < args.size(); ++ii) {
                set.addAll(Coerce.toVncSet(args.nth(ii)).getJavaSet());
            }
            return VncHashSet.ofAll(set);
        }
    };
    public static VncFunction intersection = new VncFunction("intersection", (VncVal)VncFunction.meta().arglists("(intersection s1)", "(intersection s1 s2)", "(intersection s1 s2 & sets)").doc("Return a set that is the intersection of the input sets").examples("(intersection (set 1))", "(intersection (set 1 2) (set 2 3))", "(intersection (set 1 2) (set 3 4))").seeAlso("union", "difference", "cons", "conj", "disj").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertMinArity(this, args, 1);
            HashSet intersection = new HashSet();
            Set<VncVal> first = Coerce.toVncSet(args.first()).getJavaSet();
            first.forEach(v -> {
                boolean intersect = true;
                for (int ii = 1; ii < args.size(); ++ii) {
                    if (Coerce.toVncSet(args.nth(ii)).getJavaSet().contains(v)) continue;
                    intersect = false;
                    break;
                }
                if (intersect) {
                    intersection.add(v);
                }
            });
            return VncHashSet.ofAll(intersection);
        }
    };
    public static VncFunction subset_Q = new VncFunction("subset?", (VncVal)VncFunction.meta().arglists("(subset? set1 set2)").doc("Return true if set1 is a subset of set2").examples("(subset? #{2 3} #{1 2 3 4})", "(subset? #{2 5} #{1 2 3 4})").seeAlso("set", "superset?", "union", "difference", "intersection").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2);
            VncSet set1 = Coerce.toVncSet(args.first());
            VncSet set2 = Coerce.toVncSet(args.second());
            return VncBoolean.of(set1.stream().allMatch(v -> set2.contains((VncVal)v)));
        }
    };
    public static VncFunction superset_Q = new VncFunction("superset?", (VncVal)VncFunction.meta().arglists("(superset? set1 set2)").doc("Return true if set1 is a superset of set2").examples("(superset? #{1 2 3 4} #{2 3} )", "(superset? #{1 2 3 4} #{2 5})").seeAlso("set", "subset?", "union", "difference", "intersection").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2);
            VncSet set1 = Coerce.toVncSet(args.first());
            VncSet set2 = Coerce.toVncSet(args.second());
            return VncBoolean.of(set2.stream().allMatch(v -> set1.contains((VncVal)v)));
        }
    };
    public static VncFunction juxt = new VncFunction("juxt", (VncVal)VncFunction.meta().arglists("(juxt f)", "(juxt f g)", "(juxt f g h)", "(juxt f g h & fs)").doc("Takes a set of functions and returns a fn that is the juxtaposition of those fns. The returned fn takes a variable number of args, and returns a vector containing the result of applying each fn to the args (left-to-right).\n\n`((juxt a b c) x) => [(a x) (b x) (c x)]`").examples("((juxt first last) '(1 2 3 4))", "(do                                                   \n  (defn index-by [coll key-fn]                        \n     (into {} (map (juxt key-fn identity) coll)))     \n                                                      \n  (index-by [{:id 1 :name \"foo\"}                    \n             {:id 2 :name \"bar\"}                    \n             {:id 3 :name \"baz\"}]                   \n            :id))                                       ").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertMinArity(this, args, 1);
            final ArrayList<IVncFunction> functions = new ArrayList<IVncFunction>();
            for (VncVal a : args) {
                IVncFunction fn = Coerce.toIVncFunction(a);
                fn.sandboxFunctionCallValidation();
                functions.add(fn);
            }
            return new VncFunction(76.createAnonymousFuncName("juxt:wrapped")){
                private static final long serialVersionUID = -1848883965231344442L;

                @Override
                public VncVal apply(VncList args) {
                    ArrayList values = new ArrayList();
                    functions.stream().forEach(f -> values.add(f.apply(args)));
                    return VncVector.ofList(values);
                }
            };
        }
    };
    public static VncFunction fnil = new VncFunction("fnil", (VncVal)VncFunction.meta().arglists("(fnil f x)", "(fnil f x y)", "(fnil f x y z)").doc("Takes a function f, and returns a function that calls f, replacing a nil first argument to f with the supplied value x. Higher arity versions can replace arguments in the second and third positions (y, z). Note that the function f can take any number of arguments, not just the one(s) being nil-patched.").examples(";; e.g.: change the `str/lower-case` handling of nil arguments by \n;; returning an empty string instead of nil.                      \n((fnil str/lower-case \"\") nil)                                  ", "((fnil + 10) nil)", "((fnil + 10) nil 1)", "((fnil + 10) nil 1 2)", "((fnil + 10) 20 1 2)", "((fnil + 10) nil 1 2 3 4)", "((fnil + 1000 100) nil nil)", "((fnil + 1000 100) 2000 nil 1)", "((fnil + 1000 100) nil 200 1 2)", "((fnil + 1000 100) nil nil 1 2 3 4)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2, 3, 4);
            final MeterRegistry meterRegistry = ThreadContext.getMeterRegistry();
            ArrayList<VncFunction> functions = new ArrayList<VncFunction>();
            final IVncFunction fn = Coerce.toIVncFunction(args.first());
            fn.sandboxFunctionCallValidation();
            if (args.size() == 2) {
                final VncVal x = args.second();
                functions.add(new VncFunction(77.createAnonymousFuncName("fnil:wrapped"), VncVector.of(new VncSymbol("&"), new VncString("args"))){
                    private static final long serialVersionUID = -1848883965231344442L;

                    @Override
                    public VncVal apply(VncList args) {
                        if (args.isEmpty()) {
                            throw new VncException("fnil: the passed fn function requires at least one arg");
                        }
                        VncVal a = args.first();
                        return VncFunction.applyWithMeter(fn, args.rest().addAtStart(a == Constants.Nil ? x : a), meterRegistry);
                    }
                });
            } else if (args.size() == 3) {
                final VncVal x = args.second();
                final VncVal y = args.third();
                functions.add(new VncFunction(77.createAnonymousFuncName("fnil:wrapped"), VncVector.of(new VncSymbol("&"), new VncString("args"))){
                    private static final long serialVersionUID = -1848883965231344442L;

                    @Override
                    public VncVal apply(VncList args) {
                        if (args.size() < 2) {
                            throw new VncException("fnil: the passed fn function requires at least two args");
                        }
                        VncVal a = args.first();
                        VncVal b = args.second();
                        return VncFunction.applyWithMeter(fn, args.rest().rest().addAtStart(b == Constants.Nil ? y : b).addAtStart(a == Constants.Nil ? x : a), meterRegistry);
                    }
                });
            } else if (args.size() == 4) {
                final VncVal x = args.second();
                final VncVal y = args.third();
                final VncVal z = args.fourth();
                functions.add(new VncFunction(77.createAnonymousFuncName("fnil:wrapped"), VncVector.of(new VncSymbol("&"), new VncString("args"))){
                    private static final long serialVersionUID = -1848883965231344442L;

                    @Override
                    public VncVal apply(VncList args) {
                        if (args.size() < 3) {
                            throw new VncException("fnil: the passed fn function requires at least three args");
                        }
                        VncVal a = args.first();
                        VncVal b = args.second();
                        VncVal c = args.third();
                        return VncFunction.applyWithMeter(fn, args.rest().rest().rest().addAtStart(c == Constants.Nil ? z : c).addAtStart(b == Constants.Nil ? y : b).addAtStart(a == Constants.Nil ? x : a), meterRegistry);
                    }
                });
            } else {
                return Constants.Nil;
            }
            return new VncMultiArityFunction(77.createAnonymousFuncName("fnil"), functions, false, Constants.Nil);
        }
    };
    public static VncFunction new_hash_map = new VncFunction("hash-map", (VncVal)VncFunction.meta().arglists("(hash-map & keyvals)", "(hash-map map)").doc("Creates a new hash map containing the items.").examples("(hash-map :a 1 :b 2)", "(hash-map (sorted-map :a 1 :b 2))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            if (args.size() == 1 && Types.isVncMap(args.first())) {
                VncMap map = (VncMap)args.first();
                return map instanceof VncHashMap ? map : new VncHashMap(map.getJavaMap());
            }
            if (args.size() == 1 && Types.isVncJavaObject(args.first())) {
                return ((VncJavaObject)args.first()).toVncMap();
            }
            return VncHashMap.ofAll(args);
        }
    };
    public static VncFunction new_ordered_map = new VncFunction("ordered-map", (VncVal)VncFunction.meta().arglists("(ordered-map & keyvals)", "(ordered-map map)").doc("Creates a new ordered map containing the items.").examples("(ordered-map :a 1 :b 2)", "(ordered-map (hash-map :a 1 :b 2))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            if (args.size() == 1 && Types.isVncMap(args.first())) {
                VncMap map = (VncMap)args.first();
                return map instanceof VncOrderedMap ? map : new VncOrderedMap(map.getJavaMap());
            }
            return VncOrderedMap.ofAll(args);
        }
    };
    public static VncFunction new_sorted_map = new VncFunction("sorted-map", (VncVal)VncFunction.meta().arglists("(sorted-map & keyvals)", "(sorted-map map)").doc("Creates a new sorted map containing the items.").examples("(sorted-map :a 1 :b 2)", "(sorted-map (hash-map :a 1 :b 2))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            if (args.size() == 1 && Types.isVncMap(args.first())) {
                VncMap map = (VncMap)args.first();
                return map instanceof VncSortedMap ? map : new VncSortedMap(map.getJavaMap());
            }
            return VncSortedMap.ofAll(args);
        }
    };
    public static VncFunction new_mutable_map = new VncFunction("mutable-map", (VncVal)VncFunction.meta().arglists("(mutable-map & keyvals)", "(mutable-map map)").doc("Creates a new mutable threadsafe map containing the items.").examples("(mutable-map :a 1 :b 2)", "(mutable-map {:a 1 :b 2})").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            return args.size() == 1 && Types.isVncMap(args.first()) ? new VncMutableMap(((VncMap)args.first()).getJavaMap()) : VncMutableMap.ofAll(args);
        }
    };
    public static VncFunction new_stack = new VncFunction("stack", (VncVal)VncFunction.meta().arglists("(stack)").doc("Creates a new mutable threadsafe stack.").examples("(let [s (stack)]   \n   (push! s 1)     \n   (push! s 2)     \n   (push! s 3))      ").seeAlso("peek", "pop!", "push!", "empty", "empty?", "count", "into!", "conj!", "stack?").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 0);
            return new VncStack();
        }
    };
    public static VncFunction new_queue = new VncFunction("queue", (VncVal)VncFunction.meta().arglists("(queue)", "(queue capacity)").doc("Creates a new mutable threadsafe bounded or unbounded queue.\n\nThe queue can be turned into a synchronous queue when using the functions `put!` and `take!`. `put!` waits until the value be added and `take! waits until a value is available from queue thus synchronizing the producer and consumer.").examples("; unbounded queue  \n(let [q (queue)]   \n  (offer! q 1)     \n  (offer! q 2)     \n  (offer! q 3)     \n  (poll! q)        \n  q)                ", "; bounded queue       \n(let [q (queue 10)]   \n  (offer! q 1000 1)   \n  (offer! q 1000 2)   \n  (offer! q 1000 3)   \n  (poll! q 1000)      \n  q)                   ", "; synchronous unbounded queue  \n(let [q (queue)]               \n  (put! q 1)                   \n  (put! q 2)                   \n  (put! q 3)                   \n  (take! q)                    \n  q)                            ", "; synchronous bounded queue  \n(let [q (queue 10)]          \n  (put! q 1)                 \n  (put! q 2)                 \n  (put! q 3)                 \n  (take! q)                  \n  q)                          ").seeAlso("peek", "put!", "take!", "offer!", "poll!", "empty", "empty?", "count", "queue?", "reduce", "transduce", "docoll", "into!", "conj!").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 0, 1);
            return args.isEmpty() ? new VncQueue() : new VncQueue(Coerce.toVncLong(args.first()).getIntValue());
        }
    };
    public static VncFunction new_delay_queue = new VncFunction("delay-queue", (VncVal)VncFunction.meta().arglists("(delay-queue)").doc("Creates a new delay queue.\n\nA delay-queue is an unbounded blocking queue of delayed elements, in which an element can only be taken when its delay has expired. The head of the queue is that delayed element whose delay expired furthest in the past. If no delay has expired there is no head and `poll!` will return nil. Unexpired elements cannot be removed using `take!` or `poll!`, they are otherwise treated as normal elements. For example, the `count` method returns the count of both expired and unexpired elements. This queue does not permit `nil` elements.\n\nExample rate limiter:\n\n```\n(do                                                                \n  (defprotocol RateLimiter (init [x]) (aquire [x]))                \n                                                                   \n  (deftype :rate-limiter [queue                :core/delay-queue   \n                          limit-for-period     :long               \n                          limit-refresh-period :long]              \n           RateLimiter                                             \n             (init [this]   (let [q (:queue this)                  \n                                  n (:limit-for-period this)]      \n                              (empty q)                            \n                              (repeatedly n #(put! q :token 0))    \n                              this))                               \n             (aquire [this] (let [q (:queue this)                  \n                                  p (:limit-refresh-period this)]  \n                              (take! q)                            \n                              (put! q :token p))))                 \n                                                                   \n  ;; create a limiter with a limit of 5 actions within a 2s period \n  (def limiter (init (rate-limiter. (delay-queue) 5 2000)))        \n                                                                   \n  ;; test the limiter                                              \n  (doseq [x (range 1 26)]                                          \n    (aquire limiter)                                               \n    (printf \"%s: run %2d%n\" (time/local-date-time) x)))          \n```").examples("(let [q (delay-queue)]  \n  (put! q 1 100)        \n  (put! q 1 200)        \n  (take! q))              ").seeAlso("peek", "put!", "take!", "poll!", "empty", "empty?", "count", "delay-queue?").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 0);
            return new VncDelayQueue(null);
        }
    };
    public static VncFunction new_map_entry = new VncFunction("map-entry", (VncVal)VncFunction.meta().arglists("(map-entry key val)").doc("Creates a new map entry").examples("(map-entry :a 1)", "(key (map-entry :a 1))", "(val (map-entry :a 1))", "(entries {:a 1 :b 2 :c 3})").seeAlso("map-entry?", "entries", "map", "key", "val").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2);
            return new VncMapEntry(args.first(), args.second());
        }
    };
    public static VncFunction map_Q = new VncFunction("map?", (VncVal)VncFunction.meta().arglists("(map? obj)").doc("Returns true if obj is a map").examples("(map? {:a 1 :b 2})").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            return VncBoolean.of(Types.isVncMap(args.first()));
        }
    };
    public static VncFunction hash_map_Q = new VncFunction("hash-map?", (VncVal)VncFunction.meta().arglists("(hash-map? obj)").doc("Returns true if obj is a hash map").examples("(hash-map? (hash-map :a 1 :b 2))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            return VncBoolean.of(Types.isVncHashMap(args.first()));
        }
    };
    public static VncFunction ordered_map_Q = new VncFunction("ordered-map?", (VncVal)VncFunction.meta().arglists("(ordered-map? obj)").doc("Returns true if obj is an ordered map").examples("(ordered-map? (ordered-map :a 1 :b 2))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            return VncBoolean.of(Types.isVncOrderedMap(args.first()));
        }
    };
    public static VncFunction sorted_map_Q = new VncFunction("sorted-map?", (VncVal)VncFunction.meta().arglists("(sorted-map? obj)").doc("Returns true if obj is a sorted map").examples("(sorted-map? (sorted-map :a 1 :b 2))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            return VncBoolean.of(Types.isVncSortedMap(args.first()));
        }
    };
    public static VncFunction mutable_map_Q = new VncFunction("mutable-map?", (VncVal)VncFunction.meta().arglists("(mutable-map? obj)").doc("Returns true if obj is a mutable map").examples("(mutable-map? (mutable-map :a 1 :b 2))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            return VncBoolean.of(Types.isVncMutableMap(args.first()));
        }
    };
    public static VncFunction map_entry_Q = new VncFunction("map-entry?", (VncVal)VncFunction.meta().arglists("(map-entry? m)").doc("Returns true if m is a map entry").examples("(map-entry? (map-entry :a 1))", "(map-entry? (first (entries {:a 1 :b 2})))").seeAlso("map-entry", "entries", "map").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            return VncBoolean.of(Types.isVncMapEntry(args.first()));
        }
    };
    public static VncFunction stack_Q = new VncFunction("stack?", (VncVal)VncFunction.meta().arglists("(stack? coll)").doc("Returns true if coll is a stack").examples("(stack? (stack))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            return VncBoolean.of(Types.isVncStack(args.first()));
        }
    };
    public static VncFunction queue_Q = new VncFunction("queue?", (VncVal)VncFunction.meta().arglists("(queue? coll)").doc("Returns true if coll is a queue").examples("(queue? (queue))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            return VncBoolean.of(Types.isVncQueue(args.first()));
        }
    };
    public static VncFunction delay_queue_Q = new VncFunction("delay-queue?", (VncVal)VncFunction.meta().arglists("(delay-queue? coll)").doc("Returns true if coll is a delay-queue").examples("(delay-queue? (delay-queue))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            return VncBoolean.of(Types.isVncDelayQueue(args.first()));
        }
    };
    public static VncFunction contains_Q = new VncFunction("contains?", (VncVal)VncFunction.meta().arglists("(contains? coll key)").doc("Returns true if key is present in the given collection, otherwise returns false.").examples("(contains? #{:a :b} :a)", "(contains? {:a 1 :b 2} :a)", "(contains? [10 11 12] 1)", "(contains? [10 11 12] 5)", "(contains? \"abc\" 1)", "(contains? \"abc\" 5)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2);
            VncVal coll = args.first();
            VncVal key = args.second();
            if (Types.isVncMap(coll)) {
                return ((VncMap)coll).containsKey(key);
            }
            if (Types.isVncVector(coll)) {
                VncVector v = (VncVector)coll;
                VncLong k = (VncLong)key;
                return VncBoolean.of(v.size() > k.getValue().intValue());
            }
            if (Types.isVncSet(coll)) {
                return VncBoolean.of(((VncSet)coll).contains(key));
            }
            if (Types.isVncString(coll)) {
                VncString s = (VncString)coll;
                VncLong k = (VncLong)key;
                return VncBoolean.of(s.getValue().length() > k.getValue().intValue());
            }
            throw new VncException(String.format("Function 'contains?' does not allow %s as coll", Types.getType(coll)));
        }
    };
    public static VncFunction not_contains_Q = new VncFunction("not-contains?", (VncVal)VncFunction.meta().arglists("(not-contains? coll key)").doc("Returns true if key is not present in the given collection, otherwise returns false.").examples("(not-contains? #{:a :b} :c)", "(not-contains? {:a 1 :b 2} :c)", "(not-contains? [10 11 12] 1)", "(not-contains? [10 11 12] 5)", "(not-contains? \"abc\" 1)", "(not-contains? \"abc\" 5)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2);
            return VncBoolean.of(VncBoolean.isFalse(contains_Q.apply(args)));
        }
    };
    public static VncFunction assoc = new VncFunction("assoc", (VncVal)VncFunction.meta().arglists("(assoc coll key val)", "(assoc coll key val & kvs)").doc("When applied to a map, returns a new map of the same type, that contains the mapping of key(s) to val(s). When applied to a vector, returns a new vector that contains val at index. Note - index must be <= (count vector). When applied to a custom type, returns a new custom type with passed fields changed.").examples("(assoc {} :a 1 :b 2)", "(assoc nil :a 1 :b 2)", "(assoc [1 2 3] 0 10)", "(assoc [1 2 3] 3 10)", "(assoc [1 2 3] 6 10)", "(do                                                 \n  (deftype :complex [real :long, imaginary :long])  \n  (def x (complex. 100 200))                        \n  (def y (assoc x :real 110))                       \n  (pr-str y))                                         ").seeAlso("dissoc", "update").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            VncVal coll = args.first();
            if (coll == Constants.Nil) {
                return new VncHashMap().assoc(args.rest());
            }
            if (Types.isVncMutableMap(coll)) {
                throw new VncException("Function 'assoc' can not be used with mutable maps use assoc!");
            }
            if (Types.isVncMutableVector(coll) || Types.isVncMutableList(coll)) {
                throw new VncException("Function 'assoc' can not be used with mutable vectors use assoc!");
            }
            if (Types.isVncCustomType(coll)) {
                return ((VncCustomType)coll).assoc(args.rest());
            }
            if (Types.isVncMap(coll)) {
                return ((VncMap)coll).assoc(args.rest());
            }
            if (Types.isVncVector(coll) || Types.isVncList(coll)) {
                VncSequence seq = (VncSequence)coll;
                VncList keyvals = args.rest();
                for (int ii = 0; ii < keyvals.size(); ii += 2) {
                    VncLong key = Coerce.toVncLong(keyvals.nth(ii));
                    VncVal val = keyvals.nth(ii + 1);
                    seq = seq.size() > key.getValue().intValue() ? seq.setAt(key.getValue().intValue(), val) : seq.addAtEnd(val);
                }
                return seq;
            }
            if (Types.isVncString(coll)) {
                String s = ((VncString)coll).getValue();
                VncList keyvals = args.rest();
                for (int ii = 0; ii < keyvals.size(); ii += 2) {
                    VncLong key = Coerce.toVncLong(keyvals.nth(ii));
                    VncString val = Coerce.toVncString(keyvals.nth(ii + 1));
                    int idx = key.getValue().intValue();
                    if (s.length() > idx) {
                        if (idx == 0) {
                            s = "" + val.getValue().charAt(0) + s.substring(1);
                            continue;
                        }
                        if (idx == s.length() - 1) {
                            s = s.substring(0, idx) + val.getValue().charAt(0);
                            continue;
                        }
                        s = s.substring(0, idx) + val.getValue().charAt(0) + s.substring(idx + 1);
                        continue;
                    }
                    s = s + val.getValue().charAt(0);
                }
                return new VncString(s);
            }
            throw new VncException(String.format("Function 'assoc' does not allow %s as collection", Types.getType(coll)));
        }
    };
    public static VncFunction assoc_BANG = new VncFunction("assoc!", (VncVal)VncFunction.meta().arglists("(assoc! coll key val)", "(assoc! coll key val & kvs)").doc("Associates key/vals with a mutable map, returns the map").examples("(assoc! nil :a 1 :b 2)", "(assoc! (mutable-map) :a 1 :b 2)", "(assoc! (mutable-vector 1 2 3) 0 10)", "(assoc! (mutable-vector 1 2 3) 3 10)", "(assoc! (mutable-vector 1 2 3) 6 10)").seeAlso("dissoc!", "update!").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            VncVal coll = args.first();
            if (coll == Constants.Nil) {
                return new VncMutableMap().assoc(args.rest());
            }
            if (Types.isVncMutableMap(coll) || Types.isVncJavaMap(coll)) {
                return ((VncMap)coll).assoc(args.rest());
            }
            if (Types.isVncMutableVector(coll) || Types.isVncMutableList(coll) || Types.isVncJavaList(coll)) {
                VncSequence seq = (VncSequence)coll;
                VncList keyvals = args.rest();
                for (int ii = 0; ii < keyvals.size(); ii += 2) {
                    VncLong key = Coerce.toVncLong(keyvals.nth(ii));
                    VncVal val = keyvals.nth(ii + 1);
                    seq = seq.size() > key.getValue().intValue() ? seq.setAt(key.getValue().intValue(), val) : seq.addAtEnd(val);
                }
                return seq;
            }
            if (Types.isVncThreadLocal(coll)) {
                VncThreadLocal th = (VncThreadLocal)coll;
                return th.assoc(args.rest());
            }
            throw new VncException(String.format("Function 'assoc!' does not allow %s as collection. It works with mutable maps only.", Types.getType(coll)));
        }
    };
    public static VncFunction assoc_in = new VncFunction("assoc-in", (VncVal)VncFunction.meta().arglists("(assoc-in m ks v)").doc("Associates a value in a nested associative structure, where ks is a sequence of keys and v is the new value and returns a new nested structure. If any levels do not exist, hash-maps or vectors will be created.").examples("(do                                               \n  (def users [ {:name \"James\" :age 26}          \n               {:name \"John\" :age 43}])         \n  (assoc-in users [1 :age] 44))                   ", "(do                                               \n  (def users [ {:name \"James\" :age 26}          \n               {:name \"John\" :age 43}])         \n  (assoc-in users [2] {:name \"Jack\" :age 19}))  ").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 3);
            VncVal coll = args.first();
            VncSequence keys = Coerce.toVncSequence(args.second());
            VncVal val = args.third();
            VncVal key = keys.first();
            VncSequence keyRest = keys.rest();
            if (keyRest.isEmpty()) {
                return assoc.applyOf(coll, key, val);
            }
            VncVal childColl = get.applyOf(coll, key);
            if (childColl == Constants.Nil || childColl instanceof VncSequence || childColl instanceof VncMap) {
                return assoc.applyOf(coll, key, assoc_in.applyOf(childColl, keyRest, val));
            }
            return assoc.applyOf(coll, key, assoc_in.applyOf(VncHashMap.empty(), keyRest, val));
        }
    };
    public static VncFunction dissoc_in = new VncFunction("dissoc-in", (VncVal)VncFunction.meta().arglists("(dissoc-in m ks)").doc("Dissociates an entrye in a nested associative structure, where ks is a sequence of keys and returns a new nested structure.").examples("(do                                               \n  (def users [ {:name \"James\" :age 26}          \n               {:name \"John\" :age 43} ])        \n  (dissoc-in users [1]))                            ", "(do                                               \n  (def users [ {:name \"James\" :age 26}          \n               {:name \"John\" :age 43} ])        \n  (dissoc-in users [1 :age]))                       ").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2);
            VncVal coll = args.first();
            VncSequence keys = Coerce.toVncSequence(args.second());
            if (keys.size() == 0) {
                return coll;
            }
            if (keys.size() == 1) {
                return dissoc.applyOf(coll, keys.first());
            }
            return update_in.applyOf(coll, keys.butlast(), dissoc, keys.last());
        }
    };
    public static VncFunction update_in = new VncFunction("update-in", (VncVal)VncFunction.meta().arglists("(update-in [m ks f & fargs])").doc("Updates' a value in a nested associative structure, where ks is a sequence of keys and f is a function that will take the old value and any supplied fargs and return the new value, and returns a new nested structure. \n\nIf any levels do not exist, hash-maps will be reated.").examples("(do                                               \n  (def users [ {:name \"James\" :age 26}          \n               {:name \"John\" :age 43} ])        \n  (update-in users [1 :age] inc))                   ", "(update-in {:a 12} [:a] * 4)", "(update-in {:a 12} [:a] + 3 4)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertMinArity(this, args, 3);
            VncFunction up = new VncFunction("up", this.getMeta()){
                private static final long serialVersionUID = -1L;

                @Override
                public VncVal apply(VncList args) {
                    VncVal m_ = args.first();
                    VncVal k_ = Coerce.toVncSequence(args.second()).first();
                    VncSequence ks_ = Coerce.toVncSequence(args.second()).rest();
                    VncFunction f_ = Coerce.toVncFunction(args.third());
                    VncList args_ = args.slice(3);
                    f_.sandboxFunctionCallValidation();
                    if (!ks_.isEmpty()) {
                        return assoc.applyOf(m_, k_, apply.applyOf(this, get.applyOf(m_, k_), ks_, f_, args_));
                    }
                    return assoc.applyOf(m_, k_, apply.applyOf(f_, get.applyOf(m_, k_), args_));
                }
            };
            return up.apply(args);
        }
    };
    public static VncFunction get_in = new VncFunction("get-in", (VncVal)VncFunction.meta().arglists("(get-in m ks)", "(get-in m ks not-found)").doc("Returns the value in a nested associative structure, where ks is a sequence of keys. Returns nil if the key is not present, or the not-found value if supplied.").examples("(get-in {:a 1 :b {:c 2 :d 3}} [:b :c])", "(get-in [:a :b :c] [0])", "(get-in [:a :b [:c :d :e]] [2 1])", "(get-in {:a 1 :b {:c [4 5 6]}} [:b :c 1])").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            VncConstant key_not_found;
            ArityExceptions.assertArity(this, args, 2, 3);
            VncCollection coll = Coerce.toVncCollection(args.first());
            VncSequence keys = Coerce.toVncSequence(args.second());
            VncVal vncVal = key_not_found = args.size() == 3 ? args.nth(2) : Constants.Nil;
            while (!keys.isEmpty()) {
                VncVal key = keys.first();
                keys = keys.rest();
                if (Types.isVncMap(coll)) {
                    VncVal val = ((VncMap)coll).get(key);
                    if (val == Constants.Nil) {
                        return key_not_found;
                    }
                    if (keys.isEmpty()) {
                        return val;
                    }
                    if (Types.isVncCollection(val)) {
                        coll = (VncCollection)val;
                        continue;
                    }
                    return key_not_found;
                }
                if (Types.isVncLong(key)) {
                    int index = ((VncLong)key).getValue().intValue();
                    VncVal val = ((VncSequence)coll).nthOrDefault(index, Constants.Nil);
                    if (val == Constants.Nil) {
                        return key_not_found;
                    }
                    if (keys.isEmpty()) {
                        return val;
                    }
                    if (Types.isVncCollection(val)) {
                        coll = (VncCollection)val;
                        continue;
                    }
                    return key_not_found;
                }
                return key_not_found;
            }
            return key_not_found;
        }
    };
    public static VncFunction dissoc = new VncFunction("dissoc", (VncVal)VncFunction.meta().arglists("(dissoc coll key)", "(dissoc coll key & ks)").doc("Returns a new coll of the same type, that does not contain a mapping for key(s)").examples("(dissoc {:a 1 :b 2 :c 3} :b)", "(dissoc {:a 1 :b 2 :c 3} :c :b)", "(dissoc [1 2 3] 0)", "(do                                                 \n  (deftype :complex [real :long, imaginary :long])  \n  (def x (complex. 100 200))                        \n  (def y (dissoc x :real))                          \n  (pr-str y))                                         ").seeAlso("assoc", "update").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            VncVal coll = args.first();
            if (coll == Constants.Nil) {
                return Constants.Nil;
            }
            if (Types.isVncMutableMap(coll)) {
                throw new VncException("Function 'dissoc' can not be used with mutable maps use dissoc!");
            }
            if (Types.isVncMap(coll)) {
                return ((VncMap)args.first()).dissoc(args.rest());
            }
            if (Types.isVncVector(coll)) {
                VncVector vec = (VncVector)coll;
                VncList keyvals = args.rest();
                for (int ii = 0; ii < keyvals.size(); ++ii) {
                    VncLong key = Coerce.toVncLong(keyvals.nth(ii));
                    if (vec.size() <= key.getValue().intValue()) continue;
                    vec = vec.removeAt(key.getValue().intValue());
                }
                return vec;
            }
            if (Types.isVncString(coll)) {
                String s = ((VncString)coll).getValue();
                VncList keyvals = args.rest();
                for (int ii = 0; ii < keyvals.size(); ++ii) {
                    VncLong key = Coerce.toVncLong(keyvals.nth(ii));
                    int idx = key.getValue().intValue();
                    if (s.length() <= idx) continue;
                    s = idx == 0 ? s.substring(1) : (idx == s.length() - 1 ? s.substring(0, idx) : s.substring(0, idx) + s.substring(idx + 1));
                }
                return new VncString(s);
            }
            throw new VncException(String.format("Function 'dissoc' does not allow %s as coll", Types.getType(coll)));
        }
    };
    public static VncFunction dissoc_BANG = new VncFunction("dissoc!", (VncVal)VncFunction.meta().arglists("(dissoc! coll key)", "(dissoc! coll key & ks)").doc("Dissociates keys from a mutable map, returns the map").examples("(dissoc! (mutable-map :a 1 :b 2 :c 3) :b)", "(dissoc! (mutable-map :a 1 :b 2 :c 3) :c :b)", "(dissoc! (mutable-vector 1 2 3) 0)").seeAlso("assoc!", "update!").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            VncVal coll = args.first();
            if (coll == Constants.Nil) {
                return Constants.Nil;
            }
            if (Types.isVncMutableMap(coll)) {
                return ((VncMap)coll).dissoc(args.rest());
            }
            if (Types.isVncMutableVector(coll) || Types.isVncMutableList(coll) || Types.isVncJavaList(coll)) {
                VncSequence seq = (VncSequence)coll;
                VncList keyvals = args.rest();
                for (int ii = 0; ii < keyvals.size(); ++ii) {
                    VncLong key = Coerce.toVncLong(keyvals.nth(ii));
                    if (seq.size() <= key.getValue().intValue()) continue;
                    seq = seq.removeAt(key.getValue().intValue());
                }
                return seq;
            }
            if (Types.isVncThreadLocal(coll)) {
                VncThreadLocal th = (VncThreadLocal)coll;
                return th.dissoc(args.rest());
            }
            throw new VncException(String.format("Function 'dissoc!' does not allow %s as coll. It works with mutable maps and vectors only.", Types.getType(coll)));
        }
    };
    public static VncFunction get = new VncFunction("get", (VncVal)VncFunction.meta().arglists("(get map key)", "(get map key not-found)").doc("Returns the value mapped to key, not-found or nil if key not present.\n\nNote: `(get :x foo)` is almost twice as fast as `(:x foo)`").examples("(get {:a 1 :b 2} :b)", ";; keywords act like functions on maps \n(:b {:a 1 :b 2})").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2, 3);
            VncVal coll = args.first();
            if (coll == Constants.Nil) {
                VncVal key_not_found = args.size() == 3 ? args.third() : Constants.Nil;
                return key_not_found;
            }
            if (Types.isVncMap(coll)) {
                VncMap map = (VncMap)coll;
                VncVal key = args.second();
                VncVal value = map.get(key);
                return value != Constants.Nil ? value : (args.size() == 3 ? args.third() : Constants.Nil);
            }
            if (Types.isVncVector(coll)) {
                VncVector vec = (VncVector)coll;
                int idx = Coerce.toVncLong(args.second()).getIntValue();
                VncVal key_not_found = args.size() == 3 ? args.third() : Constants.Nil;
                return vec.nthOrDefault(idx, key_not_found);
            }
            if (Types.isVncThreadLocal(coll)) {
                VncThreadLocal th = (VncThreadLocal)coll;
                VncKeyword key = Coerce.toVncKeyword(args.second());
                VncVal value = th.get(key);
                return value != Constants.Nil ? value : (args.size() == 3 ? args.third() : Constants.Nil);
            }
            if (Types.isVncSet(coll)) {
                VncSet set = (VncSet)coll;
                VncVal val = args.second();
                return set.contains(val) ? val : (args.size() == 3 ? args.third() : Constants.Nil);
            }
            throw new VncException(String.format("Function 'get' does not allow %s as collection", Types.getType(coll)));
        }
    };
    public static VncFunction find = new VncFunction("find", (VncVal)VncFunction.meta().arglists("(find map key)").doc("Returns the map entry for key, or nil if key not present.").examples("(find {:a 1 :b 2} :b)", "(find {:a 1 :b 2} :z)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            VncVal key;
            ArityExceptions.assertArity(this, args, 2);
            if (args.first() == Constants.Nil) {
                return Constants.Nil;
            }
            VncMap mhm = Coerce.toVncMap(args.first());
            VncVal value = mhm.get(key = args.second());
            return value == Constants.Nil ? Constants.Nil : VncVector.of(key, value);
        }
    };
    public static VncFunction key = new VncFunction("key", (VncVal)VncFunction.meta().arglists("(key e)").doc("Returns the key of the map entry.").examples("(key (find {:a 1 :b 2} :b))", "(key (first (entries {:a 1 :b 2 :c 3})))").seeAlso("map", "entries", "val", "keys").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            VncVal first = args.first();
            if (Types.isVncMapEntry(first)) {
                return ((VncMapEntry)first).getKey();
            }
            return Coerce.toVncSequence(first).first();
        }
    };
    public static VncFunction keys = new VncFunction("keys", (VncVal)VncFunction.meta().arglists("(keys map)").doc("Returns a collection of the map's keys.\n\nPlease note that the functions 'keys' and 'vals' applied to the same map are not guaranteed not return the keys and vals in the same order! \n\nTo achieve this, keys and vals can calculated based on the map's entry list: \n\n```venice\n(let [e (entries {:a 1 :b 2 :c 3})]\n  (println (map key e))\n  (println (map val e)))\n```").examples("(keys {:a 1 :b 2 :c 3})").seeAlso("vals", "entries", "map").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            return Coerce.toVncMap(args.first()).keys();
        }
    };
    public static VncFunction val = new VncFunction("val", (VncVal)VncFunction.meta().arglists("(val e)").doc("Returns the val of the map entry.").examples("(val (find {:a 1 :b 2} :b))", "(val (first (entries {:a 1 :b 2 :c 3})))").seeAlso("map", "entries", "key", "vals").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            VncVal first = args.first();
            if (Types.isVncMapEntry(first)) {
                return ((VncMapEntry)first).getValue();
            }
            return Coerce.toVncSequence(first).second();
        }
    };
    public static VncFunction vals = new VncFunction("vals", (VncVal)VncFunction.meta().arglists("(vals map)").doc("Returns a collection of the map's values.\n\nPlease note that the functions 'keys' and 'vals' applied to the same map are not guaranteed not return the keys and vals in the same order! \n\nTo achieve this, keys and vals can calculated based on the map's entry list: \n\n```venice\n(let [e (entries {:a 1 :b 2 :c 3})]\n  (println (map key e))\n  (println (map val e)))\n```").examples("(vals {:a 1 :b 2 :c 3})").seeAlso("keys", "entries", "map").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            VncMap mhm = Coerce.toVncMap(args.first());
            return VncList.ofColl(mhm.getJavaMap().values());
        }
    };
    public static VncFunction select_keys = new VncFunction("select-keys", (VncVal)VncFunction.meta().arglists("(select-keys map keyseq)").doc("Returns a map containing only those entries in map whose key is in keys").examples("(select-keys {:a 1 :b 2} [:a])", "(select-keys {:a 1 :b 2} [:a :c])", "(select-keys {:a 1 :b 2 :c 3} [:a :c])").seeAlso("keys", "entries", "map").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2);
            if (args.first() == Constants.Nil) {
                return new VncHashMap();
            }
            VncMap map = Coerce.toVncMap(args.first());
            if (args.second() == Constants.Nil) {
                return map.emptyWithMeta();
            }
            VncSequence keyseq = Coerce.toVncSequence(args.second());
            VncMap newMap = map.emptyWithMeta();
            for (VncVal k : keyseq.getJavaList()) {
                if (!VncBoolean.isTrue(map.containsKey(k))) continue;
                newMap = newMap.assoc(k, map.get(k));
            }
            return newMap;
        }
    };
    public static VncFunction entries = new VncFunction("entries", (VncVal)VncFunction.meta().arglists("(entries m)").doc("Returns a collection of the map's entries.").examples("(entries {:a 1 :b 2 :c 3})", "(let [e (entries {:a 1 :b 2 :c 3})]\n  (println (map key e))\n  (println (map val e)))", ";; compare to 'into' \n(let [e (into [] {:a 1 :b 2 :c 3})]\n  (println (map first e))\n  (println (map second e)))").seeAlso("map", "key", "val", "keys", "vals", "map-entry").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            VncMap mhm = Coerce.toVncMap(args.first());
            return VncList.ofList(mhm.entries());
        }
    };
    public static VncFunction update = new VncFunction("update", (VncVal)VncFunction.meta().arglists("(update m k f)", "(update m k f & fargs)").doc("Updates a value in an associative structure, where k is a key and f is a function that will take the old value and any supplied fargs and return the new value. Returns a new structure. \n\nIf the key does not exist, `nil` is passed as the old value. The optional fargs are passed to the function f as `(f old-value (f old-value arg1 arg2 ...) ...)`.").examples("(update [] 0 (fn [x] 5))", "(update [0 1 2] 0 (fn [x] 5))", "(update [0 1 2] 1 (fn [x] (+ x 3)))", "(update {} :a (fn [x] 5))", "(update {:a 0} :b (fn [x] 5))", "(update {:a 0 :b 1} :a (fn [x] (+ x 5)))", "(update [0 1 2] 1 + 3)", "(update {:a 0 :b 1} :b * 4)").seeAlso("assoc", "dissoc").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertMinArity(this, args, 3);
            MeterRegistry meterRegistry = ThreadContext.getMeterRegistry();
            VncVal m = args.first();
            VncVal k = args.second();
            VncVal f = args.third();
            VncList supplementalArgs = args.slice(3);
            IVncFunction fn = Coerce.toIVncFunction(f);
            fn.sandboxFunctionCallValidation();
            if (Types.isVncSequence(m)) {
                VncSequence list = (VncSequence)m;
                int idx = Coerce.toVncLong(k).getValue().intValue();
                if (idx < 0 || idx > list.size()) {
                    throw new VncException(String.format("Function 'update' index %d out of bounds", idx));
                }
                if (idx < list.size()) {
                    VncList fnArgs = VncList.of(list.nth(idx)).addAllAtEnd(supplementalArgs);
                    return list.setAt(idx, VncFunction.applyWithMeter(fn, fnArgs, meterRegistry));
                }
                VncList fnArgs = VncList.of(Constants.Nil).addAllAtEnd(supplementalArgs);
                return list.addAtEnd(VncFunction.applyWithMeter(fn, fnArgs, meterRegistry));
            }
            if (Types.isVncMap(m)) {
                VncMap map = (VncMap)m;
                VncList fnArgs = VncList.of(map.get(k)).addAllAtEnd(supplementalArgs);
                return map.assoc(k, VncFunction.applyWithMeter(fn, fnArgs, meterRegistry));
            }
            throw new VncException(String.format("'update' does not allow %s as associative structure", Types.getType(args.first())));
        }
    };
    public static VncFunction update_BANG = new VncFunction("update!", (VncVal)VncFunction.meta().arglists("(update! m k f & fargs)").doc("Updates a value in a mutable associative structure, where k is a key and f is a function that will take the old value and any supplied fargs and return the new value. Returns a new structure. \n\nIf the key does not exist, `nil` is passed as the old value. The optional fargs are passed to the function f as `(f old-value arg1 arg2 ...)`.").examples("(update! (mutable-vector) 0 (fn [x] 5))", "(update! (mutable-vector 0 1 2) 0 (fn [x] 5))", "(update! (mutable-vector 0 1 2) 0 (fn [x] (+ x 1)))", "(update! (mutable-map) :a (fn [x] 5))", "(update! (mutable-map :a 0) :b (fn [x] 5))", "(update! (mutable-map :a 0 :b 1) :a (fn [x] 5))", "(update! (mutable-vector 0 1 2) 0 + 4)", "(update! (mutable-map :a 0 :b 1) :b * 4)").seeAlso("assoc!", "dissoc!").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertMinArity(this, args, 3);
            MeterRegistry meterRegistry = ThreadContext.getMeterRegistry();
            VncVal m = args.first();
            VncVal k = args.second();
            VncVal f = args.third();
            VncList supplementalArgs = args.slice(3);
            IVncFunction fn = Coerce.toIVncFunction(f);
            fn.sandboxFunctionCallValidation();
            if (Types.isVncMutableMap(m)) {
                VncMutableMap map = (VncMutableMap)m;
                VncList fnArgs = VncList.of(map.get(k)).addAllAtEnd(supplementalArgs);
                return map.assoc(k, VncFunction.applyWithMeter(fn, fnArgs, meterRegistry));
            }
            if (Types.isVncMutableVector(m) || Types.isVncMutableList(m) || Types.isVncJavaList(m)) {
                VncSequence seq = (VncSequence)m;
                int idx = Coerce.toVncLong(args.second()).getValue().intValue();
                if (idx < 0 || idx > seq.size()) {
                    throw new VncException(String.format("Function 'update' index %d out of bounds", idx));
                }
                if (idx < seq.size()) {
                    VncList fnArgs = VncList.of(seq.nth(idx)).addAllAtEnd(supplementalArgs);
                    return seq.setAt(idx, VncFunction.applyWithMeter(fn, fnArgs, meterRegistry));
                }
                VncList fnArgs = VncList.of(Constants.Nil).addAllAtEnd(supplementalArgs);
                return seq.addAtEnd(VncFunction.applyWithMeter(fn, fnArgs, meterRegistry));
            }
            throw new VncException(String.format("'update!' does not allow %s as map. It works with mutable maps only.", Types.getType(args.first())));
        }
    };
    public static VncFunction split_at = new VncFunction("split-at", (VncVal)VncFunction.meta().arglists("(split-at n coll)").doc("Returns a vector of [(take n coll) (drop n coll)]").examples("(split-at 2 [1 2 3 4 5])", "(split-at 3 [1 2])").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2);
            if (args.second() == Constants.Nil) {
                return VncVector.of(VncList.empty(), VncList.empty());
            }
            VncSequence seq = Coerce.toVncSequence(args.second());
            int n = Math.min(seq.size(), Math.max(0, Coerce.toVncLong(args.first()).getValue().intValue()));
            return VncVector.of(seq.slice(0, n).toVncList(), seq.slice(n).toVncList());
        }
    };
    public static VncFunction split_with = new VncFunction("split-with", (VncVal)VncFunction.meta().arglists("(split-with pred coll)").doc("Splits the collection at the first false/nil predicate result in a vector with two lists").examples("(split-with odd? [1 3 5 6 7 9])", "(split-with odd? [1 3 5])", "(split-with odd? [2 4 6])").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2);
            if (args.second() == Constants.Nil) {
                return VncVector.of(VncList.empty(), VncList.empty());
            }
            IVncFunction pred = Coerce.toIVncFunction(args.first());
            VncSequence coll = Coerce.toVncSequence(args.second());
            pred.sandboxFunctionCallValidation();
            int splitPos = coll.size();
            int pos = 0;
            for (VncVal v : coll) {
                VncVal match = pred.apply(VncList.of(v));
                if (VncBoolean.isFalse(match) || match == Constants.Nil) {
                    splitPos = pos;
                    break;
                }
                ++pos;
            }
            if (splitPos == 0) {
                return VncVector.of(VncList.empty(), coll.toVncList());
            }
            if (splitPos < coll.size()) {
                return VncVector.of(coll.slice(0, splitPos).toVncList(), coll.slice(splitPos).toVncList());
            }
            return VncVector.of(coll.toVncList(), VncList.empty());
        }
    };
    public static VncFunction into = new VncFunction("into", (VncVal)VncFunction.meta().arglists("(into)", "(into to)", "(into to from)").doc("Returns a new coll consisting of to coll with all of the items of from coll conjoined.").examples("(into (sorted-map) [ [:a 1] [:c 3] [:b 2] ])", "(into (sorted-map) [ {:a 1} {:c 3} {:b 2} ])", "(into (sorted-map) [(map-entry :b 2) (map-entry :c 3) (map-entry :a 1)])", "(into (sorted-map) {:b 2 :c 3 :a 1})", "(into [] {:a 1, :b 2})", "(into '() '(1 2 3))", "(into [1 2 3] '(4 5 6))", "(into '() (bytebuf [0 1 2]))", "(into [] (bytebuf [0 1 2]))", "(into '() \"abc\")", "(into [] \"abc\")").seeAlso("concat", "merge").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 0, 1, 2);
            if (args.size() == 0) {
                return VncList.empty();
            }
            if (args.size() == 1) {
                return args.first();
            }
            if (args.second() == Constants.Nil) {
                return args.first();
            }
            VncCollection to = Coerce.toVncCollection(args.first());
            if (to instanceof VncMutable) {
                throw new VncException(String.format("Function 'into' does not allow the mutable collection %s as to-coll. Please use 'into!' instead!", Types.getType(args.first())));
            }
            if (Types.isVncByteBuffer(args.second())) {
                VncList byteList = ((VncByteBuffer)args.second()).toVncList();
                if (Types.isVncSequence(to)) {
                    return ((VncSequence)to).addAllAtEnd(byteList);
                }
                throw new VncException(String.format("Function 'into' does only allow list and vector as to-coll if from-coll is a bytebuf", new Object[0]));
            }
            if (Types.isVncString(args.second())) {
                VncList charList = ((VncString)args.second()).toVncList();
                if (Types.isVncSequence(to)) {
                    return ((VncSequence)to).addAllAtEnd(charList);
                }
                if (Types.isVncSet(to)) {
                    return ((VncSet)to).addAll(charList);
                }
                throw new VncException(String.format("Function 'into' does only allow list, vector, and set as to-coll if from-coll is a string", new Object[0]));
            }
            VncCollection from = Coerce.toVncCollection(args.second());
            if (Types.isVncVector(to)) {
                return ((VncVector)to).addAllAtEnd(from.toVncList());
            }
            if (Types.isVncList(to)) {
                return ((VncList)to).addAllAtStart(from.toVncList(), true);
            }
            if (Types.isVncSet(to)) {
                return ((VncSet)to).addAll(from.toVncList());
            }
            if (Types.isVncMap(to)) {
                if (Types.isVncSequence(from)) {
                    VncMap toMap = (VncMap)to;
                    for (VncVal it : (VncSequence)from) {
                        if (Types.isVncSequence(it)) {
                            toMap = toMap.assoc(((VncSequence)it).toVncList());
                            continue;
                        }
                        if (Types.isVncMapEntry(it)) {
                            VncMapEntry entry = (VncMapEntry)it;
                            toMap = toMap.assoc(entry.getKey(), entry.getValue());
                            continue;
                        }
                        if (!Types.isVncMap(it)) continue;
                        toMap = toMap.putAll((VncMap)it);
                    }
                    return toMap;
                }
                if (Types.isVncMap(from)) {
                    return ((VncMap)to).putAll((VncMap)from);
                }
                throw new VncException(String.format("Function 'into' does not allow %s as from-coll into a map", Types.getType(from)));
            }
            throw new VncException(String.format("Function 'into' does not allow %s as to-coll", Types.getType(args.first())));
        }
    };
    public static VncFunction into_BANG = new VncFunction("into!", (VncVal)VncFunction.meta().arglists("(into!)", "(into! to)", "(into! to from)").doc("Adds all of the items of 'from' conjoined to the mutable 'to' collection").examples("(into! (queue) [1 2 3 4])", "(into! (stack) [1 2 3 4])", "(do\n   (into! (. :java.util.concurrent.CopyOnWriteArrayList :new)\n          (doto (. :java.util.ArrayList :new)\n                (. :add 3)\n                (. :add 4))))", "(do\n   (into! (. :java.util.concurrent.CopyOnWriteArrayList :new)\n          '(3 4)))").seeAlso("concat", "merge").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 0, 1, 2);
            if (args.size() == 0) {
                return VncList.empty();
            }
            if (args.size() == 1) {
                return args.first();
            }
            if (args.second() == Constants.Nil) {
                return args.first();
            }
            VncCollection to = Coerce.toVncCollection(args.first());
            if (!(to instanceof VncMutable)) {
                throw new VncException("Function 'into!' does not allow persistent collections as to-coll. Please use 'into' instead!");
            }
            if (Types.isVncByteBuffer(args.second())) {
                VncList byteList = ((VncByteBuffer)args.second()).toVncList();
                if (Types.isVncSequence(to)) {
                    return ((VncSequence)to).addAllAtEnd(byteList);
                }
                throw new VncException(String.format("Function 'into!' does only allow list and vector as to-coll if from-coll is a bytebuf", new Object[0]));
            }
            if (Types.isVncString(args.second())) {
                VncList charList = ((VncString)args.second()).toVncList();
                if (Types.isVncSequence(to)) {
                    return ((VncSequence)to).addAllAtEnd(charList);
                }
                if (Types.isVncSet(to)) {
                    return ((VncSet)to).addAll(charList);
                }
                throw new VncException(String.format("Function 'into!' does only allow list, vector, and set as to-coll if from-coll is a string", new Object[0]));
            }
            VncCollection from = Coerce.toVncCollection(args.second());
            if (Types.isVncMutableList(to)) {
                return ((VncMutableList)to).addAllAtStart(from.toVncList(), true);
            }
            if (Types.isVncMutableVector(to)) {
                return ((VncMutableVector)to).addAllAtEnd(from.toVncList());
            }
            if (Types.isVncQueue(to)) {
                if (Types.isVncSequence(from)) {
                    VncQueue queue = (VncQueue)to;
                    for (VncVal it : (VncSequence)from) {
                        queue.put(it);
                    }
                    return queue;
                }
                throw new VncException(String.format("Function 'into!' does not allow %s as from-coll into a queue", Types.getType(from)));
            }
            if (Types.isVncStack(to)) {
                if (Types.isVncSequence(from)) {
                    VncStack stack = (VncStack)to;
                    for (VncVal it : (VncSequence)from) {
                        stack.push(it);
                    }
                    return stack;
                }
                throw new VncException(String.format("Function 'into!' does not allow %s as from-coll into a queue", Types.getType(from)));
            }
            if (Types.isVncSet(to)) {
                return ((VncSet)to).addAll(from.toVncList());
            }
            if (Types.isVncMap(to)) {
                if (Types.isVncSequence(from)) {
                    VncMap toMap = (VncMap)to;
                    for (VncVal it : (VncSequence)from) {
                        if (Types.isVncSequence(it)) {
                            toMap = toMap.assoc(((VncSequence)it).toVncList());
                            continue;
                        }
                        if (Types.isVncMapEntry(it)) {
                            VncMapEntry entry = (VncMapEntry)it;
                            toMap = toMap.assoc(entry.getKey(), entry.getValue());
                            continue;
                        }
                        if (!Types.isVncMap(it)) continue;
                        toMap = toMap.putAll((VncMap)it);
                    }
                    return toMap;
                }
                if (Types.isVncMap(from)) {
                    return ((VncMap)to).putAll((VncMap)from);
                }
                throw new VncException(String.format("Function 'into!' does not allow %s as from-coll into a map", Types.getType(from)));
            }
            if (Types.isVncJavaList(to)) {
                if (Types.isVncJavaList(from)) {
                    List to_ = (List)((VncJavaList)to).getDelegate();
                    List from_ = (List)((VncJavaList)from).getDelegate();
                    to_.addAll(from_);
                    return to;
                }
                if (Types.isVncJavaSet(from)) {
                    List to_ = (List)((VncJavaList)to).getDelegate();
                    Set from_ = (Set)((VncJavaSet)from).getDelegate();
                    to_.addAll(from_);
                    return to;
                }
                return ((VncJavaList)to).addAllAtEnd(from.toVncList());
            }
            if (Types.isVncJavaSet(to)) {
                if (Types.isVncJavaSet(from)) {
                    Set to_ = (Set)((VncJavaSet)to).getDelegate();
                    Set from_ = (Set)((VncJavaSet)from).getDelegate();
                    to_.addAll(from_);
                    return to;
                }
                if (Types.isVncJavaList(from)) {
                    Set to_ = (Set)((VncJavaSet)to).getDelegate();
                    List from_ = (List)((VncJavaList)to).getDelegate();
                    to_.addAll(from_);
                    return to;
                }
                return ((VncJavaSet)to).addAll(from.toVncList());
            }
            throw new VncException(String.format("Function 'into!' does not allow %s as to-coll", Types.getType(args.first())));
        }
    };
    public static VncFunction sequential_Q = new VncFunction("sequential?", (VncVal)VncFunction.meta().arglists("(sequential? coll)").doc("Returns true if coll is a sequential collection").examples("(sequential? '(1))", "(sequential? [1])", "(sequential? {:a 1})", "(sequential? nil)", "(sequential? \"abc\")").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            return VncBoolean.of(Types.isVncSequence(args.first()));
        }
    };
    public static VncFunction coll_Q = new VncFunction("coll?", (VncVal)VncFunction.meta().arglists("(coll? coll)").doc("Returns true if coll is a collection").examples("(coll? {:a 1})", "(coll? [1 2])").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            return VncBoolean.of(Types.isVncCollection(args.first()));
        }
    };
    public static VncFunction every_Q = new VncFunction("every?", (VncVal)VncFunction.meta().arglists("(every? pred coll)").doc("Returns true if the predicate is true for all collection items, false otherwise.").examples("(every? number? nil)", "(every? number? [])", "(every? number? [1 2 3 4])", "(every? number? [1 2 3 :a])", "(every? #(>= % 10) [10 11 12])").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1, 2);
            if (args.second() == Constants.Nil) {
                return VncBoolean.False;
            }
            IVncFunction pred = Coerce.toIVncFunction(args.first());
            VncCollection coll = Coerce.toVncCollection(args.second());
            pred.sandboxFunctionCallValidation();
            if (coll.isEmpty()) {
                return VncBoolean.False;
            }
            return VncBoolean.of(coll.toVncList().stream().allMatch(v -> {
                VncVal r = pred.apply(VncList.of(v));
                return r != Constants.Nil && !VncBoolean.isFalse(r);
            }));
        }
    };
    public static VncFunction not_every_Q = new VncFunction("not-every?", (VncVal)VncFunction.meta().arglists("(not-every? pred coll)").doc("Returns false if the predicate is true for all collection items, true otherwise").examples("(not-every? number? nil)", "(not-every? number? [])", "(not-every? number? [1 2 3 4])", "(not-every? number? [1 2 3 :a])", "(not-every? #(>= % 10) [10 11 12])").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2);
            return VncBoolean.of(VncBoolean.isFalse(every_Q.apply(args)));
        }
    };
    public static VncFunction any_Q = new VncFunction("any?", (VncVal)VncFunction.meta().arglists("(any? pred coll)").doc("Returns true if the predicate is true for at least one collection item, false otherwise.").examples("(any? number? nil)", "(any? number? [])", "(any? number? [1 :a :b])", "(any? number? [1 2 3])", "(any? #(== % 10) [10 20 30])", "(any? #(>= % 10) [1 5 10])").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1, 2);
            if (args.second() == Constants.Nil) {
                return VncBoolean.False;
            }
            IVncFunction pred = Coerce.toIVncFunction(args.first());
            VncCollection coll = Coerce.toVncCollection(args.second());
            pred.sandboxFunctionCallValidation();
            if (coll.isEmpty()) {
                return VncBoolean.False;
            }
            return VncBoolean.of(coll.toVncList().stream().anyMatch(v -> {
                VncVal r = pred.apply(VncList.of(v));
                return r != Constants.Nil && !VncBoolean.isFalse(r);
            }));
        }
    };
    public static VncFunction not_any_Q = new VncFunction("not-any?", (VncVal)VncFunction.meta().arglists("(not-any? pred coll)").doc("Returns false if the predicate is true for at least one collection item, true otherwise").examples("(not-any? number? nil)", "(not-any? number? [])", "(not-any? number? [1 :a :b])", "(not-any? number? [1 2 3])", "(not-any? #(>= % 10) [1 5 10])").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2);
            return VncBoolean.of(VncBoolean.isFalse(any_Q.apply(args)));
        }
    };
    public static VncFunction some = new VncFunction("some", (VncVal)VncFunction.meta().arglists("(some pred coll)").doc("Returns the first logical true value of (pred x) for any x in coll, else nil. \n\nStops processing the collection if the first value is found that meets the predicate.").examples("(some even? '(1 2 3 4))", "(some even? '(1 3 5 7))", "(some #{5} [1 2 3 4 5])", "(some #(== 5 %) [1 2 3 4 5])", "(some #(if (even? %) %) [1 2 3 4])").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2);
            if (args.second() == Constants.Nil) {
                return Constants.Nil;
            }
            IVncFunction pred = Coerce.toIVncFunction(args.first());
            VncCollection coll = Coerce.toVncCollection(args.second());
            pred.sandboxFunctionCallValidation();
            if (coll.isEmpty()) {
                return Constants.Nil;
            }
            VncCollection items = coll instanceof VncSequence ? (VncSequence)coll : (coll instanceof VncSet ? (VncSet)coll : coll.toVncList());
            for (VncVal v : items) {
                VncVal r = pred.apply(VncList.of(v));
                if (VncBoolean.isFalse(r) || r == Constants.Nil) continue;
                return r;
            }
            return Constants.Nil;
        }
    };
    public static VncFunction every_pred = new VncFunction("every-pred", (VncVal)VncFunction.meta().arglists("(every-pred p1 & p)").doc("Takes a set of predicates and returns a function f that returns true if all of its composing predicates return a logical true value against all of its arguments, else it returns false. Note that f is short-circuiting in that it will stop execution on the first argument that triggers a logical false result against the original predicates.").examples("((every-pred number?) 1)", "((every-pred number?) 1 2)", "((every-pred number? even?) 2 4 6)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertMinArity(this, args, 1);
            final ArrayList predicates = new ArrayList();
            args.forEach((Consumer<? super VncVal>)((Consumer<VncVal>)p -> {
                VncFunction fn = Coerce.toVncFunction(p);
                fn.sandboxFunctionCallValidation();
                predicates.add(fn);
            }));
            return new VncFunction(126.createAnonymousFuncName("every-pred:wrapped")){
                private static final long serialVersionUID = -1L;

                @Override
                public VncVal apply(VncList args) {
                    for (VncVal arg : args) {
                        for (VncFunction pred : predicates) {
                            VncVal res = pred.apply(VncList.of(arg));
                            if (VncBoolean.isFalse(res)) {
                                return VncBoolean.False;
                            }
                            if (VncBoolean.isTrue(res)) continue;
                            throw new VncException(String.format("every-pred: The predicate function %s did not return a boolean value", pred.getQualifiedName()));
                        }
                    }
                    return VncBoolean.True;
                }
            };
        }
    };
    public static VncFunction any_pred = new VncFunction("any-pred", (VncVal)VncFunction.meta().arglists("(any-pred p1 & p)").doc("Takes a set of predicates and returns a function f that returns the first logical true value returned by one of its composing predicates against any of its arguments, else it returns logical false. Note that f is short-circuiting in that it will stop execution on the first argument that triggers a logical true result against the original predicates.").examples("((any-pred number?) 1)", "((any-pred number?) 1 \"a\")", "((any-pred number? string?) 2 \"a\")").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertMinArity(this, args, 1);
            final ArrayList predicates = new ArrayList();
            args.forEach((Consumer<? super VncVal>)((Consumer<VncVal>)p -> {
                VncFunction fn = Coerce.toVncFunction(p);
                fn.sandboxFunctionCallValidation();
                predicates.add(fn);
            }));
            return new VncFunction(127.createAnonymousFuncName("any-pred:wrapped")){
                private static final long serialVersionUID = -1L;

                @Override
                public VncVal apply(VncList args) {
                    for (VncVal arg : args) {
                        for (VncFunction pred : predicates) {
                            VncVal res = pred.apply(VncList.of(arg));
                            if (VncBoolean.isTrue(res)) {
                                return VncBoolean.True;
                            }
                            if (VncBoolean.isFalse(res)) continue;
                            throw new VncException(String.format("any-pred: The predicate function %s did not return a boolean value", pred.getQualifiedName()));
                        }
                    }
                    return VncBoolean.False;
                }
            };
        }
    };
    public static VncFunction count = new VncFunction("count", (VncVal)VncFunction.meta().arglists("(count coll)").doc("Returns the number of items in the collection. `(count nil)` returns 0. Also works on strings, and Java Collections").examples("(count {:a 1 :b 2})", "(count [1 2])", "(count \"abc\")").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            VncVal arg = args.first();
            if (arg == Constants.Nil) {
                return new VncLong(0L);
            }
            if (Types.isVncString(arg)) {
                return new VncLong(((VncString)arg).getValue().length());
            }
            if (Types.isVncByteBuffer(arg)) {
                return new VncLong(((VncByteBuffer)arg).size());
            }
            if (Types.isVncCollection(arg)) {
                return new VncLong(((VncCollection)arg).size());
            }
            throw new VncException(String.format("Invalid argument type %s while calling function 'count'", Types.getType(arg)));
        }
    };
    public static VncFunction empty = new VncFunction("empty", (VncVal)VncFunction.meta().arglists("(empty coll)").doc("Returns an empty collection of the same category as coll, or nil if coll is nil. If the collection is mutable clears the collection and returns the the emptied collection.").examples("(empty {:a 1})", "(empty [1 2])", "(empty '(1 2))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            VncVal coll = args.first();
            if (coll == Constants.Nil) {
                return Constants.Nil;
            }
            if (coll instanceof VncMutable) {
                ((VncMutable)((Object)coll)).clear();
                return coll;
            }
            if (Types.isVncCollection(coll)) {
                return ((VncCollection)coll).emptyWithMeta();
            }
            throw new VncException(String.format("Invalid argument type %s while calling function 'empty'", Types.getType(coll)));
        }
    };
    public static VncFunction empty_Q = new VncFunction("empty?", (VncVal)VncFunction.meta().arglists("(empty? x)").doc("Returns true if x is empty.  Accepts strings, collections and bytebufs.").examples("(empty? {})", "(empty? [])", "(empty? '())", "(empty? \"\")").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            VncVal val = args.first();
            if (val == Constants.Nil) {
                return VncBoolean.True;
            }
            if (Types.isVncString(val)) {
                return VncBoolean.of(((VncString)val).getValue().isEmpty());
            }
            if (Types.isVncCollection(val)) {
                return VncBoolean.of(((VncCollection)val).isEmpty());
            }
            if (Types.isVncByteBuffer(val)) {
                return VncBoolean.of(((VncByteBuffer)val).size() == 0);
            }
            return VncBoolean.False;
        }
    };
    public static VncFunction not_empty_Q = new VncFunction("not-empty?", (VncVal)VncFunction.meta().arglists("(not-empty? x)").doc("Returns true if x is not empty. Accepts strings, collections and bytebufs.").examples("(not-empty? {:a 1})", "(not-empty? [1 2])", "(not-empty? '(1 2))", "(not-empty? \"abc\")").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            VncVal val = args.first();
            if (val == Constants.Nil) {
                return VncBoolean.False;
            }
            if (Types.isVncString(val)) {
                return VncBoolean.of(!((VncString)val).getValue().isEmpty());
            }
            if (Types.isVncCollection(val)) {
                return VncBoolean.of(!((VncCollection)val).isEmpty());
            }
            if (Types.isVncByteBuffer(val)) {
                return VncBoolean.of(((VncByteBuffer)val).size() > 0);
            }
            return VncBoolean.True;
        }
    };
    public static VncFunction cons = new VncFunction("cons", (VncVal)VncFunction.meta().arglists("(cons x coll)").doc("Returns a new collection where x is the first element and coll is the rest").examples("(cons 1 '(2 3 4 5 6))", "(cons 1 nil)", "(cons [1 2] [4 5 6])", "(cons 3 (set 1 2))", "(cons {:c 3} {:a 1 :b 2})", "(cons (map-entry :c 3) {:a 1 :b 2})", "; cons a value to a lazy sequence    \n(->> (cons -1 (lazy-seq 0 #(+ % 1))) \n     (take 5)                        \n     (doall))", "; recursive lazy sequence (fibonacci example)    \n(do                                              \n  (defn fib                                      \n    ([]    (fib 1 1))                            \n    ([a b] (cons a (fn [] (fib b (+ a b))))))    \n                                                 \n    (doall (take 6 (fib))))                        ").seeAlso("conj", "list*", "vector*").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2);
            VncVal x = args.first();
            VncVal coll = args.second();
            if (coll == Constants.Nil) {
                return VncList.of(x);
            }
            if (coll instanceof VncMutable) {
                throw new VncException(String.format("Function 'cons' does not allow the mutable collection %s as coll. Please use 'cons!' instead!", Types.getType(args.first())));
            }
            if (Types.isVncVector(coll)) {
                return ((VncVector)coll).addAtStart(x);
            }
            if (Types.isVncList(coll)) {
                return ((VncList)coll).addAtStart(x);
            }
            if (Types.isVncLazySeq(coll)) {
                return VncLazySeq.cons(x, (VncLazySeq)coll, (VncVal)Constants.Nil);
            }
            if (Types.isVncHashSet(coll)) {
                return ((VncHashSet)coll).add(x);
            }
            if (Types.isVncSortedSet(coll)) {
                return ((VncSortedSet)coll).add(x);
            }
            if (Types.isVncMap(coll)) {
                if (Types.isVncMapEntry(x)) {
                    VncMapEntry entry = (VncMapEntry)x;
                    return ((VncMap)coll).assoc(entry.getKey(), entry.getValue());
                }
                if (Types.isVncMap(x)) {
                    return ((VncMap)coll).putAll((VncMap)x);
                }
                throw new VncException(String.format("Invalid argument type %s for element while calling function 'cons' on map", Types.getType(x)));
            }
            if (Types.isVncFunction(coll)) {
                VncFunction fn = (VncFunction)args.second();
                fn.sandboxFunctionCallValidation();
                return VncLazySeq.cons(args.first(), fn, (VncVal)Constants.Nil);
            }
            throw new VncException(String.format("Invalid argument type %s while calling function 'cons'", Types.getType(coll)));
        }
    };
    public static VncFunction conj = new VncFunction("conj", (VncVal)VncFunction.meta().arglists("(conj)", "(conj x)", "(conj coll x)", "(conj coll x & xs)").doc("Returns a new collection with the x, xs 'added'. `(conj nil item)` returns (item). For list, vectors and ordered maps the values are added at the end. For all other sets and maps the position is undefined.").examples("(conj [1 2 3] 4)", "(conj [1 2 3] 4 5)", "(conj [1 2 3] [4 5])", "(conj '(1 2 3) 4)", "(conj '(1 2 3) 4 5)", "(conj '(1 2 3) '(4 5))", "(conj (set 1 2 3) 4)", "(conj {:a 1 :b 2} [:c 3])", "(conj {:a 1 :b 2} {:c 3})", "(conj {:a 1 :b 2} (map-entry :c 3))", "(conj)", "(conj 4)").seeAlso("cons", "into", "list*", "vector*").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            if (args.isEmpty()) {
                return VncVector.empty();
            }
            if (args.size() == 1) {
                return args.first();
            }
            VncVal coll = args.first();
            if (coll == Constants.Nil) {
                coll = VncList.empty();
            }
            if (coll instanceof VncMutable) {
                throw new VncException(String.format("Function 'conj' does not allow the mutable collection %s as coll. Please use 'conj!' instead!", Types.getType(args.first())));
            }
            if (Types.isVncVector(coll)) {
                return ((VncVector)coll).addAllAtEnd(args.rest());
            }
            if (Types.isVncList(coll)) {
                return ((VncList)coll).addAllAtEnd(args.rest());
            }
            if (Types.isVncSet(coll)) {
                return ((VncSet)coll).addAll(args.rest());
            }
            if (Types.isVncMap(coll)) {
                VncMap map = (VncMap)coll;
                for (VncVal v : args.rest()) {
                    if (Types.isVncSequence(v) && ((VncSequence)v).size() == 2) {
                        map = map.assoc(VncList.of(((VncSequence)v).first(), ((VncSequence)v).second()));
                        continue;
                    }
                    if (Types.isVncMapEntry(v)) {
                        VncMapEntry entry = (VncMapEntry)v;
                        map = map.assoc(entry.getKey(), entry.getValue());
                        continue;
                    }
                    if (Types.isVncMap(v)) {
                        map = map.putAll((VncMap)v);
                        continue;
                    }
                    throw new VncException(String.format("Invalid x %s while calling function 'conj'", Types.getType(v)));
                }
                return map;
            }
            throw new VncException(String.format("Invalid coll %s while calling function 'conj'", Types.getType(coll)));
        }
    };
    public static VncFunction cons_BANG = new VncFunction("cons!", (VncVal)VncFunction.meta().arglists("(cons! x coll)").doc("Adds x to the mutable coll").examples("(cons! 1 (mutable-list 2 3))", "(cons! 3 (mutable-set 1 2))", "(cons! {:c 3} (mutable-map :a 1 :b 2))", "(cons! (map-entry :c 3) (mutable-map :a 1 :b 2))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2);
            VncVal coll = args.second();
            if (!(coll instanceof VncMutable)) {
                throw new VncException("Function 'cons!' does not allow persistent collections as coll. Please use 'cons' instead!");
            }
            if (Types.isVncMutableList(coll)) {
                return ((VncMutableList)coll).addAtStart(args.first());
            }
            if (Types.isVncMutableSet(coll)) {
                return ((VncMutableSet)coll).add(args.first());
            }
            if (Types.isVncMutableMap(coll)) {
                if (Types.isVncMapEntry(args.first())) {
                    VncMapEntry entry = (VncMapEntry)args.first();
                    return ((VncMutableMap)coll).assoc(entry.getKey(), entry.getValue());
                }
                if (Types.isVncMap(args.first())) {
                    return ((VncMutableMap)coll).putAll((VncMap)args.first());
                }
                throw new VncException(String.format("Invalid argument type %s for element while calling function 'cons' on mutable map", Types.getType(args.first())));
            }
            throw new VncException(String.format("Invalid argument type %s while calling function 'cons!'", Types.getType(coll)));
        }
    };
    public static VncFunction conj_BANG = new VncFunction("conj!", (VncVal)VncFunction.meta().arglists("(conj!)", "(conj! x)", "(conj! coll x)", "(conj! coll x & xs)").doc("Returns a new mutable collection with the x, xs 'added'. `(conj! nil item)` returns `(item)`. For mutable list the values are added at the end. For all mutable sets and maps the position is undefined.").examples("(conj! (mutable-list 1 2 3) 4)", "(conj! (mutable-list 1 2 3) 4 5)", "(conj! (mutable-list 1 2 3) '(4 5))", "(conj! (mutable-set 1 2 3) 4)", "(conj! (mutable-map :a 1 :b 2) [:c 3])", "(conj! (mutable-map :a 1 :b 2) {:c 3})", "(conj! (mutable-map :a 1 :b 2) (map-entry :c 3))", "(conj! (stack) 1 2 3))", "(conj! (queue) 1 2 3))", "(conj!)", "(conj! 4)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            if (args.isEmpty()) {
                return new VncMutableList();
            }
            if (args.size() == 1) {
                return args.first();
            }
            VncVal coll = args.first();
            if (coll == Constants.Nil) {
                coll = new VncMutableList();
            }
            if (!(coll instanceof VncMutable)) {
                throw new VncException("Function 'conj!' does not allow persistent collections as coll. Please use 'conj' instead!");
            }
            if (Types.isVncMutableList(coll)) {
                return ((VncMutableList)coll).addAllAtEnd(args.rest());
            }
            if (Types.isVncMutableSet(coll)) {
                return ((VncMutableSet)coll).addAll(args.rest());
            }
            if (Types.isVncMutableMap(coll)) {
                VncMutableMap map = (VncMutableMap)coll;
                for (VncVal v : args.rest()) {
                    if (Types.isVncSequence(v) && ((VncSequence)v).size() == 2) {
                        map = map.assoc(VncList.of(((VncSequence)v).first(), ((VncSequence)v).second()));
                        continue;
                    }
                    if (Types.isVncMapEntry(v)) {
                        VncMapEntry entry = (VncMapEntry)v;
                        map = map.assoc(entry.getKey(), entry.getValue());
                        continue;
                    }
                    if (Types.isVncMap(v)) {
                        map = map.putAll((VncMap)v);
                        continue;
                    }
                    throw new VncException(String.format("Invalid x %s while calling function 'conj!'", Types.getType(v)));
                }
                return map;
            }
            if (Types.isVncQueue(coll)) {
                VncQueue queue = (VncQueue)coll;
                for (VncVal it : args.rest()) {
                    queue.put(it);
                }
                return queue;
            }
            if (Types.isVncStack(coll)) {
                VncStack stack = (VncStack)coll;
                for (VncVal it : args.rest()) {
                    stack.push(it);
                }
                return stack;
            }
            throw new VncException(String.format("Invalid coll %s while calling function 'conj!'", Types.getType(coll)));
        }
    };
    public static VncFunction concat = new VncFunction("concat", (VncVal)VncFunction.meta().arglists("(concat coll)", "(concat coll & colls)").doc("Returns a list of the concatenation of the elements in the supplied collections.").examples("(concat [1 2])", "(concat [1 2] [4 5 6])", "(concat '(1 2))", "(concat '(1 2) [4 5 6])", "(concat {:a 1})", "(concat {:a 1} {:b 2 :c 3})", "(concat \"abc\")", "(concat \"abc\" \"def\")").seeAlso("into", "merge").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            VncList result = VncList.empty();
            for (VncVal val : args) {
                if (val == Constants.Nil) continue;
                if (Types.isVncString(val)) {
                    result = result.addAllAtEnd(((VncString)val).toVncList());
                    continue;
                }
                if (Types.isVncCollection(val)) {
                    result = result.addAllAtEnd(((VncCollection)val).toVncList());
                    continue;
                }
                throw new VncException(String.format("Invalid argument type %s while calling function 'concat'", Types.getType(val)));
            }
            return result;
        }
    };
    public static VncFunction interleave = new VncFunction("interleave", (VncVal)VncFunction.meta().arglists("(interleave c1 c2)", "(interleave c1 c2 & colls)").doc("Returns a collection of the first item in each coll, then the second etc. \n\nSupports lazy sequences as long at least one collection is not a lazy sequence.").examples("(interleave [:a :b :c] [1 2])", "(interleave [:a :b :c] (lazy-seq 1 inc))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        /*
         * Unable to fully structure code
         */
        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertMinArity(this, args, 2);
            numColl = args.size();
            seqs = new VncSequence[numColl];
            for (ii = 0; ii < numColl; ++ii) {
                seqs[ii] = Coerce.toVncSequence(args.nth(ii));
            }
            result = new ArrayList<VncVal>();
            tuple = new VncVal[numColl];
            while (true) {
                for (ii = 0; ii < numColl; ++ii) {
                    if (seqs[ii].isEmpty()) {
                        return VncList.ofList(result);
                    }
                    tuple[ii] = seqs[ii].first();
                    seqs[ii] = seqs[ii].rest();
                }
                ii = 0;
                while (true) {
                    if (ii >= numColl) ** continue;
                    result.add(tuple[ii]);
                    ++ii;
                }
                break;
            }
        }
    };
    public static VncFunction interpose = new VncFunction("interpose", (VncVal)VncFunction.meta().arglists("(interpose sep coll)").doc("Returns a collection of the elements of coll separated by sep.").examples("(interpose \", \" [1 2 3])", "(apply str (interpose \", \" [1 2 3]))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2);
            VncVal sep = args.first();
            VncSequence coll = Coerce.toVncSequence(args.second());
            ArrayList<VncVal> result = new ArrayList<VncVal>();
            if (!coll.isEmpty()) {
                result.add(coll.first());
                for (VncVal p : coll.rest()) {
                    result.add(sep);
                    result.add(p);
                }
            }
            return VncList.ofList(result);
        }
    };
    public static VncFunction cartesian_product = new VncFunction("cartesian-product", (VncVal)VncFunction.meta().arglists("(cartesian-product coll1 coll2 coll*)").doc("Returns the cartesian product of two or more collections.\n\nRemoves all duplicates items in the collections before computing the cartesian product.").examples("(cartesian-product [1 2 3] [1 2 3])", "(cartesian-product [0 1] [0 1] [0 1])").seeAlso("combinations").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertMinArity(this, args, 2);
            VncList result = VncList.empty();
            VncSequence coll = (VncSequence)CoreFunctions.sort("combinations", Coerce.toVncSequence(args.first()).distinct());
            for (VncVal c : coll) {
                result = result.addAtEnd(VncList.of(c));
            }
            VncList restColls = args.rest();
            while (!restColls.isEmpty()) {
                coll = (VncSequence)CoreFunctions.sort("combinations", Coerce.toVncSequence(restColls.first()).distinct());
                restColls = restColls.rest();
                VncList resultTmp = VncList.empty();
                for (VncVal tuple : result) {
                    for (VncVal c : coll) {
                        resultTmp = resultTmp.addAtEnd(((VncList)tuple).addAtEnd(c));
                    }
                }
                result = resultTmp;
            }
            return result;
        }
    };
    public static VncFunction combinations = new VncFunction("combinations", (VncVal)VncFunction.meta().arglists("(combinations coll n)").doc("All the unique ways of taking n different elements from the items in the collection").examples("(combinations [0 1 2 3] 1)", "(combinations [0 1 2 3] 2)", "(combinations [0 1 2 3] 3)", "(combinations [0 1 2 3] 4)").seeAlso("cartesian-product").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2);
            VncSequence coll = (VncSequence)CoreFunctions.sort("combinations", Coerce.toVncSequence(args.first()).distinct());
            int n = Coerce.toVncLong(args.second()).getIntValue();
            if (n == 1) {
                VncList result = VncList.empty();
                while (!coll.isEmpty()) {
                    result = result.addAtEnd(coll.slice(0, 1));
                    coll = coll.drop(1);
                }
                return result;
            }
            if (n > 1 && n < coll.size()) {
                VncList result = VncList.empty();
                while (!coll.isEmpty()) {
                    VncSequence head = coll.take(n - 1);
                    VncSequence rest = coll.drop(n - 1);
                    for (VncVal v : rest) {
                        result = result.addAtEnd(head.addAtEnd(v));
                    }
                    coll = coll.drop(1);
                }
                return result;
            }
            if (n == coll.size()) {
                return VncList.of(coll);
            }
            return VncList.empty();
        }
    };
    public static VncFunction first = new VncFunction("first", (VncVal)VncFunction.meta().arglists("(first coll)").doc("Returns the first element of coll or nil if coll is nil or empty.").examples("(first nil)", "(first [])", "(first [1 2 3])", "(first '())", "(first '(1 2 3))", "(first \"abc\")").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 0, 1);
            VncVal coll = args.first();
            if (coll == Constants.Nil) {
                return Constants.Nil;
            }
            if (Types.isVncSequence(coll)) {
                return ((VncSequence)coll).first();
            }
            if (Types.isVncString(coll)) {
                return ((VncString)coll).first();
            }
            throw new VncException(String.format("Invalid argument type %s while calling function 'first'", Types.getType(coll)));
        }
    };
    public static VncFunction second = new VncFunction("second", (VncVal)VncFunction.meta().arglists("(second coll)").doc("Returns the second element of coll.").examples("(second nil)", "(second [])", "(second [1 2 3])", "(second '())", "(second '(1 2 3))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            VncVal coll = args.first();
            if (coll == Constants.Nil) {
                return Constants.Nil;
            }
            if (Types.isVncSequence(coll)) {
                return ((VncSequence)coll).second();
            }
            if (Types.isVncString(coll)) {
                return ((VncString)coll).second();
            }
            throw new VncException(String.format("Invalid argument type %s while calling function 'second'", Types.getType(coll)));
        }
    };
    public static VncFunction third = new VncFunction("third", (VncVal)VncFunction.meta().arglists("(third coll)").doc("Returns the third element of coll.").examples("(third nil)", "(third [])", "(third [1 2 3])", "(third '())", "(third '(1 2 3))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            VncVal coll = args.first();
            if (coll == Constants.Nil) {
                return Constants.Nil;
            }
            if (Types.isVncSequence(coll)) {
                return ((VncSequence)coll).third();
            }
            if (Types.isVncString(coll)) {
                return ((VncString)coll).nth(2);
            }
            throw new VncException(String.format("Invalid argument type %s while calling function 'third'", Types.getType(coll)));
        }
    };
    public static VncFunction fourth = new VncFunction("fourth", (VncVal)VncFunction.meta().arglists("(fourth coll)").doc("Returns the fourth element of coll.").examples("(fourth nil)", "(fourth [])", "(fourth [1 2 3 4 5])", "(fourth '())", "(fourth '(1 2 3 4 5))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            VncVal coll = args.first();
            if (coll == Constants.Nil) {
                return Constants.Nil;
            }
            if (Types.isVncSequence(coll)) {
                return ((VncSequence)coll).fourth();
            }
            if (Types.isVncString(coll)) {
                return ((VncString)coll).nth(3);
            }
            throw new VncException(String.format("Invalid argument type %s while calling function 'fourth'", Types.getType(coll)));
        }
    };
    public static VncFunction nth = new VncFunction("nth", (VncVal)VncFunction.meta().arglists("(nth coll idx)").doc("Returns the nth element of coll.").examples("(nth nil 1)", "(nth [1 2 3] 1)", "(nth '(1 2 3) 1)", "(nth \"abc\" 2)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2);
            int idx = Coerce.toVncLong(args.second()).getValue().intValue();
            VncVal coll = args.first();
            if (coll == Constants.Nil) {
                return Constants.Nil;
            }
            if (Types.isVncSequence(coll)) {
                return ((VncSequence)coll).nth(idx);
            }
            if (Types.isVncString(coll)) {
                return ((VncString)coll).nth(idx);
            }
            throw new VncException(String.format("Invalid argument type %s while calling function 'nth'", Types.getType(coll)));
        }
    };
    public static VncFunction last = new VncFunction("last", (VncVal)VncFunction.meta().arglists("(last coll)").doc("Returns the last element of coll.").examples("(last nil)", "(last [])", "(last [1 2 3])", "(last '())", "(last '(1 2 3))", "(last \"abc\")").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            VncVal val = args.first();
            if (val == Constants.Nil) {
                return Constants.Nil;
            }
            if (Types.isVncSequence(val)) {
                return ((VncSequence)val).last();
            }
            if (Types.isVncString(val)) {
                return ((VncString)val).last();
            }
            throw new VncException(String.format("Invalid argument type %s while calling function 'last'", Types.getType(val)));
        }
    };
    public static VncFunction rest = new VncFunction("rest", (VncVal)VncFunction.meta().arglists("(rest coll)").doc("Returns a possibly empty collection of the items after the first.").examples("(rest nil)", "(rest [])", "(rest [1])", "(rest [1 2 3])", "(rest '())", "(rest '(1))", "(rest '(1 2 3))", "(rest \"1234\")").seeAlso("str/rest").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            VncVal coll = args.first();
            if (coll == Constants.Nil) {
                return Constants.Nil;
            }
            if (Types.isVncSequence(coll)) {
                return ((VncSequence)coll).rest();
            }
            if (Types.isVncString(coll)) {
                String s = ((VncString)coll).getValue();
                if (s.length() > 1) {
                    ArrayList<VncChar> lst = new ArrayList<VncChar>();
                    for (char c : s.toCharArray()) {
                        lst.add(new VncChar(c));
                    }
                    return VncList.ofList(lst).rest();
                }
                return VncList.empty();
            }
            throw new VncException(String.format("Invalid argument type %s while calling function 'rest'", Types.getType(args.first())));
        }
    };
    public static VncFunction butlast = new VncFunction("butlast", (VncVal)VncFunction.meta().arglists("(butlast coll)").doc("Returns a collection with all but the last list element").examples("(butlast nil)", "(butlast [])", "(butlast [1])", "(butlast [1 2 3])", "(butlast '())", "(butlast '(1))", "(butlast '(1 2 3))", "(butlast \"1234\")").seeAlso("str/butlast").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            VncVal coll = args.first();
            if (coll == Constants.Nil) {
                return Constants.Nil;
            }
            if (Types.isVncSequence(coll)) {
                return ((VncSequence)coll).dropRight(1);
            }
            if (Types.isVncString(coll)) {
                String s = ((VncString)coll).getValue();
                if (s.length() > 1) {
                    ArrayList<VncChar> lst = new ArrayList<VncChar>();
                    for (char c : s.toCharArray()) {
                        lst.add(new VncChar(c));
                    }
                    return VncList.ofList(lst).slice(0, s.length() - 1);
                }
                return VncList.empty();
            }
            throw new VncException(String.format("Invalid argument type %s while calling function 'butlast'", Types.getType(args.first())));
        }
    };
    public static VncFunction nfirst = new VncFunction("nfirst", (VncVal)VncFunction.meta().arglists("(nfirst coll n)").doc("Returns a collection of the first n items").examples("(nfirst nil 2)", "(nfirst [] 2)", "(nfirst [1] 2)", "(nfirst [1 2 3] 2)", "(nfirst '() 2)", "(nfirst '(1) 2)", "(nfirst '(1 2 3) 2)", "(nfirst \"abcdef\" 2)", "(nfirst (lazy-seq 1 #(+ % 1)) 4)").seeAlso("str/nfirst").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2);
            VncVal coll = args.first();
            int n = Coerce.toVncLong(args.second()).getValue().intValue();
            if (coll == Constants.Nil) {
                return VncList.empty();
            }
            if (Types.isVncVector(coll)) {
                VncVector vec = (VncVector)coll;
                n = Math.max(0, Math.min(vec.size(), n));
                return vec.slice(0, n);
            }
            if (Types.isVncList(coll) || Types.isVncJavaList(coll)) {
                VncSequence list = (VncSequence)args.first();
                n = Math.max(0, Math.min(list.size(), n));
                return list.slice(0, n);
            }
            if (Types.isVncLazySeq(coll)) {
                VncLazySeq list = (VncLazySeq)args.first();
                return list.slice(0, n);
            }
            if (Types.isVncMutableList(coll)) {
                VncMutableList list = (VncMutableList)args.first();
                n = Math.max(0, Math.min(list.size(), n));
                return list.slice(0, n);
            }
            if (Types.isVncString(coll)) {
                VncList list = ((VncString)coll).toVncList();
                n = Math.max(0, Math.min(((VncCollection)list).size(), n));
                return ((VncSequence)list).slice(0, n);
            }
            throw new VncException(String.format("nfirst: type %s not supported", Types.getType(coll)));
        }
    };
    public static VncFunction nlast = new VncFunction("nlast", (VncVal)VncFunction.meta().arglists("(nlast coll n)").doc("Returns a collection of the last n items").examples("(nlast nil 2)", "(nlast [] 2)", "(nlast [1] 2)", "(nlast [1 2 3] 2)", "(nlast '() 2)", "(nlast '(1) 2)", "(nlast '(1 2 3) 2)", "(nlast \"abcdef\" 2)").seeAlso("str/nlast").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2);
            VncVal coll = args.first();
            int n = Coerce.toVncLong(args.second()).getValue().intValue();
            if (args.first() == Constants.Nil) {
                return VncList.empty();
            }
            if (Types.isVncVector(coll)) {
                VncVector vec = (VncVector)coll;
                n = Math.max(0, Math.min(vec.size(), n));
                return vec.slice(vec.size() - n);
            }
            if (Types.isVncList(coll) || Types.isVncJavaList(coll)) {
                VncSequence list = (VncSequence)args.first();
                n = Math.max(0, Math.min(list.size(), n));
                return list.slice(list.size() - n);
            }
            if (Types.isVncMutableList(coll)) {
                VncMutableList list = (VncMutableList)args.first();
                n = Math.max(0, Math.min(list.size(), n));
                return list.slice(list.size() - n);
            }
            if (Types.isVncString(coll)) {
                VncList list = ((VncString)coll).toVncList();
                n = Math.max(0, Math.min(((VncCollection)list).size(), n));
                return ((VncSequence)list).slice(((VncCollection)list).size() - n);
            }
            throw new VncException(String.format("nlast: type %s not supported", Types.getType(coll)));
        }
    };
    public static VncFunction partition = new VncFunction("partition", (VncVal)VncFunction.meta().arglists("(partition n coll)", "(partition n step coll)", "(partition n step padcoll coll)").doc("Returns a collection of lists of n items each, at offsets step apart. If step is not supplied, defaults to n, i.e. the partitions do not overlap. If a padcoll collection is supplied, use its elements as necessary to complete last partition upto n items. In case there are not enough padding elements, return a partition with less than n items. padcoll may be a lazy sequence").examples("(partition 3 [0 1 2 3 4 5 6])", "(partition 3 3 (repeat 99) [0 1 2 3 4 5 6])", "(partition 3 3 [] [0 1 2 3 4 5 6])", "(partition 2 3 [0 1 2 3 4 5 6])", "(partition 3 1 [0 1 2 3 4 5 6])", "(partition 3 6 [\"a\"] (range 20))", "(partition 4 6 [\"a\" \"b\" \"c\" \"d\"] (range 20))").seeAlso("partition-all", "partition-by").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            VncSequence seq;
            int step;
            ArityExceptions.assertArity(this, args, 2, 3, 4);
            int n = Coerce.toVncLong(args.first()).getValue().intValue();
            int n2 = step = args.size() > 2 ? Coerce.toVncLong(args.second()).getValue().intValue() : n;
            VncList padseq = args.size() == 4 ? (args.third() == Constants.Nil ? VncList.empty() : Coerce.toVncSequence(args.third())) : null;
            VncSequence vncSequence = seq = args.last() == Constants.Nil ? VncList.empty() : Coerce.toVncSequence(args.last());
            if (n <= 0) {
                throw new VncException("partition: n must be greater than 0");
            }
            if (step <= 0) {
                throw new VncException("partition: step must be greater than 0");
            }
            VncList result = VncList.empty();
            while (!((VncCollection)seq).isEmpty()) {
                VncSequence part = ((VncSequence)seq).take(n);
                if (Types.isVncLazySeq(part)) {
                    part = ((VncLazySeq)part).realize();
                }
                if (padseq != null) {
                    VncSequence partPadded = part.addAllAtEnd(((VncSequence)padseq).take(n - part.size()));
                    result = result.addAtEnd(partPadded);
                } else if (part.size() == n) {
                    result = result.addAtEnd(part);
                }
                if (part.size() < n) break;
                seq = ((VncSequence)seq).drop(step);
            }
            return result;
        }
    };
    public static VncFunction partition_all = new VncFunction("partition-all", (VncVal)VncFunction.meta().arglists("(partition-all n coll)", "(partition-all n step coll)").doc("Returns a collection of lists of n items each, at offsets step apart. If step is not supplied, defaults to n, i.e. the partitions do not overlap. May include partitions with fewer than n items at the end.").examples("(partition-all 3 [0 1 2 3 4 5 6])", "(partition-all 2 3 [0 1 2 3 4 5 6])", "(partition-all 3 1 [0 1 2 3 4 5 6])", "(partition-all 3 6 [\"a\"])", "(partition-all 2 2 [\"a\" \"b\" \"c\" \"d\"])").seeAlso("partition", "partition-by").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            VncSequence seq;
            ArityExceptions.assertArity(this, args, 2, 3);
            int n = Coerce.toVncLong(args.first()).getValue().intValue();
            int step = args.size() > 2 ? Coerce.toVncLong(args.second()).getValue().intValue() : n;
            VncSequence vncSequence = seq = args.last() == Constants.Nil ? VncList.empty() : Coerce.toVncSequence(args.last());
            if (n <= 0) {
                throw new VncException("partition-all: n must be greater than 0");
            }
            if (step <= 0) {
                throw new VncException("partition-all: step must be greater than 0");
            }
            VncList result = VncList.empty();
            while (!((VncCollection)seq).isEmpty()) {
                VncSequence part = ((VncSequence)seq).take(n);
                if (Types.isVncLazySeq(part)) {
                    part = ((VncLazySeq)part).realize();
                }
                result = result.addAtEnd(part);
                if (part.size() < n) break;
                seq = ((VncSequence)seq).drop(step);
            }
            return result;
        }
    };
    public static VncFunction partition_by = new VncFunction("partition-by", (VncVal)VncFunction.meta().arglists("(partition-by f coll)").doc("Applies f to each value in coll, splitting it each time f returns a new value.").examples("(partition-by even? [1 2 4 3 5 6])", "(partition-by identity (seq \"ABBA\"))", "(partition-by identity [1 1 1 1 2 2 3])").seeAlso("partition", "partition-all").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2);
            MeterRegistry meterRegistry = ThreadContext.getMeterRegistry();
            IVncFunction f = Coerce.toIVncFunction(args.first());
            VncSequence seq = Coerce.toVncSequence(args.second());
            f.sandboxFunctionCallValidation();
            if (seq.isEmpty()) {
                return VncList.empty();
            }
            VncList result = VncList.empty();
            VncList part = VncList.empty();
            VncVal v = seq.first();
            seq = seq.rest();
            part = part.addAtEnd(v);
            VncVal splitValLast = VncFunction.applyWithMeter(f, VncList.of(v), meterRegistry);
            while (!seq.isEmpty()) {
                v = seq.first();
                seq = seq.rest();
                VncVal splitVal = VncFunction.applyWithMeter(f, VncList.of(v), meterRegistry);
                VncBoolean equal = (VncBoolean)VncFunction.applyWithMeter(equal_Q, VncList.of(splitValLast, splitVal), meterRegistry);
                if (!VncBoolean.isTrue(equal)) {
                    splitValLast = splitVal;
                    result = result.addAtEnd(part);
                    part = VncList.empty();
                }
                part = part.addAtEnd(v);
            }
            if (!part.isEmpty()) {
                result = result.addAtEnd(part);
            }
            return result;
        }
    };
    public static VncFunction emptyToNil = new VncFunction("empty-to-nil", (VncVal)VncFunction.meta().arglists("(empty-to-nil x)").doc("Returns nil if x is empty").examples("(empty-to-nil \"\")", "(empty-to-nil [])", "(empty-to-nil '())", "(empty-to-nil {})").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            VncVal arg = args.first();
            if (Types.isVncString(arg)) {
                return ((VncString)arg).getValue().isEmpty() ? Constants.Nil : arg;
            }
            if (Types.isVncSequence(arg)) {
                return ((VncSequence)arg).isEmpty() ? Constants.Nil : arg;
            }
            if (Types.isVncSet(arg)) {
                return ((VncSet)arg).isEmpty() ? Constants.Nil : arg;
            }
            if (Types.isVncMap(arg)) {
                return ((VncMap)arg).isEmpty() ? Constants.Nil : arg;
            }
            return arg;
        }
    };
    public static VncFunction instance_of_Q = new VncFunction("instance-of?", (VncVal)VncFunction.meta().arglists("(instance-of? type x)").doc("Returns true if x is an instance of the given type").examples("(instance-of? :long 500)", "(instance-of? :java.math.BigInteger 500)").seeAlso("type", "supertype", "supertypes").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2);
            VncKeyword type = Coerce.toVncKeyword(args.first());
            if (type.hasNamespace()) {
                return VncBoolean.of(Types.isInstanceOf(type, args.second()));
            }
            VncKeyword qualifiedType = type.withNamespace(Namespaces.NS_CORE);
            if (Types.isInstanceOf(qualifiedType, args.second())) {
                return VncBoolean.True;
            }
            return VncBoolean.of(Types.isInstanceOf(type, args.second()));
        }
    };
    public static VncFunction pop = new VncFunction("pop", (VncVal)VncFunction.meta().arglists("(pop coll)").doc("For a list, returns a new list without the first item, for a vector, returns a new vector without the last item.").examples("(pop '(1 2 3 4))", "(pop [1 2 3 4])").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            VncVal val = args.first();
            if (val == Constants.Nil) {
                return Constants.Nil;
            }
            if (Types.isVncVector(val)) {
                VncVector vec = (VncVector)val;
                return vec.size() < 2 ? VncVector.empty() : vec.slice(0, vec.size() - 1);
            }
            if (Types.isVncSequence(val)) {
                VncSequence seq = (VncSequence)val;
                return seq.isEmpty() ? VncList.empty() : seq.rest();
            }
            throw new VncException(String.format("pop: type %s not supported", Types.getType(args.first())));
        }
    };
    public static VncFunction pop_BANG = new VncFunction("pop!", (VncVal)VncFunction.meta().arglists("(pop! stack)").doc("Pops an item from a stack.").examples("(let [s (stack)]   \n   (push! s 1)     \n   (push! s 2)     \n   (push! s 3)     \n   (pop! s))").seeAlso("stack", "peek", "push!", "empty?", "count").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            VncVal val = args.first();
            if (val == Constants.Nil) {
                return Constants.Nil;
            }
            if (Types.isVncStack(val)) {
                return ((VncStack)val).pop();
            }
            throw new VncException(String.format("pop!: type %s not supported", Types.getType(args.first())));
        }
    };
    public static VncFunction push_BANG = new VncFunction("push!", (VncVal)VncFunction.meta().arglists("(push! stack v)").doc("Pushes an item to a stack.").examples("(let [s (stack)]   \n   (push! s 1)     \n   (push! s 2)     \n   (push! s 3)     \n   (pop! s))").seeAlso("stack", "peek", "pop!", "empty?", "count").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2);
            VncVal val = args.first();
            if (val == Constants.Nil) {
                return Constants.Nil;
            }
            if (Types.isVncStack(val)) {
                return ((VncStack)val).push(args.second());
            }
            throw new VncException(String.format("push!: type %s not supported", Types.getType(args.first())));
        }
    };
    public static VncFunction offer_BANG = new VncFunction("offer!", (VncVal)VncFunction.meta().arglists("(offer! queue v)", "(offer! queue timeout v)").doc("Offers an item to a queue with an optional timeout in milliseconds. If a timeout is given waits up to the specified wait time if necessary for space to become available. For an indefinite timeout pass the timeout value :indefinite. If no timeout is given returns immediately false if the queue does not have any more capacity. Returns true if the element was added to this queue, else false.").examples("(let [q (queue)]           \n  (offer! q 1)             \n  (offer! q 1000 2)        \n  (offer! q :indefinite 3) \n  (offer! q 3)             \n  (poll! q)                \n  q)").seeAlso("queue", "put!", "take!", "poll!", "peek", "empty?", "count").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2, 3);
            VncVal val = args.first();
            if (val == Constants.Nil) {
                return Constants.Nil;
            }
            if (Types.isVncQueue(val)) {
                if (args.size() == 2) {
                    return ((VncQueue)val).offer(args.second());
                }
                VncVal option = args.second();
                if (Types.isVncKeyword(option)) {
                    if (((VncKeyword)option).hasValue("indefinite")) {
                        ((VncQueue)val).put(args.third());
                        return VncBoolean.True;
                    }
                    throw new VncException(String.format("offer!: timeout value '%s' not supported", option.toString()));
                }
                long timeout = Coerce.toVncLong(option).getValue();
                return ((VncQueue)val).offer(args.third(), timeout);
            }
            throw new VncException(String.format("offer!: type %s not supported", Types.getType(args.first())));
        }
    };
    public static VncFunction put_BANG = new VncFunction("put!", (VncVal)VncFunction.meta().arglists("(put! queue val)", "(put! queue val delay)").doc("Puts an item to a queue. The operation is synchronous, it waits indefinitely until the value can be placed on the queue. Returns always nil.\n\n*queue:* `(put! queue val)`\u00b6\nPuts the value 'val' to the tail of the queue.\n\n*delay-queue:* `(put! queue val delay)`\u00b6\nPuts the value 'val' with a delay of 'delay' milliseconds to a delay-queue").examples("(let [q (queue)]   \n  (put! q 1)       \n  (poll! q)        \n  q)", "(let [q (delay-queue)]   \n  (put! q 1 100)         \n  (take! q))             ").seeAlso("queue", "take!", "offer!", "poll!", "peek", "empty?", "count").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2, 3);
            VncVal coll = args.first();
            if (coll == Constants.Nil) {
                return Constants.Nil;
            }
            if (Types.isVncQueue(coll)) {
                if (args.size() == 2) {
                    ((VncQueue)coll).put(args.second());
                    return Constants.Nil;
                }
                throw new VncException("put! for a queue requires two args (put! queue val)");
            }
            if (Types.isVncDelayQueue(coll)) {
                if (args.size() == 3) {
                    VncVal val = args.second();
                    if (val == Constants.Nil) {
                        throw new VncException("put! A delay-queue does not permit nil elements");
                    }
                    ((VncDelayQueue)coll).put(val, Coerce.toVncLong(args.third()).getValue(), TimeUnit.MILLISECONDS);
                    return Constants.Nil;
                }
                throw new VncException("put! for a delay-queue requires three args (put! queue val delay)");
            }
            throw new VncException(String.format("put!: type %s not supported", Types.getType(args.first())));
        }
    };
    public static VncFunction poll_BANG = new VncFunction("poll!", (VncVal)VncFunction.meta().arglists("(poll! queue)", "(poll! queue timeout)").doc("Polls an item from a queue with an optional timeout in milliseconds. For an indefinite timeout pass the timeout value :indefinite. If no timeout is given returns the item if one is available else returns nil. With a timeout returns the item if one is available within the given timeout else returns nil.").examples("(let [q (conj! (queue) 1 2 3 4)]   \n  (poll! q)                        \n  (poll! q 1000)                   \n  q)").seeAlso("queue", "put!", "take!", "offer!", "peek", "empty?", "count").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1, 2);
            VncVal val = args.first();
            if (val == Constants.Nil) {
                return Constants.Nil;
            }
            if (Types.isVncQueue(val)) {
                if (args.size() == 1) {
                    return ((VncQueue)val).poll();
                }
                VncVal option = args.second();
                if (Types.isVncKeyword(option)) {
                    if (((VncKeyword)option).hasValue("indefinite")) {
                        return ((VncQueue)val).take();
                    }
                    throw new VncException(String.format("poll!: timeout value '%s' not supported", option.toString()));
                }
                long timeout = Coerce.toVncLong(option).getValue();
                return ((VncQueue)val).poll(timeout);
            }
            if (Types.isVncDelayQueue(val)) {
                if (args.size() == 1) {
                    return ((VncDelayQueue)val).poll();
                }
                VncVal option = args.second();
                if (Types.isVncKeyword(option)) {
                    if (((VncKeyword)option).hasValue("indefinite")) {
                        return ((VncDelayQueue)val).take();
                    }
                    throw new VncException(String.format("poll!: timeout value '%s' not supported", option.toString()));
                }
                long timeout = Coerce.toVncLong(option).getValue();
                return ((VncDelayQueue)val).poll(timeout);
            }
            throw new VncException(String.format("poll!: type %s not supported", Types.getType(args.first())));
        }
    };
    public static VncFunction take_BANG = new VncFunction("take!", (VncVal)VncFunction.meta().arglists("(take! queue)").doc("Retrieves and removes the head value of the queue, waiting if necessary until a value becomes available.").examples("(let [q (queue)]   \n  (put! q 1)       \n  (take! q)        \n  q)").seeAlso("queue", "put!", "offer!", "poll!", "peek", "empty?", "count").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            VncVal queue = args.first();
            if (queue == Constants.Nil) {
                return Constants.Nil;
            }
            if (Types.isVncQueue(queue)) {
                return ((VncQueue)queue).take();
            }
            if (Types.isVncDelayQueue(queue)) {
                return ((VncDelayQueue)queue).take();
            }
            throw new VncException(String.format("take!: type %s not supported", Types.getType(args.first())));
        }
    };
    public static VncFunction peek = new VncFunction("peek", (VncVal)VncFunction.meta().arglists("(peek coll)").doc("For a list, same as first, for a vector, same as last, for a stack the top element (or nil if the stack is empty), for a queue the head element (or nil if the queue is empty).").examples("(peek '(1 2 3 4))", "(peek [1 2 3 4])", "(let [s (conj! (stack) 1 2 3 4)] \n   (peek s))                      ", "(let [q (conj! (queue) 1 2 3 4)] \n   (peek q))                      ").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            VncVal val = args.first();
            if (val == Constants.Nil) {
                return Constants.Nil;
            }
            if (Types.isVncVector(val)) {
                VncVector vec = (VncVector)val;
                return vec.isEmpty() ? Constants.Nil : vec.nth(vec.size() - 1);
            }
            if (Types.isVncSequence(val)) {
                VncSequence seq = (VncSequence)val;
                return seq.isEmpty() ? Constants.Nil : seq.first();
            }
            if (Types.isVncStack(val)) {
                return ((VncStack)val).peek();
            }
            if (Types.isVncQueue(val)) {
                return ((VncQueue)val).peek();
            }
            if (Types.isVncDelayQueue(val)) {
                return ((VncDelayQueue)val).peek();
            }
            throw new VncException(String.format("peek: type %s not supported", Types.getType(args.first())));
        }
    };
    public static VncFunction sort = new VncFunction("sort", (VncVal)VncFunction.meta().arglists("(sort coll)", "(sort comparefn coll)").doc("Returns a sorted list of the items in coll. If no compare function comparefn is supplied, uses the natural compare. The compare function takes two arguments and returns -1, 0, or 1").examples("(sort [3 2 5 4 1 6])", "(sort compare [3 2 5 4 1 6])", "; reversed\n(sort (comp - compare) [3 2 5 4 1 6])", "(sort {:c 3 :a 1 :b 2})").seeAlso("sort-by").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1, 2);
            VncFunction compfn = args.size() == 1 ? compare : Coerce.toIVncFunction(args.first());
            compfn.sandboxFunctionCallValidation();
            VncVal coll = args.last();
            return CoreFunctions.sort("sort", coll, (x, y) -> Coerce.toVncLong(compfn.apply(VncList.of(x, y))).getIntValue());
        }
    };
    public static VncFunction sort_by = new VncFunction("sort-by", (VncVal)VncFunction.meta().arglists("(sort-by keyfn coll)", "(sort-by keyfn compfn coll)").doc("Returns a sorted sequence of the items in coll, where the sort order is determined by comparing (keyfn item).  If no comparator is supplied, uses compare. \n\nTo sort by multiple values use `juxt`, see the examples below.").examples("(sort-by :id [{:id 2 :name \"Smith\"} {:id 1 :name \"Jones\"} ])", "(sort-by count [\"aaa\" \"bb\" \"c\"])", "; reversed                                                            \n(sort-by count (comp - compare) [\"aaa\" \"bb\" \"c\"])               ", "(sort-by first [[1 2] [3 4] [2 3]])                                   ", "; sort tuples by first value, and where first value is equal,         \n; sort by second value                                                \n(sort-by (juxt first second) [[3 2] [1 3] [3 1] [1 2]])                ", "; reversed                                                            \n(sort-by first (comp - compare) [[1 2] [3 4] [2 3]])                  ", "(sort-by :rank [{:rank 2} {:rank 3} {:rank 1}])                       ", "; reversed                                                            \n(sort-by :rank (comp - compare) [{:rank 2} {:rank 3} {:rank 1}])      ", ";sort entries in a map by value                                       \n(sort-by val {:foo 7, :bar 3, :baz 5})                                ", "; sort by :foo, and where :foo is equal, sort by :bar                 \n(do                                                                   \n  (def x [ {:foo 2 :bar 11}                                           \n           {:foo 1 :bar 99}                                           \n           {:foo 2 :bar 55}                                           \n           {:foo 1 :bar 77} ])                                        \n  (sort-by (juxt :foo :bar) x))                                       ", "; sort by a given key order                                           \n(do                                                                   \n  (def x [ {:foo 2 :bar 11}                                           \n           {:foo 1 :bar 99}                                           \n           {:foo 2 :bar 55}                                           \n           {:foo 1 :bar 77} ])                                        \n  (def order [55 77 99 11])                                           \n  (sort-by #((into {} (map-indexed (fn [i e] [e i]) order)) (:bar %)) \n           x))                                                         ").seeAlso("sort").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2, 3);
            IVncFunction keyfn = Coerce.toIVncFunction(args.first());
            VncFunction compfn = args.size() == 2 ? compare : Coerce.toIVncFunction(args.second());
            keyfn.sandboxFunctionCallValidation();
            compfn.sandboxFunctionCallValidation();
            return CoreFunctions.sort("sort-by", args.last(), (x, y) -> Coerce.toVncLong(compfn.apply(VncList.of(keyfn.apply(VncList.of(x)), keyfn.apply(VncList.of(y))))).getIntValue());
        }
    };
    public static VncFunction group_by = new VncFunction("group-by", (VncVal)VncFunction.meta().arglists("(group-by f coll)").doc("Returns a map of the elements of coll keyed by the result of f on each element. The value at each key will be a vector of the corresponding elements, in the order they appeared in coll.").examples("(group-by count [\"a\" \"as\" \"asd\" \"aa\" \"asdf\" \"qwer\"])", "(group-by odd? (range 10))", "(group-by identity (seq \"abracadabra\"))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2);
            MeterRegistry meterRegistry = ThreadContext.getMeterRegistry();
            IVncFunction fn = Coerce.toIVncFunction(args.first());
            VncSequence coll = Coerce.toVncSequence(args.second());
            fn.sandboxFunctionCallValidation();
            VncMap map = new VncOrderedMap();
            for (VncVal v : coll) {
                VncVal key = VncFunction.applyWithMeter(fn, VncList.of(v), meterRegistry);
                VncVal val = ((VncMap)map).getJavaMap().get(key);
                if (val == null) {
                    map = ((VncMap)map).assoc(key, VncVector.of(v));
                    continue;
                }
                VncSequence seq = Coerce.toVncSequence(val);
                map = ((VncMap)map).assoc(key, seq.addAtEnd(v));
            }
            return map;
        }
    };
    public static VncFunction frequencies = new VncFunction("frequencies", (VncVal)VncFunction.meta().arglists("(frequencies coll)").doc("Returns a map from distinct items in coll to the number of times they appear.").examples("(frequencies [:a :b :a :a])", ";; Turn a frequency map back into a coll.\n(mapcat (fn [[x n]] (repeat n x)) {:a 2 :b 1 :c 3})").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            VncSequence coll = Coerce.toVncSequence(args.first());
            HashMap<VncVal, VncLong> map = new HashMap<VncVal, VncLong>();
            for (VncVal v : coll) {
                VncLong count = (VncLong)map.get(v);
                if (count == null) {
                    map.put(v, new VncLong(1L));
                    continue;
                }
                map.put(v, new VncLong(count.getValue() + 1L));
            }
            return new VncHashMap(map);
        }
    };
    public static VncFunction apply = new VncFunction("apply", (VncVal)VncFunction.meta().arglists("(apply f args* coll)").doc("Applies f to all arguments composed of args and coll").examples("(apply + [1 2 3])", "(apply + 1 2 [3 4 5])", "(apply str [1 2 3 4 5])", "(apply inc [1])").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            IVncFunction fn = Coerce.toIVncFunction(args.first());
            VncList fn_args = args.slice(1, args.size() - 1);
            fn.sandboxFunctionCallValidation();
            VncVal coll = args.last();
            return coll == Constants.Nil ? fn.apply(fn_args) : fn.apply(fn_args.addAllAtEnd(Coerce.toVncSequence(coll)));
        }
    };
    public static VncFunction comp = new VncFunction("comp", (VncVal)VncFunction.meta().arglists("(comp f*)").doc("Takes a set of functions and returns a fn that is the composition of those fns. The returned fn takes a variable number of args, applies the rightmost of fns to the args, the next fn (right-to-left) to the result, etc. ").examples("((comp str +) 8 8 8)", "(map (comp - (partial + 3) (partial * 2)) [1 2 3 4])", "((reduce comp [(partial + 1) (partial * 2) (partial + 3)]) 100)", "(filter (comp not zero?) [0 1 0 2 0 3 0 4])", "(do \n   (def fifth (comp first rest rest rest rest)) \n   (fifth [1 2 3 4 5]))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertMinArity(this, args, 0);
            final MeterRegistry meterRegistry = ThreadContext.getMeterRegistry();
            int len = args.size();
            final IVncFunction[] fns = new IVncFunction[len == 0 ? 1 : len];
            if (len == 0) {
                fns[0] = identity;
            } else {
                for (int ii = 0; ii < len; ++ii) {
                    IVncFunction fn = Coerce.toIVncFunction(args.nth(ii));
                    fn.sandboxFunctionCallValidation();
                    fns[len - 1 - ii] = fn;
                }
            }
            return new VncFunction(169.createAnonymousFuncName("comp")){
                private static final long serialVersionUID = -1L;

                @Override
                public VncVal apply(VncList args) {
                    VncList args_ = args;
                    for (int ii = 0; ii < fns.length - 1; ++ii) {
                        VncVal result = VncFunction.applyWithMeter(fns[ii], args_, meterRegistry);
                        args_ = VncList.of(result);
                    }
                    return VncFunction.applyWithMeter(fns[fns.length - 1], args_, meterRegistry);
                }
            };
        }
    };
    public static VncFunction compare = new VncFunction("compare", (VncVal)VncFunction.meta().arglists("(compare x y)").doc("Comparator. Returns -1, 0, or 1 when x is logically 'less than', 'equal to', or 'greater than' y. For list and vectors the longer sequence is always 'greater' regardless of its contents. For sets and maps only the size of the collection is compared.").examples("(compare nil 0)", "(compare 0 nil)", "(compare 1 0)", "(compare 1 1)", "(compare 1M 2M)", "(compare 1 nil)", "(compare nil 1)", "(compare \"aaa\" \"bbb\")", "(compare [0 1 2] [0 1 2])", "(compare [0 1 2] [0 9 2])", "(compare [0 9 2] [0 1 2])", "(compare [1 2 3] [0 1 2 3])", "(compare [0 1 2] [3 4])").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2);
            return new VncLong(args.first().compareTo(args.second()));
        }
    };
    public static VncFunction partial = new VncFunction("partial", (VncVal)VncFunction.meta().arglists("(partial f args*)").doc("Takes a function f and fewer than the normal arguments to f, and returns a fn that takes a variable number of additional args. When called, the returned function calls f with args + additional args.").examples("((partial * 2) 3)", "(map (partial * 2) [1 2 3 4])", "(map (partial reduce +) [[1 2 3 4] [5 6 7 8]])", "(do \n   (def hundred-times (partial * 100)) \n   (hundred-times 5))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertMinArity(this, args, 1);
            final VncVal first = args.first();
            final IVncFunction fn = Coerce.toIVncFunction(first);
            final VncList fnArgs = args.rest();
            fn.sandboxFunctionCallValidation();
            return new VncFunction(171.createAnonymousFuncName("partial")){
                private static final long serialVersionUID = -1L;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public VncVal apply(VncList args) {
                    CallStack cs = ThreadContext.getCallStack();
                    try {
                        VncList fnArgsAll = fnArgs.addAllAtEnd(args);
                        cs.push(fn instanceof VncFunction ? new CallFrame((VncFunction)fn, fnArgsAll) : new CallFrame(Types.getType(first).getQualifiedName(), fnArgsAll, first.getMeta()));
                        VncVal vncVal = fn.apply(fnArgsAll);
                        return vncVal;
                    }
                    finally {
                        cs.pop();
                    }
                }
            };
        }
    };
    public static VncFunction run_BANG = new VncFunction("run!", (VncVal)VncFunction.meta().arglists("(run! f coll)").doc("Runs the supplied function, for purposes of side effects, on successive items in the collection. Returns `nil`").examples("(run! prn [1 2 3 4])").seeAlso("docoll", "mapv").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2);
            return docoll.apply(args);
        }
    };
    public static VncFunction mapv = new VncFunction("mapv", (VncVal)VncFunction.meta().arglists("(mapv f coll colls*)").doc("Returns a vector consisting of the result of applying f to the set of first items of each coll, followed by applying f to the set of second items in each coll, until any one of the colls is exhausted. Any remaining items in other colls are ignored. ").examples("(mapv inc [1 2 3 4])", "(mapv + [1 2 3 4] [10 20 30 40])", "(mapv vector [1 2 3 4] [10 20 30 40])").seeAlso("docoll").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertMinArity(this, args, 2);
            MeterRegistry meterRegistry = ThreadContext.getMeterRegistry();
            IVncFunction fn = Coerce.toIVncFunction(args.first());
            VncList lists = FunctionsUtil.removeNilValues(args.rest());
            ArrayList<VncVal> result = new ArrayList<VncVal>();
            fn.sandboxFunctionCallValidation();
            if (lists.isEmpty()) {
                return Constants.Nil;
            }
            int index = 0;
            boolean hasMore = true;
            while (hasMore) {
                ArrayList<VncVal> fnArgs = new ArrayList<VncVal>();
                for (int ii = 0; ii < lists.size(); ++ii) {
                    VncSequence nthList = Coerce.toVncSequence(lists.nth(ii));
                    if (nthList.size() <= index) {
                        hasMore = false;
                        break;
                    }
                    fnArgs.add(nthList.nth(index));
                }
                if (!hasMore) continue;
                result.add(VncFunction.applyWithMeter(fn, VncList.ofList(fnArgs), meterRegistry));
                ++index;
            }
            return VncVector.ofList(result);
        }
    };
    public static VncFunction map_keys = new VncFunction("map-keys", (VncVal)VncFunction.meta().arglists("(map-keys f m)").doc("Applys function f to the keys of the map m.").examples("(map-keys name {:a 1 :b 2 :c 3})").seeAlso("map-vals", "map-invert").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertMinArity(this, args, 2);
            MeterRegistry meterRegistry = ThreadContext.getMeterRegistry();
            IVncFunction fn = Coerce.toIVncFunction(args.first());
            VncMap map = Coerce.toVncMap(args.second());
            fn.sandboxFunctionCallValidation();
            VncMap newMap = map.emptyWithMeta();
            for (VncMapEntry e : map.entries()) {
                newMap = newMap.assoc(VncList.of(VncFunction.applyWithMeter(fn, VncList.of(e.getKey()), meterRegistry), e.getValue()));
            }
            return newMap;
        }
    };
    public static VncFunction map_vals = new VncFunction("map-vals", (VncVal)VncFunction.meta().arglists("(map-vals f m)").doc("Applys function f to the values of the map m.").examples("(map-vals inc {:a 1 :b 2 :c 3})", "(map-vals :len {:a {:col 1 :len 10} :b {:col 2 :len 20} :c {:col 3 :len 30}})").seeAlso("map-keys", "map-invert").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertMinArity(this, args, 2);
            MeterRegistry meterRegistry = ThreadContext.getMeterRegistry();
            IVncFunction fn = Coerce.toIVncFunction(args.first());
            VncMap map = Coerce.toVncMap(args.second());
            fn.sandboxFunctionCallValidation();
            VncMap newMap = map.emptyWithMeta();
            for (VncMapEntry e : map.entries()) {
                newMap = newMap.assoc(VncList.of(e.getKey(), VncFunction.applyWithMeter(fn, VncList.of(e.getValue()), meterRegistry)));
            }
            return newMap;
        }
    };
    public static VncFunction docoll = new VncFunction("docoll", (VncVal)VncFunction.meta().arglists("(docoll f coll)").doc("Applies f to the items of the collection presumably for side effects. Returns nil. ").examples("(docoll #(println %) [1 2 3 4])", "(docoll \n    (fn [[k v]] (println (pr-str k v)))  \n    {:a 1 :b 2 :c 3 :d 4})", ";; docoll all elements of a queue. calls (take! queue) to get the     \n;; elements of the queue.                                             \n;; note: use nil to mark the end of the queue otherwise docoll will   \n;;       block forever!                                               \n(let [q (conj! (queue) 1 2 3 nil)]                                    \n  (docoll println q))                                                 ").seeAlso("mapv").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2);
            MeterRegistry meterRegistry = ThreadContext.getMeterRegistry();
            IVncFunction fn = Coerce.toIVncFunction(args.first());
            VncVal coll = args.second();
            fn.sandboxFunctionCallValidation();
            if (coll != Constants.Nil) {
                if (Types.isVncSequence(coll)) {
                    for (VncVal p : (VncSequence)coll) {
                        VncFunction.applyWithMeter(fn, VncList.of(p), meterRegistry);
                    }
                } else if (Types.isVncMap(coll)) {
                    ((VncMap)coll).entries().forEach(v -> VncFunction.applyWithMeter(fn, VncList.of(VncVector.of(v.getKey(), v.getValue())), meterRegistry));
                } else if (Types.isVncQueue(coll)) {
                    VncVal v2;
                    VncQueue queue = (VncQueue)coll;
                    while ((v2 = queue.take()) != Constants.Nil) {
                        VncFunction.applyWithMeter(fn, VncList.of(v2), meterRegistry);
                    }
                } else {
                    throw new VncException(String.format("docoll: collection type %s not supported", Types.getType(coll)));
                }
            }
            return Constants.Nil;
        }
    };
    public static VncFunction doall = new VncFunction("doall", (VncVal)VncFunction.meta().arglists("(doall coll)", "(doall n coll)").doc("When lazy sequences are produced doall can be used to force any effects and realize the lazy sequence.").examples("(->> (lazy-seq #(rand-long 100))  \n     (take 4)                     \n     (doall))", "(->> (lazy-seq #(rand-long 100))  \n     (doall 4))").seeAlso("lazy-seq").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1, 2);
            if (args.size() == 1) {
                if (Types.isVncLazySeq(args.first())) {
                    VncLazySeq seq = (VncLazySeq)args.first();
                    return seq.realize();
                }
                if (Types.isVncCollection(args.first())) {
                    return args.first();
                }
                throw new VncException(String.format("doall: type %s not supported", Types.getType(args.first())));
            }
            int n = Coerce.toVncLong(args.first()).getIntValue();
            if (Types.isVncLazySeq(args.second())) {
                VncLazySeq seq = (VncLazySeq)args.second();
                return seq.realize(n);
            }
            if (Types.isVncSequence(args.second())) {
                VncSequence seq = (VncSequence)args.second();
                return seq.toVncList().slice(0, n);
            }
            if (Types.isVncCollection(args.second())) {
                VncCollection coll = (VncCollection)args.second();
                return coll.toVncList().slice(0, n);
            }
            throw new VncException(String.format("doall: type %s not supported", Types.getType(args.second())));
        }
    };
    public static VncFunction mapcat = new VncFunction("mapcat", (VncVal)VncFunction.meta().arglists("(mapcat fn & colls)").doc("Returns the result of applying concat to the result of applying map to fn and colls. Thus function fn should return a collection.").examples("(mapcat identity [[1 2 3] [4 5 6] [7 8 9]])", "(mapcat identity [[1 2 [3 4]] [5 6 [7 8]]])", "(mapcat reverse [[3 2 1 ] [6 5 4] [9 8 7]])", "(mapcat list [:a :b :c] [1 2 3])", "(mapcat #(remove even? %) [[1 2] [2 2] [2 3]])", "(mapcat #(repeat 2 %) [1 2])", "(mapcat (juxt inc dec)  [1 2 3 4])", ";; Turn a frequency map back into a coll.\n(mapcat (fn [[x n]] (repeat n x)) {:a 2 :b 1 :c 3})").seeAlso("map", "flatten").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            return concat.apply(Coerce.toVncList(TransducerFunctions.map.apply(args)));
        }
    };
    public static VncFunction map_invert = new VncFunction("map-invert", (VncVal)VncFunction.meta().arglists("(map-invert m)").doc("Returns the map with the vals mapped to the keys.").examples("(map-invert {:a 1 :b 2 :c 3})").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            VncMap m = Coerce.toVncMap(args.first());
            HashMap<VncVal, VncVal> inverted = new HashMap<VncVal, VncVal>();
            for (VncMapEntry e : m.entries()) {
                inverted.put(e.getValue(), e.getKey());
            }
            return m.withValues(inverted, m.getMeta());
        }
    };
    public static VncFunction filter_k = new VncFunction("filter-k", (VncVal)VncFunction.meta().arglists("(filter-k f map)").doc("Returns a map with entries for which the predicate (f key) returns logical true. f is a function with one arguments.").examples("(filter-k #(= % :a) {:a 1 :b 2 :c 3})").seeAlso("filter-kv").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2);
            IVncFunction filterFn = Coerce.toIVncFunction(args.first());
            VncMap map = Coerce.toVncMap(args.second());
            filterFn.sandboxFunctionCallValidation();
            if (map.isEmpty()) {
                return map;
            }
            for (VncVal key : map.keys()) {
                VncVal r = filterFn.apply(VncList.of(key));
                if (r != Constants.Nil && !VncBoolean.isFalse(r)) continue;
                map = map.dissoc(key);
            }
            return map;
        }
    };
    public static VncFunction filter_kv = new VncFunction("filter-kv", (VncVal)VncFunction.meta().arglists("(filter-kv f map)").doc("Returns a map with entries for which the predicate `(f key value)` returns logical true. f is a function with two arguments.").examples("(filter-kv (fn [k v] (= k :a)) {:a 1 :b 2 :c 3})", "(filter-kv (fn [k v] (= v 2)) {:a 1 :b 2 :c 3})").seeAlso("filter-k").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2);
            IVncFunction filterFn = Coerce.toIVncFunction(args.first());
            VncMap map = Coerce.toVncMap(args.second());
            filterFn.sandboxFunctionCallValidation();
            if (map.isEmpty()) {
                return map;
            }
            HashMap<VncVal, VncVal> filtered = new HashMap<VncVal, VncVal>();
            for (VncMapEntry entry : map.entries()) {
                VncVal val;
                VncVal key = entry.getKey();
                VncVal r = filterFn.apply(VncList.of(key, val = entry.getValue()));
                if (r == Constants.Nil || VncBoolean.isFalse(r)) continue;
                filtered.put(key, val);
            }
            return new VncHashMap(filtered, map.getMeta());
        }
    };
    public static VncFunction reduce = new VncFunction("reduce", (VncVal)VncFunction.meta().arglists("(reduce f coll)", "(reduce f val coll)").doc("f should be a function of 2 arguments. If val is not supplied, returns the result of applying f to the first 2 items in coll, then applying f to that result and the 3rd item, etc. If coll contains no items, f must accept no arguments as well, and reduce returns the result of calling f with no arguments. If coll has only 1 item, it is returned and f is not called.  If val is supplied, returns the result of applying f to val and the first item in coll, then applying f to that result and the 2nd item, etc. If coll contains no items, returns val and f is not called.\n\n`reduce` can work with queues as collection, given that the end of the queue is marked by addding a `nil` element. Otherwise the reducer does not not when to stop reading elements from the queue.").examples("(reduce + [1 2 3 4 5 6 7])", "(reduce + 10 [1 2 3 4 5 6 7])", "(reduce (fn [x y] (+ x y 10)) [1 2 3 4 5 6 7])", "(reduce (fn [x y] (+ x y 10)) 10 [1 2 3 4 5 6 7])", "((reduce comp [(partial + 1) (partial * 2) (partial + 3)]) 100)", "(reduce (fn [m [k v]] (assoc m k v)) {} [[:a 1] [:b 2] [:c 3]])", "(reduce (fn [m [k v]] (assoc m v k)) {} {:b 2 :a 1 :c 3})", "(reduce (fn [m c] (assoc m (first c) c)) {} [[:a 1] [:b 2] [:c 3]])", ";; sliding window (width 3) average\n(->> (partition 3 1 (repeatedly 10 #(rand-long 30)))\n     (map (fn [window] (/ (reduce + window) (count window)))))", ";; reduce all elements of a queue. calls (take! queue) to get the     \n;; elements of the queue.                                             \n;; note: use nil to mark the end of the queue otherwise reduce will   \n;;       block forever!                                               \n(let [q (conj! (queue) 1 2 3 4 5 6 7 nil)]                            \n  (reduce + q))                                                       ").seeAlso("reduce-kv", "map", "filter").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2, 3);
            boolean noInitValue = args.size() < 3;
            IVncFunction reduceFn = Coerce.toIVncFunction(args.first());
            VncVal init = noInitValue ? null : args.second();
            VncVal coll = noInitValue ? args.second() : args.third();
            reduceFn.sandboxFunctionCallValidation();
            if (Types.isVncSequence(coll)) {
                return CoreFunctions.reduce_sequence((VncSequence)coll, reduceFn, init);
            }
            if (Types.isVncMap(coll)) {
                return CoreFunctions.reduce_sequence(((VncMap)coll).toVncList(), reduceFn, init);
            }
            if (Types.isVncQueue(coll)) {
                return CoreFunctions.reduce_queue((VncQueue)coll, reduceFn, init);
            }
            if (coll == Constants.Nil) {
                return CoreFunctions.reduce_sequence(VncList.empty(), reduceFn, init);
            }
            throw new VncException(String.format("reduce: collection type %s not supported", Types.getType(args.last())));
        }
    };
    public static VncFunction reduce_kv = new VncFunction("reduce-kv", (VncVal)VncFunction.meta().arglists("(reduce-kv f init coll)").doc("Reduces an associative collection. f should be a function of 3 arguments. Returns the result of applying f to init, the first key and the first value in coll, then applying f to that result and the 2nd key and value, etc. If coll contains no entries, returns init and f is not called. Note that reduce-kv is supported on vectors, where the keys will be the ordinals.").examples("(reduce-kv (fn [m k v] (assoc m v k)) \n           {}                         \n           {:a 1 :b 2 :c 3})", "(reduce-kv (fn [m k v] (assoc m k (:col v))) \n           {}                                \n           {:a {:col :red   :len 10}         \n            :b {:col :green :len 20}         \n            :c {:col :blue  :len 30} })").seeAlso("reduce", "map", "filter").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 3);
            IVncFunction reduceFn = Coerce.toIVncFunction(args.first());
            List<VncMapEntry> values = Coerce.toVncMap(args.third()).entries();
            reduceFn.sandboxFunctionCallValidation();
            VncVal value = args.second();
            if (values.isEmpty()) {
                return value;
            }
            for (VncMapEntry entry : values) {
                VncVal key = entry.getKey();
                VncVal val = entry.getValue();
                value = reduceFn.apply(VncList.of(value, key, val));
            }
            return value;
        }
    };
    public static VncFunction merge = new VncFunction("merge", (VncVal)VncFunction.meta().arglists("(merge & maps)").doc("Returns a map that consists of the rest of the maps conj-ed onto the first.  If a key occurs in more than one map, the mapping from the latter (left-to-right) will be the mapping in the result.").examples("(merge {:a 1 :b 2 :c 3} {:b 9 :d 4})", "(merge {:a 1} nil)", "(merge nil {:a 1})", "(merge nil nil)").seeAlso("merge-with", "merge-deep", "into", "concat").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertMinArity(this, args, 1);
            List maps = args.stream().filter(v -> v != Constants.Nil).collect(Collectors.toList());
            if (maps.isEmpty()) {
                return Constants.Nil;
            }
            HashMap map = new HashMap();
            maps.stream().forEach(v -> map.putAll(Coerce.toVncMap(v).getJavaMap()));
            return new VncHashMap(map);
        }
    };
    public static VncFunction merge_with = new VncFunction("merge-with", (VncVal)VncFunction.meta().arglists("(merge-with f & maps)").doc("Returns a map that consists of the rest of the maps conj-ed onto the first. If a key occurs in more than one map, the mapping(s) from the latter (left-to-right) will be combined with the mapping in the result by calling (f val-in-result val-in-latter).").examples("(merge-with + {:a 1 :b 2} {:a 9 :b 98 :c 0})", "(merge-with into {:a [1] :b [2]} {:b [3 4] :c [5 6]})").seeAlso("merge", "merge-deep").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertMinArity(this, args, 1);
            List rest = args.rest().stream().filter(v -> v != Constants.Nil).map(v -> Coerce.toVncMap(v)).collect(Collectors.toList());
            if (rest.isEmpty()) {
                return new VncHashMap();
            }
            if (rest.size() == 1) {
                return (VncVal)rest.get(0);
            }
            VncFunction fn = Coerce.toVncFunction(args.first());
            fn.sandboxFunctionCallValidation();
            HashMap<VncVal, VncVal> map = new HashMap<VncVal, VncVal>();
            for (VncMap m : rest) {
                for (VncMapEntry e : m.entries()) {
                    VncVal key = e.getKey();
                    VncVal val1 = (VncVal)map.get(key);
                    VncVal val2 = e.getValue();
                    if (val1 == null) {
                        map.put(key, fn.apply(VncList.of(val2)));
                        continue;
                    }
                    if (val2 == null) {
                        map.put(key, fn.apply(VncList.of(val1)));
                        continue;
                    }
                    map.put(key, fn.apply(VncList.of(val1, val2)));
                }
            }
            return new VncHashMap(map);
        }
    };
    public static VncFunction merge_deep = new VncFunction("merge-deep", (VncVal)VncFunction.meta().arglists("(merge-deep values)", "(merge-deep strategy & values)").doc("Recursively merges maps.\n\nIf the first parameter is a keyword it defines the strategy to\nuse when merging non-map collections. Options are:\n\n1. *:replace*, the default, the last value is used\n2. *:into*, if the value in every map is a collection they are\n   concatenated using `into`. Thus the type of (first) value is\n   maintained.").examples("(merge-deep {:a {:c 2}} {:a {:b 1}})", "(merge-deep :replace {:a [1]} {:a [2]})", "(merge-deep :into {:a [1]} {:a [2]})", "(merge-deep {:a 1} nil)").seeAlso("merge", "merge-with").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertMinArity(this, args, 1);
            boolean hasStrategy = Types.isVncKeyword(args.first());
            VncList values = hasStrategy ? args.rest() : args;
            VncKeyword strategy = hasStrategy ? (VncKeyword)args.first() : new VncKeyword(":replace");
            boolean strategyInto = new VncKeyword(":into").equals(strategy);
            if (VncBoolean.isTrue(every_Q.applyOf(map_Q, values))) {
                return apply.applyOf(merge_with, partial.applyOf(merge_deep, strategy), values);
            }
            if (strategyInto && VncBoolean.isTrue(every_Q.applyOf(coll_Q, values))) {
                return reduce.applyOf(into, values);
            }
            return values.last();
        }
    };
    public static VncFunction disj = new VncFunction("disj", (VncVal)VncFunction.meta().arglists("(disj set x)", "(disj set x & xs)").doc("Returns a new set with the x, xs removed.").examples("(disj (set 1 2 3) 3)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertMinArity(this, args, 2);
            if (args.first() instanceof VncSet) {
                return ((VncSet)args.first()).removeAll(args.rest());
            }
            throw new VncException(String.format("Invalid coll %s while calling function 'disj'", Types.getType(args.first())));
        }
    };
    public static VncFunction seq = new VncFunction("seq", (VncVal)VncFunction.meta().arglists("(seq coll)").doc("Returns a seq on the collection. If the collection is empty, returns nil. `(seq nil)` returns nil. seq also works on Strings and converts Java streams to lists.").examples("(seq nil)", "(seq [])", "(seq [1 2 3])", "(seq '(1 2 3))", "(seq {:a 1 :b 2})", "(seq \"abcd\")").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            VncVal val = args.first();
            if (Types.isVncJavaObject(val, Stream.class)) {
                Stream stream = (Stream)((VncJavaObject)val).getDelegate();
                return VncList.ofList(stream.map(o -> new VncJavaObject(o)).collect(Collectors.toList()));
            }
            if (Types.isVncMap(val)) {
                if (((VncMap)val).isEmpty()) {
                    return Constants.Nil;
                }
                return VncList.ofList(((VncMap)val).entries().stream().map(e -> VncVector.of(e.getKey(), e.getValue())).collect(Collectors.toList()));
            }
            if (Types.isVncLazySeq(val)) {
                return ((VncLazySeq)val).isEmpty() ? Constants.Nil : val;
            }
            if (Types.isVncSequence(val)) {
                return ((VncSequence)val).isEmpty() ? Constants.Nil : ((VncSequence)val).toVncList();
            }
            if (Types.isVncString(val)) {
                VncString s = (VncString)val;
                return s.isEmpty() ? Constants.Nil : s.toVncList();
            }
            if (val == Constants.Nil) {
                return Constants.Nil;
            }
            throw new VncException("seq: called on non-sequence");
        }
    };
    public static VncFunction repeat = new VncFunction("repeat", (VncVal)VncFunction.meta().arglists("(repeat x)", "(repeat n x)").doc("Returns a lazy sequence of x values or a collection with the value x repeated n times.").examples("(repeat 3 \"hello\")", "(repeat 5 [1 2])", "(repeat \":\")", "(interleave [:a :b :c] (repeat 100))").seeAlso("repeatedly", "dotimes", "constantly").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1, 2);
            if (args.size() == 1) {
                final VncVal val = args.first();
                return VncLazySeq.continually(new VncFunction(189.createAnonymousFuncName("repeat")){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public VncVal apply(VncList args) {
                        return val;
                    }
                }, Constants.Nil);
            }
            long repeat = Coerce.toVncLong(args.first()).getValue();
            if (repeat < 0L) {
                throw new VncException("repeat: a count n must be grater or equal to 0");
            }
            VncVal val = args.second();
            ArrayList<VncVal> values = new ArrayList<VncVal>();
            int ii = 0;
            while ((long)ii < repeat) {
                values.add(val);
                ++ii;
            }
            return VncList.ofList(values);
        }
    };
    public static VncFunction repeatedly = new VncFunction("repeatedly", (VncVal)VncFunction.meta().arglists("(repeatedly n fn)").doc("Takes a function of no args, presumably with side effects, and returns a collection of n calls to it").examples("(repeatedly 5 #(rand-long 11))", ";; compare with repeat, which only calls the 'rand-long'\n;; function once, repeating the value five times. \n(repeat 5 (rand-long 11))").seeAlso("repeat", "dotimes", "constantly").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2);
            MeterRegistry meterRegistry = ThreadContext.getMeterRegistry();
            long repeat = Coerce.toVncLong(args.first()).getValue();
            IVncFunction fn = Coerce.toIVncFunction(args.second());
            fn.sandboxFunctionCallValidation();
            if (repeat < 0L) {
                throw new VncException("repeatedly: a count n must be grater or equal to 0");
            }
            ArrayList<VncVal> values = new ArrayList<VncVal>();
            int ii = 0;
            while ((long)ii < repeat) {
                values.add(VncFunction.applyWithMeter(fn, VncList.empty(), meterRegistry));
                ++ii;
            }
            return VncList.ofList(values);
        }
    };
    public static VncFunction cycle = new VncFunction("cycle", (VncVal)VncFunction.meta().arglists("(cycle coll)").doc("Returns a lazy (infinite!) sequence of repetitions of the items in coll.").examples("(doall (take 5 (cycle [1 2])))").seeAlso("repeat", "repeatedly", "dotimes", "constantly").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            final VncSequence seq = Coerce.toVncSequence(args.first());
            if (seq.isEmpty()) {
                throw new VncException("cycle: the cycle collection must not be empty!");
            }
            VncFunction f = new VncFunction(191.createAnonymousFuncName("cycle")){
                private int idx;
                private static final long serialVersionUID = -1L;
                {
                    super(name);
                    this.idx = -1;
                }

                @Override
                public VncVal apply(VncList args) {
                    this.idx = (this.idx + 1) % seq.size();
                    return seq.nth(this.idx);
                }
            };
            return VncLazySeq.iterate(f, Constants.Nil);
        }
    };
    public static VncFunction identity = new VncFunction("identity", (VncVal)VncFunction.meta().arglists("(identity x)").doc("Returns its argument.").examples("(identity 4)", "(filter identity [1 2 3 nil 4 false true 1234])").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVector getParams() {
            return VncVector.of(new VncSymbol("x"));
        }

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            return args.first();
        }
    };
    public static VncFunction meta = new VncFunction("meta", (VncVal)VncFunction.meta().arglists("(meta obj)").doc("Returns the metadata of obj, returns nil if there is no metadata.").examples("(meta (vary-meta [1 2] assoc :a 1))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            return args.first().getMeta();
        }
    };
    public static VncFunction with_meta = new VncFunction("with-meta", (VncVal)VncFunction.meta().arglists("(with-meta obj m)").doc("Returns a copy of the object obj, with a map m as its metadata.").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2);
            return args.first().withMeta(Coerce.toVncMap(args.second()));
        }
    };
    public static VncFunction vary_meta = new VncFunction("vary-meta", (VncVal)VncFunction.meta().arglists("(vary-meta obj f & args)").doc("Returns a copy of the object obj, with (apply f (meta obj) args) as its metadata.").examples("(meta (vary-meta [1 2] assoc :a 1))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertMinArity(this, args, 2);
            VncVal obj = args.first();
            VncVal meta = obj.getMeta();
            IVncFunction fn = Coerce.toIVncFunction(args.second());
            VncList fnArgs = args.slice(2).addAtStart(meta == Constants.Nil ? new VncHashMap() : meta);
            return obj.withMeta(fn.apply(fnArgs));
        }
    };
    public static VncFunction alter_meta_BANG = new VncFunction("alter-meta!", (VncVal)VncFunction.meta().arglists("(alter-meta! obj f & args)").doc("Atomically sets the metadata for a namespace/agent/atom/volatile \nto be:                                                           \n\n  `(apply f its-current-meta args)`                              \n\nf must be free of side-effects.").examples("(do                                   \n  (def counter (atom 0))              \n  (alter-meta! counter assoc :a 1))   ", "(do                                   \n  (def counter (atom 0))              \n  (alter-meta! counter assoc :a 1)    \n  (meta counter))                     ").seeAlso("meta", "reset-meta!").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertMinArity(this, args, 2);
            throw new VncException("The function alter-meta! is not yet implemented!");
        }
    };
    public static VncFunction reset_meta_BANG = new VncFunction("reset-meta!", (VncVal)VncFunction.meta().arglists("(reset-meta! obj metadata-map)").doc("Atomically resets the metadata for a namespace/agent/atom/volatile").examples("(do                                   \n  (def counter (atom 0))              \n  (alter-meta! counter assoc :a 1)    \n  (reset-meta! counter {}))           ", "(do                                   \n  (def counter (atom 0))              \n  (alter-meta! counter assoc :a 1)    \n  (reset-meta! counter {})            \n  (meta counter))                     ").seeAlso("meta", "alter-meta!").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2);
            throw new VncException("The function reset-meta! is not yet implemented!");
        }
    };
    public static VncFunction ns_alias = new VncFunction("ns-alias", (VncVal)VncFunction.meta().arglists("(ns-alias alias namespace-sym)").doc("Add an alias in the current namespace to another namespace. Arguments are two symbols: the alias to be used, and the symbolic name of the target namespace.").examples("(ns-alias 'p 'parsatron)", "(do                      \n  (load-module :hexdump) \n  (ns-alias 'h 'hexdump) \n  (h/dump [0 1 2 3]))    ").seeAlso("ns-unalias", "ns-aliases", "*ns*", "ns").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2);
            VncSymbol alias = Coerce.toVncSymbol(args.first());
            VncSymbol ns = Coerce.toVncSymbol(args.second());
            Namespaces.getCurrentNamespace().addAlias(alias.getName(), ns.getQualifiedName());
            return Constants.Nil;
        }
    };
    public static VncFunction ns_aliases = new VncFunction("ns-aliases", (VncVal)VncFunction.meta().arglists("(ns-aliases)").doc("Returns a map of the aliases defined in the current namespace.").examples("(ns-aliases)", "(do                        \n  (ns-alias 'h 'hexdump)   \n  (ns-alias 'p 'parsatron) \n  (ns-aliases))            ").seeAlso("ns-alias", "ns-unalias", "*ns*", "ns").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 0);
            return Namespaces.getCurrentNamespace().listAliases();
        }
    };
    public static VncFunction ns_unalias = new VncFunction("ns-unalias", (VncVal)VncFunction.meta().arglists("(ns-unalias alias)").doc("Removes a namespace alias in the current namespace.").examples("(do                      \n  (ns-alias 'h 'hexdump) \n  (ns-unalias 'h))         ").seeAlso("ns-alias", "ns-aliases", "*ns*", "ns").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            VncSymbol alias = Coerce.toVncSymbol(args.first());
            Namespaces.getCurrentNamespace().removeAlias(alias.getName());
            return Constants.Nil;
        }
    };
    public static VncFunction gensym = new VncFunction("gensym", (VncVal)VncFunction.meta().arglists("(gensym)", "(gensym prefix)").doc("Generates a symbol.").examples("(gensym)", "(gensym \"prefix_\")").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 0, 1);
            return args.isEmpty() ? GenSym.generate() : GenSym.generate(Types.isVncSymbol(args.first()) ? Coerce.toVncSymbol(args.first()).getName() : Coerce.toVncString(args.first()).getValue());
        }
    };
    public static VncFunction name = new VncFunction("name", (VncVal)VncFunction.meta().arglists("(name x)").doc("Returns the name String of a string, symbol, keyword, or function").examples("(name :user/x)", "(name 'x)", "(name \"x\")", "(name str/digit?)").seeAlso("qualified-name", "namespace", "fn-name").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            VncVal arg = args.first();
            if (arg == Constants.Nil) {
                return Constants.Nil;
            }
            if (Types.isVncKeyword(arg)) {
                return new VncString(((VncKeyword)arg).getSimpleName());
            }
            if (Types.isVncSymbol(arg)) {
                return new VncString(((VncSymbol)arg).getSimpleName());
            }
            if (Types.isVncString(arg)) {
                return arg;
            }
            if (Types.isVncFunction(arg) || Types.isVncMacro(arg)) {
                return new VncString(((VncFunction)arg).getSimpleName());
            }
            throw new VncException(String.format("Function 'name' does not allow %s as parameter", Types.getType(arg)));
        }
    };
    public static VncFunction qualified_name = new VncFunction("qualified-name", (VncVal)VncFunction.meta().arglists("(name x)").doc("Returns the qualified name String of a string, symbol, keyword, or function").examples("(qualified-name :user/x)", "(qualified-name 'x)", "(qualified-name \"x\")", "(qualified-name str/digit?)").seeAlso("name", "namespace", "fn-name").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            VncVal arg = args.first();
            if (arg == Constants.Nil) {
                return Constants.Nil;
            }
            if (Types.isVncKeyword(arg)) {
                return new VncString(((VncKeyword)arg).getQualifiedName());
            }
            if (Types.isVncSymbol(arg)) {
                return new VncString(((VncSymbol)arg).getQualifiedName());
            }
            if (Types.isVncString(arg)) {
                return arg;
            }
            if (Types.isVncFunction(arg) || Types.isVncMacro(arg)) {
                return new VncString(((VncFunction)arg).getQualifiedName());
            }
            throw new VncException(String.format("Function 'qualified-name' does not allow %s as parameter", Types.getType(arg)));
        }
    };
    public static VncFunction type = new VncFunction("type", (VncVal)VncFunction.meta().arglists("(type x)").doc("Returns the type of x.").examples("(type 5)", "(type [1 2])", "(type (. :java.math.BigInteger :valueOf 100))").seeAlso("supertype", "supertypes", "instance-of?").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            return Types.getType(args.first());
        }
    };
    public static VncFunction supertype = new VncFunction("supertype", (VncVal)VncFunction.meta().arglists("(supertype x)").doc("Returns the super type of x.").examples("(supertype 5)", "(supertype [1 2])", "(supertype (. :java.math.BigInteger :valueOf 100))").seeAlso("type", "supertypes", "instance-of?").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            return Types.getSupertype(args.first());
        }
    };
    public static VncFunction supertypes = new VncFunction("supertypes", (VncVal)VncFunction.meta().arglists("(supertypes x)").doc("Returns the super types of x.").examples("(supertypes 5)", "(supertypes [1 2])", "(supertypes (. :java.math.BigInteger :valueOf 100))").seeAlso("type", "supertype", "instance-of?").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            return Types.getSupertypes(args.first());
        }
    };
    public static VncFunction highlight = new VncFunction("highlight", (VncVal)VncFunction.meta().arglists("(highlight form)").doc("Syntax highlighting. Reads the form and returns a list of (token, token-class) tuples. \n\nToken classes: \n\n```\n   :comment                 ; .... \n   :whitespaces             \"  \", \"\\n\", \"  \\n\"  \n\n   :string                  \"lorem\", \"\"\"lorem\"\"\"  \n   :number                  100, 100I, 100.0, 100.23M  \n   :constant                nil, true, false  \n   :keyword                 :alpha  \n   :symbol                  alpha  \n   :symbol-special-form     def, loop, ...  \n   :symbol-function-name    +, println, ...  \n\n   :quote                   '  \n   :quasi-quote             `  \n   :unquote                 ~  \n   :unquote-splicing        ~@  \n\n   :meta                    ^private, ^{:arglist '() :doc \"....\"}\n   :at                      @  \n   :hash                    #  \n   :brace-begin             {  \n   :brace-end               {  \n   :bracket-begin           [  \n   :bracket-end             ]  \n   :parenthesis-begin       (  \n   :parenthesis-end         )  \n\n   :unknown                 anything that could not be classified\n```").examples("(highlight \"(+ 10 20)\")", "(highlight \"(if (= 1 2) true false)\")").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            String form = Coerce.toVncString(args.first()).getValue();
            Map<HighlightClass, VncKeyword> classMap = Arrays.stream(HighlightClass.values()).collect(Collectors.toMap(p -> p, p -> new VncKeyword(p.name().toLowerCase().replace('_', '-'))));
            VncList list = VncList.empty();
            for (HighlightItem it : HighlightParser.parse(form)) {
                list = list.addAtEnd(VncList.of(new VncString(it.getForm()), classMap.get((Object)it.getClazz())));
            }
            return list;
        }
    };
    public static final Map<VncVal, VncVal> ns = new SymbolMapBuilder().add(nil_Q).add(some_Q).add(true_Q).add(false_Q).add(boolean_Q).add(int_Q).add(long_Q).add(double_Q).add(decimal_Q).add(bigint_Q).add(number_Q).add(string_Q).add(char_Q).add(symbol).add(symbol_Q).add(qualified_symbol_Q).add(keyword).add(keyword_Q).add(fn_Q).add(macro_Q).add(fn_name).add(fn_about).add(fn_body).add(fn_pre_conditions).add(just).add(just_Q).add(pr_str).add(str).add(to_str).add(read_string).add(equal_Q).add(equal_strict_Q).add(lt).add(lte).add(gt).add(gte).add(match_Q).add(not_match_Q).add(match_Q).add(not_match_Q).add(boolean_cast).add(char_cast).add(int_cast).add(long_cast).add(double_cast).add(decimal_cast).add(bigint_cast).add(char_literals).add(mutable_Q).add(new_list).add(new_list_ASTERISK).add(list_Q).add(new_mutable_list).add(mutable_list_Q).add(new_vector).add(new_vector_ASTERISK).add(vector_Q).add(new_mutable_vector).add(mutable_vector_Q).add(new_lazy_seq).add(lazyseq_Q).add(map_Q).add(map_entry_Q).add(hash_map_Q).add(ordered_map_Q).add(sorted_map_Q).add(mutable_map_Q).add(stack_Q).add(queue_Q).add(delay_queue_Q).add(new_hash_map).add(new_ordered_map).add(new_sorted_map).add(new_mutable_map).add(new_map_entry).add(new_stack).add(new_queue).add(new_delay_queue).add(assoc).add(assoc_BANG).add(assoc_in).add(dissoc).add(dissoc_BANG).add(dissoc_in).add(contains_Q).add(not_contains_Q).add(find).add(get).add(get_in).add(key).add(keys).add(val).add(vals).add(entries).add(select_keys).add(update).add(update_BANG).add(update_in).add(subvec).add(sublist).add(empty).add(set_Q).add(sorted_set_Q).add(mutable_set_Q).add(new_set).add(new_sorted_set).add(new_mutable_set).add(distinct_Q).add(difference).add(union).add(intersection).add(subset_Q).add(superset_Q).add(juxt).add(fnil).add(shuffle).add(split_at).add(split_with).add(into).add(into_BANG).add(sequential_Q).add(coll_Q).add(cons).add(cons_BANG).add(conj).add(conj_BANG).add(concat).add(interpose).add(interleave).add(cartesian_product).add(combinations).add(mapcat).add(map_invert).add(docoll).add(doall).add(nth).add(first).add(second).add(third).add(fourth).add(last).add(rest).add(butlast).add(nfirst).add(nlast).add(emptyToNil).add(pop).add(put_BANG).add(take_BANG).add(pop_BANG).add(push_BANG).add(poll_BANG).add(offer_BANG).add(peek).add(empty_Q).add(not_empty_Q).add(every_Q).add(not_every_Q).add(any_Q).add(not_any_Q).add(every_pred).add(any_pred).add(count).add(compare).add(apply).add(comp).add(partial).add(mapv).add(partition).add(partition_all).add(partition_by).add(filter_k).add(filter_kv).add(reduce).add(reduce_kv).add(replace).add(group_by).add(frequencies).add(sort).add(sort_by).add(some).add(map_keys).add(map_vals).add(run_BANG).add(merge).add(merge_with).add(merge_deep).add(disj).add(seq).add(repeat).add(repeatedly).add(cycle).add(meta).add(with_meta).add(vary_meta).add(alter_meta_BANG).add(reset_meta_BANG).add(identity).add(gensym).add(name).add(qualified_name).add(type).add(supertype).add(supertypes).add(instance_of_Q).add(highlight).add(ns_alias).add(ns_aliases).add(ns_unalias).toMap();

    public static boolean vector_Q(VncVal mv) {
        return Types.isVncVector(mv);
    }

    private static VncVal reduce_sequence(VncSequence seq, IVncFunction reduceFn, VncVal init) {
        MeterRegistry meterRegistry = ThreadContext.getMeterRegistry();
        if (init == null) {
            return seq.isEmpty() ? reduceFn.apply(VncList.empty()) : Reducer.reduce(reduceFn, seq.first(), seq.rest(), meterRegistry);
        }
        return Reducer.reduce(reduceFn, init, seq, meterRegistry);
    }

    private static VncVal reduce_queue(VncQueue queue, IVncFunction reduceFn, VncVal init) {
        MeterRegistry meterRegistry = ThreadContext.getMeterRegistry();
        if (init == null) {
            VncVal init_ = queue.take();
            return init_ == Constants.Nil ? reduceFn.apply(VncList.empty()) : Reducer.reduce(reduceFn, init_, queue, meterRegistry);
        }
        return Reducer.reduce(reduceFn, init, queue, meterRegistry);
    }

    private static VncVal sort(String fnName, VncVal coll) {
        return CoreFunctions.sort(fnName, coll, (x, y) -> Coerce.toVncLong(compare.apply(VncList.of(x, y))).getIntValue());
    }

    private static VncVal sort(String fnName, VncVal coll, Comparator<VncVal> c) {
        if (Types.isVncVector(coll)) {
            return VncVector.ofList(((VncVector)coll).stream().sorted(c).collect(Collectors.toList()));
        }
        if (Types.isVncSequence(coll)) {
            return VncList.ofList(((VncSequence)coll).stream().sorted(c).collect(Collectors.toList()));
        }
        if (Types.isVncSet(coll)) {
            return VncList.ofList(((VncSet)coll).stream().sorted(c).collect(Collectors.toList()));
        }
        if (Types.isVncMap(coll)) {
            return VncList.ofList(((VncMap)coll).toVncList().stream().sorted(c).collect(Collectors.toList()));
        }
        throw new VncException(String.format("%s: collection type %s not supported", fnName, Types.getType(coll)));
    }

    private static String renderCharLiteralsMarkdownTable() {
        return "| Char Literal                      | Unicode | Char | \n| [![width: 25%; text-align: left]] | :------ | :--- | \n" + VncChar.symbols().entrySet().stream().map(e -> String.format("| %s | %s | %s |", e.getKey(), ((VncChar)e.getValue()).toUnicode(), ((VncChar)e.getValue()).getValue().charValue() == '\u00b6' ? "#\\\\\u00b6" : ((VncChar)e.getValue()).toString(true))).collect(Collectors.joining("\n"));
    }
}

