/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.specialforms;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.env.Env;
import com.github.jlangch.venice.impl.javainterop.JavaImports;
import com.github.jlangch.venice.impl.namespaces.Namespace;
import com.github.jlangch.venice.impl.namespaces.Namespaces;
import com.github.jlangch.venice.impl.specialforms.util.SpecialFormsContext;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncSpecialForm;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncVector;
import com.github.jlangch.venice.impl.types.util.Coerce;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.impl.util.ArityExceptions;
import com.github.jlangch.venice.impl.util.SymbolMapBuilder;
import java.util.Map;
import java.util.function.Consumer;

public class SpecialForms_ImportFunctions {
    public static VncSpecialForm import_ = new VncSpecialForm("import", (VncVal)VncSpecialForm.meta().arglists("(import class & classes)", "(import class :as alias)").doc("Imports one or multiple Java classes. Imports are bound to the current namespace.\n\nAliases are helpful if Java classes have the same name but different packages like `java.util.Date` and `java.sql.Date`:\n\n```                                                  \n(do                                                  \n  (import :java.util.Date)                           \n  (import :java.sql.Date :as :sql.Date)              \n                                                     \n  (println (. :Date :new))                           \n  (println (. :sql.Date :valueOf \"2022-06-24\")))   \n```").examples("(do                        \n  (import :java.lang.Math) \n  (. :Math :max 2 10))      ", "(do                        \n  (import :java.awt.Point  \n          :java.lang.Math) \n  (. :Math :max 2 10))      ", "(do                        \n  (import :java.awt.Color :as :AwtColor)    \n  (. :AwtColor :new 200I 230I 255I 180I))   ", "(do                                                                            \n  (ns util)                                                                    \n  (defn import? [clazz ns_]                                                    \n    (any? #(== % clazz) (map first (imports ns_))))                            \n                                                                               \n  (ns alpha)                                                                   \n  (import :java.lang.Math)                                                     \n  (println \"alpha:\" (util/import? :java.lang.Math 'alpha))                   \n                                                                               \n  (ns beta)                                                                    \n  (println \"beta:\" (util/import? :java.lang.Math 'beta))                     \n                                                                               \n  (ns alpha)                                                                   \n  (println \"alpha:\" (util/import? :java.lang.Math 'alpha))                   \n)").seeAlso("imports").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncVal specialFormMeta, VncList args, Env env, SpecialFormsContext ctx) {
            ArityExceptions.assertMinArity("import", ArityExceptions.FnType.SpecialForm, args, 0);
            JavaImports jImports = Namespaces.getCurrentNamespace().getJavaImports();
            VncList args_ = args;
            while (!args_.isEmpty()) {
                VncVal def = args_.first();
                VncVal as = args_.second();
                if (Types.isVncKeyword(as) && "as".equals(((VncKeyword)as).getValue())) {
                    VncVal alias = args_.third();
                    if (alias != Constants.Nil) {
                        jImports.add(Coerce.toVncString(def).getValue(), Coerce.toVncString(alias).getValue());
                        args_ = args_.drop(3);
                        continue;
                    }
                    throw new VncException("Invalid Java import definition!");
                }
                jImports.add(Coerce.toVncString(def).getValue());
                args_ = args_.drop(1);
            }
            return Constants.Nil;
        }
    };
    public static VncSpecialForm imports_ = new VncSpecialForm("imports", (VncVal)VncSpecialForm.meta().arglists("(imports & options)", "(imports ns & options)").doc("Without namespace arg returns a list with the registered imports for the current namespace. With namespace arg returns a list with the registered imports for the given namespace. \n\nOptions:  \n\n| :print | print the import list to the current value of `*out*` | ").examples("(do                           \n  (import :java.lang.Math)    \n  (imports))                  ", "(do                           \n  (import :java.lang.Math)    \n  (imports :print))           ", "(do                           \n  (ns foo)                    \n  (import :java.lang.Math)    \n  (ns bar)                    \n  (imports 'foo))              ").seeAlso("import").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncVal specialFormMeta, VncList args, Env env, SpecialFormsContext ctx) {
            ArityExceptions.assertArity("imports", ArityExceptions.FnType.SpecialForm, args, 0, 1, 2);
            boolean print = Types.isVncKeyword(args.last()) && "print".equals(((VncKeyword)args.last()).getValue());
            VncList args_ = print ? args.butlast() : args;
            Namespace namespace = Namespaces.getCurrentNamespace();
            if (!args_.isEmpty()) {
                VncSymbol ns = Coerce.toVncSymbol(ctx.getEvaluator().evaluate(args.first(), env, false));
                namespace = ctx.getNsRegistry().get(ns);
                if (namespace == null) {
                    throw new VncException(String.format("The namespace '%s' does not exist", ns.toString()));
                }
            }
            VncList importList = namespace.getJavaImportsAsVncList();
            if (print) {
                VncFunction printFn = (VncFunction)env.get(new VncSymbol("println"));
                importList.forEach((Consumer<? super VncVal>)((Consumer<VncVal>)i -> printFn.applyOf(((VncVector)i).first(), new VncKeyword("as"), ((VncVector)i).second())));
                return Constants.Nil;
            }
            return importList;
        }
    };
    public static final Map<VncVal, VncVal> ns = new SymbolMapBuilder().add(import_).add(imports_).toMap();
}

