/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.specialforms;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.env.Env;
import com.github.jlangch.venice.impl.functions.CoreFunctions;
import com.github.jlangch.venice.impl.namespaces.Namespace;
import com.github.jlangch.venice.impl.namespaces.NamespaceRegistry;
import com.github.jlangch.venice.impl.namespaces.Namespaces;
import com.github.jlangch.venice.impl.specialforms.util.SpecialFormsContext;
import com.github.jlangch.venice.impl.specialforms.util.SpecialFormsUtil;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.INamespaceAware;
import com.github.jlangch.venice.impl.types.VncBoolean;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncSpecialForm;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncHashMap;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.util.Coerce;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.impl.util.ArityExceptions;
import com.github.jlangch.venice.impl.util.SymbolMapBuilder;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class SpecialForms_NamespaceFunctions {
    public static VncSpecialForm ns_new = new VncSpecialForm("ns", (VncVal)VncSpecialForm.meta().arglists("(ns sym)").doc("Opens a namespace.").examples("(do                               \n  (ns xxx)                        \n  (def foo 1)                     \n  (ns yyy)                        \n  (def foo 5)                     \n  (println xxx/foo foo yyy/foo))    ").seeAlso("*ns*", "ns?", "ns-unmap", "ns-remove", "ns-list", "ns-alias", "ns-meta", "namespace", "var-ns").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncVal specialFormMeta, VncList args, Env env, SpecialFormsContext ctx) {
            VncSymbol ns;
            SpecialFormsUtil.specialFormCallValidation(ctx, "ns");
            ArityExceptions.assertArity("ns", ArityExceptions.FnType.SpecialForm, args, 1);
            VncVal name = args.first();
            VncSymbol vncSymbol = ns = Types.isVncSymbol(name) ? (VncSymbol)name : (VncSymbol)CoreFunctions.symbol.apply(VncList.of(ctx.getEvaluator().evaluate(name, env, false)));
            if (ns.hasNamespace() && !"core".equals(ns.getNamespace())) {
                throw new VncException(String.format("A namespace '%s' must not have itself a namespace! However you can use '%s'.", ns.getQualifiedName(), ns.getNamespace() + "." + ns.getSimpleName()));
            }
            VncSymbol ns_ = new VncSymbol(ns.getSimpleName());
            if (Namespaces.isSystemNS(ns_.getSimpleName()) && ctx.getSealedSystemNS().get()) {
                throw new VncException("Namespace '" + ns_.getName() + "' cannot be reopened!");
            }
            Namespaces.setCurrentNamespace(ctx.getNsRegistry().computeIfAbsent(ns_));
            return ns_;
        }
    };
    public static VncSpecialForm ns_unmap = new VncSpecialForm("ns-unmap", (VncVal)VncSpecialForm.meta().arglists("(ns-unmap ns sym)").doc("Removes the mappings for the symbol from the namespace.").examples("(do                    \n  (ns foo)             \n  (def x 1)            \n  (ns-unmap 'foo 'x)   \n  (ns-unmap *ns* 'x))   ").seeAlso("ns", "*ns*", "ns-remove", "ns-list", "namespace", "var-ns").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncVal specialFormMeta, VncList args, Env env, SpecialFormsContext ctx) {
            SpecialFormsUtil.specialFormCallValidation(ctx, "ns-unmap");
            ArityExceptions.assertArity("ns-unmap", ArityExceptions.FnType.SpecialForm, args, 2);
            VncSymbol ns = Coerce.toVncSymbol(ctx.getEvaluator().evaluate(args.first(), env, false));
            if (Namespaces.isSystemNS(ns.getName()) && ctx.getSealedSystemNS().get()) {
                throw new VncException("Cannot remove a symbol from namespace '" + ns.getName() + "'!");
            }
            VncSymbol sym = Coerce.toVncSymbol(ctx.getEvaluator().evaluate(args.second(), env, false));
            env.removeGlobalSymbol(sym.withNamespace(ns));
            return Constants.Nil;
        }
    };
    public static VncSpecialForm ns_remove = new VncSpecialForm("ns-remove", (VncVal)VncSpecialForm.meta().arglists("(ns-remove ns)").doc("Removes the mappings for all symbols from the namespace.").examples("(do                                     \n  (ns foo)                              \n  (def x 1)                             \n  (ns bar)                              \n  (def y 1)                             \n  (ns-remove 'foo)                      \n  (println \"ns foo:\" (ns-list 'foo))  \n  (println \"ns bar:\" (ns-list 'bar)))   ").seeAlso("ns", "ns-unmap", "ns-list", "namespace", "var-ns").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncVal specialFormMeta, VncList args, Env env, SpecialFormsContext ctx) {
            SpecialFormsUtil.specialFormCallValidation(ctx, "ns-remove");
            ArityExceptions.assertArity("ns-remove", ArityExceptions.FnType.SpecialForm, args, 1);
            VncSymbol ns = Coerce.toVncSymbol(ctx.getEvaluator().evaluate(args.first(), env, false));
            VncSymbol nsCurr = Namespaces.getCurrentNS();
            if (Namespaces.isSystemNS(ns.getName()) && ctx.getSealedSystemNS().get()) {
                throw new VncException("Namespace '" + ns.getName() + "' cannot be removed!");
            }
            if (ns.equals(nsCurr)) {
                throw new VncException("The current samespace '" + nsCurr.getName() + "' cannot be removed!");
            }
            env.removeGlobalSymbolsByNS(ns);
            ctx.getNsRegistry().remove(ns);
            return Constants.Nil;
        }
    };
    public static VncSpecialForm ns_list = new VncSpecialForm("ns-list", (VncVal)VncSpecialForm.meta().arglists("(ns-list)", "(ns-list ns)").doc("Without arg lists the loaded namespaces, else lists all the symbols in the specified namespace ns.").examples("(ns-list 'regex)", "(ns-list)").seeAlso("ns", "*ns*", "ns-unmap", "ns-remove", "namespace", "var-ns").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncVal specialFormMeta, VncList args, Env env, SpecialFormsContext ctx) {
            SpecialFormsUtil.specialFormCallValidation(ctx, "ns-list");
            ArityExceptions.assertArity("ns-list", ArityExceptions.FnType.SpecialForm, args, 0, 1);
            if (args.isEmpty()) {
                return VncList.ofList(env.getAllGlobalSymbols().keySet().stream().filter(s -> s.hasNamespace()).map(s -> s.getNamespace()).distinct().sorted().map(s -> new VncString((String)s)).collect(Collectors.toList()));
            }
            VncSymbol ns = Coerce.toVncSymbol(ctx.getEvaluator().evaluate(args.first(), env, false));
            String nsCore = Namespaces.NS_CORE.getName();
            String nsName = nsCore.equals(ns.getName()) ? null : ns.getName();
            return VncList.ofList(env.getAllGlobalSymbols().keySet().stream().filter(s -> Objects.equals(nsName, s.getNamespace())).sorted().collect(Collectors.toList()));
        }
    };
    public static VncSpecialForm namespace = new VncSpecialForm("namespace", (VncVal)VncSpecialForm.meta().arglists("(namespace x)").doc("Returns the namespace string of a symbol, keyword, or function. If x is a registered namespace returns x. \n\nThrows an exception if x does not support namespaces like `(namespace 2)`.").examples("(namespace 'user/foo)", "(namespace :user/foo)", "(namespace str/digit?)", "(namespace *ns*)").seeAlso("name", "fn-name", "ns", "*ns*", "var-ns").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncVal specialFormMeta, VncList args, Env env, SpecialFormsContext ctx) {
            NamespaceRegistry nsRegistry;
            Namespace ns;
            VncSymbol sym;
            SpecialFormsUtil.specialFormCallValidation(ctx, "namespace");
            ArityExceptions.assertArity("namespace", ArityExceptions.FnType.SpecialForm, args, 1);
            VncVal val = ctx.getEvaluator().evaluate(args.first(), env, false);
            if (val instanceof VncSymbol && !(sym = (VncSymbol)val).hasNamespace() && (ns = (nsRegistry = ctx.getNsRegistry()).get((VncSymbol)val)) != null) {
                return new VncString(((VncSymbol)val).getName());
            }
            if (val instanceof INamespaceAware) {
                String ns2 = ((INamespaceAware)((Object)val)).getNamespace();
                return ns2 == null ? Constants.Nil : new VncString(ns2);
            }
            throw new VncException(String.format("The type '%s' does not support namespaces!", Types.getType(val)));
        }
    };
    public static VncSpecialForm ns_Q = new VncSpecialForm("ns?", (VncVal)VncSpecialForm.meta().arglists("(ns? n)").doc("Returns true if n is an existing namespace that has been defined with `(ns n)` else false.").examples("(do           \n  (ns foo)    \n  (ns? foo))  ").seeAlso("ns").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncVal specialFormMeta, VncList args, Env env, SpecialFormsContext ctx) {
            VncSymbol ns;
            SpecialFormsUtil.specialFormCallValidation(ctx, "ns?");
            ArityExceptions.assertArity("ns?", ArityExceptions.FnType.SpecialForm, args, 1);
            VncVal name = args.first();
            VncSymbol vncSymbol = ns = Types.isVncSymbol(name) ? (VncSymbol)name : (VncSymbol)CoreFunctions.symbol.apply(VncList.of(ctx.getEvaluator().evaluate(name, env, false)));
            if (ns.hasNamespace() && !"core".equals(ns.getNamespace())) {
                throw new VncException(String.format("A namespace '%s' must not have itself a namespace! However you can use '%s'.", ns.getQualifiedName(), ns.getNamespace() + "." + ns.getSimpleName()));
            }
            VncSymbol ns_ = new VncSymbol(ns.getSimpleName());
            Namespace n = ctx.getNsRegistry().get(ns_);
            return VncBoolean.of(n != null);
        }
    };
    public static VncSpecialForm ns_meta = new VncSpecialForm("ns-meta", (VncVal)VncSpecialForm.meta().arglists("(ns-meta n)").doc("Returns the meta data of the namespace n or `nil` if n is not an existing namespace").examples("(do               \n  (ns foo)        \n  (ns-meta foo))  ", "(do               \n  (ns foo)        \n  (ns-meta 'foo)) ", "(do                        \n  (ns foo)                 \n  (def n 'foo)             \n  (ns-meta (var-get n)))   ").seeAlso("alter-ns-meta!", "reset-ns-meta!", "ns").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncVal specialFormMeta, VncList args, Env env, SpecialFormsContext ctx) {
            VncSymbol ns;
            SpecialFormsUtil.specialFormCallValidation(ctx, "ns-meta");
            ArityExceptions.assertArity("ns-meta", ArityExceptions.FnType.SpecialForm, args, 1);
            VncVal name = args.first();
            VncSymbol vncSymbol = ns = Types.isVncSymbol(name) ? (VncSymbol)name : (VncSymbol)CoreFunctions.symbol.apply(VncList.of(ctx.getEvaluator().evaluate(name, env, false)));
            if (ns.hasNamespace() && !"core".equals(ns.getNamespace())) {
                throw new VncException(String.format("A namespace '%s' must not have itself a namespace! However you can use '%s'.", ns.getQualifiedName(), ns.getNamespace() + "." + ns.getSimpleName()));
            }
            VncSymbol ns_ = new VncSymbol(ns.getSimpleName());
            Namespace n = ctx.getNsRegistry().get(ns_);
            return n == null ? Constants.Nil : n.getMeta();
        }
    };
    public static VncSpecialForm reset_ns_meta_BANG = new VncSpecialForm("reset-ns-meta!", (VncVal)VncSpecialForm.meta().arglists("(reset-ns-meta! n datamap)").doc("Resets the metadata for a namespace").examples("(do                         \n  (ns foo)                  \n  (reset-ns-meta! foo {}))  ", "(do                                  \n  (ns foo)                           \n  (def n 'foo)                       \n  (reset-ns-meta! (var-get n) {})    \n  (pr-str (ns-meta (var-get n))))    ").seeAlso("ns-meta", "alter-ns-meta!", "ns").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncVal specialFormMeta, VncList args, Env env, SpecialFormsContext ctx) {
            VncSymbol ns;
            SpecialFormsUtil.specialFormCallValidation(ctx, "reset-ns-meta!");
            ArityExceptions.assertArity("reset-ns-meta!", ArityExceptions.FnType.SpecialForm, args, 2);
            VncVal name = args.first();
            VncHashMap meta = Coerce.toVncHashMap(args.second());
            VncSymbol vncSymbol = ns = Types.isVncSymbol(name) ? (VncSymbol)name : (VncSymbol)CoreFunctions.symbol.apply(VncList.of(ctx.getEvaluator().evaluate(name, env, false)));
            if (ns.hasNamespace() && !"core".equals(ns.getNamespace())) {
                throw new VncException(String.format("A namespace '%s' must not have itself a namespace! However you can use '%s'.", ns.getQualifiedName(), ns.getNamespace() + "." + ns.getSimpleName()));
            }
            VncSymbol ns_ = new VncSymbol(ns.getSimpleName());
            Namespace n = ctx.getNsRegistry().get(ns_);
            if (n != null) {
                n.setMeta(meta);
                return meta;
            }
            throw new VncException(String.format("The namespace '%s does not exist. It has not been create with (ns %s)!", ns.getSimpleName(), ns.getSimpleName()));
        }
    };
    public static VncSpecialForm alter_ns_meta_BANG = new VncSpecialForm("alter-ns-meta!", (VncVal)VncSpecialForm.meta().arglists("(alter-ns-meta! n f & args)").doc("Alters the metadata for a namespace. f must be free of side-effects.").examples("(do                                 \n  (ns foo)                          \n  (alter-ns-meta! foo assoc :a 1))  ", "(do                                          \n  (ns foo)                                   \n  (def n 'foo)                               \n  (alter-ns-meta! (var-get n) assoc :a 1)    \n  (pr-str (ns-meta (var-get n))))            ").seeAlso("ns-meta", "reset-ns-meta!", "ns").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncVal specialFormMeta, VncList args, Env env, SpecialFormsContext ctx) {
            VncSymbol ns;
            SpecialFormsUtil.specialFormCallValidation(ctx, "alter-ns-meta!");
            ArityExceptions.assertMinArity("alter-ns-meta!", ArityExceptions.FnType.SpecialForm, args, 2);
            VncVal name = args.first();
            VncFunction f = Coerce.toVncFunction(ctx.getEvaluator().evaluate(args.second(), env, false));
            VncList fArgs = (VncList)ctx.getValuesEvaluator().evaluate_values(args.slice(2), env);
            VncSymbol vncSymbol = ns = Types.isVncSymbol(name) ? (VncSymbol)name : (VncSymbol)CoreFunctions.symbol.apply(VncList.of(ctx.getEvaluator().evaluate(name, env, false)));
            if (ns.hasNamespace() && !"core".equals(ns.getNamespace())) {
                throw new VncException(String.format("A namespace '%s' must not have itself a namespace! However you can use '%s'.", ns.getQualifiedName(), ns.getNamespace() + "." + ns.getSimpleName()));
            }
            VncSymbol ns_ = new VncSymbol(ns.getSimpleName());
            Namespace n = ctx.getNsRegistry().get(ns_);
            if (n != null) {
                VncHashMap meta = n.getMeta();
                VncList fnArgs = VncList.of(meta).addAllAtEnd(fArgs);
                VncVal newMeta = f.apply(fnArgs);
                if (Types.isVncHashMap(newMeta)) {
                    n.setMeta((VncHashMap)newMeta);
                    return newMeta;
                }
                throw new VncException(String.format("The mapping function f that alters a namespace's meta data must return hash map instead of a value of type %s!", Types.getType(newMeta)));
            }
            throw new VncException(String.format("The namespace '%s does not exist. It has not been create with (ns %s)!", ns.getSimpleName(), ns.getSimpleName()));
        }
    };
    public static final Map<VncVal, VncVal> ns = new SymbolMapBuilder().add(ns_new).add(ns_list).add(ns_remove).add(ns_unmap).add(ns_meta).add(alter_ns_meta_BANG).add(reset_ns_meta_BANG).add(ns_Q).add(namespace).toMap();
}

