/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.specialforms;

import com.github.jlangch.venice.impl.env.Env;
import com.github.jlangch.venice.impl.env.Var;
import com.github.jlangch.venice.impl.namespaces.Namespaces;
import com.github.jlangch.venice.impl.specialforms.util.SpecialFormsContext;
import com.github.jlangch.venice.impl.specialforms.util.SpecialFormsUtil;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.VncBoolean;
import com.github.jlangch.venice.impl.types.VncSpecialForm;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.util.Coerce;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.impl.util.ArityExceptions;
import com.github.jlangch.venice.impl.util.SymbolMapBuilder;
import java.util.Map;

public class SpecialForms_VarFunctions {
    public static VncSpecialForm var_get = new VncSpecialForm("var-get", (VncVal)VncSpecialForm.meta().arglists("(var-get v)").doc("Returns a var's value.").examples("(var-get +)", "(var-get '+)", "(var-get (symbol \"+\"))", "((var-get +) 1 2)", "(do \n  (def x 10) \n  (var-get 'x))").seeAlso("var-ns", "var-name", "var-local?", "var-global?", "var-thread-local?").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncVal specialFormMeta, VncList args, Env env, SpecialFormsContext ctx) {
            SpecialFormsUtil.specialFormCallValidation(ctx, "var-get");
            ArityExceptions.assertArity("var-get", ArityExceptions.FnType.SpecialForm, args, 1);
            VncSymbol sym = Types.isVncSymbol(args.first()) ? (VncSymbol)args.first() : Coerce.toVncSymbol(ctx.getEvaluator().evaluate(args.first(), env, false));
            return env.getOrNil(sym);
        }
    };
    public static VncSpecialForm var_ns = new VncSpecialForm("var-ns", (VncVal)VncSpecialForm.meta().arglists("(var-ns v)").doc("Returns the namespace of the var's symbol").examples("(var-ns +)", "(var-ns '+)", "(var-ns (symbol \"+\"))", ";; aliased function \n(do \n  (ns foo) \n  (def add +)\n  (var-ns add))", "(do  \n  (def x 10) \n  (var-ns x))", "(let [x 10]\n  (var-ns x))", ";; compare with namespace \n(do \n  (ns foo) \n  (def add +)\n  (namespace add))", ";; compare aliased function with namespace \n(do \n  (ns foo) \n  (def add +)\n  (namespace add))").seeAlso("namespace", "var-get", "var-name", "var-local?", "var-global?", "var-thread-local?").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncVal specialFormMeta, VncList args, Env env, SpecialFormsContext ctx) {
            VncSymbol sym;
            SpecialFormsUtil.specialFormCallValidation(ctx, "var-ns");
            ArityExceptions.assertArity("var-ns", ArityExceptions.FnType.SpecialForm, args, 1);
            VncSymbol vncSymbol = sym = Types.isVncSymbol(args.first()) ? (VncSymbol)args.first() : Coerce.toVncSymbol(ctx.getEvaluator().evaluate(args.first(), env, false));
            if (sym.hasNamespace()) {
                return new VncString(sym.getNamespace());
            }
            if (env.isLocal(sym)) {
                return Constants.Nil;
            }
            Var v = env.getGlobalVarOrNull(sym);
            return v == null ? Constants.Nil : new VncString(v.getName().hasNamespace() ? v.getName().getNamespace() : Namespaces.NS_CORE.getName());
        }
    };
    public static VncSpecialForm var_name = new VncSpecialForm("var-name", (VncVal)VncSpecialForm.meta().arglists("(var-name v)").doc("Returns the name of the var's symbol").examples("(var-name +)", "(var-name '+)", "(var-name (symbol \"+\"))", ";; aliased function \n(do \n  (ns foo) \n  (def add +)\n  (var-name add))", "(do \n  (def x 10) \n  (var-name x))", "(let [x 10] \n  (var-name x))", ";; compare with name \n(do \n  (ns foo) \n  (def add +)\n  (name add))", ";; compare aliased function with name \n(do \n  (ns foo) \n  (def add +)\n  (name add))").seeAlso("name", "var-get", "var-ns", "var-local?", "var-global?", "var-thread-local?").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncVal specialFormMeta, VncList args, Env env, SpecialFormsContext ctx) {
            SpecialFormsUtil.specialFormCallValidation(ctx, "var-name");
            ArityExceptions.assertArity("var-name", ArityExceptions.FnType.SpecialForm, args, 1);
            VncSymbol sym = Types.isVncSymbol(args.first()) ? (VncSymbol)args.first() : Coerce.toVncSymbol(ctx.getEvaluator().evaluate(args.first(), env, false));
            return new VncString(sym.getSimpleName());
        }
    };
    public static VncSpecialForm var_localQ = new VncSpecialForm("var-local?", (VncVal)VncSpecialForm.meta().arglists("(var-local? v)").doc("Returns true if the var is local else false").examples("(var-local? +)", "(var-local? '+)", "(var-local? (symbol \"+\"))", "(do               \n  (def x 10)      \n  (var-local? x))   ", "(let [x 10]       \n  (var-local? x))   ").seeAlso("var-get", "var-ns", "var-name", "var-global?", "var-thread-local?").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncVal specialFormMeta, VncList args, Env env, SpecialFormsContext ctx) {
            ArityExceptions.assertArity("var-local?", ArityExceptions.FnType.SpecialForm, args, 1);
            VncSymbol sym = Types.isVncSymbol(args.first()) ? (VncSymbol)args.first() : Coerce.toVncSymbol(ctx.getEvaluator().evaluate(args.first(), env, false));
            return VncBoolean.of(env.isLocal(sym));
        }
    };
    public static VncSpecialForm var_thread_localQ = new VncSpecialForm("var-thread-local?", (VncVal)VncSpecialForm.meta().arglists("(var-thread-local? v)").doc("Returns true if the var is thread-local else false").examples("(binding [x 100] \n  (var-local? x))").seeAlso("var-get", "var-ns", "var-name", "var-local?", "var-global?").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncVal specialFormMeta, VncList args, Env env, SpecialFormsContext ctx) {
            ArityExceptions.assertArity("var-thread-local?", ArityExceptions.FnType.SpecialForm, args, 1);
            VncSymbol sym = Types.isVncSymbol(args.first()) ? (VncSymbol)args.first() : Coerce.toVncSymbol(ctx.getEvaluator().evaluate(args.first(), env, false));
            return VncBoolean.of(env.isDynamic(sym));
        }
    };
    public static VncSpecialForm var_globalQ = new VncSpecialForm("var-global?", (VncVal)VncSpecialForm.meta().arglists("(var-global? v)").doc("Returns true if the var is global else false").examples("(var-global? +)", "(var-global? '+)", "(var-global? (symbol \"+\"))", "(do                \n  (def x 10)       \n  (var-global? x))   ", "(let [x 10]        \n  (var-global? x))   ").seeAlso("var-get", "var-ns", "var-name", "var-local?", "var-thread-local?").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncVal specialFormMeta, VncList args, Env env, SpecialFormsContext ctx) {
            ArityExceptions.assertArity("var-global?", ArityExceptions.FnType.SpecialForm, args, 1);
            VncSymbol sym = Types.isVncSymbol(args.first()) ? (VncSymbol)args.first() : Coerce.toVncSymbol(ctx.getEvaluator().evaluate(args.first(), env, false));
            return VncBoolean.of(env.isGlobal(sym));
        }
    };
    public static final Map<VncVal, VncVal> ns = new SymbolMapBuilder().add(var_get).add(var_globalQ).add(var_localQ).add(var_name).add(var_ns).add(var_thread_localQ).toMap();
}

