/*   __    __         _
 *   \ \  / /__ _ __ (_) ___ ___
 *    \ \/ / _ \ '_ \| |/ __/ _ \
 *     \  /  __/ | | | | (_|  __/
 *      \/ \___|_| |_|_|\___\___|
 *
 *
 * Copyright 2017-2022 Venice
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.github.jlangch.venice.util.servlet;

import java.io.IOException;

import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.MultipartConfig;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.Part;


// MultipartConfig in web.xml
//    <servlet>
//        <servlet-name>StudentRegistrationUsn</servlet-name>
//        <servlet-class>com.example.StudentRegistrationUsn</servlet-class>
//        <multipart-config>
//            <max-file-size>10485760</max-file-size>
//            <max-request-size>20971520</max-request-size>
//            <file-size-threshold>5242880</file-size-threshold>
//        </multipart-config>
//    </servlet>
//    <servlet-mapping>
//        <servlet-name>StudentRegistrationUsn</servlet-name>
//        <url-pattern>/university/student/registration</url-pattern>
//    </servlet-mapping>


@MultipartConfig(
        maxFileSize = 1024*1024*1024,       // 1 GB
        maxRequestSize = 1024*1024*1024*3,  // 3 GB
        fileSizeThreshold = 1024*1024*100)  // 100 MB
public class VeniceFileUploadServlet extends VeniceServlet {

    public VeniceFileUploadServlet(final IVeniceServlet delegate) {
        super(delegate);
    }

    @Override
    protected void doPost(
            final HttpServletRequest req,
            final HttpServletResponse resp
    ) throws ServletException, IOException {
        // Triggers the lazy load of the parameter map for POST "application/x-www-form-urlencoded"
        // requests. Accessing req.getParameterMap() via reflection does not seem to load
        // the parameter map from x-www-form-urlencoded body.
        req.getParameterMap();

        final Part filePart = req.getPart("file");
        final String fileName = filePart.getSubmittedFileName();
        for (Part part : req.getParts()) {
            part.write("/tmp/upload/" + fileName);
        }
        resp.getWriter().print("The file uploaded sucessfully.");
    }


    private static final long serialVersionUID = 7024848763477707717L;
}
