/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.functions;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.functions.IOFunctionsStreams;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.VncChar;
import com.github.jlangch.venice.impl.types.VncConstant;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncHashMap;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.util.Coerce;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.impl.util.ArityExceptions;
import com.github.jlangch.venice.impl.util.SymbolMapBuilder;
import com.github.jlangch.venice.impl.util.csv.CSVReader;
import com.github.jlangch.venice.impl.util.csv.CSVWriter;
import com.github.jlangch.venice.impl.util.io.CharsetUtil;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CsvFunctions {
    public static VncFunction read = new VncFunction("csv/read", (VncVal)VncFunction.meta().arglists("(csv/read source & options)").doc("Reads CSV-data from a source.                                     \n\nThe source may be a:                                              \n\n * `string`                                                       \n * `bytebuf`                                                      \n * `java.io.File`, e.g: `(io/file \"/temp/foo.json\")`            \n * `java.nio.Path`,                                  `            \n * `java.io.InputStream`                                          \n * `java.io.Reader`                                               \n\nOptions:\n\n| :encoding enc  | used when reading from a binary data source                    e.g :encoding :utf-8, defaults to :utf-8 |\n| :separator val | e.g. \",\", defaults to a comma |\n| :quote val     | e.g. \"'\", defaults to a double quote |").examples("(csv/read \"1,\\\"ab\\\",false\")", "(csv/read \"1:::'ab':false\" :separator \":\" :quote \"'\")").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertMinArity(this, args, 1);
            this.sandboxFunctionCallValidation();
            try {
                Reader rd;
                VncVal source = args.first();
                VncHashMap options = VncHashMap.ofAll(args.rest());
                char separator = CsvFunctions.toChar(options.get(new VncKeyword("separator")), ',');
                char quote = CsvFunctions.toChar(options.get(new VncKeyword("quote")), '\"');
                CSVReader parser = new CSVReader(separator, quote);
                if (Types.isVncString(source)) {
                    return CsvFunctions.map(parser.parse(((VncString)source).getValue()));
                }
                if (Types.isVncJavaObject(source, File.class) || Types.isVncJavaObject(source, Path.class)) {
                    InputStream fileIS = Coerce.toVncJavaObject(IOFunctionsStreams.io_file_in_stream.applyOf(source), InputStream.class);
                    VncVal encVal = options.get(new VncKeyword("encoding"));
                    try (InputStream is = fileIS;){
                        VncList vncList = CsvFunctions.map(parser.parse(is, CharsetUtil.charset(encVal)));
                        return vncList;
                    }
                }
                if (Types.isVncJavaObject(source, InputStream.class)) {
                    InputStream is = (InputStream)Coerce.toVncJavaObject(args.first()).getDelegate();
                    VncVal encVal = options.get(new VncKeyword("encoding"));
                    try (InputStream is_ = is;){
                        VncList vncList = CsvFunctions.map(parser.parse(is_, CharsetUtil.charset(encVal)));
                        return vncList;
                    }
                }
                if (!Types.isVncJavaObject(source, Reader.class)) {
                    throw new VncException(String.format("Function 'csv/read' does not allow %s as source", Types.getType(args.first())));
                }
                try (Reader rd_ = rd = (Reader)Coerce.toVncJavaObject(args.first()).getDelegate();){
                    VncList vncList = CsvFunctions.map(parser.parse(rd_));
                    return vncList;
                }
            }
            catch (VncException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new VncException(ex.getMessage(), ex);
            }
        }
    };
    public static VncFunction write = new VncFunction("csv/write", (VncVal)VncFunction.meta().arglists("(csv/write sink records & options)").doc("Spits data to a sink in CSV format.\n\nThe sink may be a:                                            \n\n * `java.io.File`, e.g: `(io/file \"/temp/foo.json\")`       \n * `java.nio.Path`                                           \n * `java.io.OutputStream`                                    \n * `java.io.Writer`                                          \n\nOptions:\n\n| :separator val | e.g. \",\", defaults to a comma |\n| :quote val     | e.g. \"'\", defaults to a double quote |\n| :newline val   | :lf (default) or :cr+lf |\n| :encoding enc  | used when writing to a binary data sink.                    e.g :encoding :utf-8, defaults to :utf-8 |").examples("(csv/write (io/file \"test.csv\") [[1 \"AC\" false] [2 \"WS\" true]])").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertMinArity(this, args, 2);
            this.sandboxFunctionCallValidation();
            try {
                Object out = Coerce.toVncJavaObject(args.first()).getDelegate();
                VncHashMap options = VncHashMap.ofAll(args.rest().rest());
                char separator = CsvFunctions.toChar(options.get(new VncKeyword("separator")), ',');
                char quote = CsvFunctions.toChar(options.get(new VncKeyword("quote")), '\"');
                String newline = CsvFunctions.toNewLine(options.get(new VncKeyword("newline")));
                String encoding = CsvFunctions.encoding(options.get(new VncKeyword("encoding")));
                CSVWriter csvWriter = new CSVWriter(separator, quote, newline);
                if (out instanceof File || out instanceof Path) {
                    OutputStream os = Coerce.toVncJavaObject(IOFunctionsStreams.io_file_out_stream.applyOf(args.first()), OutputStream.class);
                    try (OutputStreamWriter wr = new OutputStreamWriter(os, encoding);){
                        csvWriter.write((Writer)wr, Coerce.toVncSequence(args.second()));
                        VncConstant vncConstant = Constants.Nil;
                        return vncConstant;
                    }
                }
                if (out instanceof OutputStream) {
                    try (OutputStreamWriter wr = new OutputStreamWriter((OutputStream)out, encoding);){
                        csvWriter.write((Writer)wr, Coerce.toVncSequence(args.second()));
                        VncConstant vncConstant = Constants.Nil;
                        return vncConstant;
                    }
                }
                if (!(out instanceof Writer)) {
                    throw new VncException(String.format("Function 'csv/write' does not allow %s as sink", Types.getType(args.first())));
                }
                try (Writer wr = (Writer)out;){
                    csvWriter.write(wr, Coerce.toVncSequence(args.second()));
                    VncConstant vncConstant = Constants.Nil;
                    return vncConstant;
                }
            }
            catch (VncException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new VncException(ex.getMessage(), ex);
            }
        }
    };
    public static VncFunction write_str = new VncFunction("csv/write-str", (VncVal)VncFunction.meta().arglists("(csv/write-str records & options)").doc("Writes data to a string in CSV format.\n\nOptions:\n\n| :separator val | e.g. \",\", defaults to a comma |\n| :quote val     | e.g. \"'\", defaults to a double quote |\n| :newline val   | :lf (default) or :cr+lf |").examples("(csv/write-str [[1 \"AC\" false] [2 \"WS\" true]])", "(csv/write-str [[1 \"AC\" false] [2 \"WS, '-1'\" true]]\n               :quote \"'\"\n               :separator \",\"\n               :newline :cr+lf)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertMinArity(this, args, 1);
            try {
                VncHashMap options = VncHashMap.ofAll(args.rest());
                char separator = CsvFunctions.toChar(options.get(new VncKeyword("separator")), ',');
                char quote = CsvFunctions.toChar(options.get(new VncKeyword("quote")), '\"');
                String newline = CsvFunctions.toNewLine(options.get(new VncKeyword("newline")));
                CSVWriter csvWriter = new CSVWriter(separator, quote, newline);
                StringWriter sw = new StringWriter();
                csvWriter.write((Writer)sw, Coerce.toVncSequence(args.first()));
                return new VncString(sw.toString());
            }
            catch (VncException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new VncException(ex.getMessage(), ex);
            }
        }
    };
    public static final Map<VncVal, VncVal> ns = new SymbolMapBuilder().add(read).add(write).add(write_str).toMap();

    private static VncList map(List<List<String>> data) {
        ArrayList<VncList> vncRecords = new ArrayList<VncList>();
        for (List<String> record : data) {
            ArrayList<VncConstant> vncRecord = new ArrayList<VncConstant>();
            for (String s : record) {
                vncRecord.add((VncConstant)(s == null ? Constants.Nil : new VncString(s)));
            }
            vncRecords.add(VncList.ofList(vncRecord));
        }
        return VncList.ofList(vncRecords);
    }

    private static char toChar(VncVal v, char defaultChar) {
        if (v == Constants.Nil) {
            return defaultChar;
        }
        if (Types.isVncChar(v)) {
            return ((VncChar)v).getValue().charValue();
        }
        if (Types.isVncString(v)) {
            String s = ((VncString)v).getValue();
            return s.isEmpty() ? defaultChar : s.charAt(0);
        }
        return defaultChar;
    }

    private static String toNewLine(VncVal v) {
        if (Types.isVncKeyword(v)) {
            String s = ((VncKeyword)v).getValue();
            if (s.equals("lf")) {
                return "\n";
            }
            if (s.equals("cr+lf")) {
                return "\r\n";
            }
            return "\n";
        }
        if (Types.isVncString(v)) {
            return ((VncString)v).getValue();
        }
        return "\n";
    }

    private static String encoding(VncVal enc) {
        return enc == Constants.Nil ? "UTF-8" : (Types.isVncKeyword(enc) ? Coerce.toVncKeyword(enc).getValue() : Coerce.toVncString(enc).getValue());
    }
}

