/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.functions;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.functions.CoreFunctions;
import com.github.jlangch.venice.impl.functions.FunctionsUtil;
import com.github.jlangch.venice.impl.thread.ThreadContext;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.IVncFunction;
import com.github.jlangch.venice.impl.types.VncBoolean;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncLong;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncCollection;
import com.github.jlangch.venice.impl.types.collections.VncHashMap;
import com.github.jlangch.venice.impl.types.collections.VncLazySeq;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncMap;
import com.github.jlangch.venice.impl.types.collections.VncSequence;
import com.github.jlangch.venice.impl.types.collections.VncSet;
import com.github.jlangch.venice.impl.types.collections.VncVector;
import com.github.jlangch.venice.impl.types.util.Coerce;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.impl.util.ArityExceptions;
import com.github.jlangch.venice.impl.util.MeterRegistry;
import com.github.jlangch.venice.impl.util.SymbolMapBuilder;
import com.github.jlangch.venice.impl.util.transducer.Reduced;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public class TransducerFunctions {
    public static VncFunction transduce = new VncFunction("transduce", (VncVal)VncFunction.meta().arglists("(transduce xform f coll)", "(transduce xform f init coll)").doc("Reduce with a transformation of a reduction function f (xf). If init is not supplied, `(f)` will be called to produce it. f should be a reducing step function that accepts both 1 and 2 arguments. Returns the result of applying (the transformed) xf to init and the first item in coll, then applying xf to that result and the 2nd item, etc. If coll contains no items, returns init and f is not called.\n\n`transduce` can work with queues as collection, given that the end of the queue is marked by addding a `nil` element. Otherwise the transducer does not not when to stop reading elements from the queue.\n\n```\nTransformations            Reductions            Control   \n----------------------     ------------------    --------- \nmap        map-indexed     rf-first              halt-when \nfilter     flatten         rf-last                         \ndrop       drop-while      rf-any?                         \ndrop-last  remove          rf-every?                       \ntake       take-while                                      \ntake-last  keep            conj                            \ndedupe     distinct        +, *                            \nsorted     reverse         max, min                        \n```").examples("(transduce identity + [1 2 3 4])", "(transduce (map #(+ % 3)) + [1 2 3 4])", "(transduce identity max [1 2 3])", "(transduce identity rf-last [1 2 3])", "(transduce identity (rf-every? pos?) [1 2 3])", "(transduce (map inc) conj [1 2 3])", ";; transduce all elements of a queue. calls (take! queue) to get the   \n;; elements of the queue.                                              \n;; note: use nil to mark the end of the queue otherwise transduce will \n;;       block forever!                                                \n(let [q (conj! (queue) 1 2 3 nil)]                                     \n  (transduce (map inc) conj q))                                        ", "(do                                       \n  (def xform (comp (drop 2) (take 3)))    \n  (transduce xform conj [1 2 3 4 5 6]))     ", "(do                                       \n  (def xform (comp                        \n               (map #(* % 10))            \n               (map #(+ % 1))             \n               (sorted compare)           \n               (drop 3)                   \n               (take 2)                   \n               (reverse)))                \n  (transduce xform conj [1 2 3 4 5 6]))     ").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 3, 4);
            VncFunction xform = Coerce.toVncFunction(args.first());
            VncFunction reduction_fn = Coerce.toVncFunction(args.second());
            VncCollection coll = Coerce.toVncCollection(args.last());
            xform.sandboxFunctionCallValidation();
            reduction_fn.sandboxFunctionCallValidation();
            VncVal init = args.size() == 4 ? args.third() : reduction_fn.apply(VncList.empty());
            VncFunction xf = (VncFunction)xform.apply(VncList.of(reduction_fn));
            xf.sandboxFunctionCallValidation();
            VncVal ret = CoreFunctions.reduce.apply(VncList.of(xf, init, coll));
            return Reduced.unreduced(xf.apply(VncList.of(ret)));
        }
    };
    public static VncFunction reduced = new VncFunction("reduced", (VncVal)VncFunction.meta().arglists("(reduced x)").doc("Wraps x in a way such that a reduce will terminate with the value x.").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            return Reduced.reduced(args.first());
        }
    };
    public static VncFunction reduced_Q = new VncFunction("reduced?", (VncVal)VncFunction.meta().arglists("(reduced? x)").doc("Returns true if x is the result of a call to reduced.").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            return VncBoolean.of(Reduced.isReduced(args.first()));
        }
    };
    public static VncFunction map = new VncFunction("map", (VncVal)VncFunction.meta().arglists("(map f coll colls*)").doc("Applys f to the set of first items of each coll, followed by applying f to the set of second items in each coll, until any one of the colls is exhausted. Any remaining items in other colls are ignored.\u00b6Returns a transducer when no collection is provided.").examples("(map inc [1 2 3 4])", "(map + [1 2 3 4] [10 20 30 40])", "(map list '(1 2 3 4) '(10 20 30 40))", "(map vector (lazy-seq 1 inc) [10 20 30 40])", "(map (fn [e] [(key e) (inc (val e))]) {:a 1 :b 2})", "(map inc #{1 2 3})").seeAlso("filter", "reduce", "map-indexed").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            MeterRegistry meterRegistry = ThreadContext.getMeterRegistry();
            if (args.size() == 0) {
                return Constants.Nil;
            }
            if (args.size() == 1) {
                final IVncFunction fn = Coerce.toIVncFunction(args.first());
                fn.sandboxFunctionCallValidation();
                return new VncFunction(4.createAnonymousFuncName("map:transducer:wrapped")){
                    private static final long serialVersionUID = -1L;

                    @Override
                    public VncVal apply(VncList args) {
                        ArityExceptions.assertArity(this, args, 1);
                        final IVncFunction rf = Coerce.toIVncFunction(args.first());
                        rf.sandboxFunctionCallValidation();
                        return new VncFunction(1.createAnonymousFuncName("map:transducer")){
                            private static final long serialVersionUID = -1L;

                            @Override
                            public VncVal apply(VncList args) {
                                switch (args.size()) {
                                    case 0: {
                                        return rf.apply(VncList.empty());
                                    }
                                    case 1: {
                                        return rf.apply(VncList.of(args.first()));
                                    }
                                    case 2: {
                                        VncVal result = args.first();
                                        VncVal input = args.second();
                                        return rf.apply(VncList.of(result, fn.apply(VncList.of(input))));
                                    }
                                }
                                ArityExceptions.assertArity(this, args, 0, 1, 2);
                                return Constants.Nil;
                            }
                        };
                    }
                };
            }
            IVncFunction fn = Coerce.toIVncFunction(args.first());
            VncList lists = FunctionsUtil.removeNilValues(args.rest());
            ArrayList<VncVal> result = new ArrayList<VncVal>();
            if (lists.isEmpty()) {
                return Constants.Nil;
            }
            if (lists.size() == 1) {
                VncSequence seq = VncSequence.coerceToSequence(lists.first());
                seq = meterRegistry.enabled ? seq.map(v -> VncFunction.applyWithMeter(fn, VncList.of(v), meterRegistry)) : seq.map(v -> fn.apply(VncList.of(v)));
                return seq instanceof VncLazySeq ? seq : seq.toVncList();
            }
            VncSequence[] seqs = new VncSequence[lists.size()];
            for (int ii = 0; ii < lists.size(); ++ii) {
                seqs[ii] = VncSequence.coerceToSequence(lists.nth(ii));
            }
            while (!TransducerFunctions.isOneEmpty(seqs)) {
                ArrayList<VncVal> fnArgs = new ArrayList<VncVal>();
                for (int ii = 0; ii < seqs.length; ++ii) {
                    fnArgs.add(seqs[ii].first());
                    seqs[ii] = seqs[ii].rest();
                }
                VncVal val = VncFunction.applyWithMeter(fn, VncList.ofList(fnArgs), meterRegistry);
                result.add(val);
            }
            return VncList.ofList(result);
        }
    };
    public static VncFunction map_indexed = new VncFunction("map-indexed", (VncVal)VncFunction.meta().arglists("(map-indexed f coll)").doc("Returns a collection of applying f to 0 and the first item of coll, followed by applying f to 1 and the second item of coll, etc. until coll is exhausted.\u00b6Returns a stateful transducer when no collection is provided.").examples("(map-indexed (fn [idx val] [idx val]) [:a :b :c])", "(map-indexed vector [:a :b :c])", ";; start at index 1 instead of zero \n(map-indexed #(vector (inc %1) %2) [:a :b :c])", "(map-indexed vector \"abcdef\")", "(map-indexed hash-map [:a :b :c])").seeAlso("map").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            VncCollection items;
            MeterRegistry meterRegistry = ThreadContext.getMeterRegistry();
            if (args.size() == 0) {
                return Constants.Nil;
            }
            if (args.size() == 1) {
                final IVncFunction fn = Coerce.toIVncFunction(args.first());
                fn.sandboxFunctionCallValidation();
                return new VncFunction(5.createAnonymousFuncName("map-indexed:transducer:wrapped")){
                    private static final long serialVersionUID = -1L;

                    @Override
                    public VncVal apply(VncList args) {
                        ArityExceptions.assertArity(this, args, 1);
                        final VncFunction rf = Coerce.toVncFunction(args.first());
                        rf.sandboxFunctionCallValidation();
                        final AtomicLong idx = new AtomicLong(0L);
                        return new VncFunction(1.createAnonymousFuncName("map-indexed:transducer")){
                            private static final long serialVersionUID = -1L;

                            @Override
                            public VncVal apply(VncList args) {
                                switch (args.size()) {
                                    case 0: {
                                        return rf.apply(VncList.empty());
                                    }
                                    case 1: {
                                        return rf.apply(VncList.of(args.first()));
                                    }
                                    case 2: {
                                        VncVal result = args.first();
                                        VncVal input = args.second();
                                        return rf.apply(VncList.of(result, fn.apply(VncList.of(new VncLong(idx.getAndIncrement()), input))));
                                    }
                                }
                                ArityExceptions.assertArity(this, args, 0, 1, 2);
                                return Constants.Nil;
                            }
                        };
                    }
                };
            }
            VncFunction fn = Coerce.toVncFunction(args.first());
            fn.sandboxFunctionCallValidation();
            VncVal coll = args.second();
            if (Types.isVncSequence(coll)) {
                items = (VncSequence)coll;
            } else if (Types.isVncSet(coll)) {
                items = (VncSet)coll;
            } else if (Types.isVncMap(coll)) {
                items = ((VncMap)coll).toVncList();
            } else if (Types.isVncString(coll)) {
                items = ((VncString)coll).toVncList();
            } else {
                throw new VncException("Function 'map-indexed' requires a list, vector, set, map, or string as coll argument.");
            }
            ArrayList<VncVal> list = new ArrayList<VncVal>();
            int index = 0;
            Iterator iterator = items.iterator();
            while (iterator.hasNext()) {
                VncVal v = (VncVal)iterator.next();
                list.add(VncFunction.applyWithMeter(fn, VncList.of(new VncLong(index++), v), meterRegistry));
            }
            return VncList.ofList(list);
        }
    };
    public static VncFunction filter = new VncFunction("filter", (VncVal)VncFunction.meta().arglists("(filter predicate coll)").doc("Returns a collection of the items in coll for which `(predicate item)` returns logical true.\u00b6Returns a transducer when no collection is provided.").examples("(filter even? [1 2 3 4 5 6 7])", "(filter #(even? (val %)) {:a 1 :b 2})", "(filter even? #{1 2 3})").seeAlso("map", "reduce").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1, 2);
            MeterRegistry meterRegistry = ThreadContext.getMeterRegistry();
            final IVncFunction predicate = Coerce.toIVncFunction(args.first());
            predicate.sandboxFunctionCallValidation();
            if (args.size() == 1) {
                return new VncFunction(6.createAnonymousFuncName("filter:transducer:wrapped")){
                    private static final long serialVersionUID = -1L;

                    @Override
                    public VncVal apply(VncList args) {
                        ArityExceptions.assertArity(this, args, 1);
                        final VncFunction rf = Coerce.toVncFunction(args.first());
                        rf.sandboxFunctionCallValidation();
                        return new VncFunction(1.createAnonymousFuncName("filter:transducer")){
                            private static final long serialVersionUID = -1L;

                            @Override
                            public VncVal apply(VncList args) {
                                switch (args.size()) {
                                    case 0: {
                                        return rf.apply(VncList.empty());
                                    }
                                    case 1: {
                                        return rf.apply(VncList.of(args.first()));
                                    }
                                    case 2: {
                                        VncVal result = args.first();
                                        VncVal input = args.second();
                                        VncVal cond = predicate.apply(VncList.of(input));
                                        return !VncBoolean.isFalseOrNil(cond) ? rf.apply(VncList.of(result, input)) : result;
                                    }
                                }
                                ArityExceptions.assertArity(this, args, 0, 1, 2);
                                return Constants.Nil;
                            }
                        };
                    }
                };
            }
            VncSequence seq = VncSequence.coerceToSequence(args.second());
            seq = meterRegistry.enabled ? seq.filter(v -> !VncBoolean.isFalseOrNil(VncFunction.applyWithMeter(predicate, VncList.of(v), meterRegistry))) : seq.filter(v -> !VncBoolean.isFalseOrNil(predicate.apply(VncList.of(v))));
            return seq instanceof VncLazySeq ? seq : seq.toVncList();
        }
    };
    public static VncFunction drop = new VncFunction("drop", (VncVal)VncFunction.meta().arglists("(drop n coll)").doc("Returns a collection of all but the first n items in coll.\u00b6Returns a stateful transducer when no collection is provided.").examples("(drop 3 [1 2 3 4 5])", "(drop 10 [1 2 3 4 5])").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1, 2);
            if (args.size() == 1) {
                final long n = Coerce.toVncLong(args.first()).getValue();
                return new VncFunction(7.createAnonymousFuncName("drop:transducer:wrapped")){
                    private static final long serialVersionUID = -1L;

                    @Override
                    public VncVal apply(VncList args) {
                        ArityExceptions.assertArity(this, args, 1);
                        final VncFunction rf = Coerce.toVncFunction(args.first());
                        rf.sandboxFunctionCallValidation();
                        final AtomicLong nn = new AtomicLong(n);
                        return new VncFunction(1.createAnonymousFuncName("drop:transducer")){
                            private static final long serialVersionUID = -1L;

                            @Override
                            public VncVal apply(VncList args) {
                                switch (args.size()) {
                                    case 0: {
                                        return rf.apply(VncList.empty());
                                    }
                                    case 1: {
                                        return rf.apply(VncList.of(args.first()));
                                    }
                                    case 2: {
                                        VncVal result = args.first();
                                        VncVal input = args.second();
                                        return nn.getAndDecrement() > 0L ? result : rf.apply(VncList.of(result, input));
                                    }
                                }
                                ArityExceptions.assertArity(this, args, 0, 1, 2);
                                return Constants.Nil;
                            }
                        };
                    }
                };
            }
            VncLong n = Coerce.toVncLong(args.first());
            VncSequence coll = VncSequence.coerceToSequence(args.second());
            return coll.drop(n.getIntValue());
        }
    };
    public static VncFunction drop_while = new VncFunction("drop-while", (VncVal)VncFunction.meta().arglists("(drop-while predicate coll)").doc("Returns a list of the items in coll starting from the first item for which `(predicate item)` returns logical false.\u00b6Returns a stateful transducer when no collection is provided.").examples("(drop-while neg? [-2 -1 0 1 2 3])").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1, 2);
            MeterRegistry meterRegistry = ThreadContext.getMeterRegistry();
            final IVncFunction predicate = Coerce.toIVncFunction(args.first());
            predicate.sandboxFunctionCallValidation();
            if (args.size() == 1) {
                return new VncFunction(8.createAnonymousFuncName("drop-while:transducer:wrapped")){
                    private static final long serialVersionUID = -1L;

                    @Override
                    public VncVal apply(VncList args) {
                        ArityExceptions.assertArity(this, args, 1);
                        final VncFunction rf = Coerce.toVncFunction(args.first());
                        rf.sandboxFunctionCallValidation();
                        final AtomicBoolean take = new AtomicBoolean(false);
                        return new VncFunction(1.createAnonymousFuncName("drop-while:transducer")){
                            private static final long serialVersionUID = -1L;

                            @Override
                            public VncVal apply(VncList args) {
                                switch (args.size()) {
                                    case 0: {
                                        return rf.apply(VncList.empty());
                                    }
                                    case 1: {
                                        return rf.apply(VncList.of(args.first()));
                                    }
                                    case 2: {
                                        VncVal result = args.first();
                                        VncVal input = args.second();
                                        if (take.get()) {
                                            return rf.apply(VncList.of(result, input));
                                        }
                                        VncVal drop = predicate.apply(VncList.of(input));
                                        if (VncBoolean.isFalseOrNil(drop)) {
                                            take.set(true);
                                            return rf.apply(VncList.of(result, input));
                                        }
                                        return result;
                                    }
                                }
                                ArityExceptions.assertArity(this, args, 0, 1, 2);
                                return Constants.Nil;
                            }
                        };
                    }
                };
            }
            VncSequence coll = VncSequence.coerceToSequence(args.second());
            return coll.dropWhile(v -> !VncBoolean.isFalseOrNil(VncFunction.applyWithMeter(predicate, VncList.of(v), meterRegistry)));
        }
    };
    public static VncFunction drop_last = new VncFunction("drop-last", (VncVal)VncFunction.meta().arglists("(drop-last n coll)").doc("Return a sequence of all but the last n items in coll.\u00b6Returns a stateful transducer when no collection is provided.").examples("(drop-last 3 [1 2 3 4 5])", "(drop-last 10 [1 2 3 4 5])").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1, 2);
            if (args.size() == 1) {
                final int n = Math.max(0, Coerce.toVncLong(args.first()).getValue().intValue());
                return new VncFunction(9.createAnonymousFuncName("drop-last:transducer:wrapped")){
                    private static final long serialVersionUID = -1L;

                    @Override
                    public VncVal apply(VncList args) {
                        ArityExceptions.assertArity(this, args, 1);
                        final VncFunction rf = Coerce.toVncFunction(args.first());
                        rf.sandboxFunctionCallValidation();
                        final ArrayList list = new ArrayList();
                        return new VncFunction(1.createAnonymousFuncName("drop-last:transducer")){
                            private static final long serialVersionUID = -1L;

                            @Override
                            public VncVal apply(VncList args) {
                                switch (args.size()) {
                                    case 0: {
                                        return rf.apply(VncList.empty());
                                    }
                                    case 1: {
                                        VncVal result = args.first();
                                        VncList dropList = list.size() > n ? VncList.ofList(list.subList(0, list.size() - n)) : VncList.empty();
                                        result = CoreFunctions.reduce.apply(VncList.of(rf, result, dropList));
                                        return rf.apply(VncList.of(result));
                                    }
                                    case 2: {
                                        VncVal result = args.first();
                                        VncVal input = args.second();
                                        list.add(input);
                                        return result;
                                    }
                                }
                                ArityExceptions.assertArity(this, args, 0, 1, 2);
                                return Constants.Nil;
                            }
                        };
                    }
                };
            }
            VncLong n = Coerce.toVncLong(args.first());
            VncSequence coll = VncSequence.coerceToSequence(args.second());
            return coll.dropRight(n.getIntValue());
        }
    };
    public static VncFunction take = new VncFunction("take", (VncVal)VncFunction.meta().arglists("(take n coll)").doc("Returns a collection of the first n items in coll, or all items if there are fewer than n.\u00b6Returns a stateful transducer when no collection is provided. \nReturns a lazy sequence if coll is a lazy sequence.").examples("(take 3 [1 2 3 4 5])", "(take 10 [1 2 3 4 5])", "(doall (take 4 (repeat 3)))", "(doall (take 10 (cycle (range 0 3))))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1, 2);
            if (args.size() == 1) {
                final long n = Coerce.toVncLong(args.first()).getValue();
                return new VncFunction(10.createAnonymousFuncName("take:transducer:wrapped")){
                    private static final long serialVersionUID = -1L;

                    @Override
                    public VncVal apply(VncList args) {
                        ArityExceptions.assertArity(this, args, 1);
                        final VncFunction rf = Coerce.toVncFunction(args.first());
                        rf.sandboxFunctionCallValidation();
                        final AtomicLong nn = new AtomicLong(n);
                        return new VncFunction(1.createAnonymousFuncName("take:transducer")){
                            private static final long serialVersionUID = -1L;

                            @Override
                            public VncVal apply(VncList args) {
                                switch (args.size()) {
                                    case 0: {
                                        return rf.apply(VncList.empty());
                                    }
                                    case 1: {
                                        return rf.apply(VncList.of(args.first()));
                                    }
                                    case 2: {
                                        VncVal result = args.first();
                                        VncVal input = args.second();
                                        return nn.getAndDecrement() > 0L ? rf.apply(VncList.of(result, input)) : Reduced.reduced(result);
                                    }
                                }
                                ArityExceptions.assertArity(this, args, 0, 1, 2);
                                return Constants.Nil;
                            }
                        };
                    }
                };
            }
            VncLong n = Coerce.toVncLong(args.first());
            VncSequence coll = VncSequence.coerceToSequence(args.second());
            return coll.take(n.getIntValue());
        }
    };
    public static VncFunction take_while = new VncFunction("take-while", (VncVal)VncFunction.meta().arglists("(take-while predicate coll)").doc("Returns a list of successive items from coll while `(predicate item)` returns logical true.\u00b6Returns a transducer when no collection is provided.").examples("(take-while neg? [-2 -1 0 1 2 3])").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1, 2);
            MeterRegistry meterRegistry = ThreadContext.getMeterRegistry();
            final IVncFunction predicate = Coerce.toIVncFunction(args.first());
            predicate.sandboxFunctionCallValidation();
            if (args.size() == 1) {
                return new VncFunction(11.createAnonymousFuncName("take-while:transducer:wrapped")){
                    private static final long serialVersionUID = -1L;

                    @Override
                    public VncVal apply(VncList args) {
                        ArityExceptions.assertArity(this, args, 1);
                        final VncFunction rf = Coerce.toVncFunction(args.first());
                        rf.sandboxFunctionCallValidation();
                        return new VncFunction(1.createAnonymousFuncName("take-while:transducer")){
                            private static final long serialVersionUID = -1L;

                            @Override
                            public VncVal apply(VncList args) {
                                switch (args.size()) {
                                    case 0: {
                                        return rf.apply(VncList.empty());
                                    }
                                    case 1: {
                                        return rf.apply(VncList.of(args.first()));
                                    }
                                    case 2: {
                                        VncVal result = args.first();
                                        VncVal input = args.second();
                                        VncVal take = predicate.apply(VncList.of(input));
                                        if (VncBoolean.isFalseOrNil(take)) {
                                            return Reduced.reduced(result);
                                        }
                                        return rf.apply(VncList.of(result, input));
                                    }
                                }
                                ArityExceptions.assertArity(this, args, 0, 1, 2);
                                return Constants.Nil;
                            }
                        };
                    }
                };
            }
            VncSequence coll = VncSequence.coerceToSequence(args.second());
            return coll.takeWhile(v -> !VncBoolean.isFalseOrNil(VncFunction.applyWithMeter(predicate, VncList.of(v), meterRegistry)));
        }
    };
    public static VncFunction take_last = new VncFunction("take-last", (VncVal)VncFunction.meta().arglists("(take-last n coll)").doc("Return a sequence of the last n items in coll.\u00b6Returns a stateful transducer when no collection is provided.").examples("(take-last 3 [1 2 3 4 5])", "(take-last 10 [1 2 3 4 5])").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1, 2);
            if (args.size() == 1) {
                final int n = Math.max(0, Coerce.toVncLong(args.first()).getValue().intValue());
                return new VncFunction(12.createAnonymousFuncName("take-last:transducer:wrapped")){
                    private static final long serialVersionUID = -1L;

                    @Override
                    public VncVal apply(VncList args) {
                        ArityExceptions.assertArity(this, args, 1);
                        final VncFunction rf = Coerce.toVncFunction(args.first());
                        rf.sandboxFunctionCallValidation();
                        final LinkedList list = new LinkedList();
                        return new VncFunction(1.createAnonymousFuncName("take-last:transducer")){
                            private static final long serialVersionUID = -1L;

                            @Override
                            public VncVal apply(VncList args) {
                                switch (args.size()) {
                                    case 0: {
                                        return rf.apply(VncList.empty());
                                    }
                                    case 1: {
                                        VncVal result = args.first();
                                        result = CoreFunctions.reduce.apply(VncList.of(rf, result, VncList.ofList(list)));
                                        return rf.apply(VncList.of(result));
                                    }
                                    case 2: {
                                        VncVal result = args.first();
                                        VncVal input = args.second();
                                        list.add(input);
                                        if (list.size() > n) {
                                            list.removeFirst();
                                        }
                                        return result;
                                    }
                                }
                                ArityExceptions.assertArity(this, args, 0, 1, 2);
                                return Constants.Nil;
                            }
                        };
                    }
                };
            }
            VncLong n = Coerce.toVncLong(args.first());
            VncSequence coll = VncSequence.coerceToSequence(args.second());
            return coll.takeRight(n.getIntValue());
        }
    };
    public static VncFunction keep = new VncFunction("keep", (VncVal)VncFunction.meta().arglists("(keep f coll)").doc("Returns a sequence of the non-nil results of `(f item)`. Note, this means false return values will be included. f must be free of side-effects.\u00b6Returns a transducer when no collection is provided.").examples("(keep even? (range 1 4))", "(keep (fn [x] (if (odd? x) x)) (range 4))", "(keep #{3 5 7} '(1 3 5 7 9))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1, 2);
            if (args.size() == 1) {
                final IVncFunction fn = Coerce.toIVncFunction(args.first());
                fn.sandboxFunctionCallValidation();
                return new VncFunction(13.createAnonymousFuncName("keep:transducer:wrapped")){
                    private static final long serialVersionUID = -1L;

                    @Override
                    public VncVal apply(VncList args) {
                        ArityExceptions.assertArity(this, args, 1);
                        final VncFunction rf = Coerce.toVncFunction(args.first());
                        rf.sandboxFunctionCallValidation();
                        return new VncFunction(1.createAnonymousFuncName("keep:transducer")){
                            private static final long serialVersionUID = -1L;

                            @Override
                            public VncVal apply(VncList args) {
                                switch (args.size()) {
                                    case 0: {
                                        return rf.apply(VncList.empty());
                                    }
                                    case 1: {
                                        return rf.apply(VncList.of(args.first()));
                                    }
                                    case 2: {
                                        VncVal result = args.first();
                                        VncVal input = args.second();
                                        VncVal val = fn.apply(VncList.of(input));
                                        return VncBoolean.isFalseOrNil(val) ? result : rf.apply(VncList.of(result, input));
                                    }
                                }
                                ArityExceptions.assertArity(this, args, 0, 1, 2);
                                return Constants.Nil;
                            }
                        };
                    }
                };
            }
            VncVal result = map.apply(args);
            return result == Constants.Nil ? Constants.Nil : FunctionsUtil.removeNilValues(Coerce.toVncList(result));
        }
    };
    public static VncFunction dedupe = new VncFunction("dedupe", (VncVal)VncFunction.meta().arglists("(dedupe coll)").doc("Returns a collection with all consecutive duplicates removed.\u00b6Returns a stateful transducer when no collection is provided.").examples("(dedupe [1 2 2 2 3 4 4 2 3])", "(dedupe '(1 2 2 2 3 4 4 2 3))").seeAlso("distinct").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 0, 1);
            if (args.isEmpty()) {
                return new VncFunction(14.createAnonymousFuncName("dedupe:transducer:wrapped")){
                    private static final long serialVersionUID = -1L;

                    @Override
                    public VncVal apply(VncList args) {
                        ArityExceptions.assertArity(this, args, 1);
                        final VncFunction rf = Coerce.toVncFunction(args.first());
                        rf.sandboxFunctionCallValidation();
                        final AtomicReference<VncKeyword> seen = new AtomicReference<VncKeyword>(NONE);
                        return new VncFunction(1.createAnonymousFuncName("dedupe:transducer")){
                            private static final long serialVersionUID = -1L;

                            @Override
                            public VncVal apply(VncList args) {
                                switch (args.size()) {
                                    case 0: {
                                        return rf.apply(VncList.empty());
                                    }
                                    case 1: {
                                        return rf.apply(VncList.of(args.first()));
                                    }
                                    case 2: {
                                        VncVal result = args.first();
                                        VncVal input = args.second();
                                        if (!input.equals(seen.get())) {
                                            seen.set(input);
                                            return rf.apply(VncList.of(result, input));
                                        }
                                        return result;
                                    }
                                }
                                ArityExceptions.assertArity(this, args, 0, 1, 2);
                                return Constants.Nil;
                            }
                        };
                    }
                };
            }
            if (args.first() == Constants.Nil) {
                return VncList.empty();
            }
            VncVal seen = NONE;
            ArrayList<VncVal> items = new ArrayList<VncVal>();
            for (VncVal val : VncSequence.coerceToSequence(args.first())) {
                if (val.equals(seen)) continue;
                items.add(val);
                seen = val;
            }
            return ((VncSequence)args.first()).withValues(items);
        }
    };
    public static VncFunction remove = new VncFunction("remove", (VncVal)VncFunction.meta().arglists("(remove predicate coll)").doc("Returns a collection of the items in coll for which `(predicate item)` returns logical false.\u00b6Returns a transducer when no collection is provided.").examples("(remove nil? [1 nil nil 4 5 6])", "(remove even? [1 2 3 4 5 6 7])", "(remove #{3 5} '(1 3 5 7 9))", "(remove #(= 3 %) '(1 2 3 4 5 6))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1, 2);
            MeterRegistry meterRegistry = ThreadContext.getMeterRegistry();
            final IVncFunction predicate = Coerce.toIVncFunction(args.first());
            predicate.sandboxFunctionCallValidation();
            if (args.size() == 1) {
                VncFunction fn = new VncFunction(15.createAnonymousFuncName("remove:transducer")){
                    private static final long serialVersionUID = -1L;

                    @Override
                    public VncVal apply(VncList args) {
                        return VncBoolean.of(VncBoolean.isFalseOrNil(predicate.apply(args)));
                    }
                };
                return filter.apply(VncList.of(fn));
            }
            VncSequence seq = VncSequence.coerceToSequence(args.second()).filter(v -> VncBoolean.isFalseOrNil(VncFunction.applyWithMeter(predicate, VncList.of(v), meterRegistry)));
            return seq instanceof VncLazySeq ? seq : seq.toVncList();
        }
    };
    public static VncFunction distinct = new VncFunction("distinct", (VncVal)VncFunction.meta().arglists("(distinct coll)").doc("Returns a collection with all duplicates removed.\u00b6Returns a stateful transducer when no collection is provided.").examples("(distinct [1 2 3 4 2 3 4])", "(distinct '(1 2 3 4 2 3 4))").seeAlso("dedupe", "distinct?").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 0, 1);
            if (args.isEmpty()) {
                return new VncFunction(16.createAnonymousFuncName("distinct:transducer:wrapped")){
                    private static final long serialVersionUID = -1L;

                    @Override
                    public VncVal apply(VncList args) {
                        ArityExceptions.assertArity(this, args, 1);
                        final VncFunction rf = Coerce.toVncFunction(args.first());
                        rf.sandboxFunctionCallValidation();
                        final HashSet seen = new HashSet();
                        return new VncFunction(1.createAnonymousFuncName("distinct:transducer")){
                            private static final long serialVersionUID = -1L;

                            @Override
                            public VncVal apply(VncList args) {
                                switch (args.size()) {
                                    case 0: {
                                        return rf.apply(VncList.empty());
                                    }
                                    case 1: {
                                        return rf.apply(VncList.of(args.first()));
                                    }
                                    case 2: {
                                        VncVal result = args.first();
                                        VncVal input = args.second();
                                        if (seen.contains(input)) {
                                            return result;
                                        }
                                        seen.add(input);
                                        return rf.apply(VncList.of(result, input));
                                    }
                                }
                                ArityExceptions.assertArity(this, args, 0, 1, 2);
                                return Constants.Nil;
                            }
                        };
                    }
                };
            }
            return args.first() == Constants.Nil ? VncList.empty() : Coerce.toVncSequence(args.first()).distinct();
        }
    };
    public static VncFunction sorted = new VncFunction("sorted", (VncVal)VncFunction.meta().arglists("(sorted cmp coll)").doc("Returns a sorted collection using the compare function cmp. The compare function takes two arguments and returns -1, 0, or 1.\u00b6Returns a stateful transducer when no collection is provided.").examples("(sorted compare [4 2 1 5 6 3])", "(sorted (comp (partial * -1) compare) [4 2 1 5 6 3])").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1, 2);
            final VncFunction compfn = Coerce.toVncFunction(args.first());
            if (args.size() == 1) {
                return new VncFunction(17.createAnonymousFuncName("sorted:transducer:wrapped")){
                    private static final long serialVersionUID = -1L;

                    @Override
                    public VncVal apply(VncList args) {
                        ArityExceptions.assertArity(this, args, 1);
                        final VncFunction rf = Coerce.toVncFunction(args.first());
                        rf.sandboxFunctionCallValidation();
                        final ArrayList list = new ArrayList();
                        return new VncFunction(1.createAnonymousFuncName("sorted:transducer")){
                            private static final long serialVersionUID = -1L;

                            @Override
                            public VncVal apply(VncList args) {
                                switch (args.size()) {
                                    case 0: {
                                        return rf.apply(VncList.empty());
                                    }
                                    case 1: {
                                        VncVal result = args.first();
                                        VncVal sortedList = CoreFunctions.sort.apply(VncList.of(compfn, VncList.ofList(list)));
                                        result = CoreFunctions.reduce.apply(VncList.of(rf, result, sortedList));
                                        return rf.apply(VncList.of(result));
                                    }
                                    case 2: {
                                        VncVal result = args.first();
                                        VncVal input = args.second();
                                        list.add(input);
                                        return result;
                                    }
                                }
                                ArityExceptions.assertArity(this, args, 0, 1, 2);
                                return Constants.Nil;
                            }
                        };
                    }
                };
            }
            return CoreFunctions.sort.apply(args);
        }
    };
    public static VncFunction reverse = new VncFunction("reverse", (VncVal)VncFunction.meta().arglists("(reverse coll)").doc("Returns a collection of the items in coll in reverse order.\u00b6Returns a stateful transducer when no collection is provided.").examples("(reverse [1 2 3 4 5 6])", "(reverse \"abcdef\")").seeAlso("str/reverse").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 0, 1);
            if (args.size() == 0) {
                return new VncFunction(18.createAnonymousFuncName("reverse:transducer:wrapped")){
                    private static final long serialVersionUID = -1L;

                    @Override
                    public VncVal apply(VncList args) {
                        ArityExceptions.assertArity(this, args, 1);
                        final VncFunction rf = Coerce.toVncFunction(args.first());
                        rf.sandboxFunctionCallValidation();
                        final ArrayList list = new ArrayList();
                        return new VncFunction(1.createAnonymousFuncName("reverse:transducer")){
                            private static final long serialVersionUID = -1L;

                            @Override
                            public VncVal apply(VncList args) {
                                switch (args.size()) {
                                    case 0: {
                                        return rf.apply(VncList.empty());
                                    }
                                    case 1: {
                                        VncVal result = args.first();
                                        Collections.reverse(list);
                                        result = CoreFunctions.reduce.apply(VncList.of(rf, result, VncList.ofList(list)));
                                        return rf.apply(VncList.of(result));
                                    }
                                    case 2: {
                                        VncVal result = args.first();
                                        VncVal input = args.second();
                                        list.add(input);
                                        return result;
                                    }
                                }
                                ArityExceptions.assertArity(this, args, 0, 1, 2);
                                return Constants.Nil;
                            }
                        };
                    }
                };
            }
            VncVal coll = args.first();
            if (coll == Constants.Nil) {
                return Constants.Nil;
            }
            if (Types.isVncSequence(coll)) {
                return ((VncSequence)coll).reverse();
            }
            if (Types.isVncCollection(coll)) {
                return ((VncCollection)coll).toVncList().reverse();
            }
            if (Types.isVncString(coll)) {
                return ((VncString)coll).toVncList().reverse();
            }
            throw new VncException("Function 'reverse' requires a list, vector, set, map, or string as coll argument.");
        }
    };
    public static VncFunction flatten = new VncFunction("flatten", (VncVal)VncFunction.meta().arglists("(flatten coll)").doc("Takes any nested combination of collections (lists, vectors, etc.) and returns their contents as a single, flat sequence. `(flatten nil)` returns an empty list.\u00b6Returns a transducer when no collection is provided.").examples("(flatten [])", "(flatten [[1 2 3] [4 [5 6]] [7 [8 [9]]]])", "(flatten [1 2 {:a 3 :b [4 5 6]}])", "(flatten (seq {:a 1 :b 2}))").seeAlso("mapcat").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 0, 1);
            if (args.size() == 0) {
                return new VncFunction(19.createAnonymousFuncName("flatten:transducer:wrapped")){
                    private static final long serialVersionUID = -1L;

                    @Override
                    public VncVal apply(VncList args) {
                        ArityExceptions.assertArity(this, args, 1);
                        final VncFunction rf = Coerce.toVncFunction(args.first());
                        rf.sandboxFunctionCallValidation();
                        return new VncFunction(1.createAnonymousFuncName("flatten:transducer")){
                            private static final long serialVersionUID = -1L;

                            @Override
                            public VncVal apply(VncList args) {
                                switch (args.size()) {
                                    case 0: {
                                        return rf.apply(VncList.empty());
                                    }
                                    case 1: {
                                        VncVal result = args.first();
                                        return rf.apply(VncList.of(result));
                                    }
                                    case 2: {
                                        VncVal result = args.first();
                                        VncVal input = args.second();
                                        if (Types.isVncCollection(input)) {
                                            for (VncVal v : TransducerFunctions.flatten(Coerce.toVncCollection(input))) {
                                                result = rf.apply(VncList.of(result, v));
                                            }
                                            return result;
                                        }
                                        return rf.apply(VncList.of(result, input));
                                    }
                                }
                                ArityExceptions.assertArity(this, args, 0, 1, 2);
                                return Constants.Nil;
                            }
                        };
                    }
                };
            }
            VncCollection coll = Coerce.toVncCollection(args.first());
            List result = TransducerFunctions.flatten(coll);
            return Types.isVncVector(coll) ? VncVector.ofList(result) : VncList.ofList(result);
        }
    };
    public static VncFunction halt_when = new VncFunction("halt-when", (VncVal)VncFunction.meta().arglists("(halt-when pred)", "(halt-when pred retf)").doc("Returns a transducer that ends transduction when pred returns true for an input. When retf is supplied it must be a fn of 2 arguments - it will be passed the (completed) result so far and the input that triggered the predicate, and its return value (if it does not throw an exception) will be the return value of the transducer. If retf is not supplied, the input that triggered the predicate will be returned. If the predicate never returns true the transduction is unaffected.").examples("(do                                                     \n  (def xf (comp (halt-when #(== % 10)) (filter odd?)))  \n  (transduce xf conj [1 2 3 4 5 6 7 8 9]))                ", "(do                                                     \n  (def xf (comp (halt-when #(> % 5)) (filter odd?)))    \n  (transduce xf conj [1 2 3 4 5 6 7 8 9]))                ").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1, 2, 3);
            final VncFunction predicate = Coerce.toVncFunction(args.first());
            final VncFunction halt_return_fn = args.size() > 1 ? Coerce.toVncFunction(args.second()) : null;
            final VncFunction no_halt_return_fn = args.size() > 2 ? Coerce.toVncFunction(args.third()) : null;
            predicate.sandboxFunctionCallValidation();
            if (halt_return_fn != null) {
                halt_return_fn.sandboxFunctionCallValidation();
            }
            if (no_halt_return_fn != null) {
                no_halt_return_fn.sandboxFunctionCallValidation();
            }
            return new VncFunction(20.createAnonymousFuncName("halt-when:transducer:wrapped")){
                private static final long serialVersionUID = -1L;

                @Override
                public VncVal apply(VncList args) {
                    ArityExceptions.assertArity(this, args, 1);
                    final VncFunction rf = Coerce.toVncFunction(args.first());
                    rf.sandboxFunctionCallValidation();
                    return new VncFunction(1.createAnonymousFuncName("halt-when:transducer")){
                        private static final long serialVersionUID = -1L;

                        @Override
                        public VncVal apply(VncList args) {
                            switch (args.size()) {
                                case 0: {
                                    return rf.apply(VncList.empty());
                                }
                                case 1: {
                                    VncVal result = args.first();
                                    if (Types.isVncMap(result) && VncBoolean.isTrue(((VncMap)result).containsKey(HALT))) {
                                        return ((VncMap)result).get(HALT);
                                    }
                                    if (no_halt_return_fn != null) {
                                        return no_halt_return_fn.apply(VncList.of(result));
                                    }
                                    return rf.apply(VncList.of(result));
                                }
                                case 2: {
                                    VncVal result = args.first();
                                    VncVal input = args.second();
                                    VncVal cond = predicate.apply(VncList.of(input));
                                    if (!VncBoolean.isFalseOrNil(cond)) {
                                        VncVal haltVal = halt_return_fn != null ? halt_return_fn.apply(VncList.of(rf.apply(VncList.of(result)), input)) : input;
                                        return Reduced.reduced(VncHashMap.of(HALT, haltVal));
                                    }
                                    return rf.apply(VncList.of(result, input));
                                }
                            }
                            ArityExceptions.assertArity(this, args, 0, 1, 2);
                            return Constants.Nil;
                        }
                    };
                }
            };
        }
    };
    public static final VncKeyword HALT = new VncKeyword("@halt");
    private static final VncKeyword NONE = new VncKeyword("@none");
    public static final Map<VncVal, VncVal> ns = new SymbolMapBuilder().add(transduce).add(reduced).add(reduced_Q).add(map).add(map_indexed).add(filter).add(drop).add(drop_while).add(drop_last).add(take).add(take_while).add(take_last).add(keep).add(dedupe).add(remove).add(distinct).add(sorted).add(reverse).add(flatten).add(halt_when).toMap();

    private static List<VncVal> flatten(VncVal value) {
        ArrayList<VncVal> list = new ArrayList<VncVal>();
        TransducerFunctions.flatten(value, list);
        return list;
    }

    private static void flatten(VncVal value, List<VncVal> result) {
        if (Types.isVncSequence(value)) {
            for (VncVal v : (VncSequence)value) {
                TransducerFunctions.flatten(v, result);
            }
        } else {
            result.add(value);
        }
    }

    private static boolean isOneEmpty(VncSequence[] seqs) {
        for (int ii = 0; ii < seqs.length; ++ii) {
            if (!seqs[ii].isEmpty()) continue;
            return true;
        }
        return false;
    }
}

