/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.javainterop;

import com.github.jlangch.venice.impl.VeniceInterpreter;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DynamicClassLoader
extends URLClassLoader {
    private static final ConcurrentHashMap<String, Reference<Class<?>>> classCache = new ConcurrentHashMap();
    private static final URL[] EMPTY_URLS = new URL[0];
    private static final ReferenceQueue<Class<?>> refQueue = new ReferenceQueue();

    public DynamicClassLoader() {
        super(EMPTY_URLS, DynamicClassLoader.getParentClassLoader());
    }

    public DynamicClassLoader(ClassLoader parent) {
        super(EMPTY_URLS, parent);
    }

    public Class<?> defineClass(String name, byte[] bytes, Object srcForm) {
        DynamicClassLoader.clearCache(refQueue, classCache);
        Class<?> clazz = this.defineClass(name, bytes, 0, bytes.length);
        classCache.put(name, new SoftReference(clazz, refQueue));
        return clazz;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Class<?> clazz = DynamicClassLoader.findInMemoryClass(name);
        return clazz != null ? clazz : super.findClass(name);
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> clazz = this.findLoadedClass(name);
        if (clazz == null && (clazz = DynamicClassLoader.findInMemoryClass(name)) == null) {
            clazz = super.loadClass(name, false);
        }
        if (resolve) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    @Override
    public void addURL(URL url) {
        super.addURL(url);
    }

    public static void clearCache(ReferenceQueue<Class<?>> rq, ConcurrentHashMap<String, Reference<Class<?>>> cache) {
        if (rq.poll() != null) {
            while (rq.poll() != null) {
            }
            for (Map.Entry<String, Reference<Class<?>>> e : cache.entrySet()) {
                Reference<Class<?>> val = e.getValue();
                if (val == null || val.get() != null) continue;
                cache.remove(e.getKey(), val);
            }
        }
    }

    private static Class<?> findInMemoryClass(String name) {
        Reference<Class<?>> classRef = classCache.get(name);
        if (classRef != null) {
            Class<?> clazz = classRef.get();
            if (clazz != null) {
                return clazz;
            }
            classCache.remove(name, classRef);
        }
        return null;
    }

    private static ClassLoader getParentClassLoader() {
        ClassLoader ctxClassLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader sysClassLoader = ClassLoader.getSystemClassLoader();
        return ctxClassLoader == null || ctxClassLoader == sysClassLoader ? VeniceInterpreter.class.getClassLoader() : ctxClassLoader;
    }
}

