/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.specialforms;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.FunctionBuilder;
import com.github.jlangch.venice.impl.env.Env;
import com.github.jlangch.venice.impl.env.Var;
import com.github.jlangch.venice.impl.namespaces.Namespaces;
import com.github.jlangch.venice.impl.specialforms.util.SpecialFormsContext;
import com.github.jlangch.venice.impl.specialforms.util.SpecialFormsUtil;
import com.github.jlangch.venice.impl.types.VncBoolean;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncMultiArityFunction;
import com.github.jlangch.venice.impl.types.VncSpecialForm;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncSequence;
import com.github.jlangch.venice.impl.types.collections.VncVector;
import com.github.jlangch.venice.impl.types.util.Coerce;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.impl.util.ArityExceptions;
import com.github.jlangch.venice.impl.util.MetaUtil;
import com.github.jlangch.venice.impl.util.SymbolMapBuilder;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Consumer;

public class SpecialForms_DefFunctions {
    public static VncSpecialForm def = new VncSpecialForm("def", (VncVal)VncSpecialForm.meta().arglists("(def name expr)").doc("Creates a global variable.").examples("(def x 5)", "(def sum (fn [x y] (+ x y)))", "(def ^{:private true} x 100)").seeAlso("def", "def-", "defonce", "def-dynamic", "set!").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncVal specialFormMeta, VncList args, Env env, SpecialFormsContext ctx) {
            ArityExceptions.assertArity("def", ArityExceptions.FnType.SpecialForm, args, 1, 2);
            VncSymbol name = SpecialFormsUtil.validateSymbolWithCurrNS(Namespaces.qualifySymbolWithCurrNS(SpecialFormsUtil.evaluateSymbolMetaData(args.first(), env, ctx)), "def");
            VncVal val = args.second();
            VncVal res = ctx.getEvaluator().evaluate(val, env, false);
            res = res.withMeta(MetaUtil.mergeMeta(res.getMeta(), name.getMeta()));
            env.setGlobal(new Var(name, res, true));
            return name;
        }
    };
    public static VncSpecialForm defonce = new VncSpecialForm("defonce", (VncVal)VncSpecialForm.meta().arglists("(defonce name expr)").doc("Creates a global variable that can not be overwritten").examples("(defonce x 5)", "(defonce ^{:private true} x 5)").seeAlso("def", "def-dynamic").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncVal specialFormMeta, VncList args, Env env, SpecialFormsContext ctx) {
            ArityExceptions.assertArity("defonce", ArityExceptions.FnType.SpecialForm, args, 1, 2);
            VncSymbol name = SpecialFormsUtil.validateSymbolWithCurrNS(Namespaces.qualifySymbolWithCurrNS(SpecialFormsUtil.evaluateSymbolMetaData(args.first(), env, ctx)), "defonce");
            VncVal val = args.second();
            VncVal res = ctx.getEvaluator().evaluate(val, env, false).withMeta(name.getMeta());
            env.setGlobal(new Var(name, res, false));
            return name;
        }
    };
    public static VncSpecialForm def_dynamic = new VncSpecialForm("def-dynamic", (VncVal)VncSpecialForm.meta().arglists("(def-dynamic name expr)").doc("Creates a dynamic variable that starts off as a global variable and can be bound with 'binding' to a new value on the local thread.").examples("(do                      \n   (def-dynamic x 100)   \n   (println x)           \n   (binding [x 200]      \n      (println x))       \n   (println x)))           ", "(def-dynamic ^{:private true} x 100)").seeAlso("binding", "def", "defonce", "set!").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncVal specialFormMeta, VncList args, Env env, SpecialFormsContext ctx) {
            ArityExceptions.assertArity("def-dynamic", ArityExceptions.FnType.SpecialForm, args, 1, 2);
            VncSymbol name = SpecialFormsUtil.validateSymbolWithCurrNS(Namespaces.qualifySymbolWithCurrNS(SpecialFormsUtil.evaluateSymbolMetaData(args.first(), env, ctx)), "def-dynamic");
            VncVal val = args.second();
            VncVal res = ctx.getEvaluator().evaluate(val, env, false).withMeta(name.getMeta());
            env.setGlobalDynamic(name, res);
            return name;
        }
    };
    public static VncSpecialForm defmacro = new VncSpecialForm("defmacro", (VncVal)VncSpecialForm.meta().arglists("(defmacro name [params*] body)").doc("Macro definition").examples("(defmacro unless [pred a b]   \n  `(if (not ~pred) ~a ~b))      ").seeAlso("macroexpand", "macroexpand-all").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncVal specialFormMeta, VncList args, Env env, SpecialFormsContext ctx) {
            ArityExceptions.assertMinArity("defmacro", ArityExceptions.FnType.SpecialForm, args, 2);
            FunctionBuilder functionBuilder = ctx.getFunctionBuilder();
            int argPos = 0;
            VncSymbol macroName = Namespaces.qualifySymbolWithCurrNS(SpecialFormsUtil.evaluateSymbolMetaData(args.nth(argPos++), env, ctx));
            VncVal meta = macroName.getMeta();
            if (MetaUtil.isPrivate(meta)) {
                throw new VncException(String.format("The macro '%s' must not be defined as private! Venice does not support private macros.", macroName.getName()));
            }
            VncSequence paramsOrSig = Coerce.toVncSequence(args.nth(argPos));
            String name = macroName.getName();
            String ns = macroName.getNamespace();
            if (ns == null && !Namespaces.isCoreNS(ns = Namespaces.getCurrentNS().getName())) {
                name = ns + "/" + name;
            }
            meta = MetaUtil.addMetaVal(meta, MetaUtil.NS, new VncString(ns), MetaUtil.MACRO, VncBoolean.True);
            VncSymbol macroName_ = new VncSymbol(name, meta);
            if (Types.isVncVector(paramsOrSig)) {
                VncVector params = (VncVector)paramsOrSig;
                VncList body = args.slice(++argPos);
                VncFunction macroFn = functionBuilder.buildFunction(macroName_.getName(), params, body, null, true, meta, env);
                env.setGlobal(new Var(macroName_, macroFn.withMeta(meta), false));
                return macroFn;
            }
            ArrayList<VncFunction> fns = new ArrayList<VncFunction>();
            VncVal meta_ = meta;
            args.slice(argPos).forEach((Consumer<? super VncVal>)((Consumer<VncVal>)s -> {
                int pos = 0;
                VncList fnSig = Coerce.toVncList(s);
                VncVector fnParams = Coerce.toVncVector(fnSig.nth(pos++));
                VncList fnBody = fnSig.slice(pos);
                fns.add(functionBuilder.buildFunction(macroName_.getName() + "-arity-" + fnParams.size(), fnParams, fnBody, null, true, meta_, env));
            }));
            VncMultiArityFunction macroFn = new VncMultiArityFunction(macroName_.getName(), fns, true, meta);
            env.setGlobal(new Var(macroName_, macroFn, false));
            return macroFn;
        }
    };
    public static final Map<VncVal, VncVal> ns = new SymbolMapBuilder().add(def).add(defonce).add(def_dynamic).add(defmacro).toMap();
}

