/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.util.excel;

import com.github.jlangch.venice.ExcelException;
import com.github.jlangch.venice.impl.util.TimeUtil;
import com.github.jlangch.venice.impl.util.excel.ExcelCellStyles;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.Date;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellAddress;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelSheet {
    public static final float COL_WIDTH_MAGIC_FACTOR = 46.4f;
    private static final Boolean NULL_BOOLEAN = null;
    private final Sheet sheet;
    private final ExcelCellStyles cellStyles;
    private final FormulaEvaluator evaluator;

    public ExcelSheet(Sheet sheet, ExcelCellStyles cellFormats, FormulaEvaluator evaluator) {
        this.sheet = sheet;
        this.cellStyles = cellFormats;
        this.evaluator = evaluator;
    }

    public String getName() {
        return this.sheet.getSheetName();
    }

    public int getIndex() {
        return this.sheet.getWorkbook().getSheetIndex(this.sheet);
    }

    public int getFirstRowNum() {
        return this.sheet.getFirstRowNum();
    }

    public int getLastRowNum() {
        return this.sheet.getLastRowNum();
    }

    public int getFirstCellNum(int row) {
        Row r = this.sheet.getRow(row);
        return r == null ? -1 : (int)r.getFirstCellNum();
    }

    public int getLastCellNum(int row) {
        Row r = this.sheet.getRow(row);
        return r == null ? -1 : (int)r.getLastCellNum();
    }

    public boolean isCellEmpty(int row, int col) {
        Cell cell = this.getCell(row, col);
        return cell == null || cell.getCellType() == CellType.BLANK;
    }

    public String getCellAddress(int row, int col) {
        return new CellAddress(row, col).formatAsString();
    }

    public String getCellType(int row, int col) {
        Cell cell = this.getCell(row, col);
        if (cell == null) {
            return "notfound";
        }
        return this.getCellType(cell.getCellType());
    }

    public String getCellFormulaResultType(int row, int col) {
        Cell cell = this.getCell(row, col);
        if (cell == null) {
            return "notfound";
        }
        if (cell.getCellType() == CellType.FORMULA) {
            return this.getCellType(cell.getCachedFormulaResultType());
        }
        return this.getCellType(cell.getCellType());
    }

    public String getString(int row, int col) {
        Cell cell = this.getCell(row, col);
        if (cell == null) {
            return null;
        }
        if (cell.getCellType() == CellType.FORMULA) {
            return this.getString(this.evaluator.evaluateInCell(cell));
        }
        return this.getString(cell);
    }

    public Boolean getBoolean(int row, int col) {
        Cell cell = this.getCell(row, col);
        if (cell == null) {
            return NULL_BOOLEAN;
        }
        if (cell.getCellType() == CellType.FORMULA) {
            return this.getBoolean(this.evaluator.evaluateInCell(cell));
        }
        return this.getBoolean(cell);
    }

    public Long getInteger(int row, int col) {
        Cell cell = this.getCell(row, col);
        if (cell == null) {
            return null;
        }
        if (cell.getCellType() == CellType.FORMULA) {
            return this.getInteger(this.evaluator.evaluateInCell(cell));
        }
        return this.getInteger(cell);
    }

    public Double getFloat(int row, int col) {
        Cell cell = this.getCell(row, col);
        if (cell == null) {
            return null;
        }
        if (cell.getCellType() == CellType.FORMULA) {
            return this.getFloat(this.evaluator.evaluateInCell(cell));
        }
        return this.getFloat(cell);
    }

    public LocalDateTime getDate(int row, int col) {
        Cell cell = this.getCell(row, col);
        if (cell == null) {
            return null;
        }
        if (cell.getCellType() == CellType.FORMULA) {
            return this.getDate(this.evaluator.evaluateInCell(cell));
        }
        return this.getDate(cell);
    }

    public String getFormula(int row, int col) {
        Cell cell = this.getCell(row, col);
        return this.getFormula(cell);
    }

    public void setString(int row, int col, String value, String styleName) {
        this.setCellValue(this.getCellCreate(row, col), value, styleName);
    }

    public void setString(int row, int col, String value) {
        this.setCellValue(this.getCellCreate(row, col), value, "string");
    }

    public void setBoolean(int row, int col, Boolean value, String styleName) {
        this.setCellValue(this.getCellCreate(row, col), value, styleName);
    }

    public void setBoolean(int row, int col, Boolean value) {
        this.setCellValue(this.getCellCreate(row, col), value, "boolean");
    }

    public void setInteger(int row, int col, Integer value, String styleName) {
        this.setCellValue(this.getCellCreate(row, col), value, styleName);
    }

    public void setInteger(int row, int col, Integer value) {
        this.setCellValue(this.getCellCreate(row, col), value, "integer");
    }

    public void setInteger(int row, int col, Long value, String styleName) {
        this.setCellValue(this.getCellCreate(row, col), value, styleName);
    }

    public void setInteger(int row, int col, Long value) {
        this.setCellValue(this.getCellCreate(row, col), value, "integer");
    }

    public void setFloat(int row, int col, Float value, String styleName) {
        this.setCellValue(this.getCellCreate(row, col), value, styleName);
    }

    public void setFloat(int row, int col, Float value) {
        this.setCellValue(this.getCellCreate(row, col), value, "float");
    }

    public void setFloat(int row, int col, Double value, String styleName) {
        this.setCellValue(this.getCellCreate(row, col), value, styleName);
    }

    public void setFloat(int row, int col, Double value) {
        this.setCellValue(this.getCellCreate(row, col), value, "float");
    }

    public void setDate(int row, int col, Date value, String styleName) {
        this.setCellValue(this.getCellCreate(row, col), value, styleName);
    }

    public void setDate(int row, int col, LocalDate value, String styleName) {
        this.setCellValue(this.getCellCreate(row, col), value, styleName);
    }

    public void setDate(int row, int col, LocalDateTime value, String styleName) {
        this.setCellValue(this.getCellCreate(row, col), value, styleName);
    }

    public void setDate(int row, int col, ZonedDateTime value, String styleName) {
        this.setCellValue(this.getCellCreate(row, col), value, styleName);
    }

    public void setDate(int row, int col, Date value) {
        this.setCellValue(this.getCellCreate(row, col), value, "date");
    }

    public void setDate(int row, int col, LocalDate value) {
        this.setCellValue(this.getCellCreate(row, col), value, "date");
    }

    public void setDate(int row, int col, LocalDateTime value) {
        this.setCellValue(this.getCellCreate(row, col), value, "date");
    }

    public void setDate(int row, int col, ZonedDateTime value) {
        this.setCellValue(this.getCellCreate(row, col), value, "date");
    }

    public void setColumnWidthInPoints(int col, int width) {
        this.sheet.setColumnWidth(col, (int)((float)width * 46.4f));
    }

    public void rowHeightInPoints(int row, int height) {
        this.getRowCreate(row).setHeight((short)(height * 20));
    }

    public void setValue(int row, int col, Object value) {
        this.setValue(row, col, value, null);
    }

    public void setValue(int row, int col, Object value, String styleName) {
        if (value == null) {
            this.setCellValue(this.getCellCreate(row, col), null, null);
        } else if (value instanceof String) {
            this.setString(row, col, (String)value, this.coalesce(styleName, "string"));
        } else if (value instanceof Boolean) {
            this.setBoolean(row, col, (Boolean)value, this.coalesce(styleName, "boolean"));
        } else if (value instanceof Integer) {
            this.setInteger(row, col, (Integer)value, this.coalesce(styleName, "integer"));
        } else if (value instanceof Long) {
            this.setInteger(row, col, (Long)value, this.coalesce(styleName, "integer"));
        } else if (value instanceof Float) {
            this.setFloat(row, col, (Float)value, this.coalesce(styleName, "float"));
        } else if (value instanceof Double) {
            this.setFloat(row, col, (Double)value, this.coalesce(styleName, "float"));
        } else if (value instanceof BigDecimal) {
            this.setFloat(row, col, ((BigDecimal)value).doubleValue(), this.coalesce(styleName, "float"));
        } else if (value instanceof BigInteger) {
            this.setInteger(row, col, ((BigInteger)value).longValue(), this.coalesce(styleName, "integer"));
        } else if (value instanceof LocalDate) {
            this.setDate(row, col, (LocalDate)value, this.coalesce(styleName, "date"));
        } else if (value instanceof LocalDateTime) {
            this.setDate(row, col, (LocalDateTime)value, this.coalesce(styleName, "datetime"));
        } else if (value instanceof ZonedDateTime) {
            this.setDate(row, col, (ZonedDateTime)value, this.coalesce(styleName, "datetime"));
        } else if (value instanceof Date) {
            this.setDate(row, col, (Date)value, this.coalesce(styleName, "datetime"));
        } else {
            throw new IllegalArgumentException("Invalid value type " + value.getClass().getSimpleName());
        }
    }

    public void setFormula(int row, int col, String formula) {
        this.setFormula(row, col, formula, null);
    }

    public void setFormula(int row, int col, String formula, String styleName) {
        Cell cell = this.getCellCreate(row, col);
        cell.setCellFormula(formula);
        CellStyle style = this.cellStyles.getCellStyle(styleName);
        if (style != null) {
            cell.setCellStyle(style);
        }
    }

    public void addMergedRegion(int rowFrom, int rowTo, int colFrom, int colTo) {
        this.sheet.addMergedRegion(new CellRangeAddress(rowFrom, rowTo, colFrom, colTo));
    }

    public void addMergedRegion(String ref) {
        this.sheet.addMergedRegion(CellRangeAddress.valueOf((String)ref));
    }

    public void setDisplayZeros(boolean value) {
        this.sheet.setDisplayZeros(value);
    }

    public void autoSizeColumn(int col) {
        this.sheet.autoSizeColumn(col);
    }

    public void autoSizeColumns() {
        Row row;
        int firstRow = this.sheet.getFirstRowNum();
        if (firstRow >= 0 && (row = this.sheet.getRow(firstRow)) != null) {
            for (int col = 0; col < row.getLastCellNum(); ++col) {
                this.sheet.autoSizeColumn(col);
            }
        }
    }

    public void evaluateAllFormulas() {
        this.evaluator.evaluateAll();
    }

    private void setCellValue(Cell cell, Object value, String styleName) {
        CellStyle style = this.cellStyles.getCellStyle(styleName);
        if (style != null) {
            cell.setCellStyle(style);
        }
        if (value == null) {
            cell.setBlank();
        } else if (value instanceof String) {
            if (this.sheet.getWorkbook() instanceof XSSFWorkbook) {
                cell.setCellValue((RichTextString)new XSSFRichTextString(value.toString()));
            } else {
                cell.setCellValue(value.toString());
            }
        } else if (value instanceof Boolean) {
            cell.setCellValue(((Boolean)value).booleanValue());
        } else if (value instanceof Integer) {
            cell.setCellValue((double)((Integer)value).longValue());
        } else if (value instanceof Long) {
            cell.setCellValue((double)((Long)value).longValue());
        } else if (value instanceof Float) {
            cell.setCellValue(((Float)value).doubleValue());
        } else if (value instanceof Double) {
            cell.setCellValue(((Double)value).doubleValue());
        } else if (value instanceof BigDecimal) {
            cell.setCellValue(((BigDecimal)value).doubleValue());
        } else if (value instanceof Date) {
            cell.setCellValue((Date)value);
        } else if (value instanceof LocalDate) {
            cell.setCellValue(TimeUtil.convertLocalDateToDate((LocalDate)value));
        } else if (value instanceof LocalDateTime) {
            cell.setCellValue(TimeUtil.convertLocalDateTimeToDate((LocalDateTime)value));
        } else if (value instanceof ZonedDateTime) {
            cell.setCellValue(TimeUtil.convertZonedDateTimeToDate((ZonedDateTime)value));
        }
    }

    private Cell getCell(int row, int col) {
        Row r = this.sheet.getRow(row);
        return r == null ? null : r.getCell(col, Row.MissingCellPolicy.RETURN_BLANK_AS_NULL);
    }

    private Cell getCellCreate(int row, int col) {
        return this.getRowCreate(row).createCell(col);
    }

    private Row getRowCreate(int row) {
        Row r = this.sheet.getRow(row);
        return r != null ? r : this.sheet.createRow(row);
    }

    private String coalesce(String s1, String s2) {
        return s1 != null ? s1 : s2;
    }

    private String getString(Cell cell) {
        if (cell == null) {
            return null;
        }
        if (cell.getCellType() == CellType.BLANK) {
            return null;
        }
        if (cell.getCellType() == CellType.STRING) {
            return cell.getStringCellValue();
        }
        if (cell.getCellType() == CellType.BOOLEAN) {
            return Boolean.toString(cell.getBooleanCellValue());
        }
        if (cell.getCellType() == CellType.NUMERIC) {
            return Double.toString(cell.getNumericCellValue());
        }
        throw new ExcelException(String.format("The Excel cell [%d,%d] does not contain a string value", cell.getRowIndex(), cell.getColumnIndex()));
    }

    private Boolean getBoolean(Cell cell) {
        if (cell == null) {
            return NULL_BOOLEAN;
        }
        if (cell.getCellType() == CellType.BLANK) {
            return NULL_BOOLEAN;
        }
        if (cell.getCellType() == CellType.BOOLEAN) {
            return cell.getBooleanCellValue();
        }
        throw new ExcelException(String.format("The Excel cell [%d,%d] does not contain a boolean value", cell.getRowIndex(), cell.getColumnIndex()));
    }

    private Long getInteger(Cell cell) {
        if (cell == null) {
            return null;
        }
        if (cell.getCellType() == CellType.BLANK) {
            return null;
        }
        if (cell.getCellType() == CellType.NUMERIC) {
            return (long)(cell.getNumericCellValue() + 0.5);
        }
        if (cell.getCellType() == CellType.FORMULA) {
            CellValue cellValue = this.evaluator.evaluate(cell);
            if (cellValue.getCellType() == CellType.NUMERIC) {
                return (long)(cellValue.getNumberValue() + 0.5);
            }
            throw new ExcelException(String.format("The Excel cell [%d,%d] formula does not evaluate to an integer value", cell.getRowIndex(), cell.getColumnIndex()));
        }
        throw new ExcelException(String.format("The Excel cell [%d,%d] does not contain an integer value", cell.getRowIndex(), cell.getColumnIndex()));
    }

    private Double getFloat(Cell cell) {
        if (cell == null) {
            return null;
        }
        if (cell.getCellType() == CellType.BLANK) {
            return null;
        }
        if (cell.getCellType() == CellType.NUMERIC) {
            return cell.getNumericCellValue();
        }
        throw new ExcelException(String.format("The Excel cell [%d,%d] does not contain a float value. It actually holds a %s.", cell.getRowIndex(), cell.getColumnIndex(), cell.getCellType().name()));
    }

    private LocalDateTime getDate(Cell cell) {
        Date date = cell == null ? null : cell.getDateCellValue();
        return date == null ? null : TimeUtil.convertDateToLocalDateTime(date);
    }

    private String getFormula(Cell cell) {
        if (cell == null) {
            return null;
        }
        if (cell.getCellType() == CellType.BLANK) {
            return null;
        }
        if (cell.getCellType() == CellType.FORMULA) {
            return cell.getCellFormula();
        }
        throw new ExcelException(String.format("The Excel cell [%d,%d] does not contain a formula. It actually holds a %s.", cell.getRowIndex(), cell.getColumnIndex(), cell.getCellType().name()));
    }

    public String getCellType(CellType type) {
        if (type == CellType.BLANK) {
            return "blank";
        }
        if (type == CellType.STRING) {
            return "string";
        }
        if (type == CellType.BOOLEAN) {
            return "boolean";
        }
        if (type == CellType.NUMERIC) {
            return "numeric";
        }
        if (type == CellType.FORMULA) {
            return "formula";
        }
        if (type == CellType.ERROR) {
            return "error";
        }
        return "unknown";
    }
}

