/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.javainterop;

import com.github.jlangch.venice.impl.sandbox.SandboxDefaultRules;
import com.github.jlangch.venice.javainterop.SandboxInterceptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;

public class SandboxRules {
    private final List<String> rules = new ArrayList<String>();
    private Integer maxExecTimeSeconds = null;
    private Integer maxFutureThreadPoolSize = null;

    public SandboxRules() {
        this(true);
    }

    private SandboxRules(boolean withDefaults) {
        if (withDefaults) {
            this.withDefaultClasses();
        }
    }

    private SandboxRules(List<String> rules, Integer maxExecTimeSeconds, Integer maxFutureThreadPoolSize) {
        this.rules.addAll(rules);
        this.maxExecTimeSeconds = maxExecTimeSeconds;
        this.maxFutureThreadPoolSize = maxFutureThreadPoolSize;
    }

    public SandboxInterceptor sandbox() {
        return new SandboxInterceptor(this);
    }

    public static SandboxRules noDefaults() {
        return new SandboxRules(false);
    }

    public SandboxRules withClasses(String ... rules) {
        if (rules != null) {
            this.withClasses(Arrays.asList(rules));
        }
        return this;
    }

    public SandboxRules withClasses(List<String> rules) {
        if (rules != null) {
            this.rules.addAll(rules.stream().map(r -> r.startsWith("class:") ? r : "class:" + r).collect(Collectors.toList()));
        }
        return this;
    }

    public SandboxRules withClasses(Class<?> ... classes) {
        if (classes != null) {
            this.withClasses((Collection<Class<?>>)Arrays.asList(classes));
        }
        return this;
    }

    public SandboxRules withClasses(Collection<Class<?>> classes) {
        if (classes != null) {
            this.withClasses(classes.stream().map(c -> c.getName() + ":*").collect(Collectors.toList()));
        }
        return this;
    }

    public SandboxRules withDefaultClasses() {
        this.withClasses(SandboxDefaultRules.SYSTEM_CLASS_RULES);
        this.withClasses(SandboxDefaultRules.DEFAULT_CLASS_RULES);
        return this;
    }

    public SandboxRules withClasspathResources(String ... rules) {
        if (rules != null) {
            this.withClasspathResources(Arrays.asList(rules));
        }
        return this;
    }

    public SandboxRules withClasspathResources(Collection<String> rules) {
        if (rules != null) {
            this.rules.addAll(rules.stream().map(r -> r.startsWith("classpath:") ? r : "classpath:" + r).collect(Collectors.toList()));
        }
        return this;
    }

    public SandboxRules withSystemProperties(String ... rules) {
        if (rules != null) {
            this.withSystemProperties(Arrays.asList(rules));
        }
        return this;
    }

    public SandboxRules withSystemProperties(Collection<String> rules) {
        if (rules != null) {
            this.rules.addAll(rules.stream().map(r -> r.startsWith("system.property:") ? r : "system.property:" + r).collect(Collectors.toList()));
        }
        return this;
    }

    public SandboxRules withSystemEnvs(String ... rules) {
        if (rules != null) {
            this.withSystemEnvs(Arrays.asList(rules));
        }
        return this;
    }

    public SandboxRules withSystemEnvs(Collection<String> rules) {
        if (rules != null) {
            this.rules.addAll(rules.stream().map(r -> r.startsWith("system.env:") ? r : "system.env:" + r).collect(Collectors.toList()));
        }
        return this;
    }

    public SandboxRules rejectVeniceFunctions(String ... rules) {
        if (rules != null) {
            this.rejectVeniceFunctions(Arrays.asList(rules));
        }
        return this;
    }

    public SandboxRules rejectVeniceFunctions(Collection<String> rules) {
        if (rules != null) {
            String prefix = "blacklist:venice:func:";
            rules.forEach(r_ -> {
                String r = r_;
                if (r.startsWith("blacklist:venice:func:")) {
                    r = r.substring("blacklist:venice:func:".length());
                }
                if (r.startsWith("core/")) {
                    r = r.substring("core/".length());
                }
                this.rules.add("blacklist:venice:func:" + r);
            });
        }
        return this;
    }

    public SandboxRules whitelistVeniceFunctions(String ... rules) {
        if (rules != null) {
            this.whitelistVeniceFunctions(Arrays.asList(rules));
        }
        return this;
    }

    public SandboxRules whitelistVeniceFunctions(Collection<String> rules) {
        if (rules != null) {
            String prefix = "whitelist:venice:func:";
            rules.forEach(r_ -> {
                String r = r_;
                if (r.startsWith("whitelist:venice:func:")) {
                    r = r.substring("whitelist:venice:func:".length());
                }
                if (r.startsWith("core/")) {
                    r = r.substring("core/".length());
                }
                this.rules.add("whitelist:venice:func:" + r);
            });
        }
        return this;
    }

    public SandboxRules withVeniceModules(String ... rules) {
        if (rules != null) {
            this.withVeniceModules(Arrays.asList(rules));
        }
        return this;
    }

    public SandboxRules withVeniceModules(Collection<String> rules) {
        if (rules != null) {
            this.rules.addAll(rules.stream().map(r -> r.startsWith("venice:module:") ? r : "venice:module:" + r).collect(Collectors.toList()));
        }
        return this;
    }

    public SandboxRules withDefaultVeniceModules() {
        this.withVeniceModules(SandboxDefaultRules.DEFAULT_WHITELISTED_MODULES);
        return this;
    }

    public SandboxRules withMaxExecTimeSeconds(int maxExecTimeSeconds) {
        this.maxExecTimeSeconds = maxExecTimeSeconds <= 0 ? null : Integer.valueOf(maxExecTimeSeconds);
        return this;
    }

    public SandboxRules withMaxFutureThreadPoolSize(int maximumPoolSize) {
        this.maxFutureThreadPoolSize = maximumPoolSize <= 0 ? null : Integer.valueOf(maximumPoolSize);
        return this;
    }

    public SandboxRules rejectAllIoFunctions() {
        this.rejectVeniceFunctions("*io*");
        return this;
    }

    @Deprecated
    public SandboxRules rejectAllVeniceIoFunctions() {
        return this.rejectAllIoFunctions();
    }

    public SandboxRules rejectAllConcurrencyFunctions() {
        this.rejectVeniceFunctions("*concurrency*");
        return this;
    }

    public SandboxRules rejectAllSystemFunctions() {
        this.rejectVeniceFunctions("*system*");
        return this;
    }

    public SandboxRules rejectAllJavaInteropFunctions() {
        this.rejectVeniceFunctions("*java-interop*");
        return this;
    }

    public SandboxRules rejectAllSenstiveSpecialForms() {
        this.rejectVeniceFunctions("*special-forms*");
        return this;
    }

    public SandboxRules rejectAllUnsafeFunctions() {
        this.rejectVeniceFunctions("*unsafe*");
        return this;
    }

    public SandboxRules withStandardSystemProperties() {
        this.withSystemProperties(SandboxDefaultRules.DEFAULT_SYSTEM_PROPERTIES);
        return this;
    }

    public SandboxRules withAllSystemProperties() {
        this.withSystemProperties("*");
        return this;
    }

    public SandboxRules withStandardSystemEnvs() {
        this.withSystemEnvs(SandboxDefaultRules.DEFAULT_SYSTEM_ENVS);
        return this;
    }

    public SandboxRules withAllSystemEnvs() {
        this.withSystemEnvs("*");
        return this;
    }

    public SandboxRules merge(SandboxRules other) {
        ArrayList<String> merged = new ArrayList<String>(this.rules);
        merged.addAll(other.rules);
        return new SandboxRules(merged, this.maxExecTimeSeconds, this.maxFutureThreadPoolSize);
    }

    public SandboxRules unique() {
        ArrayList<String> unique = new ArrayList<String>();
        ArrayList<String> rules = new ArrayList<String>(this.rules);
        Collections.reverse(rules);
        HashSet<String> check = new HashSet<String>();
        for (String rule : rules) {
            if (check.contains(rule)) continue;
            check.add(rule);
            unique.add(rule);
        }
        Collections.reverse(unique);
        return new SandboxRules(unique, this.maxExecTimeSeconds, this.maxFutureThreadPoolSize);
    }

    public List<String> getRules() {
        return Collections.unmodifiableList(this.rules);
    }

    public Integer getMaxExecTimeSeconds() {
        return this.maxExecTimeSeconds;
    }

    public Integer getMaxFutureThreadPoolSize() {
        return this.maxFutureThreadPoolSize;
    }

    public static List<String> getDefaultRules() {
        return new SandboxRules().getRules().stream().sorted().collect(Collectors.toList());
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String prefix) {
        HashSet<String> items = new HashSet<String>(this.rules);
        items.removeAll(SandboxDefaultRules.SYSTEM_CLASS_RULES);
        items.add("maxExecTimeSeconds:" + (this.maxExecTimeSeconds == null ? "no-limit" : this.maxExecTimeSeconds.toString()));
        return new ArrayList<String>(items).stream().sorted().map(s -> "   " + s).collect(Collectors.joining("\n"));
    }
}

