/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.util.excel;

import com.github.jlangch.venice.impl.util.excel.ExcelColumnDef;
import com.github.jlangch.venice.impl.util.excel.ExcelSheet;
import com.github.jlangch.venice.util.excel.DataRecord;
import com.github.jlangch.venice.util.excel.ExcelColumnBuilder;
import com.github.jlangch.venice.util.excel.ExcelSheetReader;
import com.github.jlangch.venice.util.excel.ExcelSumFormulaBuilder;
import com.github.jlangch.venice.util.excel.ExcelWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.poi.ss.util.CellAddress;

public class ExcelSheetWriter<T> {
    public static final int DEFAULT_FONT_SIZE = 11;
    private final ExcelWriter parentBuilder;
    private final ExcelSheet sheet;
    private final List<ExcelColumnDef<T>> columnDefs = new ArrayList<ExcelColumnDef<T>>();
    private boolean noHeader = false;
    private boolean headerRendered = false;
    private int currRow0 = 0;
    private int skipRows = 0;
    private Integer columnWidth;
    private String defaultHeaderStyle;
    private String defaultBodyStyle;
    private String defaultFooterStyle;

    public ExcelSheetWriter(ExcelWriter excelBuilder, ExcelSheet sheet) {
        this.parentBuilder = excelBuilder;
        this.sheet = sheet;
    }

    public String getName() {
        return this.sheet.getName();
    }

    public int getIndex() {
        return this.sheet.getIndex() + 1;
    }

    public ExcelSheetWriter<T> noHeader() {
        this.noHeader = true;
        return this;
    }

    public ExcelSheetWriter<T> defaultHeaderStyle(String style) {
        this.defaultHeaderStyle = style;
        return this;
    }

    public ExcelSheetWriter<T> defaultBodyStyle(String style) {
        this.defaultBodyStyle = style;
        return this;
    }

    public ExcelSheetWriter<T> defaultFooterStyle(String style) {
        this.defaultFooterStyle = style;
        return this;
    }

    public ExcelColumnBuilder<T> withColumn(String colHeaderName) {
        return new ExcelColumnBuilder<T>(this, this.columnDefs, colHeaderName);
    }

    public ExcelColumnBuilder<T> withColumn(String colHeaderName, Function<? super T, ?> colMapper) {
        return new ExcelColumnBuilder<T>(this, this.columnDefs, colHeaderName).colMapper(colMapper);
    }

    public ExcelColumnBuilder<T> withColumn(String colHeaderName, String fieldName) {
        return new ExcelColumnBuilder<Object>(this, this.columnDefs, colHeaderName).colMapper(e -> ((DataRecord)e).get(fieldName));
    }

    public ExcelSheetWriter<T> columnWidth(int col1, int width) {
        this.sheet.setColumnWidthInPoints(col1 - 1, width);
        return this;
    }

    public ExcelSheetWriter<T> renderItems(List<T> items) {
        this.renderHeader();
        int bodyRowStart = this.currRow0;
        items.forEach(v -> this.renderBodyItem(v));
        int bodyRowEnd = this.currRow0 - 1;
        this.renderFooter(bodyRowStart, bodyRowEnd);
        return this;
    }

    public ExcelSheetWriter<T> renderItem(T item) {
        this.renderHeader();
        this.renderBodyItem(item);
        return this;
    }

    public ExcelSheetWriter<T> value(int row1, int col1, Object value) {
        this.sheet.setValue(row1 - 1, col1 - 1, value);
        return this;
    }

    public ExcelSheetWriter<T> value(int row1, int col1, Object value, String stylename) {
        this.sheet.setValue(row1 - 1, col1 - 1, value, stylename);
        return this;
    }

    public ExcelSheetWriter<T> formula(int row1, int col1, String formula) {
        this.sheet.setFormula(row1 - 1, col1 - 1, formula);
        return this;
    }

    public ExcelSheetWriter<T> formula(int row1, int col1, String formula, String stylename) {
        this.sheet.setFormula(row1 - 1, col1 - 1, formula, stylename);
        return this;
    }

    public ExcelSumFormulaBuilder<T> withSum(int row1, int col1) {
        return new ExcelSumFormulaBuilder(this, this.sheet, row1, col1);
    }

    public ExcelSheetWriter<T> skipRows(int count) {
        this.skipRows = Math.max(0, count);
        return this;
    }

    public ExcelSheetWriter<T> rowHeightInPoints(int row1, int height) {
        this.sheet.rowHeightInPoints(row1 - 1, height);
        return this;
    }

    public ExcelSheetWriter<T> autoSizeColumns() {
        this.sheet.autoSizeColumns();
        return this;
    }

    public ExcelSheetWriter<T> autoSizeColumn(int col1) {
        this.sheet.autoSizeColumn(col1 - 1);
        return this;
    }

    public ExcelSheetWriter<T> addMergedRegion(int rowFrom1, int rowTo1, int colFrom1, int colTo1) {
        this.sheet.addMergedRegion(rowFrom1 - 1, rowTo1 - 1, colFrom1 - 1, colTo1 - 1);
        return this;
    }

    public ExcelSheetWriter<T> evaluateAllFormulas() {
        this.sheet.evaluateAllFormulas();
        return this;
    }

    public ExcelSheetWriter<T> displayZeros(boolean value) {
        this.sheet.setDisplayZeros(value);
        return this;
    }

    public ExcelSheetWriter<T> setDefaultColumnWidthInPoints(int width) {
        this.columnWidth = width;
        return this;
    }

    public String sumFormula(int rowFrom1, int rowTo1, int colFrom1, int colTo1) {
        return String.format("SUM(%s:%s)", this.sheet.getCellAddress(rowFrom1 - 1, colFrom1 - 1), this.sheet.getCellAddress(rowTo1 - 1, colTo1 - 1));
    }

    public String cellAddress(int row1, int col1) {
        return this.sheet.getCellAddress(row1 - 1, col1 - 1);
    }

    public ExcelWriter end() {
        return this.parentBuilder;
    }

    public ExcelSheetReader reader() {
        return new ExcelSheetReader(this.parentBuilder.reader(), this.sheet);
    }

    private String getColumnHeaderStyle(int col0) {
        String style = col0 < 0 || col0 > this.columnDefs.size() - 1 ? null : this.columnDefs.get((int)col0).headerStyle;
        return style == null ? this.defaultHeaderStyle : style;
    }

    private String getColumnBodyStyle(int col0) {
        String style = col0 < 0 || col0 > this.columnDefs.size() - 1 ? null : this.columnDefs.get((int)col0).bodyStyle;
        return style == null ? this.defaultBodyStyle : style;
    }

    private String getColumnFooterStyle(int col0) {
        String style = col0 < 0 || col0 > this.columnDefs.size() - 1 ? null : this.columnDefs.get((int)col0).footerStyle;
        return style == null ? this.defaultFooterStyle : style;
    }

    private List<String> getHeaderStrings() {
        return this.columnDefs.stream().map(c -> c.header).collect(Collectors.toList());
    }

    private void setHeaderValues(int row0, List<?> values) {
        int col0 = 0;
        for (Object v : values) {
            if (v != null) {
                this.sheet.setValue(row0, col0, v, this.getColumnHeaderStyle(col0));
            }
            ++col0;
        }
    }

    private boolean hasFooter() {
        return this.columnDefs.stream().anyMatch(c -> c.footerType != ExcelColumnDef.FooterType.NONE);
    }

    private void renderHeader() {
        if (!this.headerRendered) {
            this.renderColumnWidths();
            if (!this.noHeader) {
                this.setHeaderValues(this.currRow0++, this.getHeaderStrings());
            }
            this.headerRendered = true;
        }
    }

    private void renderFooter(int bodyRowFrom0, int bodyRowTo0) {
        boolean emptyBody;
        boolean bl = emptyBody = bodyRowTo0 < bodyRowFrom0;
        if (this.hasFooter()) {
            int col0 = 0;
            for (ExcelColumnDef<T> colDef : this.columnDefs) {
                switch (colDef.footerType) {
                    case NONE: {
                        this.sheet.setValue(this.currRow0, col0, null, null);
                        break;
                    }
                    case TEXT: {
                        this.sheet.setValue(this.currRow0, col0, colDef.footerValue, this.getColumnFooterStyle(col0));
                        break;
                    }
                    case NUMBER: {
                        this.sheet.setValue(this.currRow0, col0, colDef.footerValue, this.getColumnFooterStyle(col0));
                        break;
                    }
                    case FORMULA: {
                        this.sheet.setValue(this.currRow0, col0, null, null);
                        break;
                    }
                    case SUM: {
                        if (emptyBody) {
                            this.sheet.setValue(this.currRow0, col0, null, null);
                            break;
                        }
                        String formula = String.format("SUM(%s:%s)", new CellAddress(bodyRowFrom0, col0).formatAsString(), new CellAddress(bodyRowTo0, col0).formatAsString());
                        this.sheet.setFormula(this.currRow0, col0, formula, this.getColumnFooterStyle(col0));
                        break;
                    }
                    case MIN: {
                        if (emptyBody) {
                            this.sheet.setValue(this.currRow0, col0, null, this.getColumnFooterStyle(col0));
                            break;
                        }
                        String formula = String.format("MIN(%s:%s)", new CellAddress(bodyRowFrom0, col0).formatAsString(), new CellAddress(bodyRowTo0, col0).formatAsString());
                        this.sheet.setFormula(this.currRow0, col0, formula, this.getColumnFooterStyle(col0));
                        break;
                    }
                    case MAX: {
                        if (emptyBody) {
                            this.sheet.setValue(this.currRow0, col0, null, this.getColumnFooterStyle(col0));
                            break;
                        }
                        String formula = String.format("MAX(%s:%s)", new CellAddress(bodyRowFrom0, col0).formatAsString(), new CellAddress(bodyRowTo0, col0).formatAsString());
                        this.sheet.setFormula(this.currRow0, col0, formula, this.getColumnFooterStyle(col0));
                        break;
                    }
                    case AVERAGE: {
                        if (emptyBody) {
                            this.sheet.setValue(this.currRow0, col0, null, this.getColumnFooterStyle(col0));
                            break;
                        }
                        String formula = String.format("AVERAGE(%s:%s)", new CellAddress(bodyRowFrom0, col0).formatAsString(), new CellAddress(bodyRowTo0, col0).formatAsString());
                        this.sheet.setFormula(this.currRow0, col0, formula, this.getColumnFooterStyle(col0));
                    }
                }
                ++col0;
            }
        }
        ++this.currRow0;
    }

    private void renderBodyItem(T item) {
        if (this.skipRows > 0) {
            --this.skipRows;
        } else {
            if (item != null) {
                int col0 = 0;
                for (ExcelColumnDef<T> colDef : this.columnDefs) {
                    if (colDef.colMapper != null) {
                        this.sheet.setValue(this.currRow0, col0, colDef.colMapper.apply(item), this.getColumnBodyStyle(col0));
                    }
                    ++col0;
                }
            }
            ++this.currRow0;
        }
    }

    private void renderColumnWidths() {
        int col0 = 0;
        for (ExcelColumnDef<T> colDef : this.columnDefs) {
            if (colDef.width != null) {
                this.sheet.setColumnWidthInPoints(col0, colDef.width);
            } else if (this.columnWidth != null) {
                this.sheet.setColumnWidthInPoints(col0, this.columnWidth);
            }
            ++col0;
        }
    }
}

