/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.util.excel;

import com.github.jlangch.venice.impl.util.excel.ExcelSheet;
import com.github.jlangch.venice.util.excel.ExcelSheetWriter;

public class ExcelSumFormulaBuilder<T> {
    private final ExcelSheetWriter<T> parentBuilder;
    private final ExcelSheet sheet;
    private final int row0;
    private final int col0;
    private int rowFrom0;
    private int colFrom0;
    private int rowTo0;
    private int colTo0;
    private String style;

    public ExcelSumFormulaBuilder(ExcelSheetWriter<T> parentBuilder, ExcelSheet sheet, int row1, int col1) {
        this.parentBuilder = parentBuilder;
        this.sheet = sheet;
        this.row0 = row1 - 1;
        this.col0 = col1 - 1;
    }

    public ExcelSumFormulaBuilder<T> cellFrom(int row1, int col1) {
        this.rowFrom0 = row1 - 1;
        this.colFrom0 = col1 - 1;
        return this;
    }

    public ExcelSumFormulaBuilder<T> cellTo(int row1, int col1) {
        this.rowTo0 = this.row0 - 1;
        this.colTo0 = this.col0 - 1;
        return this;
    }

    public ExcelSumFormulaBuilder<T> style(String style) {
        this.style = style;
        return this;
    }

    public ExcelSheetWriter<T> end() {
        String formula = String.format("SUM(%s:%s)", this.sheet.getCellAddress(this.rowFrom0, this.colFrom0), this.sheet.getCellAddress(this.rowTo0, this.colTo0));
        this.sheet.setFormula(this.row0, this.col0, formula, this.style);
        return this.parentBuilder;
    }
}

