/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice;

import com.github.jlangch.venice.FileException;
import com.github.jlangch.venice.Venice;
import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.docgen.util.CodeHighlighter;
import com.github.jlangch.venice.impl.docgen.util.ColorTheme;
import com.github.jlangch.venice.impl.util.StringUtil;
import com.github.jlangch.venice.impl.util.io.ClassPathResource;
import com.github.jlangch.venice.impl.util.kira.KiraTemplateEvaluator;
import com.github.jlangch.venice.util.pdf.PdfRenderer;
import com.lowagie.text.pdf.PdfReader;
import java.io.File;
import java.io.FileOutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;

public class SourceCodeRenderer {
    private static final String fontOpenSansDownload = "https://fonts.google.com/specimen/Open+Sans";
    private static final String fontSourceCodeProDownload = "https://fonts.google.com/specimen/Source+Sans+Pro";
    private static final String fontOpenSans = "OpenSans-Regular.ttf";
    private static final String fontSourceCodePro = "SourceCodePro-Regular.ttf";
    private final CodeHighlighter codeHighlighter = new CodeHighlighter(ColorTheme.getLightTheme());

    private SourceCodeRenderer() {
    }

    public static void render(String sourceFile, String destDir, String fontDir, boolean lineNumbering, boolean syntaxHighlighted) {
        SourceCodeRenderer.render(new File(sourceFile), new File(destDir), new File(fontDir), lineNumbering, syntaxHighlighted);
    }

    public static void render(File sourceFile, File destDir, File fontDir, boolean lineNumbering, boolean syntaxHighlighted) {
        try {
            if (sourceFile == null) {
                throw new IllegalArgumentException("A 'sourceFile' must not be null!");
            }
            if (fontDir == null) {
                throw new IllegalArgumentException("A 'fontDir' must not be null!");
            }
            File dir = destDir == null ? SourceCodeRenderer.getUserDir() : destDir;
            String name = sourceFile.getName();
            if (!sourceFile.canRead()) {
                throw new FileException("The file '" + sourceFile.getPath() + "' cannot be read!");
            }
            if (!dir.isDirectory()) {
                throw new FileException("The destination dir '" + dir.getPath() + "' is not a directory!");
            }
            if (!fontDir.isDirectory()) {
                throw new FileException("The font dir '" + dir.getPath() + "' is not a directory!");
            }
            if (!SourceCodeRenderer.areFontsAvailable(fontDir)) {
                return;
            }
            new SourceCodeRenderer().renderSourceCode(SourceCodeRenderer.read(sourceFile), sourceFile, new File(dir, name + ".html"), new File(dir, name + ".pdf"), fontDir, lineNumbering, syntaxHighlighted);
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to Venice source file as HTML/PDF", ex);
        }
    }

    private void renderSourceCode(String source, File srcFile, File htmlFile, File pdfFile, File fontDir, boolean lineNumbering, boolean syntaxHighlighted) throws Exception {
        System.out.println("Processing Venice file:        " + srcFile.getAbsolutePath());
        System.out.println("Rendering HTML source code to: " + htmlFile.getAbsolutePath());
        System.out.println("Rendering PDF source code to:  " + pdfFile.getAbsolutePath());
        System.out.println("Using font dir:                " + fontDir.getAbsolutePath());
        String wrapped = "(do\n" + source + "\n)";
        String codeHighlighted = syntaxHighlighted ? this.codeHighlighter.highlight(wrapped) : wrapped;
        List<String> lines = StringUtil.splitIntoLines(codeHighlighted);
        lines = lines.subList(1, lines.size() - 1);
        if (lineNumbering) {
            String lineNrFormat = syntaxHighlighted ? "<span style=\"color: #808080\">%04d   </span>%s" : "%04d   ";
            AtomicLong line = new AtomicLong(1L);
            lines = lines.stream().map(s -> String.format(lineNrFormat, line.getAndIncrement(), s)).collect(Collectors.toList());
        }
        codeHighlighted = String.join((CharSequence)"\n", lines);
        String baseURL = fontDir.toURI().toURL().toString();
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("meta-author", "Venice");
        data.put("version", Venice.getVersion());
        data.put("filename", srcFile.getName());
        data.put("code", codeHighlighted);
        data.put("pdfmode", false);
        String html = this.renderXHTML(data);
        this.save(htmlFile, html);
        data.put("pdfmode", true);
        String xhtml = this.renderXHTML(data);
        ByteBuffer pdf = this.renderPDF(xhtml, baseURL);
        byte[] pdfArr = pdf.array();
        this.save(pdfFile, pdfArr);
        PdfReader reader = new PdfReader(pdf.array());
        reader.close();
    }

    private String renderXHTML(Map<String, Object> data) {
        try {
            String template = this.loadCheatSheetTemplate();
            KiraTemplateEvaluator evaluator = new KiraTemplateEvaluator();
            String xhtml = evaluator.runAsync(() -> evaluator.evaluateKiraTemplate(template, data));
            return xhtml;
        }
        catch (VncException ex) {
            throw new RuntimeException("Failed to render source code XHTML. \nVenice Callstack: \n" + ex.getCallStackAsString("   "), ex);
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to render source code XHTML", ex);
        }
    }

    private ByteBuffer renderPDF(String xhtml, String baseURL) {
        return PdfRenderer.render(xhtml, baseURL);
    }

    private String loadCheatSheetTemplate() {
        return new ClassPathResource(Venice.class.getPackage(), "docgen/source-code.html").getResourceAsString("UTF-8");
    }

    private void save(File file, String text) throws Exception {
        this.save(file, text.getBytes("UTF-8"));
    }

    private void save(File file, byte[] data) throws Exception {
        try (FileOutputStream fos = new FileOutputStream(file);){
            fos.write(data, 0, data.length);
            fos.flush();
        }
    }

    private static boolean areFontsAvailable(File fontDir) {
        boolean ok = true;
        File font = new File(fontDir, fontOpenSans);
        if (!font.canRead()) {
            System.out.println("Error: Font " + font.getAbsolutePath() + " is not available!");
            System.out.println("    -> Download from https://fonts.google.com/specimen/Open+Sans");
            ok = false;
        }
        if (!(font = new File(fontDir, fontSourceCodePro)).canRead()) {
            System.out.println("Error: Font " + font.getAbsolutePath() + " is not available!");
            System.out.println("    -> Download from https://fonts.google.com/specimen/Source+Sans+Pro");
            ok = false;
        }
        return ok;
    }

    private static String read(File file) throws Exception {
        return new String(Files.readAllBytes(file.toPath()), Charset.forName("UTF-8"));
    }

    private static File getUserDir() {
        return new File(System.getProperty("user.dir"));
    }
}

