/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.namespaces;

import com.github.jlangch.venice.impl.namespaces.Namespace;
import com.github.jlangch.venice.impl.thread.ThreadContext;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.util.MetaUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class Namespaces {
    public static final String NS_CURRENT_NAME = "*ns*";
    public static final VncSymbol NS_CURRENT_SYMBOL = new VncSymbol("*ns*");
    public static final VncSymbol NS_USER = new VncSymbol("user");
    public static final VncSymbol NS_CORE = new VncSymbol("core");
    public static final Set<String> SYSTEM_NAMESPACES = Collections.unmodifiableSet(Namespaces.toSet(Arrays.asList("core", "cidr", "csv", "dag", "inet", "io", "json", "math", "sandbox", "sh", "str", "regex", "repl", "time")));
    public static final Set<String> RESERVED_NAMESPACES = Collections.unmodifiableSet(Namespaces.toSet(SYSTEM_NAMESPACES, Arrays.asList("bench", "component", "crypt", "docx", "excel", "http", "jackson", "kira", "local", "maven", "parsifal", "pdf", "ring", "shell", "tc", "test", "xchart", "xml", "webdav")));

    public static boolean isCoreNS(VncSymbol nsSym) {
        return NS_CORE.equals(nsSym);
    }

    public static boolean isCoreNS(String nsName) {
        return "core".equals(nsName);
    }

    public static boolean isCurrentNSSymbol(VncSymbol nsSym) {
        return NS_CURRENT_NAME.equals(nsSym.getName());
    }

    public static boolean isSystemNS(String nsName) {
        return SYSTEM_NAMESPACES.contains(nsName);
    }

    public static boolean isCurrentNSSymbol(String nsName) {
        return NS_CURRENT_NAME.equals(nsName);
    }

    public static VncSymbol getCurrentNS() {
        return ThreadContext.getCurrNS().getNS();
    }

    public static Namespace getCurrentNamespace() {
        return ThreadContext.getCurrNS();
    }

    public static void setCurrentNamespace(Namespace ns) {
        ThreadContext.setCurrNS(ns);
    }

    public static VncSymbol qualifySymbolWithCurrNS(VncSymbol sym) {
        if (sym == null) {
            return null;
        }
        if (sym.hasNamespace()) {
            return new VncSymbol(sym.getName(), MetaUtil.setNamespace(sym.getMeta(), sym.getNamespace()));
        }
        VncSymbol ns = Namespaces.getCurrentNS();
        VncVal newMeta = MetaUtil.setNamespace(sym.getMeta(), ns.getName());
        return Namespaces.isCoreNS(ns) || sym.isSpecialFormName() ? new VncSymbol(sym.getName(), newMeta) : new VncSymbol(ns.getName(), sym.getName(), newMeta);
    }

    private static Set<String> toSet(Collection<String> l1) {
        return new HashSet<String>(l1);
    }

    private static Set<String> toSet(Collection<String> l1, Collection<String> l2) {
        HashSet<String> set = new HashSet<String>(l1);
        set.addAll(l2);
        return set;
    }
}

