/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.specialforms;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.FunctionBuilder;
import com.github.jlangch.venice.impl.env.Env;
import com.github.jlangch.venice.impl.env.Var;
import com.github.jlangch.venice.impl.namespaces.Namespaces;
import com.github.jlangch.venice.impl.specialforms.util.SpecialFormsContext;
import com.github.jlangch.venice.impl.specialforms.util.SpecialFormsUtil;
import com.github.jlangch.venice.impl.types.IVncFunction;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncMultiArityFunction;
import com.github.jlangch.venice.impl.types.VncMultiFunction;
import com.github.jlangch.venice.impl.types.VncSpecialForm;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncMap;
import com.github.jlangch.venice.impl.types.collections.VncSequence;
import com.github.jlangch.venice.impl.types.collections.VncVector;
import com.github.jlangch.venice.impl.types.util.Coerce;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.impl.util.ArityExceptions;
import com.github.jlangch.venice.impl.util.SymbolMapBuilder;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Consumer;

public class SpecialForms_MethodFunctions {
    public static VncSpecialForm defmethod = new VncSpecialForm("defmethod", (VncVal)VncSpecialForm.meta().arglists("(defmethod multifn-name dispatch-val & fn-tail)").doc("Creates a new method for a multimethod associated with a dispatch-value.").examples("(do                                                                       \n   ;;defmulti with dispatch function                                      \n   (defmulti salary (fn [amount] (amount :t)))                            \n                                                                          \n   ;;defmethod provides a function implementation for a particular value  \n   (defmethod salary \"com\" [amount] (+ (:b amount) (/ (:b amount) 2)))  \n   (defmethod salary \"bon\" [amount] (+ (:b amount) 99))                 \n   (defmethod salary :default  [amount] (:b amount))                      \n                                                                          \n   [(salary {:t \"com\" :b 1000})                                         \n    (salary {:t \"bon\" :b 1000})                                         \n    (salary {:t \"xxx\" :b 1000})]                                        \n)                                                                           ").seeAlso("defmulti").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncVal specialFormMeta, VncList args, Env env, SpecialFormsContext ctx) {
            ArityExceptions.assertMinArity("defmethod", ArityExceptions.FnType.SpecialForm, args, 2);
            VncSymbol multiFnName = Namespaces.qualifySymbolWithCurrNS(Coerce.toVncSymbol(args.first()));
            VncVal multiFnVal = env.getGlobalOrNull(multiFnName);
            if (multiFnVal == null) {
                throw new VncException(String.format("No multifunction '%s' defined for the method definition", multiFnName.getName()));
            }
            VncMultiFunction multiFn = Coerce.toVncMultiFunction(multiFnVal);
            VncVal dispatchVal = args.second();
            VncVector params = Coerce.toVncVector(args.third());
            if (params.size() != multiFn.getParams().size()) {
                throw new VncException(String.format("A method definition for the multifunction '%s' must have %d parameters", multiFnName.getName(), multiFn.getParams().size()));
            }
            VncVector preConditions = SpecialForms_MethodFunctions.getFnPreconditions(args.fourth());
            VncList body = args.slice(preConditions == null ? 3 : 4);
            VncFunction fn = ctx.getFunctionBuilder().buildFunction(multiFnName.getName(), params, body, preConditions, false, specialFormMeta, env);
            return multiFn.addFn(dispatchVal, fn.withMeta(specialFormMeta));
        }
    };
    public static VncSpecialForm defmulti = new VncSpecialForm("defmulti", (VncVal)VncSpecialForm.meta().arglists("(defmulti name dispatch-fn)").doc("Creates a new multimethod with the associated dispatch function.").examples("(do                                                                         \n   ;;defmulti with dispatch function                                        \n   (defmulti salary (fn [amount] (amount :t)))                              \n                                                                            \n   ;;defmethod provides a function implementation for a particular value    \n   (defmethod salary \"com\"   [amount] (+ (:b amount) (/ (:b amount) 2)))  \n   (defmethod salary \"bon\"   [amount] (+ (:b amount) 99))                 \n   (defmethod salary :default  [amount] (:b amount))                        \n                                                                            \n   [(salary {:t \"com\" :b 1000})                                           \n    (salary {:t \"bon\" :b 1000})                                           \n    (salary {:t \"xxx\" :b 1000})]                                          \n)                                                                             ", "(do                                                \n   ;;dispatch on type                              \n   (defmulti test (fn [x] (type x)))               \n                                                   \n   (defmethod test :core/number  [x] [x :number])  \n   (defmethod test :core/string  [x] [x :string])  \n   (defmethod test :core/boolean [x] [x :boolean]) \n   (defmethod test :default      [x] [x :default]) \n                                                   \n   [(test 1)                                       \n    (test 1.0)                                     \n    (test 1.0M)                                    \n    (test \"abc\")                                 \n    (test [1])]                                    \n)                                                    ").seeAlso("defmethod").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncVal specialFormMeta, VncList args, Env env, SpecialFormsContext ctx) {
            IVncFunction dispatchFn;
            ArityExceptions.assertArity("defmulti", ArityExceptions.FnType.SpecialForm, args, 2);
            VncSymbol name = SpecialFormsUtil.validateSymbolWithCurrNS(Namespaces.qualifySymbolWithCurrNS(SpecialFormsUtil.evaluateSymbolMetaData(args.first(), env, ctx)), "defmulti");
            if (Types.isVncKeyword(args.second())) {
                dispatchFn = (VncKeyword)args.second();
            } else if (Types.isVncSymbol(args.second())) {
                dispatchFn = Coerce.toVncFunction(env.get((VncSymbol)args.second()));
                dispatchFn.sandboxFunctionCallValidation();
            } else {
                VncList fnAst = Coerce.toVncList(args.second());
                dispatchFn = (IVncFunction)((Object)fn.apply(specialFormMeta, fnAst.rest(), env, ctx));
                dispatchFn.sandboxFunctionCallValidation();
            }
            VncMultiFunction multiFn = new VncMultiFunction(name.getName(), dispatchFn).withMeta(name.getMeta());
            env.setGlobal(new Var(name, multiFn, true));
            return multiFn;
        }
    };
    public static VncSpecialForm fn = new VncSpecialForm("fn", (VncVal)VncSpecialForm.meta().arglists("(fn name? [params*] condition-map? expr*)").doc("Defines an anonymous function.").examples("(do                             \n  (def sum (fn [x y] (+ x y)))  \n  (sum 2 3))                    ", ";; multi-arity anonymous function      \n(let [f (fn ([x] x) ([x y] (+ x y)))]  \n   [(f 1) (f 4 6)])", "(map (fn double [x] (* 2 x)) (range 1 5))", "(map #(* 2 %) (range 1 5))", "(map #(* 2 %1) (range 1 5))", ";; anonymous function with two params, the second is destructured  \n(reduce (fn [m [k v]] (assoc m v k)) {} {:b 2 :a 1 :c 3})          ", ";; defining a pre-condition                 \n(do                                         \n   (def square-root                         \n        (fn [x]                             \n            { :pre [(>= x 0)] }             \n            (. :java.lang.Math :sqrt x)))   \n   (square-root 4))                           ", ";; closures                                                   \n(do                                                           \n  (defn pow [n]                                               \n    (fn [x] (apply * (repeat n x))))  ; closes over n         \n                                                              \n  ;; n is provided here as 2 and 3, then n goes out of scope  \n  (def square (pow 2))                                        \n  (def cubic (pow 3))                                         \n  (square 4))                                                 ", ";; higher-order function                                           \n(do                                                                \n   (def discount                                                   \n        (fn [percentage]                                           \n            { :pre [(and (>= percentage 0) (<= percentage 100))] } \n            (fn [price] (- price (* price percentage 0.01)))))     \n   ((discount 50) 300))                                              ").seeAlso("defn", "defn-", "def").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncVal specialFormMeta, VncList args, Env env, SpecialFormsContext ctx) {
            VncVal meta;
            VncSymbol name;
            int argPos;
            ArityExceptions.assertMinArity("fn", ArityExceptions.FnType.SpecialForm, args, 1);
            FunctionBuilder functionBuilder = ctx.getFunctionBuilder();
            if (Types.isVncSymbol(args.first())) {
                argPos = 1;
                name = (VncSymbol)args.first();
                meta = name.getMeta();
            } else {
                argPos = 0;
                name = new VncSymbol(VncFunction.createAnonymousFuncName());
                meta = args.second().getMeta();
            }
            VncSymbol fnName = Namespaces.qualifySymbolWithCurrNS(name);
            VncSequence paramsOrSig = Coerce.toVncSequence(args.nth(argPos));
            if (Types.isVncVector(paramsOrSig)) {
                VncVector preCon;
                VncVector params = (VncVector)paramsOrSig;
                if ((preCon = SpecialForms_MethodFunctions.getFnPreconditions(args.nthOrDefault(++argPos, null))) != null) {
                    ++argPos;
                }
                VncList body = args.slice(argPos);
                return functionBuilder.buildFunction(fnName.getName(), params, body, preCon, false, meta, env);
            }
            ArrayList<VncFunction> fns = new ArrayList<VncFunction>();
            args.slice(argPos).forEach((Consumer<? super VncVal>)((Consumer<VncVal>)s -> {
                int pos = 0;
                VncList sig = Coerce.toVncList(s);
                VncVector params = Coerce.toVncVector(sig.nth(pos++));
                VncVector preCon = SpecialForms_MethodFunctions.getFnPreconditions(sig.nth(pos));
                if (preCon != null) {
                    ++pos;
                }
                VncList body = sig.slice(pos);
                fns.add(functionBuilder.buildFunction(fnName.getName(), params, body, preCon, false, meta, env));
            }));
            return new VncMultiArityFunction(fnName.getName(), fns, false, meta);
        }
    };
    private static final VncKeyword PRE_CONDITION_KEY = new VncKeyword(":pre");
    public static final Map<VncVal, VncVal> ns = new SymbolMapBuilder().add(defmethod).add(defmulti).add(fn).toMap();

    private static VncVector getFnPreconditions(VncVal prePostConditions) {
        VncVal val;
        if (Types.isVncMap(prePostConditions) && Types.isVncVector(val = ((VncMap)prePostConditions).get(PRE_CONDITION_KEY))) {
            return (VncVector)val;
        }
        return null;
    }
}

