/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.modules;

import com.github.jlangch.venice.impl.types.VncKeyword;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class Modules {
    public static final Set<String> VALID_MODULES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("installer", "bouncycastle-install", "chatgpt-install", "excel-install", "ivy-install", "jansi-install", "langchain-install", "pdf-install", "qrbill-install", "tomcat-install", "xchart-install", "ansi", "app", "ascii-table", "benchmark", "cargo", "cargo-arangodb", "cargo-qdrant", "chatgpt", "cli", "clipboard", "config", "core", "component", "crypt", "dag", "docker", "docx", "excel", "esr", "fam", "fonts", "geoip", "gradle", "gradlew", "grep", "hexdump", "http-client", "http-client-legacy", "ivy", "jackson", "java", "jsonl", "kira", "langchain", "math", "matrix", "maven", "mercator", "mimetypes", "multipart", "parsifal", "qrbill", "qrref", "repl-setup", "ring", "semver", "shell", "test", "test-support", "timing", "tomcat", "tomcat-util", "tput", "trace", "utf8", "webdav", "xchart", "xml", "zipvault")));
    public static final Set<VncKeyword> NATIVE_MODULES = Collections.unmodifiableSet(new HashSet<VncKeyword>(Arrays.asList(new VncKeyword("sandbox"), new VncKeyword("math"), new VncKeyword("str"), new VncKeyword("regex"), new VncKeyword("time"), new VncKeyword("io"), new VncKeyword("json"), new VncKeyword("pdf"), new VncKeyword("inet"), new VncKeyword("cidr"), new VncKeyword("csv"))));

    public static boolean isValidModule(String module) {
        return VALID_MODULES.contains(module);
    }

    public static boolean isValidModule(VncKeyword module) {
        return Modules.isValidModule(module.getValue());
    }
}

