/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl;

import com.github.jlangch.venice.AssertionException;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.impl.util.MetaUtil;
import com.github.jlangch.venice.impl.util.callstack.CallFrame;
import com.github.jlangch.venice.impl.util.callstack.WithCallStack;

public class FunctionArgsTypeHints {
    public static void validate(VncSymbol sym, VncVal val) {
        FunctionArgsTypeHints.validate(sym, val, FunctionArgsTypeHints.getParamType(sym));
    }

    public static void validate(VncSymbol sym, VncVal val, VncKeyword typeMeta) {
        if (typeMeta != null && !Types.isInstanceOf(typeMeta, val)) {
            WithCallStack cs = new WithCallStack(FunctionArgsTypeHints.callframe(sym));
            Throwable throwable = null;
            try {
                try {
                    throw new AssertionException(String.format("function argument type not compatible: arg-name=%s, arg-type=%s, expected-type=%s ", sym.getSimpleName(), Types.getType(val).toString(true), typeMeta.toString(true)));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Throwable throwable3) {
                if (cs != null) {
                    if (throwable != null) {
                        try {
                            cs.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        cs.close();
                    }
                }
                throw throwable3;
            }
        }
    }

    public static VncKeyword[] getParamTypes(VncVal[] paramArr) {
        VncKeyword[] types = new VncKeyword[paramArr.length];
        for (int ii = 0; ii < paramArr.length; ++ii) {
            VncVal p = paramArr[ii];
            types[ii] = Types.isVncSymbol(p) ? FunctionArgsTypeHints.getParamType((VncSymbol)p) : null;
        }
        return types;
    }

    public static VncKeyword getParamType(VncSymbol param) {
        VncVal t = param.getMetaVal(MetaUtil.TYPE);
        if (Types.isVncKeyword(t)) {
            VncKeyword tkw = (VncKeyword)t;
            if (tkw.hasNamespace()) {
                return tkw;
            }
            if (Types.isCoreType(tkw.getSimpleName())) {
                return new VncKeyword("core/" + tkw.getSimpleName());
            }
            return null;
        }
        return null;
    }

    private static CallFrame callframe(VncVal val) {
        return new CallFrame("invalid-argument-type", val.getMeta());
    }
}

