/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.env;

import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.types.VncVal;
import java.beans.Transient;
import java.io.Serializable;
import java.util.List;

public class Var
implements Serializable {
    private static final long serialVersionUID = 1598432086227773369L;
    private final VncSymbol name;
    private final VncVal val;
    private final boolean overwritable;
    private final Scope scope;

    public Var(VncSymbol name, VncVal val, Scope scope) {
        this(name, val, true, scope);
    }

    public Var(VncSymbol name, VncVal val, boolean overwritable, Scope scope) {
        this.name = name;
        this.val = val == null ? Constants.Nil : val;
        this.overwritable = overwritable;
        this.scope = scope;
    }

    public VncVal getVal() {
        return this.val;
    }

    public VncSymbol getName() {
        return this.name;
    }

    public boolean isOverwritable() {
        return this.overwritable;
    }

    public Scope getScope() {
        return this.scope;
    }

    @Transient
    public boolean isGlobal() {
        return this.scope == Scope.Global;
    }

    @Transient
    public boolean isLocal() {
        return this.scope == Scope.Local;
    }

    @Transient
    public boolean isPrivate() {
        return this.name.isPrivate();
    }

    public String toString() {
        return String.format("{%s %s %s :overwritable %b}", this.getClass().getSimpleName(), this.getName().toString(), this.getVal().toString(), this.isOverwritable());
    }

    public String toString(boolean print_readably) {
        return String.format("{%s %s %s :overwritable %b}", this.getClass().getSimpleName(), this.getName().toString(print_readably), this.getVal().toString(print_readably), this.isOverwritable());
    }

    public static Var findVar(VncSymbol sym, List<Var> bindings) {
        int idx = Var.getVarIndex(sym, bindings);
        return idx < 0 ? null : bindings.get(idx);
    }

    public static int getVarIndex(VncSymbol sym, List<Var> bindings) {
        for (int ii = 0; ii < bindings.size(); ++ii) {
            Var b = bindings.get(ii);
            if (!b.getName().equals(sym)) continue;
            return ii;
        }
        return -1;
    }

    public static enum Scope {
        Global,
        Local;

    }
}

