/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.functions;

import com.github.jlangch.venice.LicenseMgr;
import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.functions.CoreFunctions;
import com.github.jlangch.venice.impl.javainterop.DynamicClassLoader2;
import com.github.jlangch.venice.impl.thread.ThreadBridge;
import com.github.jlangch.venice.impl.thread.ThreadContext;
import com.github.jlangch.venice.impl.threadpool.GlobalThreadFactory;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.VncBoolean;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncLong;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncHashMap;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncOrderedMap;
import com.github.jlangch.venice.impl.types.collections.VncVector;
import com.github.jlangch.venice.impl.types.util.Coerce;
import com.github.jlangch.venice.impl.util.ArityExceptions;
import com.github.jlangch.venice.impl.util.SymbolMapBuilder;
import com.github.jlangch.venice.impl.util.callstack.CallFrame;
import com.github.jlangch.venice.impl.util.callstack.CallStack;
import com.github.jlangch.venice.impl.util.reflect.ReflectionAccessor;
import com.github.jlangch.venice.javainterop.ReturnValue;
import com.github.jlangch.venice.util.OS;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

public class SystemFunctions {
    public static VncFunction pid = new VncFunction("pid", (VncVal)VncFunction.meta().arglists("(pid)").doc("Returns the PID of this process.").examples("(pid)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 0);
            if (SystemFunctions.javaMajorVersion() <= 8L) {
                return new VncString(ManagementFactory.getRuntimeMXBean().getName().split("@")[0]);
            }
            ReturnValue procHandle = ReflectionAccessor.invokeStaticMethod(ReflectionAccessor.classForName("java.lang.ProcessHandle"), "current", new Object[0]);
            ReturnValue ret = ReflectionAccessor.invokeInstanceMethod(procHandle.getValue(), procHandle.getFormalType(), "pid", new Object[0]);
            return new VncLong((Long)ret.getValue());
        }
    };
    public static VncFunction byte_order = new VncFunction("byte-order", (VncVal)VncFunction.meta().arglists("(byte-order)").doc("Returns the CPU's byte order.").examples("(byte-order)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            String order;
            ArityExceptions.assertArity(this, args, 0);
            switch (order = ByteBuffer.allocate(2).order().toString()) {
                case "BIG_ENDIAN": {
                    return new VncKeyword(":big-endian");
                }
                case "LITTLE_ENDIAN": {
                    return new VncKeyword(":little-endian");
                }
            }
            return new VncKeyword(":little-endian");
        }
    };
    public static VncFunction host_name = new VncFunction("host-name", (VncVal)VncFunction.meta().arglists("(host-name)").doc("Returns this host's name.").examples("(host-name)").seeAlso("host-address").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 0);
            try {
                return new VncString(InetAddress.getLocalHost().getHostName());
            }
            catch (Exception ex) {
                throw new VncException("(host-name) failed", ex);
            }
        }
    };
    public static VncFunction host_address = new VncFunction("host-address", (VncVal)VncFunction.meta().arglists("(host-address)").doc("Returns this host's ip address.").examples("(host-address)").seeAlso("host-name").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 0);
            try {
                return new VncString(InetAddress.getLocalHost().getHostAddress());
            }
            catch (Exception ex) {
                throw new VncException("(host-address) failed", ex);
            }
        }
    };
    public static VncFunction user_name = new VncFunction("user-name", (VncVal)VncFunction.meta().arglists("(user-name)").doc("Returns the logged-in's user name.").examples("(user-name)").seeAlso("io/user-home-dir").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 0);
            try {
                return new VncString(System.getProperty("user.name"));
            }
            catch (Exception ex) {
                throw new VncException("(user-name) failed", ex);
            }
        }
    };
    public static VncFunction ip_private_Q = new VncFunction("ip-private?", (VncVal)VncFunction.meta().arglists("(ip-private? addr)").doc("Returns true if the IP address is private. \n\nIPv4 addresses reserved for private networks:\n\n * 192.168.0.0 - 192.168.255.255\n * 172.16.0.0 - 172.31.255.255\n * 10.0.0.0 - 10.255.255.255\n").examples("(ip-private? \"192.168.170.181\")").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            try {
                return VncBoolean.of(InetAddress.getByName(Coerce.toVncString(args.first()).getValue()).isSiteLocalAddress());
            }
            catch (Exception ex) {
                throw new VncException("function ip-private? failed", ex);
            }
        }
    };
    public static VncFunction gc = new VncFunction("gc", (VncVal)VncFunction.meta().arglists("(gc)").doc("Run the Java garbage collector. Runs the finalization methods of any objects pending finalization prior to the GC.").examples("(gc)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 0);
            this.sandboxFunctionCallValidation();
            Runtime.getRuntime().runFinalization();
            Runtime.getRuntime().gc();
            return Constants.Nil;
        }
    };
    public static VncFunction cpus = new VncFunction("cpus", (VncVal)VncFunction.meta().arglists("(cpus)").doc("Returns the number of available processors or number of hyperthreads if the CPU supports hyperthreads.").examples("(cpus)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 0);
            return new VncLong(Runtime.getRuntime().availableProcessors());
        }
    };
    public static VncFunction shutdown_hook = new VncFunction("shutdown-hook", (VncVal)VncFunction.meta().arglists("(shutdown-hook f)").doc("Registers the function f as a JVM shutdown hook.\n\nShutdown hooks can be tested in a REPL:\n\n  * start a REPL\n  * run `(shutdown-hook (fn [] (println \"SHUTDOWN\") (sleep 3000)))`\n  * exit the REPL with `!exit`\n\nThe sandbox is active within the shutdown hook:\n\n  * start a REPL\n  * run `!sandbox customized`\n  * run `!sandbox add-rule blacklist:venice:func:+`\n  * run `(shutdown-hook (fn [] (try (+ 1 2) (catch :SecurityException ex (println ex) (sleep 3000)))))`\n  * exit the REPL with `!exit`").examples("(shutdown-hook (fn [] (println \"shutdown\")))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            this.sandboxFunctionCallValidation();
            VncFunction fn = Coerce.toVncFunction(args.first());
            fn.sandboxFunctionCallValidation();
            ThreadBridge threadBridge = ThreadBridge.create("shutdown-hook", new CallFrame[]{new CallFrame(this, args), new CallFrame(fn)}, new ThreadBridge.Options[0]);
            Runnable taskWrapper = threadBridge.bridgeRunnable(() -> fn.applyOf(new VncVal[0]));
            Thread hook = GlobalThreadFactory.newThread("shutdown-hook", taskWrapper);
            hook.setUncaughtExceptionHandler(ThreadBridge::handleUncaughtException);
            Runtime.getRuntime().addShutdownHook(hook);
            return Constants.Nil;
        }
    };
    public static VncFunction callstack = new VncFunction("callstack", (VncVal)VncFunction.meta().arglists("(callstack)").doc("Returns the current callstack.").examples("(do                             \n   (defn f1 [x] (f2 x))         \n   (defn f2 [x] (f3 x))         \n   (defn f3 [x] (f4 x))         \n   (defn f4 [x] (callstack))    \n   (f1 100))                      ").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 0);
            CallStack stack = ThreadContext.getCallStack();
            return VncVector.ofList(stack.callstack().stream().map(f -> VncOrderedMap.of(CALLSTACK_KEY_FN_NAME, f.getFnName() == null ? Constants.Nil : new VncString(f.getFnName()), CALLSTACK_KEY_FILE, new VncString(f.getFile()), CALLSTACK_KEY_LINE, new VncLong(f.getLine()), CALLSTACK_KEY_COL, new VncLong(f.getCol()))).collect(Collectors.toList()));
        }
    };
    public static VncFunction os_type = new VncFunction("os-type", (VncVal)VncFunction.meta().arglists("(os-type)").doc("Returns the OS type. Type is one of `:windows`, `:mac-osx`, `:linux`, `:unix`, or `:unknown`").examples("(os-type)").seeAlso("os-type?", "os-arch", "os-name", "os-version").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 0);
            return new VncKeyword(SystemFunctions.osType());
        }
    };
    public static VncFunction os_type_Q = new VncFunction("os-type?", (VncVal)VncFunction.meta().arglists("(os-type? type)").doc("Returns true if the OS id of the type otherwise false. Type is one of `:windows`, `:mac-osx`, `:linux`, or `:unix`").examples("(os-type? :mac-osx)", "(os-type? :windows)").seeAlso("os-type", "os-arch", "os-name", "os-version").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            String type = Coerce.toVncKeyword(args.first()).getValue();
            String osName = System.getProperty("os.name");
            switch (type) {
                case "windows": {
                    return VncBoolean.of(osName.startsWith("Windows"));
                }
                case "mac-osx": {
                    return VncBoolean.of(osName.startsWith("Mac OS X"));
                }
                case "linux": {
                    return VncBoolean.of(osName.startsWith("Linux"));
                }
            }
            return VncBoolean.False;
        }
    };
    public static VncFunction os_arch = new VncFunction("os-arch", (VncVal)VncFunction.meta().arglists("(os-arch)").doc("Returns the OS architecture. E.g: \"x86_64\"").examples("(os-arch)").seeAlso("os-type", "os-type?", "os-name", "os-version").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 0);
            return new VncString(System.getProperty("os.arch"));
        }
    };
    public static VncFunction os_name = new VncFunction("os-name", (VncVal)VncFunction.meta().arglists("(os-name)").doc("Returns the OS name. E.g.: \"Mac OS X\"").examples("(os-name)").seeAlso("os-type", "os-type?", "os-arch", "os-version").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 0);
            return new VncString(System.getProperty("os.name"));
        }
    };
    public static VncFunction os_version = new VncFunction("os-version", (VncVal)VncFunction.meta().arglists("(os-version)").doc("Returns the OS version").examples("(os-version)").seeAlso("os-type", "os-type?", "os-arch", "os-name").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 0);
            return new VncString(System.getProperty("os.version"));
        }
    };
    public static VncFunction system_prop = new VncFunction("system-prop", (VncVal)VncFunction.meta().arglists("(system-prop)", "(system-prop name)", "(system-prop name default-val)").doc("Returns the system property with the given name. Returns the default-val if the property does not exist or it's value is nil.\n\nWithout arguments returns all system properties authorized by the configured sandbox.").examples("(system-prop :os.name)", "(system-prop :foo.org \"abc\")", "(system-prop \"os.name\")").seeAlso("system-env").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 0, 1, 2);
            if (args.isEmpty()) {
                Set<String> names = System.getProperties().stringPropertyNames();
                HashMap<VncString, VncString> env = new HashMap<VncString, VncString>();
                for (String name : names) {
                    try {
                        String val = ThreadContext.getInterceptor().onReadSystemProperty(name);
                        env.put(new VncString(name), new VncString(val));
                    }
                    catch (Exception ex) {}
                }
                return new VncHashMap(env);
            }
            VncString key = Coerce.toVncString(CoreFunctions.name.apply(VncList.of(args.first())));
            VncVal defaultVal = args.size() == 2 ? args.second() : Constants.Nil;
            String val = ThreadContext.getInterceptor().onReadSystemProperty(key.getValue());
            return val == null ? defaultVal : new VncString(val);
        }
    };
    public static VncFunction system_env = new VncFunction("system-env", (VncVal)VncFunction.meta().arglists("(system-env)", "(system-env name)", "(system-env name default-val)").doc("Returns the system env variable with the given name. Returns the default-val if the variable does not exist or it's value is nil.\n\nWithout arguments returns all system env variables authorized by the configured sandbox.").examples("(system-env :SHELL)", "(system-env :FOO \"test\")", "(system-env \"SHELL\")").seeAlso("system-prop").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 0, 1, 2);
            if (args.isEmpty()) {
                Set<String> names = System.getenv().keySet();
                HashMap<VncString, VncString> env = new HashMap<VncString, VncString>();
                for (String name : names) {
                    try {
                        String val = ThreadContext.getInterceptor().onReadSystemEnv(name);
                        env.put(new VncString(name), new VncString(val));
                    }
                    catch (Exception ex) {}
                }
                return new VncHashMap(env);
            }
            VncString key = Coerce.toVncString(CoreFunctions.name.apply(VncList.of(args.first())));
            VncVal defaultVal = args.size() == 2 ? args.second() : Constants.Nil;
            String val = ThreadContext.getInterceptor().onReadSystemEnv(key.getValue());
            return val == null ? defaultVal : new VncString(val);
        }
    };
    public static VncFunction system_exit_code = new VncFunction("system-exit-code", (VncVal)VncFunction.meta().arglists("(system-exit-code code)").doc("Defines the exit code that is used if the Java VM exits. Defaults to 0. \n\nNote:\u00b6The exit code is only used when the Venice launcher has been used to run a script file, a command line script, a Venice app archive, or the REPL.").examples("(system-exit-code 0)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            VncLong code = Coerce.toVncLong(args.first());
            SYSTEM_EXIT_CODE.set(code.getIntValue());
            return Constants.Nil;
        }
    };
    public static VncFunction java_version = new VncFunction("java-version", (VncVal)VncFunction.meta().arglists("(java-version)").doc("Returns the Java VM version (1.8.0_252, 11.0.7, ...)").examples("(java-version)").seeAlso("java-major-version", "java-version-info").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 0);
            String version = System.getProperty("java.version");
            return new VncString(version);
        }
    };
    public static VncFunction java_major_version = new VncFunction("java-major-version", (VncVal)VncFunction.meta().arglists("(java-major-version)").doc("Returns the Java major version (8, 9, 11, ...).").examples("(java-major-version)").seeAlso("java-version", "java-version-info").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 0);
            return new VncLong(SystemFunctions.javaMajorVersion());
        }
    };
    public static VncFunction java_version_info = new VncFunction("java-version-info", (VncVal)VncFunction.meta().arglists("(java-version-info)").doc("Returns the Java VM version info.").examples("(java-version-info)").seeAlso("java-version", "java-major-version").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 0);
            return VncOrderedMap.of(new VncKeyword("version"), new VncString(System.getProperty("java.version")), new VncKeyword("vendor"), new VncString(System.getProperty("java.vendor")), new VncKeyword("vm-version"), new VncString(System.getProperty("java.vm.version")), new VncKeyword("vm-name"), new VncString(System.getProperty("java.vm.name")), new VncKeyword("vm-vendor"), new VncString(System.getProperty("java.vm.vendor")));
        }
    };
    public static VncFunction java_source_location = new VncFunction("java-source-location", (VncVal)VncFunction.meta().arglists("(java-source-location class)").doc("Returns the path of the source location of a class (fully qualified class name).").examples("(java-source-location :com.github.jlangch.venice.Venice)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            try {
                String className = Coerce.toVncString(CoreFunctions.name.apply(VncList.of(args.first()))).getValue();
                Class<?> clazz = Class.forName(className);
                URI uri = clazz.getProtectionDomain().getCodeSource().getLocation().toURI();
                return new VncString(new File(uri).getPath());
            }
            catch (Exception ex) {
                return Constants.Nil;
            }
        }
    };
    public static VncFunction total_memory = new VncFunction("total-memory", (VncVal)VncFunction.meta().arglists("(total-memory)").doc("Returns the total amount of memory available to the Java VM.").examples("(total-memory)").seeAlso("used-memory").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 0);
            System.gc();
            Runtime rt = Runtime.getRuntime();
            double totalMB = (double)rt.totalMemory() / 1024.0 / 1024.0;
            return new VncString(String.format("%.1fMB", totalMB));
        }
    };
    public static VncFunction used_memory = new VncFunction("used-memory", (VncVal)VncFunction.meta().arglists("(used-memory)").doc("Returns the currently used memory by the Java VM.").examples("(used-memory)").seeAlso("total-memory").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 0);
            System.gc();
            Runtime rt = Runtime.getRuntime();
            double usedMB = (double)(rt.totalMemory() - rt.freeMemory()) / 1024.0 / 1024.0;
            return new VncString(String.format("%.1fMB", usedMB));
        }
    };
    public static VncFunction load_jar = new VncFunction("load-jar", (VncVal)VncFunction.meta().arglists("(load-jar url)").doc("Dynamically load a JAR into the classpath. \n\nDynamically loading JARs is experimental and for security reasons available in the REPL only!").examples("(do                                                              \n  (load-module :maven)                                           \n  (let [uri (maven/uri \"org.knowm.xchart:xchart:3.6.5\" :jar)]  \n    (load-jar uri)))                                               ").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            VncString url = Coerce.toVncString(args.first());
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (cl != null && cl instanceof DynamicClassLoader2) {
                try {
                    ((DynamicClassLoader2)cl).addURL(new URL(url.getValue()));
                    return Constants.Nil;
                }
                catch (MalformedURLException ex) {
                    throw new VncException(String.format("Malformed URL '%s'", url.getValue()), ex);
                }
            }
            throw new VncException("There is no thread context ClassLoader available to dynamically load a JAR. For security reasons dynamically loading JARs is only available in the REPL!");
        }
    };
    public static VncFunction jansi_version = new VncFunction("jansi-version", (VncVal)VncFunction.meta().arglists("(jansi-version)").doc("Returns the Jansi version or nil if not available.").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 0);
            String version = SystemFunctions.getJansiVersion();
            return version == null ? Constants.Nil : new VncString(version);
        }
    };
    public static VncFunction license = new VncFunction("license", (VncVal)VncFunction.meta().arglists("(license)").doc("Returns the Venice license text.").examples("(println (license))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 0);
            String version = LicenseMgr.loadVeniceLicenseText();
            return new VncString(version);
        }
    };
    public static VncFunction license_all = new VncFunction("license-all", (VncVal)VncFunction.meta().arglists("(license-all)").doc("Returns the Venice license text with all 3rd party licenses.").examples("(println (license-all))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 0);
            String version = LicenseMgr.loadAll();
            return new VncString(version);
        }
    };
    public static final Map<VncVal, VncVal> ns = new SymbolMapBuilder().add(pid).add(byte_order).add(host_name).add(host_address).add(user_name).add(ip_private_Q).add(gc).add(cpus).add(shutdown_hook).add(callstack).add(os_type).add(os_type_Q).add(os_arch).add(os_name).add(os_version).add(system_prop).add(system_env).add(system_exit_code).add(java_version).add(java_version_info).add(java_source_location).add(java_major_version).add(total_memory).add(used_memory).add(load_jar).add(jansi_version).add(license).add(license_all).toMap();
    public static final VncKeyword CALLSTACK_KEY_FN_NAME = new VncKeyword(":fn-name");
    public static final VncKeyword CALLSTACK_KEY_FILE = new VncKeyword(":file");
    public static final VncKeyword CALLSTACK_KEY_LINE = new VncKeyword(":line");
    public static final VncKeyword CALLSTACK_KEY_COL = new VncKeyword(":col");
    public static final AtomicInteger SYSTEM_EXIT_CODE = new AtomicInteger(0);

    public static long javaMajorVersion() {
        String version = System.getProperty("java.version");
        if (version.startsWith("1.")) {
            version = version.substring(2);
        }
        return Long.parseLong(version.substring(0, version.indexOf(".")));
    }

    public static String osType() {
        switch (OS.type()) {
            case MacOSX: {
                return "mac-osx";
            }
            case Linux: {
                return "linux";
            }
            case Unix: {
                return "unix";
            }
            case Windows: {
                return "windows";
            }
        }
        return "unknown";
    }

    public static String getJansiVersion() {
        try {
            Class<?> clazz = Class.forName("org.fusesource.jansi.AnsiMain");
            Package p = clazz.getPackage();
            return p == null ? null : p.getImplementationVersion();
        }
        catch (Exception ex) {
            return null;
        }
    }
}

