/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.javainterop;

import com.github.jlangch.venice.impl.VeniceInterpreter;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;

public class DynamicClassLoader2
extends URLClassLoader {
    private static final URL[] EMPTY_URLS = new URL[0];
    private final ClassLoader systemClassLoader = DynamicClassLoader2.getSystemClassLoader();

    public DynamicClassLoader2() {
        this(DynamicClassLoader2.getParentClassLoader());
    }

    public DynamicClassLoader2(ClassLoader parent) {
        super(EMPTY_URLS, parent);
    }

    @Override
    public void addURL(URL url) {
        super.addURL(url);
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> loadedClass = this.findLoadedClass(name);
        if (loadedClass == null) {
            try {
                if (this.systemClassLoader != null) {
                    loadedClass = this.systemClassLoader.loadClass(name);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            try {
                if (loadedClass == null) {
                    loadedClass = this.findClass(name);
                }
            }
            catch (ClassNotFoundException e) {
                loadedClass = super.loadClass(name, resolve);
            }
        }
        if (resolve) {
            this.resolveClass(loadedClass);
        }
        return loadedClass;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        Enumeration<URL> parentRes;
        Enumeration<URL> thisRes;
        final LinkedList<URL> allRes = new LinkedList<URL>();
        Enumeration<URL> sysResources = this.systemClassLoader.getResources(name);
        if (sysResources != null) {
            while (sysResources.hasMoreElements()) {
                allRes.add(sysResources.nextElement());
            }
        }
        if ((thisRes = this.findResources(name)) != null) {
            while (thisRes.hasMoreElements()) {
                allRes.add(thisRes.nextElement());
            }
        }
        if ((parentRes = super.findResources(name)) != null) {
            while (parentRes.hasMoreElements()) {
                allRes.add(parentRes.nextElement());
            }
        }
        return new Enumeration<URL>(){
            final Iterator<URL> it;
            {
                this.it = allRes.iterator();
            }

            @Override
            public boolean hasMoreElements() {
                return this.it.hasNext();
            }

            @Override
            public URL nextElement() {
                return this.it.next();
            }
        };
    }

    @Override
    public URL getResource(String name) {
        URL res = null;
        if (this.systemClassLoader != null) {
            res = this.systemClassLoader.getResource(name);
        }
        if (res == null) {
            res = this.findResource(name);
        }
        if (res == null) {
            res = super.getResource(name);
        }
        return res;
    }

    private static ClassLoader getParentClassLoader() {
        ClassLoader ctxClassLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader sysClassLoader = ClassLoader.getSystemClassLoader();
        ClassLoader vncClassLoader = VeniceInterpreter.class.getClassLoader();
        if (ctxClassLoader == null) {
            return vncClassLoader;
        }
        if (ctxClassLoader == sysClassLoader) {
            return vncClassLoader;
        }
        if (DynamicClassLoader2.class.getSimpleName().equals(ctxClassLoader.getClass().getSimpleName())) {
            return vncClassLoader;
        }
        return ctxClassLoader;
    }
}

