/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.reader;

import com.github.jlangch.venice.impl.reader.ReaderPos;

public class CharacterReader {
    private static final int LF = 10;
    private static final int CR = 13;
    private static final int EOF = -1;
    private final String str;
    private final int length;
    private int chNext;
    private int pos;
    private int lineNr = 1;
    private int columnNr = 1;

    public CharacterReader(String s) {
        this.str = s == null ? "" : s;
        this.length = this.str.length();
        this.pos = this.str.isEmpty() ? 1 : 0;
        this.chNext = this.str.isEmpty() ? -1 : (int)this.str.charAt(0);
    }

    public int peek() {
        return this.chNext;
    }

    public void consume() {
        if (this.chNext != -1) {
            ++this.pos;
            if (this.chNext == 10) {
                ++this.lineNr;
                this.columnNr = 1;
            } else if (this.chNext != 13) {
                ++this.columnNr;
            }
            this.chNext = this.eof() ? -1 : (int)this.str.charAt(this.pos);
        }
    }

    public ReaderPos getPos() {
        return new ReaderPos(this.pos, this.lineNr, this.columnNr);
    }

    private boolean eof() {
        return this.pos >= this.length;
    }
}

