/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.repl;

import com.github.jlangch.venice.EofException;
import com.github.jlangch.venice.IRepl;
import com.github.jlangch.venice.Venice;
import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.IVeniceInterpreter;
import com.github.jlangch.venice.impl.RunMode;
import com.github.jlangch.venice.impl.VeniceInterpreter;
import com.github.jlangch.venice.impl.env.Env;
import com.github.jlangch.venice.impl.env.Var;
import com.github.jlangch.venice.impl.repl.NullExpander;
import com.github.jlangch.venice.impl.repl.REPL;
import com.github.jlangch.venice.impl.repl.ReplConfig;
import com.github.jlangch.venice.impl.repl.ReplDirs;
import com.github.jlangch.venice.impl.repl.ReplFunctions;
import com.github.jlangch.venice.impl.repl.ReplPrintStream;
import com.github.jlangch.venice.impl.repl.ReplResultHistory;
import com.github.jlangch.venice.impl.repl.TerminalPrinter;
import com.github.jlangch.venice.impl.thread.ThreadContext;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.util.CommandLineArgs;
import com.github.jlangch.venice.javainterop.IInterceptor;
import com.github.jlangch.venice.javainterop.ILoadPaths;
import java.io.BufferedReader;
import java.io.File;
import java.io.PrintStream;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.repackage.org.jline.reader.EndOfFileException;
import org.repackage.org.jline.reader.LineReader;
import org.repackage.org.jline.reader.LineReaderBuilder;
import org.repackage.org.jline.reader.MaskingCallback;
import org.repackage.org.jline.reader.UserInterruptException;
import org.repackage.org.jline.reader.impl.history.DefaultHistory;
import org.repackage.org.jline.terminal.Terminal;
import org.repackage.org.jline.terminal.TerminalBuilder;
import org.repackage.org.jline.utils.OSUtils;

public class CustomREPL
implements IRepl {
    private static final String DEFAULT_PROMPT_PRIMARY = "venice> ";
    private static final String DEFAULT_PROMPT_SECONDARY = "      | ";
    private final File app;
    private Terminal terminal;
    private String prompt = "venice> ";
    private String secondaryPrompt = "      | ";
    private Consumer<String> cmdHandler;
    private ReplConfig config;
    private IInterceptor interceptor;
    private boolean macroexpand = false;
    private boolean ansiTerminal = false;

    public CustomREPL(IInterceptor interceptor, File app) {
        this.interceptor = interceptor;
        this.app = app;
    }

    public void run(String[] args) {
        ThreadContext.setInterceptor(this.interceptor);
        if (this.terminal != null) {
            throw new VncException("The REPL is already running!");
        }
        CommandLineArgs cli = new CommandLineArgs(args);
        ILoadPaths loadpaths = this.interceptor.getLoadPaths();
        try {
            this.config = ReplConfig.load(cli);
            this.initJLineLogger(this.config);
            boolean setupMode = this.isSetupMode(cli);
            this.macroexpand = this.isMacroexpand(cli);
            this.ansiTerminal = this.isAnsiTerminal(cli, this.config);
            if (OSUtils.IS_WINDOWS) {
                String jansiVersion = this.config.getJansiVersion();
                if (jansiVersion != null) {
                    System.out.println("Using Jansi V" + jansiVersion);
                } else if (!setupMode) {
                    System.out.print("--------------------------------------------------------------------\nThe Venice REPL requires the jansi library on Windows.              \nPlease download the jar artifact 'org.fusesource.jansi:jansi:2.4.1' \nfrom a Maven repo and put it on the classpath.                      \n--------------------------------------------------------------------\n\n");
                }
            }
            System.out.println("Venice custom REPL: V" + Venice.getVersion() + (setupMode ? " (setup mode)" : ""));
            System.out.println("Java: " + System.getProperty("java.version"));
            System.out.println("Loading configuration from " + this.config.getConfigSource());
            if (loadpaths.active()) {
                System.out.print("Load paths: ");
                System.out.println(loadpaths.isUnlimitedAccess() ? "unrestricted > " : "retricted > ");
                loadpaths.getPaths().forEach(p -> System.out.println("   " + p));
            }
            System.out.println(this.getTerminalInfo());
            if (this.macroexpand) {
                System.out.println("Macro expansion enabled");
            }
            if (!setupMode) {
                System.out.println("Type '!' for help.");
            }
            this.repl(cli);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void setHandler(Consumer<String> handler) {
        this.cmdHandler = handler;
    }

    @Override
    public void setPrompt(String prompt) {
        this.prompt = prompt;
        this.secondaryPrompt = "";
    }

    @Override
    public void setPrompt(String prompt, String secondaryPrompt) {
        this.prompt = prompt;
        this.secondaryPrompt = secondaryPrompt;
    }

    @Override
    public int getTerminalWidth() {
        return this.terminal.getWidth();
    }

    @Override
    public int getTerminalHeight() {
        return this.terminal.getHeight();
    }

    private void repl(CommandLineArgs cli) throws Exception {
        this.setPrompt(this.config.getPrompt(), this.ansiTerminal ? this.config.getSecondaryPrompt() : "");
        Thread mainThread = Thread.currentThread();
        TerminalBuilder builder = TerminalBuilder.builder().streams(System.in, System.out).system(true).dumb(!this.ansiTerminal).jna(false);
        this.terminal = OSUtils.IS_WINDOWS ? builder.jansi(this.ansiTerminal).build() : builder.encoding("UTF-8").build();
        this.terminal.handle(Terminal.Signal.INT, signal -> mainThread.interrupt());
        TerminalPrinter printer = new TerminalPrinter(this.config, this.terminal, this.ansiTerminal, false);
        PrintStream out = this.createPrintStream("stdout", this.terminal);
        PrintStream err = this.createPrintStream("stderr", this.terminal);
        BufferedReader in = this.createBufferedReader("stdin", this.terminal);
        VeniceInterpreter venice = new VeniceInterpreter(this.interceptor);
        Env env = this.loadEnv(venice, cli, out, err, in);
        if (this.isSetupMode(cli)) {
            this.setupRepl(cli, venice, env, printer);
            return;
        }
        if (!this.runApp(venice, env, printer)) {
            return;
        }
        DefaultHistory history = new DefaultHistory();
        LineReader reader = LineReaderBuilder.builder().appName("Venice").terminal(this.terminal).history(history).expander(new NullExpander()).option(LineReader.Option.HISTORY_IGNORE_SPACE, false).variable("secondary-prompt-pattern", this.secondaryPrompt).build();
        ReplResultHistory resultHistory = new ReplResultHistory(3);
        while (true) {
            resultHistory.mergeToEnv(env);
            try {
                Thread.interrupted();
                String line = reader.readLine(this.prompt, null, (MaskingCallback)null, null);
                if (line == null) continue;
                this.cmdHandler.accept(line);
                continue;
            }
            catch (UserInterruptException ex) {
                Thread.interrupted();
                printer.println("interrupt", " ! interrupted ! ");
                Thread.sleep(1000L);
            }
            catch (EofException | EndOfFileException ex) {
            }
            catch (Exception ex) {
                printer.printex("error", ex);
                continue;
            }
            break;
        }
    }

    private Env loadEnv(IVeniceInterpreter venice, CommandLineArgs cli, PrintStream out, PrintStream err, BufferedReader in) {
        Env env = venice.createEnv(this.macroexpand, this.ansiTerminal, RunMode.REPL).setGlobal(new Var(new VncSymbol("*ARGV*"), cli.argsAsList(), false, Var.Scope.Global)).setStdoutPrintStream(out).setStderrPrintStream(err).setStdinReader(in);
        return ReplFunctions.register(env, this, this.terminal, this.config, this.macroexpand, ReplDirs.create());
    }

    private PrintStream createPrintStream(String context, Terminal terminal) {
        return new ReplPrintStream(terminal, this.ansiTerminal ? this.config.getColor(context) : null);
    }

    private BufferedReader createBufferedReader(String context, Terminal terminal) {
        return new BufferedReader(terminal.reader());
    }

    private void handleSetupCommand(IVeniceInterpreter venice, Env env, REPL.SetupMode setupMode, TerminalPrinter printer) {
        try {
            ReplConfig.ColorMode colorMode = this.config.isColorModeLight() && OSUtils.IS_WINDOWS ? ReplConfig.ColorMode.Dark : this.config.getColorMode();
            String sSetupMode = ":" + setupMode.name().toLowerCase();
            String sColorMode = ":" + colorMode.name().toLowerCase();
            String script = String.format("(do                                     \n  (load-module :repl-setup)             \n  (repl-setup/setup :setup-mode %s      \n                    :color-mode %s      \n                    :ansi-terminal %s))   ", sSetupMode, sColorMode, this.ansiTerminal ? "true" : "false");
            venice.RE(script, "user", env);
        }
        catch (Exception ex) {
            printer.printex("error", ex);
            printer.println("error", "REPL setup failed!");
        }
    }

    private String getTerminalInfo() {
        if (this.ansiTerminal) {
            if (this.config.getColorMode() == ReplConfig.ColorMode.None) {
                return "Using ansi terminal (colors turned off, turn on with option '-colors')";
            }
            return "Using ansi terminal (colors turned on)";
        }
        return "Using dumb terminal (colors turned off)";
    }

    private boolean isAnsiTerminal(CommandLineArgs cli, ReplConfig config) {
        String jansiVersion = config.getJansiVersion();
        boolean dumbTerminal = OSUtils.IS_WINDOWS && jansiVersion == null || cli.switchPresent("-dumb") || config.isJLineDumbTerminal();
        return !dumbTerminal;
    }

    private void initJLineLogger(ReplConfig config) {
        Level jlineLogLevel = config.getJLineLogLevel();
        if (jlineLogLevel != null) {
            Logger.getLogger("org.repackage.org.jline").setLevel(jlineLogLevel);
        }
    }

    private boolean runApp(IVeniceInterpreter venice, Env env, TerminalPrinter printer) {
        try {
            if (this.app != null) {
                printer.println("stdout", "Loading file: '" + this.app.getPath() + "'");
                venice.RE("(load-file \"" + this.app.getPath() + "\")", "user", env);
            }
            return true;
        }
        catch (Exception ex) {
            printer.printex("error", ex);
            printer.println("error", "Stopped REPL");
            return false;
        }
    }

    private boolean isSetupMode(CommandLineArgs cli) {
        return cli.switchPresent("-setup") || cli.switchPresent("-setup-ext") || cli.switchPresent("-setup-extended");
    }

    private boolean isMacroexpand(CommandLineArgs cli) {
        return cli.switchPresent("-macroexpand");
    }

    private void setupRepl(CommandLineArgs cli, IVeniceInterpreter venice, Env env, TerminalPrinter printer) {
        if (cli.switchPresent("-setup-ext") || cli.switchPresent("-setup-extended")) {
            this.handleSetupCommand(venice, env, REPL.SetupMode.Extended, printer);
            return;
        }
        if (cli.switchPresent("-setup")) {
            this.handleSetupCommand(venice, env, REPL.SetupMode.Minimal, printer);
            return;
        }
    }
}

