/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types;

import com.github.jlangch.venice.ArityException;
import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.types.TypeRank;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncMultiArityFunction;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.impl.util.MetaUtil;
import java.util.concurrent.ConcurrentHashMap;

public class VncProtocolFunction
extends VncFunction {
    public static final String TYPE = ":core/protocol-function";
    private static final long serialVersionUID = -1848883965231344442L;
    private final VncSymbol protocol;
    private final VncMultiArityFunction defaultFn;
    private final ConcurrentHashMap<VncKeyword, VncFunction> typeFunctions = new ConcurrentHashMap();

    public VncProtocolFunction(String name, VncSymbol protocol, VncMultiArityFunction defaultFn, VncVal meta) {
        super(name, null, false, null, meta);
        this.protocol = protocol;
        this.defaultFn = defaultFn;
    }

    public VncSymbol getProtocolName() {
        return this.protocol;
    }

    public void register(VncKeyword type, VncFunction fn) {
        this.typeFunctions.put(type, fn);
    }

    public void unregister(VncKeyword type) {
        this.typeFunctions.remove(type);
    }

    @Override
    public VncProtocolFunction withMeta(VncVal meta) {
        super.withMeta(meta);
        return this;
    }

    @Override
    public VncKeyword getType() {
        return new VncKeyword(TYPE, MetaUtil.typeMeta(new VncKeyword(":core/function"), new VncKeyword(":core/val")));
    }

    @Override
    public VncVal apply(VncList args) {
        return this.getFunctionForArgs(args).apply(args);
    }

    @Override
    public boolean isNative() {
        return false;
    }

    @Override
    public VncFunction getFunctionForArgs(VncList args) {
        VncKeyword type = Types.getType(args.first());
        VncFunction fn = this.typeFunctions.get(type);
        if (fn != null) {
            if (fn instanceof VncMultiArityFunction) {
                try {
                    return ((VncMultiArityFunction)fn).getFunctionForArgs(args);
                }
                catch (ArityException ex) {
                    return this.defaultFn.getFunctionForArgs(args);
                }
            }
            int arity = args.size();
            if (fn.hasVariadicArgs() ? arity >= fn.getFixedArgsCount() : fn.getFixedArgsCount() == arity) {
                return fn;
            }
        }
        return this.defaultFn.getFunctionForArgs(args);
    }

    @Override
    public VncFunction getFunctionForArity(int arity) {
        throw new VncException("Not supported VncProtocolFunction::getFunctionForArity(..)!");
    }

    @Override
    public TypeRank typeRank() {
        return TypeRank.MULTI_PROTOCOL_FUNCTION;
    }
}

