/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.util.io.zip;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.util.io.zip.Zipper;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;

public class ZipFileSystemUtil {
    public static FileSystem mountZip(File zip) throws IOException {
        try {
            return FileSystems.newFileSystem(zip.toPath(), Zipper.class.getClassLoader());
        }
        catch (Exception ex) {
            throw new VncException(String.format("Failed to mount ZIP filesystem from '%s'", zip.getPath()));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ByteBuffer loadBinaryFileFromZip(File zip, File file) {
        if (!zip.exists()) {
            throw new VncException(String.format("The ZIP file '%s' does not exist", zip.getPath()));
        }
        try (FileSystem zipFS = ZipFileSystemUtil.mountZip(zip);){
            byte[] data = Files.readAllBytes(zipFS.getPath(file.getPath(), new String[0]));
            ByteBuffer byteBuffer = ByteBuffer.wrap(data);
            return byteBuffer;
        }
        catch (Exception ex) {
            throw new VncException(String.format("Failed to load binary file '%s' from ZIP '%s'", file.getPath(), zip.getPath()));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String loadTextFileFromZip(File zip, File file, Charset charset) {
        if (!zip.exists()) {
            throw new VncException(String.format("The ZIP file '%s' does not exist", zip.getPath()));
        }
        try (FileSystem zipFS = ZipFileSystemUtil.mountZip(zip);){
            byte[] data = Files.readAllBytes(zipFS.getPath(file.getPath(), new String[0]));
            String string = new String(data, charset);
            return string;
        }
        catch (Exception ex) {
            throw new VncException(String.format("Failed to load file '%s' from ZIP '%s'", file.getPath(), zip.getPath()));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static InputStream getInputStreamFromZip(File zip, File file) {
        if (!zip.exists()) {
            throw new VncException(String.format("The ZIP file '%s' does not exist", zip.getPath()));
        }
        try (FileSystem zipFS = ZipFileSystemUtil.mountZip(zip);){
            byte[] data = Files.readAllBytes(zipFS.getPath(file.getPath(), new String[0]));
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(data);
            return byteArrayInputStream;
        }
        catch (Exception ex) {
            throw new VncException(String.format("Failed to return an InputStream for file '%s' from ZIP '%s'", file.getPath(), zip.getPath()));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static BufferedReader getBufferedReaderFromZip(File zip, File file, Charset charset) {
        if (!zip.exists()) {
            throw new VncException(String.format("The ZIP file '%s' does not exist", zip.getPath()));
        }
        try (FileSystem zipFS = ZipFileSystemUtil.mountZip(zip);){
            byte[] data = Files.readAllBytes(zipFS.getPath(file.getPath(), new String[0]));
            BufferedReader bufferedReader = new BufferedReader(new StringReader(new String(data, charset)));
            return bufferedReader;
        }
        catch (Exception ex) {
            throw new VncException(String.format("Failed to return a BufferedReader for file '%s' from ZIP '%s'", file.getPath(), zip.getPath()));
        }
    }
}

