/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.util.ssl;

import com.github.jlangch.venice.util.ssl.TlsProtocol;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public abstract class SSLSocketFactoryUtil {
    public static SSLSocketFactory getDefault() {
        return (SSLSocketFactory)SSLSocketFactory.getDefault();
    }

    public static SSLSocketFactory create(TlsProtocol protocol) throws IOException, NoSuchAlgorithmException, KeyManagementException {
        return SSLSocketFactoryUtil.create(protocol, null);
    }

    public static SSLSocketFactory create(TrustManager tm) throws IOException, NoSuchAlgorithmException, KeyManagementException {
        return SSLSocketFactoryUtil.create(null, tm);
    }

    public static SSLSocketFactory create(TlsProtocol protocol, TrustManager tm) throws IOException, NoSuchAlgorithmException, KeyManagementException {
        TrustManager[] trustManagerArray;
        SSLContext sslContext;
        SSLContext sSLContext = sslContext = protocol == null ? SSLContext.getDefault() : SSLContext.getInstance(protocol.toString());
        if (tm == null) {
            trustManagerArray = null;
        } else {
            TrustManager[] trustManagerArray2 = new TrustManager[1];
            trustManagerArray = trustManagerArray2;
            trustManagerArray2[0] = tm;
        }
        sslContext.init(null, trustManagerArray, new SecureRandom());
        return sslContext.getSocketFactory();
    }
}

