/*   __    __         _
 *   \ \  / /__ _ __ (_) ___ ___
 *    \ \/ / _ \ '_ \| |/ __/ _ \
 *     \  /  __/ | | | | (_|  __/
 *      \/ \___|_| |_|_|\___\___|
 *
 *
 * Copyright 2017-2024 Venice
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.github.jlangch.venice.impl.docgen.cheatsheet.modules;

import com.github.jlangch.venice.impl.docgen.cheatsheet.DocItemBuilder;
import com.github.jlangch.venice.impl.docgen.cheatsheet.DocSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.ISectionBuilder;


public class ModuleGradleWrapperSection implements ISectionBuilder {

    public ModuleGradleWrapperSection(final DocItemBuilder diBuilder) {
        this.diBuilder = diBuilder;
    }

    @Override
    public DocSection section() {
        final DocSection section = new DocSection(
                                            "Gradle Wrapper",
                                            "Uses the 'gradlew.sh' or 'gradlew.bat' shell scripts " +
                                            "from a Gradle project to run Gradle commands on the " +
                                            "project.\n\n" +
                                            "For projects not based on the Gradle Wrapper use the " +
                                            ":gradle module instead.",
                                            "modules.gradlew");

        final DocSection all = new DocSection("(load-module :gradlew)", id());
        section.addSection(all);

        final DocSection gradle = new DocSection("Gradle", id());
        all.addSection(gradle);
        gradle.addItem(diBuilder.getDocItem("gradlew/version", false));
        gradle.addItem(diBuilder.getDocItem("gradlew/run", false));
        gradle.addItem(diBuilder.getDocItem("gradlew/run*", false));

        return section;
    }

    private String id() {
        return diBuilder.id();
    }

    private final DocItemBuilder diBuilder;
}
