/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.functions;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.VncBoolean;
import com.github.jlangch.venice.impl.types.VncByteBuffer;
import com.github.jlangch.venice.impl.types.VncChar;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncJavaObject;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncLong;
import com.github.jlangch.venice.impl.types.VncNumber;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncHashMap;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncSequence;
import com.github.jlangch.venice.impl.types.util.Coerce;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.impl.util.ArityExceptions;
import com.github.jlangch.venice.impl.util.HexFormatter;
import com.github.jlangch.venice.impl.util.HexUtil;
import com.github.jlangch.venice.impl.util.LoremIpsum;
import com.github.jlangch.venice.impl.util.StringEscapeUtil;
import com.github.jlangch.venice.impl.util.StringUtil;
import com.github.jlangch.venice.impl.util.SymbolMapBuilder;
import com.github.jlangch.venice.impl.util.markdown.Markdown;
import com.github.jlangch.venice.impl.util.markdown.renderer.text.LineWrap;
import com.github.jlangch.venice.impl.util.markdown.renderer.text.TextRenderer;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.Normalizer;
import java.util.Arrays;
import java.util.Base64;
import java.util.IllegalFormatException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.repackage.org.jline.utils.Levenshtein;

public class StringFunctions {
    public static VncFunction str_blank_Q = new VncFunction("str/blank?", (VncVal)VncFunction.meta().arglists("(str/blank? s)").doc("True if s is nil, empty, or contains only whitespace.").examples("(str/blank? nil)", "(str/blank? \"\")", "(str/blank? \"  \")", "(str/blank? \"abc\")").seeAlso("str/not-blank?", "empty?", "not-empty?", "nil?").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            if (args.first() == Constants.Nil) {
                return VncBoolean.True;
            }
            String s = Coerce.toVncString(args.first()).getValue();
            return VncBoolean.of(StringUtil.isBlank(s));
        }
    };
    public static VncFunction str_not_blank_Q = new VncFunction("str/not-blank?", (VncVal)VncFunction.meta().arglists("(str/not-blank? s)").doc("True if s contains at least one non whitespace char.").examples("(str/not-blank? \"abc\")", "(str/not-blank? \" a \")", "(str/not-blank? nil)", "(str/not-blank? \"\")", "(str/not-blank? \"  \")").seeAlso("str/blank?", "empty?", "not-empty?", "nil?").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            if (args.first() == Constants.Nil) {
                return VncBoolean.False;
            }
            String s = Coerce.toVncString(args.first()).getValue();
            return VncBoolean.of(StringUtil.isNotBlank(s));
        }
    };
    public static VncFunction str_char_Q = new VncFunction("str/char?", (VncVal)VncFunction.meta().arglists("(str/char? s)").doc("Returns true if s is a char or a single char string.").examples("(str/char? \"x\")", "(str/char? #\\x)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            VncVal s = args.first();
            if (s == Constants.Nil) {
                return Constants.Nil;
            }
            if (Types.isVncChar(s)) {
                return VncBoolean.True;
            }
            return VncBoolean.of(Types.isVncString(s) && ((VncString)s).size() == 1);
        }
    };
    public static VncFunction str_starts_with_Q = new VncFunction("str/starts-with?", (VncVal)VncFunction.meta().arglists("(str/starts-with? s substr)").doc("True if s starts with substr.").examples("(str/starts-with? \"abc\"  \"ab\")").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2);
            if (args.first() == Constants.Nil || args.second() == Constants.Nil) {
                return VncBoolean.False;
            }
            VncString string = Coerce.toVncString(args.first());
            VncString prefix = Coerce.toVncString(args.second());
            return VncBoolean.of(string.getValue().startsWith(prefix.getValue()));
        }
    };
    public static VncFunction str_ends_with_Q = new VncFunction("str/ends-with?", (VncVal)VncFunction.meta().arglists("(str/ends-with? s substr)").doc("True if s ends with substr.").examples("(str/ends-with? \"abc\"  \"bc\")").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2);
            if (args.first() == Constants.Nil || args.second() == Constants.Nil) {
                return VncBoolean.False;
            }
            VncString string = Coerce.toVncString(args.first());
            VncString suffix = Coerce.toVncString(args.second());
            return VncBoolean.of(string.getValue().endsWith(suffix.getValue()));
        }
    };
    public static VncFunction str_contains_Q = new VncFunction("str/contains?", (VncVal)VncFunction.meta().arglists("(str/contains? s substr)").doc("True if s contains with substr.").examples("(str/contains? \"abc\" \"ab\")", "(str/contains? \"abc\" #\\b)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2);
            if (args.first() == Constants.Nil || args.second() == Constants.Nil) {
                return VncBoolean.False;
            }
            VncString string = Coerce.toVncString(args.first());
            VncVal vSubstr = args.second();
            if (Types.isVncString(vSubstr)) {
                String text = Coerce.toVncString(args.second()).getValue();
                if (text.isEmpty()) {
                    return VncBoolean.False;
                }
                return VncBoolean.of(string.getValue().contains(text));
            }
            if (Types.isVncChar(vSubstr)) {
                Character ch = Coerce.toVncChar(args.second()).getValue();
                String text = String.valueOf(ch);
                return VncBoolean.of(string.getValue().contains(text));
            }
            return VncBoolean.False;
        }
    };
    public static VncFunction str_equals_ignore_case_Q = new VncFunction("str/equals-ignore-case?", (VncVal)VncFunction.meta().arglists("(str/equals-ignore-case? s1 s2)").doc("Compares two strings ignoring case. True if both are equal.").examples("(str/equals-ignore-case? \"abc\"  \"abC\")").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2);
            VncVal v1 = args.first();
            VncVal v2 = args.second();
            if (v1 == Constants.Nil && v2 == Constants.Nil) {
                return VncBoolean.True;
            }
            if (v1 != Constants.Nil && v2 != Constants.Nil) {
                String s1 = Coerce.toVncString(args.first()).getValue();
                String s2 = Coerce.toVncString(args.second()).getValue();
                return VncBoolean.of(s1.equalsIgnoreCase(s2));
            }
            return VncBoolean.False;
        }
    };
    public static VncFunction str_align = new VncFunction("str/align", (VncVal)VncFunction.meta().arglists("(str/align width align overflow text)").doc("Aligns a text within a string of width characters.\n\nalign: :left, :center, :right\n\noverflow: :newline :clip-left, :clip-right, :ellipsis-left, :ellipsis-right").examples("(str/align 6 :left :clip-right \"abc\")", "(str/align 6 :center :clip-right \"abc\")", "(str/align 6 :right :clip-right \"abc\")", "(str/align 6 :left :clip-left \"abcdefgh\")", "(str/align 6 :left :ellipsis-left \"abcdefgh\")", "(str/align 6 :left :ellipsis-right \"abcdefgh\")").seeAlso("str/trim-to-nil", "str/trim-left", "str/trim-right").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 4);
            int width = Coerce.toVncLong(args.first()).toJavaInteger();
            String align = Coerce.toVncKeyword(args.second()).getSimpleName();
            String overflow = Coerce.toVncKeyword(args.third()).getSimpleName();
            String text = Coerce.toVncString(args.fourth()).getValue().trim().replace('\t', ' ');
            Function<String, List> clip = s -> {
                int len = s.length();
                switch (overflow) {
                    case "newline": {
                        return LineWrap.softWrap(s, width);
                    }
                    case "clip-left": {
                        return Arrays.asList(len > width ? s.substring(len - width, len) : s);
                    }
                    case "clip-right": {
                        return Arrays.asList(len > width ? s.substring(0, width) : s);
                    }
                    case "ellipsis-left": {
                        return Arrays.asList(len > width ? "\u2026" + s.substring(len - width + 1, len) : s);
                    }
                    case "ellipsis-right": {
                        return Arrays.asList(len > width ? s.substring(0, width - 1) + "\u2026" : s);
                    }
                }
                throw new VncException(String.format("Function 'str/align' got undefined overflow :%s.", overflow));
            };
            Function<String, String> justify = s -> {
                if (s.length() < width) {
                    switch (align) {
                        case "left": {
                            return StringUtil.padRight(s, width);
                        }
                        case "right": {
                            return StringUtil.padLeft(s, width);
                        }
                        case "center": {
                            return StringUtil.padCenter(s, width);
                        }
                    }
                    throw new VncException(String.format("Function 'str/align' got undefined align :%s.", align));
                }
                return s;
            };
            return new VncString(text.isEmpty() ? StringUtil.repeat(' ', width) : StringUtil.splitIntoLines(text).stream().map(s -> s.trim()).map(s -> (List)clip.apply((String)s)).flatMap(list -> list.stream()).map(s -> (String)justify.apply((String)s)).collect(Collectors.joining(System.lineSeparator())));
        }
    };
    public static VncFunction str_trim = new VncFunction("str/trim", (VncVal)VncFunction.meta().arglists("(str/trim s)").doc("Trims leading and trailing whitespaces from s.").examples("(str/trim \" abc  \")").seeAlso("str/trim-to-empty", "str/trim-to-nil", "str/trim-left", "str/trim-right").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            if (args.first() == Constants.Nil) {
                return Constants.Nil;
            }
            return new VncString(Coerce.toVncString(args.first()).getValue().trim());
        }
    };
    public static VncFunction str_trim_left = new VncFunction("str/trim-left", (VncVal)VncFunction.meta().arglists("(str/trim-left s)").doc("Trims leading whitespaces from s.").examples("(str/trim-left \" abc \")").seeAlso("str/trim-right", "str/trim", "str/trim-to-nil").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            if (args.first() == Constants.Nil) {
                return Constants.Nil;
            }
            return new VncString(StringUtil.trimLeft(Coerce.toVncString(args.first()).getValue()));
        }
    };
    public static VncFunction str_trim_right = new VncFunction("str/trim-right", (VncVal)VncFunction.meta().arglists("(str/trim-right s)").doc("Trims trailing whitespaces from s.").examples("(str/trim-right \" abc \")").seeAlso("str/trim-left", "str/trim", "str/trim-to-nil").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            if (args.first() == Constants.Nil) {
                return Constants.Nil;
            }
            return new VncString(StringUtil.trimRight(Coerce.toVncString(args.first()).getValue()));
        }
    };
    public static VncFunction str_trim_to_empty = new VncFunction("str/trim-to-empty", (VncVal)VncFunction.meta().arglists("(str/trim-to-empty s)").doc("Trims leading and trailing whitespaces from s. Returns an empty string if s is nil.").examples("(str/trim-to-empty \"\")", "(str/trim-to-empty \"    \")", "(str/trim-to-empty nil)", "(str/trim-to-empty \" abc   \")").seeAlso("str/trim", "str/trim-left", "str/trim-right").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            if (args.first() == Constants.Nil) {
                return VncString.EMPTY;
            }
            String str = Coerce.toVncString(args.first()).getValue().trim();
            return new VncString(str);
        }
    };
    public static VncFunction str_trim_to_nil = new VncFunction("str/trim-to-nil", (VncVal)VncFunction.meta().arglists("(str/trim-to-nil s)").doc("Trims leading and trailing whitespaces from s. Returns nil if the resulting string is empty").examples("(str/trim-to-nil \"\")", "(str/trim-to-nil \"    \")", "(str/trim-to-nil nil)", "(str/trim-to-nil \" abc   \")").seeAlso("str/trim-to-empty", "str/trim", "str/trim-left", "str/trim-right").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            if (args.first() == Constants.Nil) {
                return Constants.Nil;
            }
            String str = Coerce.toVncString(args.first()).getValue().trim();
            return str.isEmpty() ? Constants.Nil : new VncString(str);
        }
    };
    public static VncFunction str_index_of = new VncFunction("str/index-of", (VncVal)VncFunction.meta().arglists("(str/index-of s value)", "(str/index-of s value from-index)").doc("Return index of value (string or char) in s, optionally searching forward from from-index. Return nil if value not found.").examples("(str/index-of \"abcdefabc\" \"ab\")").seeAlso("str/index-of-char", "str/index-of-not-char", "str/last-index-of").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2, 3);
            if (Constants.Nil == args.first() || Constants.Nil == args.second()) {
                return Constants.Nil;
            }
            String text = Coerce.toVncString(args.first()).getValue();
            String searchString = Coerce.toVncString(args.second()).getValue();
            if (text.isEmpty() || searchString.isEmpty()) {
                return Constants.Nil;
            }
            if (args.size() == 3) {
                int startPos = Coerce.toVncLong(args.nth(2)).getValue().intValue();
                int pos = text.indexOf(searchString, startPos);
                return pos < 0 ? Constants.Nil : new VncLong(pos);
            }
            int pos = text.indexOf(searchString);
            return pos < 0 ? Constants.Nil : new VncLong(pos);
        }
    };
    public static VncFunction str_index_of_char = new VncFunction("str/index-of-char", (VncVal)VncFunction.meta().arglists("(str/index-of-char s chars)", "(str/index-of-char s chars from-index)").doc("Return index of the first char of chars (string or sequence of chars) in s, optionally searching forward from from-index. Return nil if value not found.").examples("(str/index-of-char \"-+-123-+-123\" \"012\")", "(str/index-of-char \"-+-123-+-123\" [#\\0 #\\1 #\\2])", "(str/index-of-char \"-+-123-+-123\" \"012\" 7)").seeAlso("str/index-of-not-char", "str/index-of", "str/last-index-of").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            int startPos;
            String chars;
            ArityExceptions.assertArity(this, args, 2, 3);
            if (Constants.Nil == args.first() || Constants.Nil == args.second()) {
                return Constants.Nil;
            }
            String text = Coerce.toVncString(args.first()).getValue();
            if (Types.isVncString(args.second())) {
                chars = Coerce.toVncString(args.second()).getValue();
            } else if (Types.isVncSequence(args.second())) {
                String errMsg = "The 'chars' sequence elements must be chars";
                chars = Coerce.toVncSequence(args.second()).getJavaList().stream().map(v -> {
                    if (Types.isVncChar(v)) {
                        return v;
                    }
                    throw new VncException("The 'chars' sequence elements must be chars");
                }).map(v -> v.toString()).collect(Collectors.joining());
            } else {
                throw new VncException(String.format("Function 'str/index-one-char-of' does not allow %s as chars argument.", Types.getType(args.second())));
            }
            if (text.isEmpty() || chars.isEmpty()) {
                return Constants.Nil;
            }
            int n = startPos = args.size() == 3 ? Coerce.toVncLong(args.nth(2)).getValue().intValue() : 0;
            if (startPos < 0) {
                return Constants.Nil;
            }
            int pos = StringUtil.indexOneCharOf(text, chars, startPos);
            return pos < 0 ? Constants.Nil : new VncLong(pos);
        }
    };
    public static VncFunction str_index_of_not_char = new VncFunction("str/index-of-not-char", (VncVal)VncFunction.meta().arglists("(str/index-of-not-char s chars)", "(str/index-of-not-char s chars from-index)").doc("Return index of the first char not of chars (string or sequence of chars) in s, optionally searching forward from from-index. Return nil if value not found.").examples("(str/index-of-not-char \"-+-123-+-123\" \"-+\")", "(str/index-of-not-char \"-+-123-+-123\" [#\\- #\\+])", "(str/index-of-not-char \"-+-123-+-123\" \"-+\" 7)").seeAlso("str/index-of-char", "str/index-of", "str/last-index-of").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            int startPos;
            String chars;
            ArityExceptions.assertArity(this, args, 2, 3);
            if (Constants.Nil == args.first() || Constants.Nil == args.second()) {
                return Constants.Nil;
            }
            String text = Coerce.toVncString(args.first()).getValue();
            if (Types.isVncString(args.second())) {
                chars = Coerce.toVncString(args.second()).getValue();
            } else if (Types.isVncSequence(args.second())) {
                String errMsg = "The 'chars' sequence elements must be chars";
                chars = Coerce.toVncSequence(args.second()).getJavaList().stream().map(v -> {
                    if (Types.isVncChar(v)) {
                        return v;
                    }
                    throw new VncException("The 'chars' sequence elements must be chars");
                }).map(v -> v.toString()).collect(Collectors.joining());
            } else {
                throw new VncException(String.format("Function 'str/index-one-char-not-of' does not allow %s as chars argument.", Types.getType(args.second())));
            }
            if (text.isEmpty() || chars.isEmpty()) {
                return Constants.Nil;
            }
            int n = startPos = args.size() == 3 ? Coerce.toVncLong(args.nth(2)).getValue().intValue() : 0;
            if (startPos < 0) {
                return Constants.Nil;
            }
            int pos = StringUtil.indexNotOf(text, chars, startPos);
            return pos < 0 ? Constants.Nil : new VncLong(pos);
        }
    };
    public static VncFunction str_last_index_of = new VncFunction("str/last-index-of", (VncVal)VncFunction.meta().arglists("(str/last-index-of s value)", "(str/last-index-of s value from-index)").doc("Return last index of value (string or char) in s, optionally searching backward from from-index. Return nil if value not found.").examples("(str/last-index-of \"abcdefabc\" \"ab\")", "(str/last-index-of \"abcdefabc\" \"de\" 6)").seeAlso("str/index-of", "str/index-of-char", "str/index-of-not-char").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2, 3);
            if (Constants.Nil == args.first() || Constants.Nil == args.second()) {
                return Constants.Nil;
            }
            String text = Coerce.toVncString(args.first()).getValue();
            String searchString = Coerce.toVncString(args.second()).getValue();
            if (text.isEmpty() || searchString.isEmpty()) {
                return Constants.Nil;
            }
            if (args.size() > 2) {
                int startPos = Coerce.toVncLong(args.nth(2)).getValue().intValue();
                int pos = text.lastIndexOf(searchString, startPos);
                return pos < 0 ? Constants.Nil : new VncLong(pos);
            }
            int pos = text.lastIndexOf(searchString);
            return pos < 0 ? Constants.Nil : new VncLong(pos);
        }
    };
    public static VncFunction str_replace_all = new VncFunction("str/replace-all", (VncVal)VncFunction.meta().arglists("(str/replace-all s search replacement)").doc("Replaces the all occurrances of search in s. The search arg may be a string or a regex pattern").examples("(str/replace-all \"abcdefabc\" \"ab\" \"__\")", "(str/replace-all \"a0b01c012d\" (regex/pattern \"[0-9]+\") \"_\")", "(str/replace-all \"a0b01c012d\" #\"[0-9]+\" \"_\")").seeAlso("str/replace-first", "str/replace-last").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertMinArity(this, args, 3);
            if (args.first() == Constants.Nil) {
                return Constants.Nil;
            }
            String text = Coerce.toVncString(args.first()).getValue();
            VncVal search = args.second();
            String replacement = Coerce.toVncString(args.third()).getValue();
            VncHashMap options = VncHashMap.ofAll(args.slice(3));
            boolean ignoreCase = VncBoolean.isTrue(options.get(new VncKeyword("ignore-case"), VncBoolean.False));
            if (Types.isVncString(search)) {
                String searchString = Coerce.toVncString(args.second()).getValue();
                return new VncString(StringUtil.replace(text, searchString, replacement, 1000000, ignoreCase));
            }
            if (Types.isVncJavaObject(search, Pattern.class)) {
                Pattern p = Coerce.toVncJavaObject(search, Pattern.class);
                Matcher m = p.matcher(text);
                return new VncString(m.replaceAll(replacement));
            }
            throw new VncException(String.format("Function 'str/replace-all' does not allow %s as search argument.", Types.getType(search)));
        }
    };
    public static VncFunction str_replace_first = new VncFunction("str/replace-first", (VncVal)VncFunction.meta().arglists("(str/replace-first s search replacement & options)").doc("Replaces the first occurrance of search in s. The search arg may be astring or a regex pattern. If the search arg is of type string the options :ignore-case and :nfirst are supported.\n\nOptions: \n\n| :ignore-case b | if true ignores case, defaults to false |\n| :nfirst n      | e.g :nfirst 2, defaults to 1 |\n").examples("(str/replace-first \"ab-cd-ef-ab-cd\" \"ab\" \"XYZ\")", "(str/replace-first \"AB-CD-EF-AB-CD\" \"ab\" \"XYZ\" :ignore-case true)", "(str/replace-first \"ab-ab-cd-ab-ef-ab-cd\" \"ab\" \"XYZ\" :nfirst 3)", "(str/replace-first \"a0b01c012d\" (regex/pattern \"[0-9]+\") \"_\")", "(str/replace-first \"a0b01c012d\" #\"[0-9]+\" \"_\")").seeAlso("str/replace-last", "str/replace-all").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertMinArity(this, args, 3);
            if (args.first() == Constants.Nil || args.second() == Constants.Nil || args.third() == Constants.Nil) {
                return args.first();
            }
            String text = Coerce.toVncString(args.first()).getValue();
            VncVal search = args.second();
            String replacement = Coerce.toVncString(args.third()).getValue();
            VncHashMap options = VncHashMap.ofAll(args.slice(3));
            boolean ignoreCase = VncBoolean.isTrue(options.get(new VncKeyword("ignore-case"), VncBoolean.False));
            long nFirst = Coerce.toVncLong(options.get(new VncKeyword("nfirst"), new VncLong(1L))).getValue();
            if (Types.isVncString(search)) {
                String searchString = Coerce.toVncString(args.second()).getValue();
                return new VncString(StringUtil.replace(text, searchString, replacement, (int)nFirst, ignoreCase));
            }
            if (Types.isVncJavaObject(search, Pattern.class)) {
                Pattern p = Coerce.toVncJavaObject(search, Pattern.class);
                Matcher m = p.matcher(text);
                return new VncString(m.replaceFirst(replacement));
            }
            throw new VncException(String.format("Function 'str/replace-first' does not allow %s as search argument.", Types.getType(search)));
        }
    };
    public static VncFunction str_replace_last = new VncFunction("str/replace-last", (VncVal)VncFunction.meta().arglists("(str/replace-last s search replacement & options)").doc("Replaces the last occurrance of search in s.\n\nOptions: \n\n| :ignore-case b | if true ignores case, defaults to false |\n").examples("(str/replace-last \"abcdefabc\" \"ab\" \"XYZ\")", "(str/replace-last \"foo.JPG\" \".jpg\" \".png\" :ignore-case true)").seeAlso("str/replace-first", "str/replace-all").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertMinArity(this, args, 3);
            if (args.first() == Constants.Nil || args.second() == Constants.Nil || args.third() == Constants.Nil) {
                return args.first();
            }
            String text = Coerce.toVncString(args.first()).getValue();
            String searchString = Coerce.toVncString(args.second()).getValue();
            String replacement = Coerce.toVncString(args.third()).getValue();
            VncHashMap options = VncHashMap.ofAll(args.slice(3));
            boolean ignoreCase = VncBoolean.isTrue(options.get(new VncKeyword("ignore-case"), VncBoolean.False));
            return new VncString(StringUtil.replaceLast(text, searchString, replacement, ignoreCase));
        }
    };
    public static VncFunction str_reverse = new VncFunction("str/reverse", (VncVal)VncFunction.meta().arglists("(str/reverse s)").doc("Reverses a string").examples("(str/reverse \"abcdef\")").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            if (args.first() == Constants.Nil) {
                return Constants.Nil;
            }
            return new VncString(new StringBuilder(Coerce.toVncString(args.first()).getValue()).reverse().toString());
        }
    };
    public static VncFunction str_lower_case = new VncFunction("str/lower-case", (VncVal)VncFunction.meta().arglists("(str/lower-case s)", "(str/lower-case locale s)").doc("Converts s to lowercase.\n\nSince case mappings are not always 1:1 character mappings when a locale is given, the resulting string may be a different length than the original!").examples("(str/lower-case \"aBcDeF\")", "(str/lower-case #\\A)", "(str/lower-case (. :java.util.Locale :new \"de\" \"DE\") \"aBcDeF\")", "(str/lower-case (. :java.util.Locale :GERMANY) \"aBcDeF\")", "(str/lower-case (. :java.util.Locale :new \"de\" \"CH\") \"aBcDeF\")", "(str/lower-case [ \"de\"] \"aBcDeF\")", "(str/lower-case [ \"de\" \"DE\"] \"aBcDeF\")", "(str/lower-case [ \"de\" \"DE\"] \"aBcDeF\")").seeAlso("str/upper-case").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1, 2);
            if (args.size() == 1) {
                VncVal v = args.first();
                if (v == Constants.Nil) {
                    return Constants.Nil;
                }
                if (v instanceof VncChar) {
                    return new VncChar(Character.toLowerCase(((VncChar)v).getValue().charValue()));
                }
                return new VncString(Coerce.toVncString(v).getValue().toLowerCase());
            }
            VncVal v = args.second();
            Locale locale = StringFunctions.toLocale(args.first());
            if (locale == null) {
                throw new VncException(String.format("str/lower-case: the first arg is not a locale. Got a '%s'.", Types.getType(args.first())));
            }
            if (v == Constants.Nil) {
                return Constants.Nil;
            }
            if (v instanceof VncChar) {
                throw new VncException("str/lower-case: Cannot convert a char to lowercase if a locale is given since case mappings are not always 1:1 character mappings when a locale is given, the resulting string may be a different length than one!");
            }
            return new VncString(Coerce.toVncString(v).getValue().toLowerCase(locale));
        }
    };
    public static VncFunction str_upper_case = new VncFunction("str/upper-case", (VncVal)VncFunction.meta().arglists("(str/upper-case s)", "(str/upper-case locale s)").doc("Converts s to uppercase.\n\nSince case mappings are not always 1:1 character mappings when a locale is given, the resulting string may be a different length than the original!").examples("(str/upper-case \"aBcDeF\")", "(str/upper-case #\\a)", "(str/upper-case (. :java.util.Locale :new \"de\" \"DE\") \"aBcDeF\")", "(str/upper-case (. :java.util.Locale :GERMANY) \"aBcDeF\")", "(str/upper-case (. :java.util.Locale :new \"de\" \"CH\") \"aBcDeF\")", "(str/upper-case [ \"de\"] \"aBcDeF\")", "(str/upper-case [ \"de\" \"DE\"] \"aBcDeF\")", "(str/upper-case [ \"de\" \"DE\"] \"aBcDeF\")").seeAlso("str/lower-case").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1, 2);
            if (args.size() == 1) {
                VncVal v = args.first();
                if (v == Constants.Nil) {
                    return Constants.Nil;
                }
                if (v instanceof VncChar) {
                    return new VncChar(Character.toUpperCase(((VncChar)v).getValue().charValue()));
                }
                return new VncString(Coerce.toVncString(v).getValue().toUpperCase());
            }
            VncVal v = args.second();
            Locale locale = StringFunctions.toLocale(args.first());
            if (locale == null) {
                throw new VncException(String.format("str/upper-case: the first arg is not a locale. Got a '%s'.", Types.getType(args.first())));
            }
            if (v == Constants.Nil) {
                return Constants.Nil;
            }
            if (v instanceof VncChar) {
                throw new VncException("str/upper-case: Cannot convert a char to uppercase if a locale is given since case mappings are not always 1:1 character mappings when a locale is given, the resulting string may be a different length than one!");
            }
            return new VncString(Coerce.toVncString(v).getValue().toUpperCase(locale));
        }
    };
    public static VncFunction str_join = new VncFunction("str/join", (VncVal)VncFunction.meta().arglists("(str/join coll)", "(str/join separator coll)").doc("Joins all elements in coll separated by an optional separator.").examples("(str/join [1 2 3])", "(str/join \"-\" [1 2 3])", "(str/join \"-\" [(char \"a\") 1 \"xyz\" 2.56M])", "(str/join #\\- [1 2 3])").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1, 2);
            VncVal last = args.last();
            if (last == Constants.Nil) {
                return VncString.EMPTY;
            }
            VncSequence coll = Coerce.toVncSequence(last);
            if (coll.isEmpty()) {
                return VncString.EMPTY;
            }
            String delim = args.size() == 1 ? "" : (Types.isVncChar(args.first()) ? Coerce.toVncChar(args.first()).toString() : Coerce.toVncString(args.first()).getValue());
            return new VncString(coll.stream().map(v -> Types.isVncString(v) ? ((VncString)v).getValue() : v.toString()).collect(Collectors.joining(delim)));
        }
    };
    public static VncFunction str_subs = new VncFunction("str/subs", (VncVal)VncFunction.meta().arglists("(str/subs s start)", "(str/subs s start end)").doc("Returns the substring of s beginning at start inclusive, and ending at end (defaults to length of string), exclusive.").examples("(str/subs \"abcdef\" 2)", "(str/subs \"abcdef\" 2 5)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2, 3);
            VncString string = Coerce.toVncString(args.first());
            VncLong from = Coerce.toVncLong(args.second());
            VncLong to = args.size() > 2 ? (VncLong)args.nth(2) : null;
            try {
                return new VncString(to == null ? string.getValue().substring(from.getValue().intValue()) : string.getValue().substring(from.getValue().intValue(), to.getValue().intValue()));
            }
            catch (StringIndexOutOfBoundsException ex) {
                throw new VncException("str/subs: index out of bounds!", ex);
            }
        }
    };
    public static VncFunction str_pos = new VncFunction("str/pos", (VncVal)VncFunction.meta().arglists("(str/pos s pos)").doc("Returns the 0 based row/column position within a string based on absolute character position. Returns a map with the keys 'row' and 'col'.\n\nNote: CR & LF count together as one each regarding the absolute position.").examples("(str/pos \"abcdefghij\" 4)", "(str/pos \"ab\ncdefghij\" 6)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2);
            String string = Coerce.toVncString(args.first()).getValue();
            int pos = Coerce.toVncLong(args.second()).getIntValue();
            char[] chars = string.toCharArray();
            int row = 0;
            int col = 0;
            block4: for (int ii = 0; ii < chars.length; ++ii) {
                if (ii == pos) {
                    return VncHashMap.of(new VncKeyword("row"), new VncLong(row), new VncKeyword("col"), new VncLong(col));
                }
                switch (chars[ii]) {
                    case '\r': {
                        continue block4;
                    }
                    case '\n': {
                        ++row;
                        col = 0;
                        continue block4;
                    }
                    default: {
                        ++col;
                    }
                }
            }
            return VncHashMap.of(new VncKeyword("row"), new VncLong(-1L), new VncKeyword("col"), new VncLong(-1L));
        }
    };
    public static VncFunction str_chars = new VncFunction("str/chars", (VncVal)VncFunction.meta().arglists("(str/chars s)").doc("Converts a string to a char list.").examples("(str/chars \"abcdef\")", "(str/join (str/chars \"abcdef\"))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            if (args.first() == Constants.Nil) {
                return VncList.empty();
            }
            String s = Coerce.toVncString(args.first()).getValue();
            return VncList.ofList(s.chars().mapToObj(c -> new VncChar((char)c)).collect(Collectors.toList()));
        }
    };
    public static VncFunction str_split = new VncFunction("str/split", (VncVal)VncFunction.meta().arglists("(str/split s regex)", "(str/split s regex limit)").doc("Splits string on a regular expression. Optional argument limit is the maximum number of splits. Returns a list of the splits.").examples("(str/split \"abc,def,ghi\" \",\")", "(str/split \"James Peter Robert\" \" \" 2)", "(str/split \"abc , def ,  ghi\" \" *, *\")", "(str/split \"abc,def,ghi\" \"((?<=,)|(?=,))\")", "(str/split \"q1w2e3r4t5y6u7i8o9p0\" #\"\\d+\")", "(str/split \"q1w2e3r4t5y6u7i8o9p0\" #\"\\d+\" 5)", "(str/split \"1234567890\" #\"(?<=\\G.{4})\")", "(str/split \"1234567890\" #\"(?=(.{4})+$)\")", "(str/split \" q1w2 \" #\"\")", "(str/split nil \",\")").seeAlso("str/split-lines").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            long limit;
            ArityExceptions.assertArity(this, args, 2, 3);
            if (args.first() == Constants.Nil) {
                return VncList.empty();
            }
            String str = Coerce.toVncString(args.first()).getValue();
            boolean limited = args.size() == 3;
            long l = limit = limited ? Coerce.toVncLong(args.third()).getValue() : -1L;
            if (Types.isVncString(args.second())) {
                VncString regex = Coerce.toVncString(args.second());
                String[] matches = limited ? str.split(regex.getValue(), (int)limit) : str.split(regex.getValue());
                return VncList.ofList(Arrays.asList(matches).stream().map(s -> new VncString((String)s)).collect(Collectors.toList()));
            }
            if (Types.isVncJavaObject(args.second(), Pattern.class)) {
                Pattern pattern = Coerce.toVncJavaObject(args.second(), Pattern.class);
                String[] matches = limited ? pattern.split(str, (int)limit) : pattern.split(str);
                return VncList.ofList(Arrays.asList(matches).stream().map(s -> new VncString((String)s)).collect(Collectors.toList()));
            }
            throw new VncException(String.format("Function 'str/split' does not allow %s as regex pattern. Expected a string or a java.util.regex.Pattern", Types.getType(args.second())));
        }
    };
    public static VncFunction str_split_at = new VncFunction("str/split-at", (VncVal)VncFunction.meta().arglists("(str/split-at s pos)").doc("Splits string at the given position. Returns a list of the splits.").examples("(str/split-at nil 1)", "(str/split-at \"\" 1)", "(str/split-at \"abc\" 0)", "(str/split-at \"abc\" 1)", "(str/split-at \"abc\" 2)", "(str/split-at \"abc\" 3)").seeAlso("str/split-lines").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2);
            if (args.first() == Constants.Nil) {
                return VncList.of(new VncString(""), new VncString(""));
            }
            String str = Coerce.toVncString(args.first()).getValue();
            long pos = Coerce.toVncLong(args.second()).getValue();
            if (pos <= 0L) {
                return VncList.of(new VncString(""), args.first());
            }
            if (pos >= (long)str.length()) {
                return VncList.of(args.first(), new VncString(""));
            }
            return VncList.of(new VncString(str.substring(0, (int)pos)), new VncString(str.substring((int)pos)));
        }
    };
    public static VncFunction str_split_lines = new VncFunction("str/split-lines", (VncVal)VncFunction.meta().arglists("(str/split-lines s)").doc("Splits s into lines.").examples("(str/split-lines \"line1\nline2\nline3\")").seeAlso("str/split", "io/slurp-lines").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            return args.first() == Constants.Nil ? VncList.empty() : VncList.ofList(StringUtil.splitIntoLines(Coerce.toVncString(args.first()).getValue()).stream().map(s -> new VncString((String)s)).collect(Collectors.toList()));
        }
    };
    public static VncFunction str_split_columns = new VncFunction("str/split-columns", (VncVal)VncFunction.meta().arglists("(str/split-columns s cols)").doc("Splits a string into columns. The columns are given by their start positions.").examples("(str/split-columns \"1abc  2d    3gh\" [0 6 12])").seeAlso("str/split").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2);
            String text = Coerce.toVncString(args.first()).getValue();
            List<VncVal> colList = Coerce.toVncSequence(args.second()).getJavaList();
            VncVal[] colStartPos_ = colList.toArray(new VncVal[0]);
            int[] colStartPos = new int[colList.size()];
            for (int ii = 0; ii < colList.size(); ++ii) {
                colStartPos[ii] = Coerce.toVncLong(colStartPos_[ii]).toJavaInteger();
            }
            List<String> cols = StringUtil.splitColumns(text, colStartPos);
            return VncList.ofColl(cols.stream().map(s -> new VncString((String)s)).collect(Collectors.toList()));
        }
    };
    public static VncFunction str_cr_lf = new VncFunction("str/cr-lf", (VncVal)VncFunction.meta().arglists("(str/cr-lf s mode)").doc("Convert a text to use LF or CR-LF.").examples("(str/cr-lf \"line1\nline2\nline3\" :cr-lf)", "(str/cr-lf \"line1\nline2\nline3\" :lf)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2);
            if (args.first() == Constants.Nil) {
                return Constants.Nil;
            }
            String text = Coerce.toVncString(args.first()).getValue();
            String mode = Coerce.toVncKeyword(args.second()).getValue();
            String ending = "cr-lf".equals(mode) ? "\r\n" : "\n";
            return new VncString(StringUtil.splitIntoLines(text).stream().collect(Collectors.joining(ending)));
        }
    };
    public static VncFunction str_crlf_to_lf = new VncFunction("str/crlf-to-lf", (VncVal)VncFunction.meta().arglists("(str/crlf-to-lf s)").doc("Converts CR-LF to LF").examples("(str/crlf-to-lf nil)", "(str/crlf-to-lf \"100\r\n200\r\n\")").seeAlso("str/cr-lf").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            if (args.first() == Constants.Nil) {
                return Constants.Nil;
            }
            String str = Coerce.toVncString(args.first()).getValue().trim();
            return new VncString(StringUtil.crlf_to_lf(str));
        }
    };
    public static VncFunction str_butlast = new VncFunction("str/butlast", (VncVal)VncFunction.meta().arglists("(str/butlast s)").doc("Returns a possibly empty string of the characters without the last.").examples("(str/butlast \"abcdef\")").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            if (args.first() == Constants.Nil) {
                return Constants.Nil;
            }
            String s = Coerce.toVncString(args.first()).getValue();
            return new VncString(s.length() <= 1 ? "" : s.substring(0, s.length() - 1));
        }
    };
    public static VncFunction str_butnlast = new VncFunction("str/butnlast", (VncVal)VncFunction.meta().arglists("(str/butnlast s n)").doc("Returns a possibly empty string of the characters without the n last characters.").examples("(str/butnlast \"abcdef\" 3)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2);
            if (args.first() == Constants.Nil) {
                return Constants.Nil;
            }
            String s = Coerce.toVncString(args.first()).getValue();
            long n = Coerce.toVncLong(args.second()).getValue();
            return new VncString((long)s.length() <= n ? "" : s.substring(0, s.length() - (int)n));
        }
    };
    public static VncFunction str_rest = new VncFunction("str/rest", (VncVal)VncFunction.meta().arglists("(str/rest s)").doc("Returns a possibly empty string of the characters after the first.").examples("(str/rest \"abcdef\")").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            if (args.first() == Constants.Nil) {
                return Constants.Nil;
            }
            String s = Coerce.toVncString(args.first()).getValue();
            return new VncString(s.length() < 2 ? "" : s.substring(1));
        }
    };
    public static VncFunction str_nrest = new VncFunction("str/nrest", (VncVal)VncFunction.meta().arglists("(str/nrest s n)").doc("Returns a possibly empty string of the characters after the n first characters.").examples("(str/nrest \"abcdef\" 3)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2);
            if (args.first() == Constants.Nil) {
                return Constants.Nil;
            }
            String s = Coerce.toVncString(args.first()).getValue();
            long n = Coerce.toVncLong(args.second()).getValue();
            return new VncString((long)s.length() < n ? "" : s.substring((int)n));
        }
    };
    public static VncFunction str_nfirst = new VncFunction("str/nfirst", (VncVal)VncFunction.meta().arglists("(str/nfirst s n)").doc("Returns a string of the n first characters of s.").examples("(str/nfirst \"abcdef\" 2)", "(str/nfirst \"abcdef\" 10)", "(str/nfirst \"abcdef\" 0)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2);
            if (args.first() == Constants.Nil) {
                return Constants.Nil;
            }
            int n = Coerce.toVncLong(args.second()).getValue().intValue();
            String s = Coerce.toVncString(args.first()).getValue();
            n = Math.max(0, Math.min(s.length(), n));
            return s.isEmpty() ? VncString.empty() : new VncString(s.substring(0, n));
        }
    };
    public static VncFunction str_nlast = new VncFunction("str/nlast", (VncVal)VncFunction.meta().arglists("(str/nlast s n)").doc("Returns a string of the n last characters of s.").examples("(str/nlast \"abcdef\" 2)", "(str/nlast \"abcdef\" 10)", "(str/nlast \"abcdef\" 0)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2);
            if (args.first() == Constants.Nil) {
                return Constants.Nil;
            }
            int n = Coerce.toVncLong(args.second()).getValue().intValue();
            String s = Coerce.toVncString(args.first()).getValue();
            n = Math.max(0, Math.min(s.length(), n));
            return s.isEmpty() ? VncString.empty() : new VncString(s.substring(s.length() - n, s.length()));
        }
    };
    public static VncFunction str_format = new VncFunction("str/format", (VncVal)VncFunction.meta().arglists("(str/format format args*)", "(str/format locale format args*)").doc("Returns a formatted string using the specified format string and arguments.\u00b6Venice uses the Java format syntax.\n\nJavaDoc: [Format Syntax](https://docs.oracle.com/javase/8/docs/api/java/util/Formatter.html#syntax)").examples("(str/format \"value: %.4f\" 1.45)", "(str/format (. :java.util.Locale :new \"de\" \"DE\") \"value: %.4f\" 1.45)", "(str/format (. :java.util.Locale :GERMANY) \"value: %.4f\" 1.45)", "(str/format (. :java.util.Locale :new \"de\" \"CH\") \"value: %,d\" 2345000)", "(str/format [ \"de\" ] \"value: %,.2f\" 100000.45)", "(str/format [ \"de\" \"DE\" ] \"value: %,.2f\" 100000.45)", "(str/format [ \"de\" \"CH\" ] \"value: %,.2f\" 100000.45)", "(str/format [ \"en\" \"US\" ] \"value: %,.2f\" 100000.45)", "(str/format [ \"de\" \"DE\" ] \"value: %,d\" 2345000)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args_) {
            Locale locale = Types.isVncString(args_.first()) ? null : StringFunctions.toLocale(args_.first());
            VncList args = locale == null ? args_ : args_.rest();
            VncString fmt = Coerce.toVncString(args.first());
            List params = args.rest().stream().map(v -> v instanceof VncNumber || v instanceof VncBoolean ? v.convertToJavaObject() : v.toString(false)).collect(Collectors.toList());
            try {
                return new VncString(String.format(locale == null ? Locale.getDefault() : locale, fmt.getValue(), params.toArray()));
            }
            catch (IllegalFormatException ex) {
                throw new VncException(ex.getMessage());
            }
        }
    };
    public static VncFunction str_quote = new VncFunction("str/quote", (VncVal)VncFunction.meta().arglists("(str/quote str q)", "(str/quote str start end)").doc("Quotes a string.").examples("(str/quote \"abc\" \"-\")", "(str/quote \"abc\" \"<\" \">\")").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2, 3);
            String s = Coerce.toVncString(args.first()).getValue();
            String start = Coerce.toVncString(args.second()).getValue();
            String end = args.size() == 2 ? start : Coerce.toVncString(args.nth(2)).getValue();
            return new VncString(start + s + end);
        }
    };
    public static VncFunction str_quoted_Q = new VncFunction("str/quoted?", (VncVal)VncFunction.meta().arglists("(str/quoted? str q)", "(str/quoted? str start end)").doc("Returns true if the string is quoted.").examples("(str/quoted? \"-abc-\" \"-\")", "(str/quoted? \"<abc>\" \"<\" \">\")").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2, 3);
            String s = Coerce.toVncString(args.first()).getValue();
            String start = Coerce.toVncString(args.second()).getValue();
            String end = args.size() == 2 ? start : Coerce.toVncString(args.nth(2)).getValue();
            return VncBoolean.of(s.startsWith(start) && s.endsWith(end));
        }
    };
    public static VncFunction str_double_quote = new VncFunction("str/double-quote", (VncVal)VncFunction.meta().arglists("(str/double-quote str)").doc("Double quotes a string.").examples("(str/double-quote \"abc\")", "(str/double-quote \"\")").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            String s = Coerce.toVncString(args.first()).getValue();
            return new VncString("\"" + s + "\"");
        }
    };
    public static VncFunction str_double_unquote = new VncFunction("str/double-unquote", (VncVal)VncFunction.meta().arglists("(str/double-unquote str)").doc("Unquotes a double quoted string.").examples("(str/double-unquote \"\\\"abc\\\"\")", "(str/double-unquote \"\\\"\\\"\")", "(str/double-unquote nil)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            if (args.first() == Constants.Nil) {
                return Constants.Nil;
            }
            String s = Coerce.toVncString(args.first()).getValue();
            if (s.startsWith("\"") && s.endsWith("\"")) {
                return new VncString(s.length() == 2 ? "" : s.substring(1, s.length() - 1));
            }
            return args.first();
        }
    };
    public static VncFunction str_double_quoted_Q = new VncFunction("str/double-quoted?", (VncVal)VncFunction.meta().arglists("(str/double-quoteed? str)").doc("Returns true if the string is double quoted.").examples("(str/double-quoted? \"\\\"abc\\\"\")").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            if (args.first() == Constants.Nil) {
                return VncBoolean.False;
            }
            String s = Coerce.toVncString(args.first()).getValue();
            return VncBoolean.of(s.startsWith("\"") && s.endsWith("\""));
        }
    };
    public static VncFunction str_truncate = new VncFunction("str/truncate", (VncVal)VncFunction.meta().arglists("(str/truncate s maxlen marker mode*)").doc("Truncates a string to the max lenght maxlen and adds the marker if the string needs to be truncated. The marker is added to the start, middle, or end of the string depending on the mode :start, :middle, :end. The mode defaults to :end").examples("(str/truncate \"abcdefghij\" 20 \"...\")", "(str/truncate \"abcdefghij\" 9 \"...\")", "(str/truncate \"abcdefghij\" 4 \"...\")", "(str/truncate \"abcdefghij\" 7 \"...\" :start)", "(str/truncate \"abcdefghij\" 7 \"...\" :middle)", "(str/truncate \"abcdefghij\" 7 \"...\" :end)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 3, 4);
            if (args.first() == Constants.Nil) {
                return Constants.Nil;
            }
            String text = Coerce.toVncString(args.first()).getValue();
            int maxLen = Coerce.toVncLong(args.second()).getValue().intValue();
            String marker = Coerce.toVncString(args.nth(2)).getValue();
            String mode = Coerce.toVncKeyword(args.nthOrDefault(3, new VncKeyword(":end"))).getValue();
            int lenMarker = marker.length();
            if (maxLen <= lenMarker) {
                throw new VncException("A maxLen must greater than the length of the truncation marker");
            }
            if (text == null || text.length() <= maxLen) {
                return args.first();
            }
            switch (mode) {
                case "start": {
                    int lenTail = maxLen - lenMarker;
                    return new VncString(marker + text.substring(text.length() - lenTail));
                }
                case "middle": {
                    int lenStart = maxLen / 2 - lenMarker / 2;
                    int lenTail = maxLen - lenStart - lenMarker;
                    return new VncString(text.substring(0, lenStart) + marker + text.substring(text.length() - lenTail));
                }
                case "end": {
                    int lenStart = maxLen - lenMarker;
                    return new VncString(text.substring(0, lenStart) + marker);
                }
            }
            throw new VncException("Invalid truncation mode ':" + mode + "'");
        }
    };
    public static VncFunction str_expand = new VncFunction("str/expand", (VncVal)VncFunction.meta().arglists("(str/expand s len fill mode*)").doc("Expands a string to the max lenght len. Fills up with the fillstring if the string needs to be expanded. The fill string is added to the start or end of the string depending on the mode :start, :end. The mode defaults to :end").examples("(str/expand \"abcdefghij\" 8 \".\")", "(str/expand \"abcdefghij\" 20 \".\")", "(str/expand \"abcdefghij\" 20 \".\" :start)", "(str/expand \"abcdefghij\" 20 \".\" :end)", "(str/expand \"abcdefghij\" 30 \"1234\" :start)", "(str/expand \"abcdefghij\" 30 \"1234\" :end)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 3, 4);
            String text = args.first() == Constants.Nil ? "" : Coerce.toVncString(args.first()).getValue();
            int len = Coerce.toVncLong(args.second()).getValue().intValue();
            String fill = Coerce.toVncString(args.nth(2)).getValue();
            String mode = Coerce.toVncKeyword(args.nthOrDefault(3, new VncKeyword(":end"))).getValue();
            if (fill.isEmpty()) {
                throw new VncException("A fill string must not be empty");
            }
            if (text.length() >= len) {
                return args.first();
            }
            int gap = len - text.length();
            StringBuilder filling = new StringBuilder();
            while (filling.length() < gap) {
                int delta = gap - filling.length();
                filling.append(delta >= fill.length() ? fill : fill.substring(0, delta));
            }
            switch (mode) {
                case "start": {
                    return new VncString(filling + text);
                }
                case "end": {
                    return new VncString(text + filling);
                }
            }
            throw new VncException("Invalid truncation mode ':" + mode + "'");
        }
    };
    public static VncFunction str_strip_start = new VncFunction("str/strip-start", (VncVal)VncFunction.meta().arglists("(str/strip-start s substr)").doc("Removes a substr only if it is at the beginning of a s, otherwise returns s.").examples("(str/strip-start \"abcdef\" \"abc\")", "(str/strip-start \"abcdef\" \"def\")").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            String substr;
            ArityExceptions.assertArity(this, args, 2);
            if (args.first() == Constants.Nil) {
                return Constants.Nil;
            }
            String s = Coerce.toVncString(args.first()).getValue();
            return new VncString(s.startsWith(substr = Coerce.toVncString(args.second()).getValue()) ? s.substring(substr.length()) : s);
        }
    };
    public static VncFunction str_strip_end = new VncFunction("str/strip-end", (VncVal)VncFunction.meta().arglists("(str/strip-end s substr)").doc("Removes a substr only if it is at the end of a s, otherwise returns s.").examples("(str/strip-end \"abcdef\" \"def\")", "(str/strip-end \"abcdef\" \"abc\")").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            String substr;
            ArityExceptions.assertArity(this, args, 2);
            if (args.first() == Constants.Nil) {
                return Constants.Nil;
            }
            String s = Coerce.toVncString(args.first()).getValue();
            return new VncString(s.endsWith(substr = Coerce.toVncString(args.second()).getValue()) ? s.substring(0, s.length() - substr.length()) : s);
        }
    };
    public static VncFunction str_strip_indent = new VncFunction("str/strip-indent", (VncVal)VncFunction.meta().arglists("(str/strip-indent s)").doc("Strip the indent of a multi-line string. The first line's leading whitespaces define the indent.").examples("(str/strip-indent \"  line1\n    line2\n    line3\")").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            if (args.first() == Constants.Nil) {
                return Constants.Nil;
            }
            return new VncString(StringUtil.stripIndent(Coerce.toVncString(args.first()).getValue()));
        }
    };
    public static VncFunction str_strip_margin = new VncFunction("str/strip-margin", (VncVal)VncFunction.meta().arglists("(str/strip-margin s)").doc("Strips leading whitespaces upto and including the margin '|' from each line in a multi-line string.").examples("(str/strip-margin \"line1\n  |  line2\n  |  line3\")").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            if (args.first() == Constants.Nil) {
                return Constants.Nil;
            }
            return new VncString(StringUtil.stripMargin(Coerce.toVncString(args.first()).getValue(), '|'));
        }
    };
    public static VncFunction str_repeat = new VncFunction("str/repeat", (VncVal)VncFunction.meta().arglists("(str/repeat s n)", "(str/repeat s n sep)").doc("Repeats s n times with an optional separator.").examples("(str/repeat \"abc\" 0)", "(str/repeat \"abc\" 3)", "(str/repeat \"abc\" 3 \"-\")", "(str/repeat #\\* 0)", "(str/repeat #\\* 3)", "(str/repeat #\\* 3 #\\-)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2, 3);
            if (args.first() == Constants.Nil) {
                return Constants.Nil;
            }
            String s = Types.isVncChar(args.first()) ? Coerce.toVncChar(args.first()).toString() : Coerce.toVncString(args.first()).getValue();
            int times = Coerce.toVncLong(args.second()).getValue().intValue();
            String sep = args.size() == 3 ? (Types.isVncChar(args.third()) ? Coerce.toVncChar(args.third()).toString() : Coerce.toVncString(args.third()).getValue()) : "";
            StringBuilder sb = new StringBuilder();
            for (int ii = 0; ii < times; ++ii) {
                if (ii > 0) {
                    sb.append(sep);
                }
                sb.append(s);
            }
            return new VncString(sb.toString());
        }
    };
    public static VncFunction str_digit_Q = new VncFunction("str/digit?", (VncVal)VncFunction.meta().arglists("(str/digit? s)").doc("True if s is a char and the char is a digit. \n\nDefined by Java Character.isDigit(ch).").examples("(str/digit? #\\8)", "(str/digit? \"8\")").seeAlso("str/letter?", "str/hexdigit?").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            VncVal v = args.first();
            if (Types.isVncChar(v)) {
                return VncBoolean.of(Character.isDigit(((VncChar)v).getValue().charValue()));
            }
            return VncBoolean.False;
        }
    };
    public static VncFunction str_hexdigit_Q = new VncFunction("str/hexdigit?", (VncVal)VncFunction.meta().arglists("(str/hexdigit? s)").doc("True if s is a char and the char is a hex digit.").examples("(str/hexdigit? #\\8)", "(str/hexdigit? #\\a)", "(str/hexdigit? #\\A)", "(str/hexdigit? #\\Y)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            VncVal v = args.first();
            if (Types.isVncChar(v)) {
                char ch = ((VncChar)v).getValue().charValue();
                return VncBoolean.of(ch >= '0' && ch <= '9' || ch >= 'A' && ch <= 'F' || ch >= 'a' && ch <= 'f');
            }
            return VncBoolean.False;
        }
    };
    public static VncFunction str_letter_Q = new VncFunction("str/letter?", (VncVal)VncFunction.meta().arglists("(str/letter? s)").doc("True if s is a char and the char is a letter. \n\nDefined by Java Character.isLetter(ch).").examples("(str/letter? #\\x)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            VncVal v = args.first();
            if (Types.isVncChar(v)) {
                return VncBoolean.of(Character.isLetter(((VncChar)v).getValue().charValue()));
            }
            if (Types.isVncString(v)) {
                String str = Coerce.toVncString(v).getValue();
                if (str.length() != 1) {
                    throw new VncException(String.format("Function 'str/letter?' expects a single char string. Got a '%s'.", Types.getType(v)));
                }
                return VncBoolean.of(Character.isLetter(str.charAt(0)));
            }
            return VncBoolean.False;
        }
    };
    public static VncFunction str_letter_or_digit_Q = new VncFunction("str/letter-or-digit?", (VncVal)VncFunction.meta().arglists("(str/letter-or-digit? s)").doc("True if s is a char the char is a letter or a digit. \n\nDefined by Java Character.isLetterOrDigit(ch).").examples("(str/letter-or-digit? #\\x)", "(str/letter-or-digit? #\\X)", "(str/letter-or-digit? #\\!)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            VncVal v = args.first();
            if (Types.isVncChar(v)) {
                return VncBoolean.of(Character.isLetterOrDigit(((VncChar)v).getValue().charValue()));
            }
            return VncBoolean.False;
        }
    };
    public static VncFunction str_lower_case_Q = new VncFunction("str/lower-case?", (VncVal)VncFunction.meta().arglists("(str/lower-case? s)").doc("True if s is a char and the char is a lower case char. \n\nDefined by Java Character.isLowerCase(ch).").examples("(str/lower-case? #\\x)", "(str/lower-case? #\\X)", "(str/lower-case? #\\8)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            VncVal v = args.first();
            if (Types.isVncChar(v)) {
                return VncBoolean.of(Character.isLowerCase(((VncChar)v).getValue().charValue()));
            }
            return VncBoolean.False;
        }
    };
    public static VncFunction str_upper_case_Q = new VncFunction("str/upper-case?", (VncVal)VncFunction.meta().arglists("(str/upper-case? s)").doc("True if s is a char and the char is an upper case char. \n\nDefined by Java Character.isUpperCase(ch).").examples("(str/upper-case? #\\x)", "(str/upper-case? #\\X)", "(str/upper-case? #\\8)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            VncVal v = args.first();
            if (Types.isVncChar(v)) {
                return VncBoolean.of(Character.isUpperCase(((VncChar)v).getValue().charValue()));
            }
            return VncBoolean.False;
        }
    };
    public static VncFunction str_linefeed_Q = new VncFunction("str/linefeed?", (VncVal)VncFunction.meta().arglists("(str/linefeed? s)").doc("True if s is a char and the char is a linefeed.").examples("(str/linefeed? #\\newline)", "(str/linefeed? (first \"\n\"))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            VncVal v = args.first();
            if (Types.isVncChar(v)) {
                return VncBoolean.of(((VncChar)v).getValue().charValue() == '\n');
            }
            return VncBoolean.False;
        }
    };
    public static VncFunction str_whitespace_Q = new VncFunction("str/whitespace?", (VncVal)VncFunction.meta().arglists("(str/whitespace? s)").doc("True if s is char and the char is a whitespace. \n\nDefined by Java Character.isWhitespace(ch).").examples("(str/whitespace? #\\space)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            VncVal v = args.first();
            if (Types.isVncChar(v)) {
                return VncBoolean.of(Character.isWhitespace(((VncChar)v).getValue().charValue()));
            }
            return VncBoolean.False;
        }
    };
    public static VncFunction str_lorem_ipsum = new VncFunction("str/lorem-ipsum", (VncVal)VncFunction.meta().arglists("(str/lorem-ipsum & options)").doc("Creates an arbitrary length Lorem Ipsum text. \n\nOptions: \n\n| :chars n      | returns n characters (limited to " + LoremIpsum.getMaxChars() + ") |\n| :paragraphs n | returns n paragraphs (limited to " + LoremIpsum.getMaxParagraphs() + ") |\n").examples("(str/lorem-ipsum :chars 250)", "(str/lorem-ipsum :paragraphs 1)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertMinArity(this, args, 0);
            VncHashMap options = VncHashMap.ofAll(args);
            VncVal chars = options.get(new VncKeyword("chars"));
            if (Types.isVncLong(chars)) {
                return new VncString(LoremIpsum.loremIpsum_Chars(Coerce.toVncLong(chars).getValue().intValue()));
            }
            VncVal paragraphs = options.get(new VncKeyword("paragraphs"));
            if (Types.isVncLong(paragraphs)) {
                return new VncString(LoremIpsum.loremIpsum_Paragraphs(Coerce.toVncLong(paragraphs).getValue().intValue()));
            }
            throw new VncException("Function 'str/lorem-ipsum' invalid options");
        }
    };
    public static VncFunction str_wrap = new VncFunction("str/wrap", (VncVal)VncFunction.meta().arglists("(str/wrap text & options)").doc("Wraps ascii text to lines with a length of maxlen characters . \n\nOptions: \n\n| :maxlen n                           | the max len of line (default 80) |\n| :line-wrap {:anywhere, :break-word} | controls the line wrap |\n").examples("(-> (str/lorem-ipsum :paragraphs 1)               \n    (str/wrap :maxlen 80 :line-wrap :break-word)) ").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            VncVal linewrap_;
            ArityExceptions.assertMinArity(this, args, 1);
            VncString text = Coerce.toVncString(args.first());
            VncHashMap options = VncHashMap.ofAll(args.rest());
            long maxlen = 80L;
            boolean breakword = true;
            VncVal maxlen_ = options.get(new VncKeyword(":maxlen"));
            if (Types.isVncLong(maxlen_)) {
                maxlen = ((VncLong)maxlen_).toJavaLong();
                maxlen = Math.max(2L, maxlen);
            }
            if (Types.isVncKeyword(linewrap_ = options.get(new VncKeyword(":line-wrap")))) {
                breakword = "break-word".equals(((VncKeyword)linewrap_).getValue());
            }
            String s = text.getValue();
            List<String> lines = breakword ? LineWrap.softWrap(s, (int)maxlen) : LineWrap.hardWrap(s, (int)maxlen);
            return new VncString(String.join((CharSequence)"\n", lines));
        }
    };
    public static VncFunction str_bytebuf_to_hex = new VncFunction("str/bytebuf-to-hex", (VncVal)VncFunction.meta().arglists("(str/bytebuf-to-hex data)", "(str/bytebuf-to-hex data :upper)").doc("Converts byte data to a hex string using the hexadecimal digits: `0123456789abcdef`. \u00b6If the :upper options is passed the hex digits `0123456789ABCDEF` are used.").examples("(str/bytebuf-to-hex (bytebuf [0 1 2 3 4 5 6]))", "(str/bytebuf-to-hex (bytebuf [202 254]) :upper)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1, 2);
            if (args.first() == Constants.Nil) {
                return Constants.Nil;
            }
            VncByteBuffer data = Coerce.toVncByteBuffer(args.first());
            if (args.size() == 1) {
                return new VncString(HexUtil.toString(data.getBytes()));
            }
            VncKeyword opt = Coerce.toVncKeyword(args.second());
            if (opt.getValue().equalsIgnoreCase("upper")) {
                return new VncString(HexUtil.toStringUpperCase(data.getBytes()));
            }
            throw new VncException("Function 'str/bytebuf-to-hex' expects the option :upper");
        }
    };
    public static VncFunction str_hex_to_bytebuf = new VncFunction("str/hex-to-bytebuf", (VncVal)VncFunction.meta().arglists("(str/hex-to-bytebuf hex)").doc("Converts a hex string to a bytebuf").examples("(str/hex-to-bytebuf \"005E4AFF\")", "(str/hex-to-bytebuf \"005e4aff\")").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            if (args.first() == Constants.Nil) {
                return Constants.Nil;
            }
            return new VncByteBuffer(HexUtil.toBytes(Coerce.toVncString(args.first()).getValue()));
        }
    };
    public static VncFunction str_format_bytebuf = new VncFunction("str/format-bytebuf", (VncVal)VncFunction.meta().arglists("(str/format-bytebuf data delimiter & options)").doc("Formats a bytebuffer. \n\nOptions \n\n| :prefix0x | prefix with 0x |").examples("(str/format-bytebuf (bytebuf [0 34 67 -30 -1]) nil)", "(str/format-bytebuf (bytebuf [0 34 67 -30 -1]) \"\")", "(str/format-bytebuf (bytebuf [0 34 67 -30 -1]) \", \")", "(str/format-bytebuf (bytebuf [0 34 67 -30 -1]) \", \" :prefix0x)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            String delimiter;
            ArityExceptions.assertArity(this, args, 2, 3);
            if (args.first() == Constants.Nil) {
                return Constants.Nil;
            }
            VncByteBuffer data = Coerce.toVncByteBuffer(args.first());
            String string = delimiter = args.second() == Constants.Nil ? "" : Coerce.toVncString(args.second()).getValue();
            if (args.size() == 2) {
                return new VncString(HexFormatter.toHex(data.getBytes(), delimiter, false));
            }
            VncKeyword opt = Coerce.toVncKeyword(args.third());
            if (opt.getValue().equalsIgnoreCase("prefix0x")) {
                return new VncString(HexFormatter.toHex(data.getBytes(), delimiter, true));
            }
            throw new VncException("Function 'str/format-bytebuf' expects the option :prefix0x");
        }
    };
    public static VncFunction str_levenshtein = new VncFunction("str/levenshtein", (VncVal)VncFunction.meta().arglists("(str/levenshtein s1 s2)").doc("Returns the *Levenshtein* distance of two strings.\n\nThe *Damerau-Levenshtein* algorithm is an extension to the *Levenshtein* algorithm which solves the edit distance problem between a source string and a target string with the following operations:\n\n  * Character Insertion\n  * Character Deletion\n  * Character Replacement\n  * Adjacent Character Swap\n\nNote that the adjacent character swap operation is an edit that may be applied when two adjacent characters in the source string match two adjacent characters in the target string, but in reverse order, rather than a general allowance for adjacent character swaps.\n\nThis implementation allows the client to specify the costs of the various edit operations with the restriction that the cost of two swap operations must not be less than the cost of a delete operation followed by an insert operation. This restriction is required to preclude two swaps involving the same character being required for optimality which, in turn, enables a fast dynamic programming solution.\n\nThe cost of the *Damerau-Levenshtein* algorithm is `O(n*m)` where `n` is the length of the source string and `m is the length of the target string. This implementation consumes `O(n*m)` space.").examples("(str/levenshtein \"Tier\" \"Tor\")", "(str/levenshtein \"Tier\" \"tor\")").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2);
            return new VncLong(Levenshtein.distance(Coerce.toVncString(args.first()).getValue(), Coerce.toVncString(args.second()).getValue()));
        }
    };
    public static VncFunction str_encode_base64 = new VncFunction("str/encode-base64", (VncVal)VncFunction.meta().arglists("(str/encode-base64 data)").doc("Base64 encode.").examples("(str/encode-base64 (bytebuf [0 1 2 3 4 5 6]))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            VncVal arg = args.first();
            if (arg == Constants.Nil) {
                return Constants.Nil;
            }
            byte[] buf = Coerce.toVncByteBuffer(arg).getBytes();
            return new VncString(Base64.getEncoder().encodeToString(buf));
        }
    };
    public static VncFunction str_decode_base64 = new VncFunction("str/decode-base64", (VncVal)VncFunction.meta().arglists("(str/decode-base64 s)").doc("Base64 decode.").examples("(str/decode-base64 (str/encode-base64 (bytebuf [0 1 2 3 4 5 6])))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            VncVal arg = args.first();
            if (arg == Constants.Nil) {
                return Constants.Nil;
            }
            String base64 = Coerce.toVncString(arg).getValue();
            return new VncByteBuffer(Base64.getDecoder().decode(base64));
        }
    };
    public static VncFunction str_encode_url = new VncFunction("str/encode-url", (VncVal)VncFunction.meta().arglists("(str/encode-url s)").doc("URL encode.").examples("(str/encode-url \"The string \u00fc@foo-bar\")").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            try {
                VncVal arg = args.first();
                if (arg == Constants.Nil) {
                    return Constants.Nil;
                }
                String s = Coerce.toVncString(arg).getValue();
                return new VncString(URLEncoder.encode(s, "UTF-8"));
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException("Unsupported encoding", ex);
            }
        }
    };
    public static VncFunction str_decode_url = new VncFunction("str/decode-url", (VncVal)VncFunction.meta().arglists("(str/decode-url s)").doc("URL decode.").examples("(str/decode-url \"The+string+%C3%BC%40foo-bar\")").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            try {
                VncVal arg = args.first();
                if (arg == Constants.Nil) {
                    return Constants.Nil;
                }
                String s = Coerce.toVncString(arg).getValue();
                return new VncString(URLDecoder.decode(s, "UTF-8"));
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException("Unsupported encoding", ex);
            }
        }
    };
    public static VncFunction str_escape_html = new VncFunction("str/escape-html", (VncVal)VncFunction.meta().arglists("(str/escape-html s)").doc("HTML escape. Escapes `&`, `<`, `>`, `\"`, `'`, and the non blocking space `U+00A0`").examples("(str/escape-html \"1 2 3 & < > \\\" ' \\u00A0\")").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            VncVal arg = args.first();
            if (arg == Constants.Nil) {
                return Constants.Nil;
            }
            String s = Coerce.toVncString(arg).getValue();
            return new VncString(StringEscapeUtil.escapeHtml(s));
        }
    };
    public static VncFunction str_escape_xml = new VncFunction("str/escape-xml", (VncVal)VncFunction.meta().arglists("(str/escape-xml s)").doc("XML escape. Escapes `&`, `<`, `>`, `\"`, `'`").examples("(str/escape-xml \"1 2 3 & < > \\\" '\")").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            VncVal arg = args.first();
            if (arg == Constants.Nil) {
                return Constants.Nil;
            }
            String s = Coerce.toVncString(arg).getValue();
            return new VncString(StringEscapeUtil.escapeXml(s));
        }
    };
    public static VncFunction str_valid_email_addr_Q = new VncFunction("str/valid-email-addr?", (VncVal)VncFunction.meta().arglists("(str/valid-email-addr? e)").doc("Returns true if e is a valid email address according to RFC5322, else returns false").examples("(str/valid-email-addr? \"user@domain.com\")", "(str/valid-email-addr? \"user@domain.co.in\")", "(str/valid-email-addr? \"user.name@domain.com\")", "(str/valid-email-addr? \"user_name@domain.com\")", "(str/valid-email-addr? \"username@yahoo.corporate.in\")").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            VncVal arg = args.first();
            if (arg == Constants.Nil) {
                return VncBoolean.False;
            }
            String s = Coerce.toVncString(arg).getValue();
            return VncBoolean.of(s.matches(StringFunctions.EMAIL_REGEX));
        }
    };
    public static VncFunction str_markdown_to_text = new VncFunction("str/markdown-to-text", (VncVal)VncFunction.meta().arglists("(str/markdown-to-text text width)").doc("Renders markdown formatted text to raw text").examples("(str/markdown-to-text \"#Title\\n\\nLorem ipsum...\")").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2);
            String text = Coerce.toVncString(args.first()).getValue();
            int width = Coerce.toVncLong(args.second()).toJavaInteger();
            Markdown md = Markdown.parse(text);
            String s = new TextRenderer().softWrap(width).render(md);
            s = s.replace("<table>", "").replace("</table>", "").replace("<tr>", "\n").replace("</tr>", "").replace("<td>", "").replace("</td>", "");
            return new VncString(s);
        }
    };
    public static VncFunction str_normalize_utf = new VncFunction("str/normalize-utf", (VncVal)VncFunction.meta().arglists("(str/normalize-utf text form)").doc("Normalizes an UTF string.\n\nOn MacOS umlauts like \u00e4 are just encoded as 'a' plus the combining diaresis character. Therefore an '\u00e4' (\\u00FC) and an '\u00e4' (a + \\u0308) from a MacOS filename are different!\n\nThis function normalizes UTF strings to simplify processing.\n\nThe *form* argument is one of:\n* :NFD  Canonical decomposition\n* :NFC  Canonical decomposition, followed by canonical composition\n* :NFKD  Compatibility decomposition\n* :NFKC  Compatibility decomposition, followed by canonical composition\n\n```                                                                     \n(load-module :hexdump  ['hexdump :as 'h])                               \n                                                                        \n ;; Even though printed the same these two strings are NOT equal        \n ;; 1: \"\u00fc\"          prints to \"\u00fc\"                                   \n ;; 2: \"u\\u0308\"   prints to \"\u00fc\"                                   \n                                                                        \n\u00abIf it looks like a duck and quacks like a duck, then it probably is a duck\u00bb is definitely WRONG here!                                                    \n                                                                        \n;; \u00fc represented as u with combining diaresis char: \\u0308  \u0308           \n(println \"u\\u0308\")                                                  \n;; => u\u0308   (actually prints as \u00fc on a terminal)                          \n                                                                        \n;; \u00fc: \\u00FC                                                           \n(println \"\\u00FC\")                                                   \n;; => \u00fc                                                                 \n                                                                        \n;; u with combining diaresis character  \u0308                                \n(h/dump (bytebuf-from-string \"u\\u0308\"))                             \n;; 00000000: 75cc 88                                  u..               \n                                                                        \n;; \u00fc                                                                    \n(h/dump (bytebuf-from-string \"\u00fc\"))                                    \n;; 00000000: c3bc                                     ..                \n                                                                        \n;; \u00fc: \\u00FC                                                           \n(h/dump (bytebuf-from-string \"\\u00FC\"))                              \n;; 00000000: c3bc                                     ..                \n                                                                        \n;; u with combined diaresis character normalized to get a standard \u00fc    \n(h/dump (bytebuf-from-string (str/normalize-utf \"u\\u0308\" :NFC)))    \n;; 00000000: c3bc                                     ..                \n                                                                        \n;; the reverse (decomposition)                                          \n(h/dump (bytebuf-from-string (str/normalize-utf \"\\u00FC\" :NFD)))     \n;; 00000000: 75cc 88                                  u..               \n```                                                                     ").seeAlso("io/file-normalize-utf").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2);
            String s = Coerce.toVncString(args.first()).getValue();
            VncKeyword form = Coerce.toVncKeyword(args.second());
            switch (form.getValue()) {
                case "NFD": {
                    return new VncString(Normalizer.normalize(s, Normalizer.Form.NFD));
                }
                case "NFC": {
                    return new VncString(Normalizer.normalize(s, Normalizer.Form.NFC));
                }
                case "NFKD": {
                    return new VncString(Normalizer.normalize(s, Normalizer.Form.NFKD));
                }
                case "NFKC": {
                    return new VncString(Normalizer.normalize(s, Normalizer.Form.NFKC));
                }
            }
            throw new VncException("Function 'str/normalize-utf' invalid form argument " + form + ". Use one of {:NFD, :NFC, :NFKD, :NFKC}!");
        }
    };
    private static final String EMAIL_REGEX = "^[\\w!#$%&\u2019*+/=?`{|}~^-]+(?:\\.[\\w!#$%&\u2019*+/=?`{|}~^-]+)*@(?:[a-zA-Z0-9-]+\\.)+[a-zA-Z]{2,6}$";
    public static final Map<VncVal, VncVal> ns = new SymbolMapBuilder().add(str_blank_Q).add(str_not_blank_Q).add(str_starts_with_Q).add(str_ends_with_Q).add(str_contains_Q).add(str_equals_ignore_case_Q).add(str_char_Q).add(str_digit_Q).add(str_hexdigit_Q).add(str_letter_Q).add(str_letter_or_digit_Q).add(str_linefeed_Q).add(str_whitespace_Q).add(str_upper_case_Q).add(str_lower_case_Q).add(str_trim).add(str_trim_left).add(str_trim_right).add(str_trim_to_empty).add(str_trim_to_nil).add(str_crlf_to_lf).add(str_align).add(str_index_of).add(str_index_of_char).add(str_index_of_not_char).add(str_last_index_of).add(str_replace_first).add(str_replace_last).add(str_replace_all).add(str_reverse).add(str_lower_case).add(str_upper_case).add(str_join).add(str_subs).add(str_pos).add(str_chars).add(str_split).add(str_split_at).add(str_split_lines).add(str_split_columns).add(str_cr_lf).add(str_format).add(str_rest).add(str_nrest).add(str_nfirst).add(str_nlast).add(str_butlast).add(str_butnlast).add(str_quote).add(str_double_quote).add(str_double_unquote).add(str_quoted_Q).add(str_double_quoted_Q).add(str_truncate).add(str_expand).add(str_strip_start).add(str_strip_end).add(str_strip_indent).add(str_strip_margin).add(str_repeat).add(str_lorem_ipsum).add(str_wrap).add(str_hex_to_bytebuf).add(str_bytebuf_to_hex).add(str_format_bytebuf).add(str_encode_base64).add(str_decode_base64).add(str_encode_url).add(str_decode_url).add(str_escape_html).add(str_escape_xml).add(str_valid_email_addr_Q).add(str_levenshtein).add(str_markdown_to_text).add(str_normalize_utf).toMap();

    private static Locale toLocale(VncVal locale) {
        if (Types.isVncJavaObject(locale, Locale.class)) {
            return (Locale)((VncJavaObject)locale).getDelegate();
        }
        if (Types.isVncSequence(locale)) {
            VncSequence localeSeq = (VncSequence)locale;
            switch (localeSeq.size()) {
                case 0: {
                    return Locale.getDefault();
                }
                case 1: {
                    return new Locale(Coerce.toVncString(localeSeq.first()).getValue());
                }
                case 2: {
                    return new Locale(Coerce.toVncString(localeSeq.first()).getValue(), Coerce.toVncString(localeSeq.second()).getValue());
                }
            }
            return new Locale(Coerce.toVncString(localeSeq.first()).getValue(), Coerce.toVncString(localeSeq.second()).getValue(), Coerce.toVncString(localeSeq.third()).getValue());
        }
        return null;
    }
}

