/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.functions;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.VncBoolean;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncJavaObject;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncLong;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncOrderedMap;
import com.github.jlangch.venice.impl.types.collections.VncSequence;
import com.github.jlangch.venice.impl.types.util.Coerce;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.impl.util.ArityExceptions;
import com.github.jlangch.venice.impl.util.SymbolMapBuilder;
import com.github.jlangch.venice.impl.util.reflect.ReflectionAccessor;
import com.github.jlangch.venice.impl.util.time.TimeUtil;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAmount;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class TimeFunctions {
    public static VncFunction date = new VncFunction("time/date", (VncVal)VncFunction.meta().arglists("(time/date)", "(time/date x)").doc("Creates a new date of type 'java.util.Date'. \nx can be a long representing milliseconds since the epoch, a 'java.time.LocalDate', a 'java.time.LocalDateTime', or a 'java.time.ZonedDateTime'").examples("(time/date)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 0, 1);
            if (args.size() == 0) {
                return new VncJavaObject(new Date());
            }
            VncVal val = args.first();
            if (Types.isVncLong(val)) {
                long millis = ((VncLong)val).getValue();
                return new VncJavaObject(new Date(millis));
            }
            if (Types.isVncJavaObject(val)) {
                Object date = ((VncJavaObject)val).getDelegate();
                if (date instanceof Date) {
                    return new VncJavaObject(new Date(((Date)date).getTime()));
                }
                if (date instanceof LocalDate) {
                    return new VncJavaObject(TimeUtil.convertLocalDateToDate((LocalDate)date));
                }
                if (date instanceof LocalDateTime) {
                    return new VncJavaObject(TimeUtil.convertLocalDateTimeToDate((LocalDateTime)date));
                }
                if (date instanceof ZonedDateTime) {
                    return new VncJavaObject(TimeUtil.convertZonedDateTimeToDate((ZonedDateTime)date));
                }
            }
            throw new VncException(String.format("Function 'time/date' does not allow %s as parameter", Types.getType(val)));
        }
    };
    public static VncFunction date_Q = new VncFunction("time/date?", (VncVal)VncFunction.meta().arglists("(time/date? date)").doc("Returns true if date is a 'java.util.Date' else false").examples("(time/date? (time/date))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            return VncBoolean.of(Types.isVncJavaObject(args.first(), Date.class));
        }
    };
    public static VncFunction local_date = new VncFunction("time/local-date", (VncVal)VncFunction.meta().arglists("(time/local-date)", "(time/local-date year month day)", "(time/local-date date)").doc("Creates a new local-date. A local-date is represented by 'java.time.LocalDate'").examples("(time/local-date)", "(time/local-date 2018 8 1)", "(time/local-date \"2018-08-01\")", "(time/local-date (time/local-date-time 2018 8 1 14 20 10))", "(time/local-date 1375315200000)", "(time/local-date (. :java.util.Date :new))").seeAlso("time/local-date-time", "time/zoned-date-time").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 0, 1, 3);
            if (args.size() == 0) {
                return new VncJavaObject(LocalDate.now());
            }
            if (args.size() == 1) {
                VncVal val = args.first();
                if (Types.isVncJavaObject(val)) {
                    Object obj = ((VncJavaObject)val).getDelegate();
                    if (obj instanceof Date) {
                        long millis = ((Date)obj).getTime();
                        return new VncJavaObject(Instant.ofEpochMilli(millis).atZone(ZoneId.systemDefault()).toLocalDate());
                    }
                    if (obj instanceof ZonedDateTime) {
                        return new VncJavaObject(((ZonedDateTime)obj).toLocalDate());
                    }
                    if (obj instanceof LocalDateTime) {
                        return new VncJavaObject(((LocalDateTime)obj).toLocalDate());
                    }
                    if (obj instanceof LocalDate) {
                        return val;
                    }
                    throw new VncException(String.format("Function 'time/local-date' does not allow %s as parameters", Types.getType(val)));
                }
                if (Types.isVncString(val)) {
                    String s = ((VncString)val).getValue();
                    return new VncJavaObject(LocalDate.parse(s));
                }
                if (Types.isVncLong(val)) {
                    long millis = ((VncLong)val).getValue();
                    return new VncJavaObject(Instant.ofEpochMilli(millis).atZone(ZoneId.systemDefault()).toLocalDate());
                }
                throw new VncException(String.format("Function 'time/local-date' does not allow %s as parameter", Types.getType(val)));
            }
            return new VncJavaObject(LocalDate.of(Coerce.toVncLong(args.first()).getValue().intValue(), Coerce.toVncLong(args.second()).getValue().intValue(), Coerce.toVncLong(args.nth(2)).getValue().intValue()));
        }
    };
    public static VncFunction local_date_Q = new VncFunction("time/local-date?", (VncVal)VncFunction.meta().arglists("(time/local-date? date)").doc("Returns true if date is a locale date ('java.time.LocalDate') else false").examples("(time/local-date? (time/local-date))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            return VncBoolean.of(Types.isVncJavaObject(args.first(), LocalDate.class));
        }
    };
    public static VncFunction local_date_parse = new VncFunction("time/local-date-parse", (VncVal)VncFunction.meta().arglists("(time/local-date-parse str format", "(time/local-date-parse str format locale").doc("Parses a local-date.                                            \n\nTo parse a large number of dates a pre instantiated formatter   delivers best performance:                                      \n\n```                                                             \n(let [fmt (time/formatter \"yyyy-MM-dd\")]                      \n  (dotimes [n 100] (time/local-date-parse \"2018-12-01\" fmt))) \n```").examples("(time/local-date-parse \"2018-12-01\" \"yyyy-MM-dd\")", "(time/local-date-parse \"2018-Dec-01\" \"yyyy-MMM-dd\" :ENGLISH)", "(time/local-date-parse \"2018-12-01\" :iso)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2, 3);
            VncString date = Coerce.toVncString(args.first());
            VncVal format = args.second();
            Locale locale = args.size() == 3 ? TimeFunctions.getLocale(args.nth(2)) : null;
            DateTimeFormatter formatter = TimeFunctions.isIsoFormat(format) ? DateTimeFormatter.ISO_LOCAL_DATE : TimeFunctions.getDateTimeFormatter(format);
            return new VncJavaObject(LocalDate.parse(date.getValue(), TimeFunctions.localize(formatter, locale)));
        }
    };
    public static VncFunction local_date_time = new VncFunction("time/local-date-time", (VncVal)VncFunction.meta().arglists("(time/local-date-time)", "(time/local-date-time year month day)", "(time/local-date-time year month day hour minute second)", "(time/local-date-time year month day hour minute second millis)", "(time/local-date-time date)").doc("Creates a new local-date-time. A local-date-time is represented by 'java.time.LocalDateTime'").examples("(time/local-date-time)", "(time/local-date-time 2018 8 1)", "(time/local-date-time 2018 8 1 14 20 10)", "(time/local-date-time 2018 8 1 14 20 10 200)", "(time/local-date-time \"2018-08-01T14:20:10.200\")", "(time/local-date-time (time/local-date 2018 8 1))", "(time/local-date-time 1375315200000)", "(time/local-date-time (. :java.util.Date :new))").seeAlso("time/local-date", "time/zoned-date-time").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 0, 1, 3, 6, 7);
            if (args.size() == 0) {
                return new VncJavaObject(LocalDateTime.now());
            }
            if (args.size() == 1) {
                VncVal val = args.first();
                if (Types.isVncJavaObject(val)) {
                    Object obj = ((VncJavaObject)val).getDelegate();
                    if (obj instanceof Date) {
                        long millis = ((Date)obj).getTime();
                        return new VncJavaObject(Instant.ofEpochMilli(millis).atZone(ZoneId.systemDefault()).toLocalDateTime());
                    }
                    if (obj instanceof ZonedDateTime) {
                        return new VncJavaObject(((ZonedDateTime)obj).toLocalDateTime());
                    }
                    if (obj instanceof LocalDateTime) {
                        return val;
                    }
                    if (obj instanceof LocalDate) {
                        return new VncJavaObject(((LocalDate)obj).atTime(0, 0, 0));
                    }
                    if (obj instanceof Instant) {
                        return new VncJavaObject(LocalDateTime.ofInstant((Instant)obj, ZoneOffset.systemDefault()));
                    }
                    throw new VncException(String.format("Function 'time/local-date-time' does not allow %s as parameters", Types.getType(val)));
                }
                if (Types.isVncString(val)) {
                    String s = ((VncString)val).getValue();
                    return new VncJavaObject(LocalDateTime.parse(s));
                }
                if (Types.isVncLong(val)) {
                    long millis = ((VncLong)val).getValue();
                    return new VncJavaObject(Instant.ofEpochMilli(millis).atZone(ZoneId.systemDefault()).toLocalDateTime());
                }
                throw new VncException(String.format("Function 'time/local-date-time' does not allow %s as parameter", Types.getType(val)));
            }
            if (args.size() == 3) {
                return new VncJavaObject(LocalDateTime.of(Coerce.toVncLong(args.first()).getValue().intValue(), Coerce.toVncLong(args.second()).getValue().intValue(), Coerce.toVncLong(args.nth(2)).getValue().intValue(), 0, 0, 0, 0));
            }
            if (args.size() == 6) {
                return new VncJavaObject(LocalDateTime.of(Coerce.toVncLong(args.first()).getValue().intValue(), Coerce.toVncLong(args.second()).getValue().intValue(), Coerce.toVncLong(args.nth(2)).getValue().intValue(), Coerce.toVncLong(args.nth(3)).getValue().intValue(), Coerce.toVncLong(args.nth(4)).getValue().intValue(), Coerce.toVncLong(args.nth(5)).getValue().intValue(), 0));
            }
            return new VncJavaObject(LocalDateTime.of(Coerce.toVncLong(args.first()).getValue().intValue(), Coerce.toVncLong(args.second()).getValue().intValue(), Coerce.toVncLong(args.nth(2)).getValue().intValue(), Coerce.toVncLong(args.nth(3)).getValue().intValue(), Coerce.toVncLong(args.nth(4)).getValue().intValue(), Coerce.toVncLong(args.nth(5)).getValue().intValue(), Coerce.toVncLong(args.nth(6)).getValue().intValue() * 1000000));
        }
    };
    public static VncFunction local_date_time_Q = new VncFunction("time/local-date-time?", (VncVal)VncFunction.meta().arglists("(time/local-date-time? date)").doc("Returns true if date is a local-date-time  ('java.time.LocalDateTime') else false").examples("(time/local-date-time? (time/local-date-time))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            return VncBoolean.of(Types.isVncJavaObject(args.first(), LocalDateTime.class));
        }
    };
    public static VncFunction local_date_time_parse = new VncFunction("time/local-date-time-parse", (VncVal)VncFunction.meta().arglists("(time/local-date-time-parse str format", "(time/local-date-time-parse str format locale").doc("Parses a local-date-time.                                                     \n\nTo parse a large number of dates a pre instantiated formatter                 delivers best performance:                                                    \n\n```                                                                           \n(let [fmt (time/formatter \"yyyy-MM-dd HH:mm:ss\")]                           \n  (dotimes [n 100] (time/local-date-time-parse \"2018-12-01 14:20:01\" fmt))) \n```").examples("(time/local-date-time-parse \"2018-08-01 14:20\" \"yyyy-MM-dd HH:mm\")", "(time/local-date-time-parse \"2018-08-01 14:20:01.231\" \"yyyy-MM-dd HH:mm:ss.SSS\")", "(time/local-date-time-parse \"2018-08-01T14:20:01.231\" :iso)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2, 3);
            VncString date = Coerce.toVncString(args.first());
            VncVal format = args.second();
            Locale locale = args.size() == 3 ? TimeFunctions.getLocale(args.nth(2)) : null;
            DateTimeFormatter formatter = TimeFunctions.isIsoFormat(format) ? DateTimeFormatter.ISO_LOCAL_DATE_TIME : TimeFunctions.getDateTimeFormatter(format);
            return new VncJavaObject(LocalDateTime.parse(date.getValue(), TimeFunctions.localize(formatter, locale)));
        }
    };
    public static VncFunction zoned_date_time = new VncFunction("time/zoned-date-time", (VncVal)VncFunction.meta().arglists("(time/zoned-date-time)", "(time/zoned-date-time year month day)", "(time/zoned-date-time year month day hour minute second)", "(time/zoned-date-time year month day hour minute second millis)", "(time/zoned-date-time date)", "(time/zoned-date-time zone-id)", "(time/zoned-date-time zone-id year month day)", "(time/zoned-date-time zone-id year month day hour minute second)", "(time/zoned-date-time zone-id year month day hour minute second millis)", "(time/zoned-date-time zone-id date)").doc("Creates a new zoned-date-time. A zoned-date-time is represented by 'java.time.ZonedDateTime'").examples("(time/zoned-date-time)", "(time/zoned-date-time 2018 8 1)", "(time/zoned-date-time 2018 8 1 14 20 10)", "(time/zoned-date-time 2018 8 1 14 20 10 200)", "(time/zoned-date-time \"2018-08-01T14:20:10.200+01:00\")", "(time/zoned-date-time (time/local-date 2018 8 1))", "(time/zoned-date-time (time/local-date-time 2018 8 1 14 20 10))", "(time/zoned-date-time 1375315200000)", "(time/zoned-date-time (. :java.util.Date :new))", "(time/zoned-date-time \"UTC\")", "(time/zoned-date-time \"UTC\" 2018 8 1)", "(time/zoned-date-time \"UTC\" 2018 8 1 14 20 10)", "(time/zoned-date-time \"UTC\" 2018 8 1 14 20 10 200)", "(time/zoned-date-time \"UTC\" \"2018-08-01T14:20:10.200+01:00\")", "(time/zoned-date-time \"UTC\" (time/local-date 2018 8 1))", "(time/zoned-date-time \"UTC\" (time/local-date-time 2018 8 1 14 20 10))", "(time/zoned-date-time \"UTC\" 1375315200000)", "(time/zoned-date-time \"UTC\" (. :java.util.Date :new))").seeAlso("time/local-date", "time/local-date-time").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            String s;
            VncVal val;
            ArityExceptions.assertArities(this, args, 0, 1, 2, 3, 4, 6, 7, 8);
            ZoneId zoneId = null;
            VncList argList = args;
            if (args.size() > 0) {
                val = args.first();
                if (Types.isVncKeyword(val)) {
                    zoneId = ZoneId.of(((VncKeyword)val).getValue());
                    argList = args.rest();
                } else if (Types.isVncString(val) && !(s = ((VncString)val).getValue()).isEmpty() && !Character.isDigit(s.charAt(0))) {
                    zoneId = ZoneId.of(s);
                    argList = args.rest();
                }
            }
            if (argList.size() == 0) {
                return new VncJavaObject(ZonedDateTime.now(TimeFunctions.orDefaultZone(zoneId)));
            }
            if (argList.size() == 1) {
                val = argList.first();
                if (Types.isVncJavaObject(val)) {
                    Object obj = ((VncJavaObject)val).getDelegate();
                    if (obj instanceof Date) {
                        long millis = ((Date)obj).getTime();
                        return new VncJavaObject(Instant.ofEpochMilli(millis).atZone(TimeFunctions.orDefaultZone(zoneId)));
                    }
                    if (obj instanceof ZonedDateTime) {
                        return new VncJavaObject(((ZonedDateTime)obj).withZoneSameInstant(TimeFunctions.orDefaultZone(zoneId)));
                    }
                    if (obj instanceof LocalDateTime) {
                        return new VncJavaObject(((LocalDateTime)obj).atZone(TimeFunctions.orDefaultZone(zoneId)));
                    }
                    if (obj instanceof LocalDate) {
                        return new VncJavaObject(((LocalDate)obj).atTime(0, 0, 0).atZone(TimeFunctions.orDefaultZone(zoneId)));
                    }
                    throw new VncException(String.format("Function 'time/zoned-date-time' does not allow %s as parameter", Types.getType(val)));
                }
                if (Types.isVncString(val)) {
                    s = ((VncString)val).getValue();
                    return new VncJavaObject(ZonedDateTime.parse(s, TimeFunctions.zone(DateTimeFormatter.ISO_ZONED_DATE_TIME, zoneId)));
                }
                if (Types.isVncLong(val)) {
                    long millis = ((VncLong)val).getValue();
                    return new VncJavaObject(Instant.ofEpochMilli(millis).atZone(TimeFunctions.orDefaultZone(zoneId)));
                }
                throw new VncException(String.format("Function 'time/zoned-date-time' does not allow %s as parameter", Types.getType(val)));
            }
            if (argList.size() == 3) {
                return new VncJavaObject(ZonedDateTime.of(Coerce.toVncLong(argList.first()).getValue().intValue(), Coerce.toVncLong(argList.second()).getValue().intValue(), Coerce.toVncLong(argList.nth(2)).getValue().intValue(), 0, 0, 0, 0, TimeFunctions.orDefaultZone(zoneId)));
            }
            if (argList.size() == 6) {
                return new VncJavaObject(ZonedDateTime.of(Coerce.toVncLong(argList.first()).getValue().intValue(), Coerce.toVncLong(argList.second()).getValue().intValue(), Coerce.toVncLong(argList.nth(2)).getValue().intValue(), Coerce.toVncLong(argList.nth(3)).getValue().intValue(), Coerce.toVncLong(argList.nth(4)).getValue().intValue(), Coerce.toVncLong(argList.nth(5)).getValue().intValue(), 0, TimeFunctions.orDefaultZone(zoneId)));
            }
            return new VncJavaObject(ZonedDateTime.of(Coerce.toVncLong(argList.first()).getValue().intValue(), Coerce.toVncLong(argList.second()).getValue().intValue(), Coerce.toVncLong(argList.nth(2)).getValue().intValue(), Coerce.toVncLong(argList.nth(3)).getValue().intValue(), Coerce.toVncLong(argList.nth(4)).getValue().intValue(), Coerce.toVncLong(argList.nth(5)).getValue().intValue(), Coerce.toVncLong(argList.nth(6)).getValue().intValue() * 1000000, TimeFunctions.orDefaultZone(zoneId)));
        }
    };
    public static VncFunction zoned_date_time_Q = new VncFunction("time/zoned-date-time?", (VncVal)VncFunction.meta().arglists("(time/zoned-date-time? date)").doc("Returns true if date is a zoned-date-time ('java.time.ZonedDateTime') else false").examples("(time/zoned-date-time? (time/zoned-date-time))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            VncVal val = args.first();
            return VncBoolean.of(Types.isVncJavaObject(val, ZonedDateTime.class));
        }
    };
    public static VncFunction zoned_date_time_parse = new VncFunction("time/zoned-date-time-parse", (VncVal)VncFunction.meta().arglists("(time/zoned-date-time-parse str format", "(time/zoned-date-time-parse str format locale").doc("Parses a zoned-date-time.                                                           \n\nTo parse a large number of dates a pre instantiated formatter                       delivers best performance:                                                          \n\n```                                                                                 \n(let [fmt (time/formatter \"yyyy-MM-dd'T'HH:mm:ssz\")]                              \n  (dotimes [n 100] (time/zoned-date-time-parse \"2018-12-01T14:20:01+01:00\" fmt))) \n```").examples("(time/zoned-date-time-parse \"2018-08-01T14:20:01+01:00\" \"yyyy-MM-dd'T'HH:mm:ssz\")", "(time/zoned-date-time-parse \"2018-08-01T14:20:01.000+01:00\" \"yyyy-MM-dd'T'HH:mm:ss.SSSz\")", "(time/zoned-date-time-parse \"2018-08-01T14:20:01.000+01:00\" :iso)", "(time/zoned-date-time-parse \"2018-08-01 14:20:01.000 +01:00\" \"yyyy-MM-dd' 'HH:mm:ss.SSS' 'z\")").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2, 3);
            VncString date = Coerce.toVncString(args.first());
            VncVal format = args.second();
            Locale locale = args.size() == 3 ? TimeFunctions.getLocale(args.nth(2)) : null;
            DateTimeFormatter formatter = TimeFunctions.isIsoFormat(format) ? DateTimeFormatter.ISO_OFFSET_DATE_TIME : TimeFunctions.getDateTimeFormatter(format);
            return new VncJavaObject(ZonedDateTime.parse(date.getValue(), TimeFunctions.localize(formatter, locale)));
        }
    };
    public static VncFunction after_Q = new VncFunction("time/after?", (VncVal)VncFunction.meta().arglists("(time/after? date1 date2)", "(time/after? date1 date2 & more)").doc("Returns true if all dates are ordered from the latest to the earliest (same semantics as `>`)").examples("(time/after? (time/local-date 2019 1 1) \n             (time/local-date 2018 1 1))", "(time/after? (time/local-date-time \"2019-01-01T10:00:00.000\") \n             (time/local-date-time \"2018-01-01T10:00:00.000\"))", "(time/after? (time/zoned-date-time \"2019-01-01T10:00:00.000+01:00\") \n             (time/zoned-date-time \"2018-01-01T10:00:00.000+01:00\"))").seeAlso("time/before?", "time/not-after?", "time/not-before?").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertMinArity(this, args, 2);
            boolean after = true;
            VncVal d1 = args.first();
            for (VncVal d2 : args.rest()) {
                Object date1 = Coerce.toVncJavaObject(d1).getDelegate();
                Object date2 = Coerce.toVncJavaObject(d2).getDelegate();
                if (date1 instanceof ZonedDateTime && date2 instanceof ZonedDateTime) {
                    after = after && ((ZonedDateTime)date1).isAfter((ZonedDateTime)date2);
                } else if (date1 instanceof LocalDateTime && date2 instanceof LocalDateTime) {
                    after = after && ((LocalDateTime)date1).isAfter((LocalDateTime)date2);
                } else if (date1 instanceof LocalDate && date2 instanceof LocalDate) {
                    after = after && ((LocalDate)date1).isAfter((LocalDate)date2);
                } else {
                    throw new VncException(String.format("Function 'time/after?' does not allow %s %s as date1 / date2 parameter", Types.getType(args.first()), Types.getType(args.second())));
                }
                if (!after) break;
                d1 = d2;
            }
            return VncBoolean.of(after);
        }
    };
    public static VncFunction not_after_Q = new VncFunction("time/not-after?", (VncVal)VncFunction.meta().arglists("(time/not-after? date1 date2)").doc("Returns true if date1 is not-after date2 else false (same semantics as `<=`)").examples("(time/not-after? (time/local-date 2018 1 1) \n                 (time/local-date 2019 1 1))", "(time/not-after? (time/local-date-time \"2018-01-01T10:00:00.000\") \n                 (time/local-date-time \"2019-01-01T10:00:00.000\"))", "(time/not-after? (time/zoned-date-time \"2018-01-01T10:00:00.000+01:00\") \n                 (time/zoned-date-time \"2019-01-01T10:00:00.000+01:00\"))").seeAlso("time/after?", "time/before?", "time/not-before?").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2);
            Object date1 = Coerce.toVncJavaObject(args.first()).getDelegate();
            Object date2 = Coerce.toVncJavaObject(args.second()).getDelegate();
            if (date1 instanceof ZonedDateTime && date2 instanceof ZonedDateTime) {
                return VncBoolean.of(!((ZonedDateTime)date1).isAfter((ZonedDateTime)date2));
            }
            if (date1 instanceof LocalDateTime && date2 instanceof LocalDateTime) {
                return VncBoolean.of(!((LocalDateTime)date1).isAfter((LocalDateTime)date2));
            }
            if (date1 instanceof LocalDate && date2 instanceof LocalDate) {
                return VncBoolean.of(!((LocalDate)date1).isAfter((LocalDate)date2));
            }
            throw new VncException(String.format("Function 'time/not-after?' does not allow %s %s as date1 / date2 parameter", Types.getType(args.first()), Types.getType(args.second())));
        }
    };
    public static VncFunction before_Q = new VncFunction("time/before?", (VncVal)VncFunction.meta().arglists("(time/before? date1 date2)", "(time/before? date1 date2 & more)").doc("Returns true if all dates are ordered from the earliest to the latest (same semantics as `<`)").examples("(time/before? (time/local-date 2018 1 1) \n              (time/local-date 2019 1 1))", "(time/before? (time/local-date-time \"2018-01-01T10:00:00.000\") \n              (time/local-date-time \"2019-01-01T10:00:00.000\"))", "(time/before? (time/zoned-date-time \"2018-01-01T10:00:00.000+01:00\") \n              (time/zoned-date-time \"2019-01-01T10:00:00.000+01:00\"))").seeAlso("time/after?", "time/not-after?", "time/not-before?").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertMinArity(this, args, 2);
            boolean before = true;
            VncVal d1 = args.first();
            for (VncVal d2 : args.rest()) {
                Object date1 = Coerce.toVncJavaObject(d1).getDelegate();
                Object date2 = Coerce.toVncJavaObject(d2).getDelegate();
                if (date1 instanceof ZonedDateTime && date2 instanceof ZonedDateTime) {
                    before = before && ((ZonedDateTime)date1).isBefore((ZonedDateTime)date2);
                } else if (date1 instanceof LocalDateTime && date2 instanceof LocalDateTime) {
                    before = before && ((LocalDateTime)date1).isBefore((LocalDateTime)date2);
                } else if (date1 instanceof LocalDate && date2 instanceof LocalDate) {
                    before = before && ((LocalDate)date1).isBefore((LocalDate)date2);
                } else {
                    throw new VncException(String.format("Function 'time/before?' does not allow %s, %s as date parameter", Types.getType(d1), Types.getType(d2)));
                }
                if (!before) break;
                d1 = d2;
            }
            return VncBoolean.of(before);
        }
    };
    public static VncFunction not_before_Q = new VncFunction("time/not-before?", (VncVal)VncFunction.meta().arglists("(time/not-before? date1 date2)").doc("Returns true if date1 is not-before date2 else false (same semantics as `>=`)").examples("(time/not-before? (time/local-date 2019 1 1) \n                  (time/local-date 2019 1 1))", "(time/not-before? (time/local-date-time \"2019-01-01T10:00:00.000\") \n                  (time/local-date-time \"2018-01-01T10:00:00.000\"))", "(time/not-before? (time/zoned-date-time \"2019-01-01T10:00:00.000+01:00\") \n                  (time/zoned-date-time \"2018-01-01T10:00:00.000+01:00\"))").seeAlso("time/after?", "time/before?", "time/not-after?").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2);
            Object date1 = Coerce.toVncJavaObject(args.first()).getDelegate();
            Object date2 = Coerce.toVncJavaObject(args.second()).getDelegate();
            if (date1 instanceof ZonedDateTime && date2 instanceof ZonedDateTime) {
                return VncBoolean.of(!((ZonedDateTime)date1).isBefore((ZonedDateTime)date2));
            }
            if (date1 instanceof LocalDateTime && date2 instanceof LocalDateTime) {
                return VncBoolean.of(!((LocalDateTime)date1).isBefore((LocalDateTime)date2));
            }
            if (date1 instanceof LocalDate && date2 instanceof LocalDate) {
                return VncBoolean.of(!((LocalDate)date1).isBefore((LocalDate)date2));
            }
            throw new VncException(String.format("Function 'time/not-before?' does not allow %s %s as date1 / date2 parameter", Types.getType(args.first()), Types.getType(args.second())));
        }
    };
    public static VncFunction plus = new VncFunction("time/plus", (VncVal)VncFunction.meta().arglists("(time/plus date unit n)", "(time/minus plus temporal)").doc("Adds the n units to the date. Units: {:years :months :weeks :days :hours :minutes :seconds :milliseconds}\n\nIn the two argument version add a :java.time.Temporal (Period, Duration) to the date.").examples("(time/plus (time/local-date) :days 2)", "(time/plus (time/local-date-time) :days 2)", "(time/plus (time/zoned-date-time) :days 2)", "(time/plus (time/local-date) (. :java.time.Period :ofDays 2))", "(time/plus (time/local-date-time) (. :java.time.Period :ofDays 2))", "(time/plus (time/zoned-date-time) (. :java.time.Period :ofDays 2))").seeAlso("time/minus").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2, 3);
            if (args.size() == 2) {
                Temporal temporal = Coerce.toVncJavaObject(args.first(), Temporal.class);
                TemporalAmount amount = Coerce.toVncJavaObject(args.second(), TemporalAmount.class);
                return new VncJavaObject(temporal.plus(amount));
            }
            Temporal temporal = Coerce.toVncJavaObject(args.first(), Temporal.class);
            ChronoUnit unit = TimeFunctions.toChronoUnit(Coerce.toVncKeyword(args.second()).getValue());
            long n = Coerce.toVncLong(args.nth(2)).getValue();
            if (unit == null) {
                throw new VncException(String.format("Function 'time/plus' invalid time unit %s", Coerce.toVncKeyword(args.second()).getValue()));
            }
            return new VncJavaObject(temporal.plus(n, unit));
        }
    };
    public static VncFunction minus = new VncFunction("time/minus", (VncVal)VncFunction.meta().arglists("(time/minus date unit n)", "(time/minus date temporal)").doc("Subtracts the n units from the date. Units: {:years :months :weeks :days :hours :minutes :seconds :milliseconds}\n\nIn the two argument version subtracts a :java.time.Temporal (Period, Duration) from the date.").examples("(time/minus (time/local-date) :days 2)", "(time/minus (time/local-date-time) :days 2)", "(time/minus (time/zoned-date-time) :days 2)", "(time/minus (time/local-date) (. :java.time.Period :ofDays 2))", "(time/minus (time/local-date-time) (. :java.time.Period :ofDays 2))", "(time/minus (time/zoned-date-time) (. :java.time.Period :ofDays 2))").seeAlso("time/plus").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2, 3);
            if (args.size() == 2) {
                Temporal temporal = Coerce.toVncJavaObject(args.first(), Temporal.class);
                TemporalAmount amount = Coerce.toVncJavaObject(args.second(), TemporalAmount.class);
                return new VncJavaObject(temporal.minus(amount));
            }
            Temporal temporal = Coerce.toVncJavaObject(args.first(), Temporal.class);
            ChronoUnit unit = TimeFunctions.toChronoUnit(Coerce.toVncKeyword(args.second()).getValue());
            long n = Coerce.toVncLong(args.nth(2)).getValue();
            if (unit == null) {
                throw new VncException(String.format("Function 'time/minus' invalid time unit %ss", Coerce.toVncKeyword(args.second()).getValue()));
            }
            return new VncJavaObject(temporal.minus(n, unit));
        }
    };
    public static VncFunction period = new VncFunction("time/period", (VncVal)VncFunction.meta().arglists("(time/period from to unit)").doc("Returns the period interval of two dates in the specified unit.\u00b6Units: {:years :months :weeks :days :hours :minutes :seconds :milliseconds}").examples("(time/period (time/local-date) (time/plus (time/local-date) :days 3) :days)", "(time/period (time/local-date-time) (time/plus (time/local-date-time) :days 3) :days)", "(time/period (time/zoned-date-time) (time/plus (time/zoned-date-time) :days 3) :days)").seeAlso("time/local-date", "time/local-date-time", "time/zoned-date-time").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 3);
            Object from = Coerce.toVncJavaObject(args.first()).getDelegate();
            Object to = Coerce.toVncJavaObject(args.second()).getDelegate();
            ChronoUnit unit = TimeFunctions.toChronoUnit(Coerce.toVncKeyword(args.nth(2)).getValue());
            if (unit == null) {
                throw new VncException(String.format("Function 'time/period' invalid time unit %s", Coerce.toVncKeyword(args.second()).getValue()));
            }
            if (from instanceof ZonedDateTime && to instanceof ZonedDateTime) {
                return new VncLong(unit.between((ZonedDateTime)from, (ZonedDateTime)to));
            }
            if (from instanceof LocalDateTime && to instanceof LocalDateTime) {
                return new VncLong(unit.between((LocalDateTime)from, (LocalDateTime)to));
            }
            if (from instanceof LocalDate && to instanceof LocalDate) {
                return new VncLong(unit.between((LocalDate)from, (LocalDate)to));
            }
            throw new VncException(String.format("Function 'time/period' does not allow %s %s as from / to parameter", Types.getType(args.first()), Types.getType(args.second())));
        }
    };
    public static VncFunction year = new VncFunction("time/year", (VncVal)VncFunction.meta().arglists("(time/year date)").doc("Returns the year of the date").examples("(time/year (time/local-date))", "(time/year (time/local-date-time))", "(time/year (time/zoned-date-time))").seeAlso("time/month", "time/day-of-year", "time/day-of-month", "time/first-day-of-month", "time/last-day-of-month", "time/day-of-week").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            Object date = Coerce.toVncJavaObject(args.first()).getDelegate();
            if (date instanceof ZonedDateTime) {
                return new VncLong(((ZonedDateTime)date).getYear());
            }
            if (date instanceof LocalDateTime) {
                return new VncLong(((LocalDateTime)date).getYear());
            }
            if (date instanceof LocalDate) {
                return new VncLong(((LocalDate)date).getYear());
            }
            throw new VncException(String.format("Function 'time/year' does not allow %s as parameter", Types.getType(args.first())));
        }
    };
    public static VncFunction month = new VncFunction("time/month", (VncVal)VncFunction.meta().arglists("(time/month date)").doc("Returns the month of the date 1..12").examples("(time/month (time/local-date))", "(time/month (time/local-date-time))", "(time/month (time/zoned-date-time))").seeAlso("time/year", "time/day-of-year", "time/day-of-month", "time/first-day-of-month", "time/last-day-of-month", "time/day-of-week").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            Object date = Coerce.toVncJavaObject(args.first()).getDelegate();
            if (date instanceof ZonedDateTime) {
                return new VncLong(((ZonedDateTime)date).getMonth().getValue());
            }
            if (date instanceof LocalDateTime) {
                return new VncLong(((LocalDateTime)date).getMonth().getValue());
            }
            if (date instanceof LocalDate) {
                return new VncLong(((LocalDate)date).getMonth().getValue());
            }
            throw new VncException(String.format("Function 'time/month' does not allow %s as parameter", Types.getType(args.first())));
        }
    };
    public static VncFunction day_of_week = new VncFunction("time/day-of-week", (VncVal)VncFunction.meta().arglists("(time/day-of-week date)").doc("Returns the day of the week (:MONDAY ... :SUNDAY)").examples("(time/day-of-week (time/local-date))", "(time/day-of-week (time/local-date-time))", "(time/day-of-week (time/zoned-date-time))").seeAlso("time/year", "time/month", "time/day-of-year", "time/day-of-month", "time/first-day-of-month", "time/last-day-of-month").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            Object date = Coerce.toVncJavaObject(args.first()).getDelegate();
            if (date instanceof ZonedDateTime) {
                return new VncKeyword(((ZonedDateTime)date).getDayOfWeek().name());
            }
            if (date instanceof LocalDateTime) {
                return new VncKeyword(((LocalDateTime)date).getDayOfWeek().name());
            }
            if (date instanceof LocalDate) {
                return new VncKeyword(((LocalDate)date).getDayOfWeek().name());
            }
            throw new VncException(String.format("Function 'time/day-of-week' does not allow %s as parameter", Types.getType(args.first())));
        }
    };
    public static VncFunction day_of_month = new VncFunction("time/day-of-month", (VncVal)VncFunction.meta().arglists("(time/day-of-month date)").doc("Returns the day of the month (1..31)").examples("(time/day-of-month (time/local-date))", "(time/day-of-month (time/local-date-time))", "(time/day-of-month (time/zoned-date-time))").seeAlso("time/year", "time/month", "time/day-of-year", "time/first-day-of-month", "time/last-day-of-month", "time/day-of-week").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            Object date = Coerce.toVncJavaObject(args.first()).getDelegate();
            if (date instanceof ZonedDateTime) {
                return new VncLong(((ZonedDateTime)date).getDayOfMonth());
            }
            if (date instanceof LocalDateTime) {
                return new VncLong(((LocalDateTime)date).getDayOfMonth());
            }
            if (date instanceof LocalDate) {
                return new VncLong(((LocalDate)date).getDayOfMonth());
            }
            throw new VncException(String.format("Function 'time/day-of-month' does not allow %s as parameters", Types.getType(args.first())));
        }
    };
    public static VncFunction day_of_year = new VncFunction("time/day-of-year", (VncVal)VncFunction.meta().arglists("(time/day-of-year date)").doc("Returns the day of the year (1..366)").examples("(time/day-of-year (time/local-date))", "(time/day-of-year (time/local-date-time))", "(time/day-of-year (time/zoned-date-time))").seeAlso("time/year", "time/month", "time/day-of-month", "time/first-day-of-month", "time/last-day-of-month", "time/day-of-week").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            Object date = Coerce.toVncJavaObject(args.first()).getDelegate();
            if (date instanceof ZonedDateTime) {
                return new VncLong(((ZonedDateTime)date).getDayOfYear());
            }
            if (date instanceof LocalDateTime) {
                return new VncLong(((LocalDateTime)date).getDayOfYear());
            }
            if (date instanceof LocalDate) {
                return new VncLong(((LocalDate)date).getDayOfYear());
            }
            throw new VncException(String.format("Function 'time/day-of-year' does not allow %s as parameter", Types.getType(args.first())));
        }
    };
    public static VncFunction first_day_of_month = new VncFunction("time/first-day-of-month", (VncVal)VncFunction.meta().arglists("(time/first-day-of-month date)").doc("Returns the first day of a month as a local-date.").examples("(time/first-day-of-month (time/local-date))", "(time/first-day-of-month (time/local-date-time))", "(time/first-day-of-month (time/zoned-date-time))").seeAlso("time/year", "time/month", "time/day-of-year", "time/day-of-month", "time/last-day-of-month", "time/day-of-week").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            Object dt = Coerce.toVncJavaObject(args.first()).getDelegate();
            if (dt instanceof ZonedDateTime) {
                LocalDate date = ((ZonedDateTime)dt).toLocalDateTime().toLocalDate();
                return new VncJavaObject(date.withDayOfMonth(1));
            }
            if (dt instanceof LocalDateTime) {
                LocalDate date = ((LocalDateTime)dt).toLocalDate();
                return new VncJavaObject(date.withDayOfMonth(1));
            }
            if (dt instanceof LocalDate) {
                LocalDate date = (LocalDate)dt;
                return new VncJavaObject(date.withDayOfMonth(1));
            }
            throw new VncException(String.format("Function 'time/first-day-of-month' does not allow %s as parameter", Types.getType(args.first())));
        }
    };
    public static VncFunction last_day_of_month = new VncFunction("time/last-day-of-month", (VncVal)VncFunction.meta().arglists("(time/last-day-of-month date)").doc("Returns the last day of a month as a local-date.").examples("(time/last-day-of-month (time/local-date))", "(time/last-day-of-month (time/local-date-time))", "(time/last-day-of-month (time/zoned-date-time))").seeAlso("time/year", "time/month", "time/day-of-year", "time/day-of-month", "time/first-day-of-month", "time/day-of-week").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            Object dt = Coerce.toVncJavaObject(args.first()).getDelegate();
            if (dt instanceof ZonedDateTime) {
                LocalDate date = ((ZonedDateTime)dt).toLocalDateTime().toLocalDate();
                return new VncJavaObject(date.withDayOfMonth(date.lengthOfMonth()));
            }
            if (dt instanceof LocalDateTime) {
                LocalDate date = ((LocalDateTime)dt).toLocalDate();
                return new VncJavaObject(date.withDayOfMonth(date.lengthOfMonth()));
            }
            if (dt instanceof LocalDate) {
                LocalDate date = (LocalDate)dt;
                return new VncJavaObject(date.withDayOfMonth(date.lengthOfMonth()));
            }
            throw new VncException(String.format("Function 'time/last-day-of-month' does not allow %s as parameter", Types.getType(args.first())));
        }
    };
    public static VncFunction hour = new VncFunction("time/hour", (VncVal)VncFunction.meta().arglists("(time/hour date)").doc("Returns the hour of the date 0..23").examples("(time/hour (time/local-date))", "(time/hour (time/local-date-time))", "(time/hour (time/zoned-date-time))").seeAlso("time/minute", "time/second", "time/milli").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            Object date = Coerce.toVncJavaObject(args.first()).getDelegate();
            if (date instanceof ZonedDateTime) {
                return new VncLong(((ZonedDateTime)date).getHour());
            }
            if (date instanceof LocalDateTime) {
                return new VncLong(((LocalDateTime)date).getHour());
            }
            if (date instanceof LocalDate) {
                return new VncLong(0L);
            }
            throw new VncException(String.format("Function 'time/hour' does not allow %s as parameter", Types.getType(args.first())));
        }
    };
    public static VncFunction minute = new VncFunction("time/minute", (VncVal)VncFunction.meta().arglists("(time/minute date)").doc("Returns the minute of the date 0..59").examples("(time/minute (time/local-date))", "(time/minute (time/local-date-time))", "(time/minute (time/zoned-date-time))").seeAlso("time/hour", "time/second", "time/milli").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            Object date = Coerce.toVncJavaObject(args.first()).getDelegate();
            if (date instanceof ZonedDateTime) {
                return new VncLong(((ZonedDateTime)date).getMinute());
            }
            if (date instanceof LocalDateTime) {
                return new VncLong(((LocalDateTime)date).getMinute());
            }
            if (date instanceof LocalDate) {
                return new VncLong(0L);
            }
            throw new VncException(String.format("Function 'time/minute' does not allow %s as parameter", Types.getType(args.first())));
        }
    };
    public static VncFunction second = new VncFunction("time/second", (VncVal)VncFunction.meta().arglists("(time/second date)").doc("Returns the second of the date 0..59").examples("(time/second (time/local-date))", "(time/second (time/local-date-time))", "(time/second (time/zoned-date-time))").seeAlso("time/hour", "time/minute", "time/milli").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            Object date = Coerce.toVncJavaObject(args.first()).getDelegate();
            if (date instanceof ZonedDateTime) {
                return new VncLong(((ZonedDateTime)date).getSecond());
            }
            if (date instanceof LocalDateTime) {
                return new VncLong(((LocalDateTime)date).getSecond());
            }
            if (date instanceof LocalDate) {
                return new VncLong(0L);
            }
            throw new VncException(String.format("Function 'time/second' does not allow %s as parameter", Types.getType(args.first())));
        }
    };
    public static VncFunction milli = new VncFunction("time/milli", (VncVal)VncFunction.meta().arglists("(time/milli date)").doc("Returns the millis of the date 0..999").examples("(time/milli (time/local-date))", "(time/milli (time/local-date-time))", "(time/milli (time/zoned-date-time))").seeAlso("time/hour", "time/minute", "time/second").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            Object date = Coerce.toVncJavaObject(args.first()).getDelegate();
            if (date instanceof ZonedDateTime) {
                return new VncLong(((ZonedDateTime)date).getNano() / 1000000);
            }
            if (date instanceof LocalDateTime) {
                return new VncLong(((LocalDateTime)date).getNano() / 1000000);
            }
            if (date instanceof LocalDate) {
                return new VncLong(0L);
            }
            throw new VncException(String.format("Function 'time/milli' does not allow %s as parameter", Types.getType(args.first())));
        }
    };
    public static VncFunction length_of_year = new VncFunction("time/length-of-year", (VncVal)VncFunction.meta().arglists("(time/length-of-year date)").doc("Returns the length of the year represented by this date. \n\nThis returns the length of the year in days, either 365 or 366.").examples("(time/length-of-year (time/local-date 2000 1 1))", "(time/length-of-year (time/local-date 2001 1 1))", "(time/length-of-year (time/local-date-time))", "(time/length-of-year (time/zoned-date-time))").seeAlso("time/length-of-month", "time/leap-year?").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            Object dt = Coerce.toVncJavaObject(args.first()).getDelegate();
            if (dt instanceof ZonedDateTime) {
                return new VncLong(((ZonedDateTime)dt).toLocalDateTime().toLocalDate().lengthOfYear());
            }
            if (dt instanceof LocalDateTime) {
                return new VncLong(((LocalDateTime)dt).toLocalDate().lengthOfYear());
            }
            if (dt instanceof LocalDate) {
                return new VncLong(((LocalDate)dt).lengthOfYear());
            }
            throw new VncException(String.format("Function 'time/length-of-year' does not allow %s as parameter", Types.getType(args.first())));
        }
    };
    public static VncFunction length_of_month = new VncFunction("time/length-of-month", (VncVal)VncFunction.meta().arglists("(time/length-of-month date)").doc("Returns the length of the month represented by this date.\n\nThis returns the length of the month in days. For example, a date in January would return 31.").examples("(time/length-of-month (time/local-date 2000 2 1))", "(time/length-of-month (time/local-date 2001 2 1))", "(time/length-of-month (time/local-date-time))", "(time/length-of-month (time/zoned-date-time))").seeAlso("time/length-of-year", "time/leap-year?").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            Object dt = Coerce.toVncJavaObject(args.first()).getDelegate();
            if (dt instanceof ZonedDateTime) {
                return new VncLong(((ZonedDateTime)dt).toLocalDateTime().toLocalDate().lengthOfMonth());
            }
            if (dt instanceof LocalDateTime) {
                return new VncLong(((LocalDateTime)dt).toLocalDate().lengthOfMonth());
            }
            if (dt instanceof LocalDate) {
                return new VncLong(((LocalDate)dt).lengthOfMonth());
            }
            throw new VncException(String.format("Function 'time/length-of-month' does not allow %s as parameter", Types.getType(args.first())));
        }
    };
    public static VncFunction leap_yearQ = new VncFunction("time/leap-year?", (VncVal)VncFunction.meta().arglists("(time/leap-year? date)").doc("Checks if the year is a leap year.").examples("(time/leap-year? 2000)", "(time/leap-year? (time/local-date 2000 1 1))", "(time/leap-year? (time/local-date-time))", "(time/leap-year? (time/zoned-date-time))").seeAlso("time/length-of-year", "time/length-of-month").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            if (args.first() instanceof VncLong) {
                return VncBoolean.of(LocalDate.of(Coerce.toVncLong(args.first()).getValue().intValue(), 1, 1).isLeapYear());
            }
            Object dt = Coerce.toVncJavaObject(args.first()).getDelegate();
            if (dt instanceof ZonedDateTime) {
                return VncBoolean.of(((ZonedDateTime)dt).toLocalDateTime().toLocalDate().isLeapYear());
            }
            if (dt instanceof LocalDateTime) {
                return VncBoolean.of(((LocalDateTime)dt).toLocalDate().isLeapYear());
            }
            if (dt instanceof LocalDate) {
                return VncBoolean.of(((LocalDate)dt).isLeapYear());
            }
            throw new VncException(String.format("Function 'time/leap-year?' does not allow %s as parameter", Types.getType(args.first())));
        }
    };
    public static VncFunction with_time = new VncFunction("time/with-time", (VncVal)VncFunction.meta().arglists("(time/with-time date hour minute second)", "(time/with-time date hour minute second millis)").doc("Sets the time of a date. Returns a new date").examples("(time/with-time (time/local-date) 22 00 15 333)", "(time/with-time (time/local-date-time) 22 00 15 333)", "(time/with-time (time/zoned-date-time) 22 00 15 333)").seeAlso("time/local-date", "time/local-date-time", "time/zoned-date-time").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            int nanos;
            ArityExceptions.assertArity(this, args, 4, 5);
            Object dt = Coerce.toVncJavaObject(args.first()).getDelegate();
            int n = nanos = args.size() == 5 ? Coerce.toVncLong(args.nth(4)).getValue().intValue() * 1000000 : 0;
            if (dt instanceof ZonedDateTime) {
                ZonedDateTime date = (ZonedDateTime)dt;
                return new VncJavaObject(date.withHour(Coerce.toVncLong(args.second()).getValue().intValue()).withMinute(Coerce.toVncLong(args.nth(2)).getValue().intValue()).withSecond(Coerce.toVncLong(args.nth(3)).getValue().intValue()).withNano(nanos));
            }
            if (dt instanceof LocalDateTime) {
                return new VncJavaObject(((LocalDateTime)dt).toLocalDate().atTime(Coerce.toVncLong(args.second()).getValue().intValue(), Coerce.toVncLong(args.nth(2)).getValue().intValue(), Coerce.toVncLong(args.nth(3)).getValue().intValue(), nanos));
            }
            if (dt instanceof LocalDate) {
                return new VncJavaObject(((LocalDate)dt).atTime(Coerce.toVncLong(args.second()).getValue().intValue(), Coerce.toVncLong(args.nth(2)).getValue().intValue(), Coerce.toVncLong(args.nth(3)).getValue().intValue(), nanos));
            }
            throw new VncException(String.format("Function 'time/with-time' does not allow %s as parameters", Types.getType(args.first())));
        }
    };
    public static VncFunction latest = new VncFunction("time/latest", (VncVal)VncFunction.meta().arglists("(time/latest coll)").doc("Returns the latest date from a collection of dates. All dates must be of equal type. The coll may be empty or nil.").examples("(time/latest [(time/local-date 2018 8 1) (time/local-date 2018 8 3)])").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            VncSequence seq = Coerce.toVncSequence(args.first());
            if (seq.isEmpty()) {
                return Constants.Nil;
            }
            if (seq.size() == 1) {
                return seq.first();
            }
            VncVal latest = seq.first();
            for (VncVal date : seq.rest()) {
                if (!VncBoolean.isTrue(after_Q.apply(VncList.of(date, latest)))) continue;
                latest = date;
            }
            return latest;
        }
    };
    public static VncFunction earliest = new VncFunction("time/earliest", (VncVal)VncFunction.meta().arglists("(time/earliest coll)").doc("Returns the earliest date from a collection of dates. All dates must be of equal type. The coll may be empty or nil.").examples("(time/earliest [(time/local-date 2018 8 4) (time/local-date 2018 8 3)])").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            VncSequence seq = Coerce.toVncSequence(args.first());
            if (seq.isEmpty()) {
                return Constants.Nil;
            }
            if (seq.size() == 1) {
                return seq.first();
            }
            VncVal latest = seq.first();
            for (VncVal date : seq.rest()) {
                if (!VncBoolean.isTrue(before_Q.apply(VncList.of(date, latest)))) continue;
                latest = date;
            }
            return latest;
        }
    };
    public static VncFunction within_Q = new VncFunction("time/within?", (VncVal)VncFunction.meta().arglists("(time/within? date start end)").doc("Returns true if the date is after or equal to the start and is before or equal to the end. All three dates must be of the same type. The start and end date may each be nil meaning start is -infinity and end is +infinity. (same semantics as `start <= date <= end`)").examples("(time/within? (time/local-date 2018 8 15) \n              (time/local-date 2018 8 10) \n              (time/local-date 2018 8 20))", "(time/within? (time/local-date 2018 8 25) \n              (time/local-date 2018 8 10) \n              (time/local-date 2018 8 20))", "(time/within? (time/local-date 2018 8 20) \n              (time/local-date 2018 8 10) \n              nil)", "(time/within? (time/local-date-time \"2019-01-01T10:00:00.000\") \n              (time/local-date-time \"2010-01-01T10:00:00.000\") \n              (time/local-date-time \"2020-01-01T10:00:00.000\"))", "(time/within? (time/zoned-date-time \"2010-01-01T10:00:00.000+01:00\") \n              (time/zoned-date-time \"2019-01-01T10:00:00.000+01:00\") \n              (time/zoned-date-time \"2020-01-01T10:00:00.000+01:00\"))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 3);
            VncVal date = args.first();
            VncVal start = args.second();
            VncVal end = args.third();
            if (start == Constants.Nil && end == Constants.Nil) {
                return VncBoolean.True;
            }
            if (start != Constants.Nil && end != Constants.Nil) {
                return VncBoolean.of(VncBoolean.isTrue(not_before_Q.apply(VncList.of(date, start))) && VncBoolean.isTrue(not_after_Q.apply(VncList.of(date, end))));
            }
            if (start != Constants.Nil) {
                return not_before_Q.apply(VncList.of(date, start));
            }
            return not_after_Q.apply(VncList.of(date, end));
        }
    };
    public static VncFunction zone = new VncFunction("time/zone", (VncVal)VncFunction.meta().arglists("(time/zone date)").doc("Returns the zone of the date").examples("(time/zone (time/zoned-date-time))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            Object date = Coerce.toVncJavaObject(args.first()).getDelegate();
            if (date instanceof ZonedDateTime) {
                return new VncString(((ZonedDateTime)date).getZone().getId());
            }
            if (date instanceof LocalDateTime) {
                return Constants.Nil;
            }
            if (date instanceof LocalDate) {
                return Constants.Nil;
            }
            throw new VncException(String.format("Function 'time/zone' does not allow %s as parameter", Types.getType(args.first())));
        }
    };
    public static VncFunction zone_offset = new VncFunction("time/zone-offset", (VncVal)VncFunction.meta().arglists("(time/zone-offset date)").doc("Returns the zone-offset of the date in minutes").examples("(time/zone-offset (time/zoned-date-time))").seeAlso("time/zoned-date-time").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            Object date = Coerce.toVncJavaObject(args.first()).getDelegate();
            if (date instanceof ZonedDateTime) {
                return new VncLong(((ZonedDateTime)date).getOffset().getTotalSeconds() / 60);
            }
            if (date instanceof LocalDateTime) {
                return Constants.Nil;
            }
            if (date instanceof LocalDate) {
                return Constants.Nil;
            }
            throw new VncException(String.format("Function 'time/zone-offset' does not allow %s as parameter", Types.getType(args.first())));
        }
    };
    public static VncFunction formatter = new VncFunction("time/formatter", (VncVal)VncFunction.meta().arglists("(time/formatter format)", "(time/formatter format locale)").doc("Creates a formatter").examples("(time/formatter \"dd-MM-yyyy\")", "(time/formatter \"dd-MM-yyyy\" :en_EN)", "(time/formatter \"dd-MM-yyyy\" \"en_EN\")", "(time/formatter \"yyyy-MM-dd'T'HH:mm:ss.SSSz\")", "(time/formatter :ISO_OFFSET_DATE_TIME)").seeAlso("time/format").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1, 2);
            Locale locale = args.size() == 2 ? TimeFunctions.getLocale(args.second()) : null;
            return new VncJavaObject(TimeFunctions.localize(TimeFunctions.getDateTimeFormatter(args.first()), locale));
        }
    };
    public static VncFunction format = new VncFunction("time/format", (VncVal)VncFunction.meta().arglists("(time/format date format)", "(time/format date format locale)", "(time/format date formatter)", "(time/format date formatter locale)").doc("Formats a date with a format.                                  \n\nTo format a large number of dates a pre instantiated formatter delivers best performance:                                     \n\n```                                                            \n(let [fmt (time/formatter \"yyyy-MM-dd'T'HH:mm:ss\")]          \n  (dotimes [n 100] (time/format (time/local-date-time) fmt)))  \n```").examples("(time/format (time/local-date) \"dd-MM-yyyy\")", "(time/format (time/local-date) (time/formatter \"dd-MM-yyyy\"))", "(time/format (time/local-date) :iso)", "(time/format (time/local-date-time) \"yyyy-MM-dd'T'HH:mm:ss\")", "(time/format (time/local-date-time) (time/formatter \"yyyy-MM-dd'T'HH:mm:ss\"))", "(time/format (time/local-date-time) :iso)", "(time/format (time/zoned-date-time) \"yyyy-MM-dd'T'HH:mm:ss.SSSz\")", "(time/format (time/zoned-date-time) :iso)", "(time/format (time/zoned-date-time) (time/formatter \"yyyy-MM-dd'T'HH:mm:ss.SSSz\"))").seeAlso("time/formatter").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2, 3);
            if (!Types.isVncJavaObject(args.first())) {
                throw new VncException(String.format("Function 'time/format' does not allow %s as date parameter", Types.getType(date)));
            }
            Locale locale = args.size() == 3 ? TimeFunctions.getLocale(args.nth(2)) : null;
            VncVal format = args.second();
            Object date = ((VncJavaObject)args.first()).getDelegate();
            if (date instanceof Date) {
                ZonedDateTime dt = Instant.ofEpochMilli(((Date)date).getTime()).atZone(ZoneId.systemDefault());
                DateTimeFormatter formatter = TimeFunctions.isIsoFormat(format) ? DateTimeFormatter.ISO_OFFSET_DATE_TIME : TimeFunctions.localize(TimeFunctions.getDateTimeFormatter(format), locale);
                return new VncString(dt.format(formatter));
            }
            if (date instanceof ZonedDateTime) {
                DateTimeFormatter formatter = TimeFunctions.isIsoFormat(format) ? DateTimeFormatter.ISO_OFFSET_DATE_TIME : TimeFunctions.localize(TimeFunctions.getDateTimeFormatter(format), locale);
                return new VncString(((ZonedDateTime)date).format(formatter));
            }
            if (date instanceof LocalDateTime) {
                DateTimeFormatter formatter = TimeFunctions.isIsoFormat(format) ? DateTimeFormatter.ISO_LOCAL_DATE_TIME : TimeFunctions.localize(TimeFunctions.getDateTimeFormatter(format), locale);
                return new VncString(((LocalDateTime)date).format(formatter));
            }
            if (date instanceof LocalDate) {
                DateTimeFormatter formatter = TimeFunctions.isIsoFormat(format) ? DateTimeFormatter.ISO_LOCAL_DATE : TimeFunctions.localize(TimeFunctions.getDateTimeFormatter(format), locale);
                return new VncString(((LocalDate)date).format(formatter));
            }
            throw new VncException(String.format("Function 'time/format' does not allow %s as date parameter", Types.getType(args.first())));
        }
    };
    public static VncFunction zone_ids = new VncFunction("time/zone-ids", (VncVal)VncFunction.meta().arglists("(time/zone-ids)").doc("Returns all available zone ids with time offset").examples("(nfirst (seq (time/zone-ids)) 10)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 0);
            ArrayList<String> zoneList = new ArrayList<String>(ZoneId.getAvailableZoneIds());
            Map allZoneIds = TimeFunctions.getAllZoneIds(zoneList);
            LinkedHashMap map = new LinkedHashMap();
            allZoneIds.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEachOrdered(e -> {
                VncVal cfr_ignored_0 = map.put(new VncString((String)e.getKey()), new VncString((String)e.getValue()));
            });
            return new VncOrderedMap(map);
        }
    };
    public static VncFunction to_millis = new VncFunction("time/to-millis", (VncVal)VncFunction.meta().arglists("(time/to-millis date)").doc("Converts the passed date to milliseconds since epoch").examples("(time/to-millis (time/date))", "(time/to-millis (time/local-date))", "(time/to-millis (time/local-date-time))", "(time/to-millis (time/zoned-date-time))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            VncVal val = args.first();
            if (Types.isVncJavaObject(val)) {
                Object date = ((VncJavaObject)val).getDelegate();
                if (date instanceof Date) {
                    return new VncLong(((Date)date).getTime());
                }
                if (date instanceof LocalDate) {
                    return new VncLong(((LocalDate)date).atTime(0, 0, 0).atZone(ZoneId.systemDefault()).toInstant().toEpochMilli());
                }
                if (date instanceof LocalDateTime) {
                    return new VncLong(((LocalDateTime)date).atZone(ZoneId.systemDefault()).toInstant().toEpochMilli());
                }
                if (date instanceof ZonedDateTime) {
                    return new VncLong(((ZonedDateTime)date).toInstant().toEpochMilli());
                }
            }
            throw new VncException(String.format("Function 'time/to-millis' does not allow %s as parameter", Types.getType(val)));
        }
    };
    public static final Map<VncVal, VncVal> ns = new SymbolMapBuilder().add(date).add(date_Q).add(local_date).add(local_date_Q).add(local_date_parse).add(local_date_time).add(local_date_time_Q).add(local_date_time_parse).add(zoned_date_time).add(zoned_date_time_Q).add(zoned_date_time_parse).add(with_time).add(zone_ids).add(to_millis).add(formatter).add(format).add(plus).add(minus).add(period).add(year).add(month).add(day_of_week).add(day_of_month).add(day_of_year).add(first_day_of_month).add(last_day_of_month).add(hour).add(minute).add(second).add(milli).add(leap_yearQ).add(length_of_year).add(length_of_month).add(zone).add(zone_offset).add(after_Q).add(not_after_Q).add(before_Q).add(not_before_Q).add(earliest).add(latest).add(within_Q).add(within_Q).toMap();

    private static Map<String, String> getAllZoneIds(List<String> zoneList) {
        HashMap<String, String> result = new HashMap<String, String>();
        LocalDateTime dt = LocalDateTime.now();
        for (String zoneId : zoneList) {
            ZoneId zone = ZoneId.of(zoneId);
            ZonedDateTime zdt = dt.atZone(zone);
            ZoneOffset zos = zdt.getOffset();
            String offset = zos.getId().replaceAll("Z", "+00:00");
            result.put(zone.toString(), offset);
        }
        return result;
    }

    private static Locale getLocale(VncVal locale) {
        if (locale == Constants.Nil) {
            return Locale.getDefault();
        }
        if (Types.isVncKeyword(locale)) {
            String[] e = ((VncKeyword)locale).getValue().split("_");
            switch (e.length) {
                case 0: {
                    return Locale.getDefault();
                }
                case 1: {
                    return new Locale(e[0]);
                }
                case 2: {
                    return new Locale(e[0], e[1]);
                }
            }
            return new Locale(e[0], e[1], e[2]);
        }
        if (Types.isVncString(locale)) {
            String[] e = ((VncString)locale).getValue().split("_");
            switch (e.length) {
                case 0: {
                    return Locale.getDefault();
                }
                case 1: {
                    return new Locale(e[0]);
                }
                case 2: {
                    return new Locale(e[0], e[1]);
                }
            }
            return new Locale(e[0], e[1], e[2]);
        }
        if (Types.isVncJavaObject(locale, Locale.class)) {
            return (Locale)((VncJavaObject)locale).getDelegate();
        }
        throw new VncException(String.format("The type %s does not define a Locale.", Types.getType(locale)));
    }

    private static DateTimeFormatter getDateTimeFormatter(VncVal fmt) {
        if (Types.isVncKeyword(fmt)) {
            return TimeFunctions.getPredefinedDateTimeFormatter((VncKeyword)fmt);
        }
        if (Types.isVncString(fmt)) {
            return DateTimeFormatter.ofPattern(((VncString)fmt).getValue());
        }
        if (Types.isVncJavaObject(fmt, DateTimeFormatter.class)) {
            return (DateTimeFormatter)((VncJavaObject)fmt).getDelegate();
        }
        throw new VncException(String.format("Function 'time/format' does not allow %s as format parameter.", Types.getType(fmt)));
    }

    private static DateTimeFormatter getPredefinedDateTimeFormatter(VncKeyword fmt) {
        String fmtName = fmt.getValue();
        try {
            return (DateTimeFormatter)ReflectionAccessor.getStaticField(DateTimeFormatter.class, fmtName).getValue();
        }
        catch (Exception ex) {
            throw new VncException(String.format("'%s' is not a predefined DateTimeFormatter.", fmtName));
        }
    }

    private static DateTimeFormatter localize(DateTimeFormatter formatter, Locale locale) {
        return locale == null ? formatter : formatter.withLocale(locale);
    }

    private static DateTimeFormatter zone(DateTimeFormatter formatter, ZoneId zoneId) {
        return zoneId == null ? formatter : formatter.withZone(zoneId);
    }

    private static boolean isIsoFormat(VncVal format) {
        return Types.isVncKeyword(format) ? "iso".equalsIgnoreCase(((VncKeyword)format).getValue()) : false;
    }

    private static ZoneId orDefaultZone(ZoneId zoneId) {
        return zoneId == null ? ZoneId.systemDefault() : zoneId;
    }

    private static ChronoUnit toChronoUnit(String unit) {
        switch (unit) {
            case "years": {
                return ChronoUnit.YEARS;
            }
            case "year": {
                return ChronoUnit.YEARS;
            }
            case "months": {
                return ChronoUnit.MONTHS;
            }
            case "month": {
                return ChronoUnit.MONTHS;
            }
            case "weeks": {
                return ChronoUnit.WEEKS;
            }
            case "week": {
                return ChronoUnit.WEEKS;
            }
            case "days": {
                return ChronoUnit.DAYS;
            }
            case "day": {
                return ChronoUnit.DAYS;
            }
            case "hours": {
                return ChronoUnit.HOURS;
            }
            case "hour": {
                return ChronoUnit.HOURS;
            }
            case "minutes": {
                return ChronoUnit.MINUTES;
            }
            case "minute": {
                return ChronoUnit.MINUTES;
            }
            case "seconds": {
                return ChronoUnit.SECONDS;
            }
            case "second": {
                return ChronoUnit.SECONDS;
            }
            case "millis": {
                return ChronoUnit.MILLIS;
            }
            case "milli": {
                return ChronoUnit.MILLIS;
            }
        }
        return null;
    }
}

